/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import sbt.CommandSource;
import sbt.CommandSource$;
import sbt.Exec;
import sbt.Exec$;
import sbt.State;
import sbt.internal.ConsolePromptEvent;
import sbt.internal.ConsoleUnpromptEvent;
import sbt.internal.FastTrackTask;
import sbt.internal.ui.UITask;
import sbt.internal.ui.UserThread;
import sbt.internal.util.Terminal;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!\u0002\u0010 \u0003\u0003!\u0003\"B\u0016\u0001\t\u0003a\u0003bB\u0018\u0001\u0005\u0004%I\u0001\r\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u0019\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1\u0011\n\u0001Q\u0001\n\tCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004R\u0001\u0001\u0006I\u0001\u0014\u0005\u0007%\u0002!)!I*\t\rm\u0003AQA\u0011]\u0011\u0019\u0001\u0007\u0001\"\u0002\"C\"1q\u000e\u0001D\u0001CADa! \u0001\u0005\u0002\u0005r\bbBA\u0002\u0001\u0011\u0015\u0011Q\u0001\u0005\b\u0003#\u0001A\u0011CA\n\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\r\u0003A\"\u0001\u0002F!A\u0011q\u000b\u0001\u0007\u0002\u0005\nI\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002j!9\u00111\u0010\u0001\u0007\u0002\u0005u\u0004\u0002CA@\u0001\u0001\u0006I!!!\t\u0011\u0005\u0005\u0006\u0001\"\u0002\"\u0003GC\u0001\"!+\u0001\t\u000b\t\u00131\u0016\u0005\t\u0003C\u0003\u0001\u0015\"\u0003\u0002.\"A\u0011q\u0017\u0001\u0005\u0002\u0005\nI\f\u0003\u0005\u0002>\u0002!\t!IA`\u0011!\t\u0019\r\u0001D\u0001C\u0005\u0015'AD\"p[6\fg\u000eZ\"iC:tW\r\u001c\u0006\u0003A\u0005\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002E\u0005\u00191O\u0019;\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005y\u0012\u0001D2p[6\fg\u000eZ)vKV,W#A\u0019\u0011\u0007IJ4(D\u00014\u0015\t!T'\u0001\u0006d_:\u001cWO\u001d:f]RT!AN\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u0005!!.\u0019<b\u0013\tQ4GA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0005qjT\"A\u0011\n\u0005y\n#\u0001B#yK\u000e\fQbY8n[\u0006tG-U;fk\u0016\u0004\u0013A\u0003:fO&\u001cH/\u001a:fIV\t!\tE\u0002D\t\u001ak\u0011!N\u0005\u0003\u000bV\u00121aU3u!\r\u0019uiO\u0005\u0003\u0011V\u0012Q!U;fk\u0016\f1B]3hSN$XM]3eA\u0005Ia-Y:u)J\f7m[\u000b\u0002\u0019B\u00191\tR'\u0011\u0007\r;e\n\u0005\u0002/\u001f&\u0011\u0001k\b\u0002\u000e\r\u0006\u001cH\u000f\u0016:bG.$\u0016m]6\u0002\u0015\u0019\f7\u000f\u001e+sC\u000e\\\u0007%\u0001\u0005sK\u001eL7\u000f^3s)\r!v+\u0017\t\u0003MUK!AV\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u00061\"\u0001\rAR\u0001\u0006cV,W/\u001a\u0005\u00065\"\u0001\r!T\u0001\u000fM\u0006\u001cH\u000f\u0016:bG.\fV/Z;f\u0003))hN]3hSN$XM\u001d\u000b\u0004)v{\u0006\"\u0002-\n\u0001\u0004q\u0006cA\"H[!)!,\u0003a\u0001\u001b\u0006\u0001\u0012\r\u001a3GCN$HK]1dWR\u000b7o\u001b\u000b\u0003)\nDQa\u0019\u0006A\u0002\u0011\fA\u0001^1tWB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ\u0014\u000e\u0003!T!![\u0012\u0002\rq\u0012xn\u001c;?\u0013\tYw%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6(\u0003)i7.V%UQJ,\u0017\rZ\u000b\u0002cB)aE\u001d;.o&\u00111o\n\u0002\n\rVt7\r^5p]J\u0002\"\u0001P;\n\u0005Y\f#!B*uCR,\u0007C\u0001=|\u001b\u0005I(B\u0001> \u0003\t)\u0018.\u0003\u0002}s\n1Q+\u0013+bg.\fA\"\\1lKVKE\u000b\u001b:fC\u0012$\"a^@\t\r\u0005\u0005A\u00021\u0001u\u0003\u0015\u0019H/\u0019;f\u0003\u0019\t\u0007\u000f]3oIR!\u0011qAA\u0007!\r1\u0013\u0011B\u0005\u0004\u0003\u00179#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001fi\u0001\u0019A\u001e\u0002\t\u0015DXmY\u0001\u000bCB\u0004XM\u001c3Fq\u0016\u001cGCBA\u0004\u0003+\tI\u0002\u0003\u0004\u0002\u00189\u0001\r\u0001Z\u0001\fG>lW.\u00198e\u0019&tW\rC\u0004\u0002\u001c9\u0001\r!!\b\u0002\r\u0015DXmY%e!\u00111\u0013q\u00043\n\u0007\u0005\u0005rE\u0001\u0004PaRLwN\\\u0001\u0005a>dG.\u0006\u0002\u0002(A!a%a\b<\u0003\u0019\u0001(o\\7qiR\u0019A+!\f\t\u000f\u0005=\u0002\u00031\u0001\u00022\u0005\tQ\rE\u0002/\u0003gI1!!\u000e \u0005I\u0019uN\\:pY\u0016\u0004&o\\7qi\u00163XM\u001c;\u0002\u0011Ut\u0007O]8naR$2\u0001VA\u001e\u0011\u001d\ty#\u0005a\u0001\u0003{\u00012ALA \u0013\r\t\te\b\u0002\u0015\u0007>t7o\u001c7f+:\u0004(o\\7qi\u00163XM\u001c;\u0002\u0019A,(\r\\5tQ\nKH/Z:\u0015\u0007Q\u000b9\u0005C\u0004\u0002JI\u0001\r!a\u0013\u0002\u000b\tLH/Z:\u0011\u000b\u0019\ni%!\u0015\n\u0007\u0005=sEA\u0003BeJ\f\u0017\u0010E\u0002'\u0003'J1!!\u0016(\u0005\u0011\u0011\u0015\u0010^3\u0002\u0015U\u001cXM\u001d+ie\u0016\fG-\u0006\u0002\u0002\\A\u0019\u00010!\u0018\n\u0007\u0005}\u0013P\u0001\u0006Vg\u0016\u0014H\u000b\u001b:fC\u0012\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0004)\u0006\u0015\u0004bBA4)\u0001\u0007\u0011qA\u0001\fY><7\u000b[;uI><h\u000eF\u0001UQ\u001d)\u0012QNA:\u0003o\u00022AJA8\u0013\r\t\th\n\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA;\u0003Q*6/\u001a\u0011uQ\u0016\u0004c/\u0019:jC:$\b\u0005\u001e5bi\u0002\"\u0018m[3tAQDW\r\t7pONCW\u000f\u001e3po:\u0004\u0003/\u0019:b[\u0016$XM]\u0011\u0003\u0003s\nQ!\r\u00185]A\nAA\\1nKV\tA-A\u0003mKZ,G\u000e\u0005\u0004\u0002\u0004\u0006%\u0015QR\u0007\u0003\u0003\u000bS1!a\"4\u0003\u0019\tGo\\7jG&!\u00111RAC\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003BAH\u00033sA!!%\u0002\u00166\u0011\u00111\u0013\u0006\u0003m\u0005JA!a&\u0002\u0014\u0006)A*\u001a<fY&!\u00111TAO\u0005\u00151\u0016\r\\;f\u0013\r\tyj\n\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0005tKRdUM^3m)\r!\u0016Q\u0015\u0005\b\u0003OC\u0002\u0019AAG\u0003\u0005a\u0017\u0001\u00037pO2+g/\u001a7\u0016\u0005\u00055ECBA\u0004\u0003_\u000b\u0019\fC\u0004\u00022j\u0001\r!!$\u0002\u000bY\fG.^3\t\r\u0005U&\u00041\u0001e\u0003\r\u0019W\u000eZ\u0001\u000e_:\u001cu.\\7b]\u0012d\u0015N\\3\u0015\t\u0005\u001d\u00111\u0018\u0005\u0007\u0003k[\u0002\u0019\u00013\u0002\u001f=tg)Y:u)J\f7m\u001b+bg.$B!a\u0002\u0002B\"1\u0011Q\u0017\u000fA\u0002\u0011\f\u0001\u0002^3s[&t\u0017\r\\\u000b\u0003\u0003\u000f\u0004B!!3\u0002N6\u0011\u00111\u001a\u0006\u0003m}IA!a4\u0002L\nAA+\u001a:nS:\fG\u000e")
public abstract class CommandChannel {
    private final ConcurrentLinkedQueue<Exec> commandQueue = new ConcurrentLinkedQueue();
    private final Set<Queue<Exec>> registered = new HashSet<Queue<Exec>>();
    private final Set<Queue<FastTrackTask>> fastTrack = new HashSet<Queue<FastTrackTask>>();
    private final AtomicReference<Enumeration.Value> level = new AtomicReference<Enumeration.Value>(Level$.MODULE$.Info());

    private ConcurrentLinkedQueue<Exec> commandQueue() {
        return this.commandQueue;
    }

    private Set<Queue<Exec>> registered() {
        return this.registered;
    }

    private Set<Queue<FastTrackTask>> fastTrack() {
        return this.fastTrack;
    }

    public final void register(Queue<Exec> queue, Queue<FastTrackTask> fastTrackQueue) {
        Set<Queue<Exec>> set = this.registered();
        synchronized (set) {
            this.registered().add(queue);
            if (!this.commandQueue().isEmpty()) {
                queue.addAll(this.commandQueue());
                this.commandQueue().clear();
            }
            this.fastTrack().add(fastTrackQueue);
        }
    }

    public final void unregister(Queue<CommandChannel> queue, Queue<FastTrackTask> fastTrackQueue) {
        Set<Queue<Exec>> set = this.registered();
        synchronized (set) {
            this.registered().remove(queue);
            this.fastTrack().remove(fastTrackQueue);
        }
    }

    public final void addFastTrackTask(String task) {
        this.fastTrack().forEach(q -> {
            Queue queue = q;
            synchronized (queue) {
                q.add(new FastTrackTask(this, task));
            }
        });
    }

    public abstract Function2<State, CommandChannel, UITask> mkUIThread();

    public UITask makeUIThread(State state) {
        return (UITask)this.mkUIThread().apply((Object)state, (Object)this);
    }

    public final boolean append(Exec exec) {
        boolean bl;
        Set<Queue<Exec>> set = this.registered();
        synchronized (set) {
            bl = new StringOps(Predef$.MODULE$.augmentString(exec.commandLine())).nonEmpty() && !(!this.registered().isEmpty() ? !((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.registered()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.add(exec))) : !this.commandQueue().add(exec));
        }
        return bl;
    }

    public boolean appendExec(String commandLine, Option<String> execId) {
        return this.append(Exec$.MODULE$.apply(commandLine, (Option<String>)execId.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)Exec$.MODULE$.newExecId())), (Option<CommandSource>)new Some((Object)CommandSource$.MODULE$.apply(this.name()))));
    }

    public Option<Exec> poll() {
        return Option$.MODULE$.apply((Object)this.commandQueue().poll());
    }

    public void prompt(ConsolePromptEvent e) {
        this.userThread().onConsolePromptEvent(e);
    }

    public void unprompt(ConsoleUnpromptEvent e) {
        this.userThread().onConsoleUnpromptEvent(e);
    }

    public abstract void publishBytes(byte[] var1);

    public abstract UserThread userThread();

    public void shutdown(boolean logShutdown) {
        this.userThread().stopThread();
        this.userThread().close();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public abstract String name();

    public final void setLevel(Enumeration.Value l) {
        this.level.set(l);
    }

    public final Enumeration.Value logLevel() {
        return this.level.get();
    }

    private boolean setLevel(Enumeration.Value value, String cmd) {
        this.level.set(value);
        return this.appendExec(cmd, (Option<String>)None$.MODULE$);
    }

    public boolean onCommandLine(String cmd) {
        String string = cmd;
        if ("error".equals(string)) {
            return this.setLevel(Level$.MODULE$.Error(), "error");
        }
        if ("debug".equals(string)) {
            return this.setLevel(Level$.MODULE$.Debug(), "debug");
        }
        if ("info".equals(string)) {
            return this.setLevel(Level$.MODULE$.Info(), "info");
        }
        if ("warn".equals(string)) {
            return this.setLevel(Level$.MODULE$.Warn(), "warn");
        }
        if (new StringOps(Predef$.MODULE$.augmentString(string)).nonEmpty()) {
            return this.appendExec(string, (Option<String>)None$.MODULE$);
        }
        return false;
    }

    public boolean onFastTrackTask(String cmd) {
        Set<Queue<FastTrackTask>> set = this.fastTrack();
        synchronized (set) {
            this.fastTrack().forEach(q -> q.add(new FastTrackTask(this, cmd)));
        }
        return true;
    }

    public abstract Terminal terminal();
}

