/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.complete;

import java.io.Serializable;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import sbt.internal.util.complete.SizeParser;
import sbt.internal.util.complete.SizeParser$Bytes$;
import sbt.internal.util.complete.SizeParser$GigaBytes$;
import sbt.internal.util.complete.SizeParser$KiloBytes$;
import sbt.internal.util.complete.SizeParser$MegaBytes$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SizeParser$ {
    public static SizeParser$ MODULE$;
    private final Parser<Object> digit;
    private final Parser<Either<Object, Object>> numberParser;
    private final Parser<SizeParser.SizeUnit> unitParser;
    private final Parser<Object> value;

    static {
        new SizeParser$();
    }

    public Option<Object> apply(String s) {
        return Parser$.MODULE$.parse(s, this.value()).toOption();
    }

    private Parser<Either<Object, Object>> parseDouble(String s) {
        Parser<Nothing$> parser;
        try {
            parser = Parser$.MODULE$.success(package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(Double.valueOf(s)))));
        }
        catch (NumberFormatException numberFormatException) {
            parser = Parser$.MODULE$.failure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Couldn't parse ").append(s).append(" as double.").toString(), Parser$.MODULE$.failure$default$2());
        }
        return parser;
    }

    private Parser<Either<Object, Object>> parseLong(String s) {
        Parser<Nothing$> parser;
        try {
            parser = Parser$.MODULE$.success(package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(Long.valueOf(s)))));
        }
        catch (NumberFormatException numberFormatException) {
            parser = Parser$.MODULE$.failure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Couldn't parse ").append(s).append(" as double.").toString(), Parser$.MODULE$.failure$default$2());
        }
        return parser;
    }

    private long multiply(Either<Object, Object> left, long right) {
        Either<Object, Object> either = left;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            double d = BoxesRunTime.unboxToDouble((Object)left2.value());
            return (long)(d * (double)right);
        }
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long l = BoxesRunTime.unboxToLong((Object)right2.value());
            return l * right;
        }
        throw new MatchError(either);
    }

    public Parser<Object> value() {
        return this.value;
    }

    public static final /* synthetic */ long $anonfun$value$1(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            SizeParser.SizeUnit sizeUnit;
            SizeParser.SizeUnit sizeUnit2;
            Some some;
            SizeParser.SizeUnit sizeUnit3;
            Either number = (Either)tuple2._1();
            Option unit = (Option)tuple2._2();
            boolean bl = false;
            Some some2 = null;
            Option option = unit;
            if (None$.MODULE$.equals(option) ? true : option instanceof Some && SizeParser$Bytes$.MODULE$.equals(sizeUnit3 = (SizeParser.SizeUnit)(some = (Some)option).value())) {
                return MODULE$.multiply((Either<Object, Object>)number, 1L);
            }
            if (option instanceof Some) {
                bl = true;
                some2 = (Some)option;
                SizeParser.SizeUnit sizeUnit4 = (SizeParser.SizeUnit)some2.value();
                if (SizeParser$KiloBytes$.MODULE$.equals(sizeUnit4)) {
                    return MODULE$.multiply((Either<Object, Object>)number, 1024L);
                }
            }
            if (bl && SizeParser$MegaBytes$.MODULE$.equals(sizeUnit2 = (SizeParser.SizeUnit)some2.value())) {
                return MODULE$.multiply((Either<Object, Object>)number, 0x100000L);
            }
            if (bl && SizeParser$GigaBytes$.MODULE$.equals(sizeUnit = (SizeParser.SizeUnit)some2.value())) {
                return MODULE$.multiply((Either<Object, Object>)number, 0x40000000L);
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)tuple2);
    }

    private SizeParser$() {
        MODULE$ = this;
        this.digit = DefaultParsers$.MODULE$.charClass((Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1)))), "digit");
        this.numberParser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(this.digit).$plus()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichCharParser('.').examples((Seq<String>)Nil$.MODULE$)).$tilde$greater(DefaultParsers$.MODULE$.richParser(this.digit).$plus())).$qmark())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq leading = (Seq)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq decimalPart = (Seq)some.value();
                    return MODULE$.parseDouble(new StringBuilder(1).append(leading.mkString()).append(".").append(decimalPart.mkString()).toString());
                }
            }
            if (tuple2 != null) {
                Seq leading = (Seq)tuple2._1();
                return MODULE$.parseLong(leading.mkString());
            }
            throw new MatchError((Object)tuple2);
        });
        this.unitParser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichStringParser("b").$bar(DefaultParsers$.MODULE$.literal("B"))).$bar(DefaultParsers$.MODULE$.literal("g"))).$bar(DefaultParsers$.MODULE$.literal("G"))).$bar(DefaultParsers$.MODULE$.literal("k"))).$bar(DefaultParsers$.MODULE$.literal("K"))).$bar(DefaultParsers$.MODULE$.literal("m"))).$bar(DefaultParsers$.MODULE$.literal("M")))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            String string = x0$2;
            if ("b".equals(string) ? true : "B".equals(string)) {
                return SizeParser$Bytes$.MODULE$;
            }
            if ("g".equals(string) ? true : "G".equals(string)) {
                return SizeParser$GigaBytes$.MODULE$;
            }
            if ("k".equals(string) ? true : "K".equals(string)) {
                return SizeParser$KiloBytes$.MODULE$;
            }
            if ("m".equals(string) ? true : "M".equals(string)) {
                return SizeParser$MegaBytes$.MODULE$;
            }
            throw new MatchError((Object)string);
        });
        this.value = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(this.numberParser).$less$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.SpaceClass()).examples((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "b", "B", "g", "G", "k", "K", "m", "M"}))).$times())).$tilde(DefaultParsers$.MODULE$.richParser(this.unitParser).$qmark())).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)SizeParser$.$anonfun$value$1(x0$3)));
    }
}

