/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import sbt.internal.io.Linux32Milli$;
import sbt.internal.io.Linux64Milli$;
import sbt.internal.io.MacMilli$;
import sbt.internal.io.Milli;
import sbt.internal.io.WinMilli$;
import sbt.io.JavaMilli$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.util.control.NonFatal$;

public final class Milli$ {
    public static Milli$ MODULE$;
    private final boolean jdkTimestamps;
    private final Milli milli;

    static {
        new Milli$();
    }

    private boolean jdkTimestamps() {
        return this.jdkTimestamps;
    }

    public Milli milli() {
        return this.milli;
    }

    public long getModifiedTime(File file) {
        return this.milli().getModifiedTime(file.getPath());
    }

    public void setModifiedTime(File file, long mtime) {
        this.milli().setModifiedTime(file.getPath(), mtime);
    }

    public void copyModifiedTime(File fromFile, File toFile) {
        this.milli().copyModifiedTime(fromFile.getPath(), toFile.getPath());
    }

    public Option<String> getMilliSupportDiagnostic(File projectDir) {
        None$ none$;
        if (this.jdkTimestamps()) {
            none$ = None$.MODULE$;
        } else {
            File file = File.createTempFile("sbt.io.Milli", "test-file", projectDir);
            try {
                long originalTime = this.getModifiedTime(file);
                this.setModifiedTime(file, originalTime - 27L);
                long newTime = this.getModifiedTime(file);
                if (newTime + 27L == originalTime) {
                    none$ = None$.MODULE$;
                } else {
                    String string;
                    String string2;
                    StringBuilder stringBuilder = new StringBuilder(61);
                    int n = Platform.getOSType();
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: {
                            string2 = "Your filesystem does not seem to support sub-second file timestamps ";
                            break;
                        }
                        default: {
                            string2 = "Your OS, filesystem, or Java VM, do not seem to support sub-second file timestamps";
                            break;
                        }
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append(string2);
                    int n2 = Platform.getOSType();
                    switch (n2) {
                        case 1: {
                            string = "(ext2/ext3, for instance, have a 1 sec resolution)";
                            break;
                        }
                        case 0: {
                            string = "(HFS+ has a 1 sec resolution, but APFS is more precise)";
                            break;
                        }
                        case 2: {
                            string = "(FAT32, for instance, has a 1-2 sec resolution but NTFS is more precise)";
                            break;
                        }
                        default: {
                            string = "";
                            break;
                        }
                    }
                    none$ = new Some((Object)stringBuilder2.append((Object)string).append(". That may affect sbt's ability to detect rapid file changes.").toString());
                }
            }
            finally {
                if (!file.delete()) {
                    throw new IOException(new StringBuilder(45).append("Unexpected: could not delete temporary file: ").append(file.getAbsolutePath()).toString());
                }
            }
        }
        return none$;
    }

    private static final boolean liftedTree1$1(String x1$1) {
        boolean bl;
        block4: {
            try {
                if (new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x1$1.split("\\."))).last())).toInt() >= 10) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
        }
        return bl;
    }

    private Milli$() {
        Milli milli;
        boolean bl;
        MODULE$ = this;
        String string = System.getProperty("sbt.io.jdktimestamps");
        if (string == null) {
            String string2 = System.getProperty("java.specification.version");
            boolean bl2 = string2 == null ? false : Milli$.liftedTree1$1(string2);
            bl = bl2;
        } else {
            String string3 = string.toLowerCase();
            String string4 = "false";
            bl = string3 == null ? string4 != null : !string3.equals(string4);
        }
        this.jdkTimestamps = bl;
        if (this.jdkTimestamps() || !Platform.isIntel()) {
            milli = JavaMilli$.MODULE$;
        } else {
            int n = Platform.getOSType();
            switch (n) {
                case 1: {
                    if (Platform.is64Bit()) {
                        milli = Linux64Milli$.MODULE$;
                        break;
                    }
                    milli = Linux32Milli$.MODULE$;
                    break;
                }
                case 0: {
                    milli = MacMilli$.MODULE$;
                    break;
                }
                case 2: {
                    milli = WinMilli$.MODULE$;
                    break;
                }
                default: {
                    milli = JavaMilli$.MODULE$;
                    break;
                }
            }
        }
        this.milli = milli;
    }
}

