/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.spi.Pty;

public abstract class AbstractPosixTerminal
extends AbstractTerminal {
    protected final Pty pty;
    protected final Attributes originalAttributes;

    public AbstractPosixTerminal(String string, String string2, Pty pty) throws IOException {
        this(string, string2, pty, null, Terminal.SignalHandler.SIG_DFL);
    }

    public AbstractPosixTerminal(String string, String string2, Pty pty, Charset charset, Terminal.SignalHandler signalHandler) throws IOException {
        super(string, string2, charset, signalHandler);
        Objects.requireNonNull(pty);
        this.pty = pty;
        this.originalAttributes = this.pty.getAttr();
    }

    public Pty getPty() {
        return this.pty;
    }

    @Override
    public Attributes getAttributes() {
        try {
            return this.pty.getAttr();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public void setAttributes(Attributes attributes) {
        try {
            this.pty.setAttr(attributes);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public Size getSize() {
        try {
            return this.pty.getSize();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public void setSize(Size size) {
        try {
            this.pty.setSize(size);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        this.pty.setAttr(this.originalAttributes);
        this.pty.close();
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return CursorSupport.getCursorPosition(this, intConsumer);
    }
}

