/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingPumpReader;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.ShutdownHooks;
import org.jline.utils.Signals;
import org.jline.utils.WriterOutputStream;

public abstract class AbstractWindowsTerminal
extends AbstractTerminal {
    public static final String TYPE_WINDOWS = "windows";
    public static final String TYPE_WINDOWS_256_COLOR = "windows-256color";
    public static final String TYPE_WINDOWS_CONEMU = "windows-conemu";
    public static final String TYPE_WINDOWS_VTP = "windows-vtp";
    public static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
    private static final int UTF8_CODE_PAGE = 65001;
    protected static final int ENABLE_PROCESSED_INPUT = 1;
    protected static final int ENABLE_LINE_INPUT = 2;
    protected static final int ENABLE_ECHO_INPUT = 4;
    protected static final int ENABLE_WINDOW_INPUT = 8;
    protected static final int ENABLE_MOUSE_INPUT = 16;
    protected static final int ENABLE_INSERT_MODE = 32;
    protected static final int ENABLE_QUICK_EDIT_MODE = 64;
    protected final Writer slaveInputPipe;
    protected final NonBlockingInputStream input;
    protected final OutputStream output;
    protected final NonBlockingReader reader;
    protected final PrintWriter writer;
    protected final Map<Terminal.Signal, Object> nativeHandlers = new HashMap<Terminal.Signal, Object>();
    protected final ShutdownHooks.Task closer;
    protected final Attributes attributes = new Attributes();
    protected final int originalConsoleMode;
    protected final Object lock = new Object();
    protected boolean paused = true;
    protected Thread pump;
    protected Terminal.MouseTracking tracking = Terminal.MouseTracking.Off;
    protected boolean focusTracking = false;
    private volatile boolean closing;
    static final int SHIFT_FLAG = 1;
    static final int ALT_FLAG = 2;
    static final int CTRL_FLAG = 4;
    static final int RIGHT_ALT_PRESSED = 1;
    static final int LEFT_ALT_PRESSED = 2;
    static final int RIGHT_CTRL_PRESSED = 4;
    static final int LEFT_CTRL_PRESSED = 8;
    static final int SHIFT_PRESSED = 16;
    static final int NUMLOCK_ON = 32;
    static final int SCROLLLOCK_ON = 64;
    static final int CAPSLOCK_ON = 128;

    public AbstractWindowsTerminal(Writer writer, String string, String string2, Charset charset, int n, boolean bl, Terminal.SignalHandler signalHandler) throws IOException {
        super(string, string2, AbstractWindowsTerminal.selectCharset(charset, n), signalHandler);
        NonBlockingPumpReader nonBlockingPumpReader = NonBlocking.nonBlockingPumpReader();
        this.slaveInputPipe = nonBlockingPumpReader.getWriter();
        this.reader = nonBlockingPumpReader;
        this.input = NonBlocking.nonBlockingStream(nonBlockingPumpReader, this.encoding());
        this.writer = new PrintWriter(writer);
        this.output = new WriterOutputStream(writer, this.encoding());
        this.parseInfoCmp();
        this.originalConsoleMode = this.getConsoleMode();
        this.attributes.setLocalFlag(Attributes.LocalFlag.ISIG, true);
        this.attributes.setControlChar(Attributes.ControlChar.VINTR, this.ctrl('C'));
        this.attributes.setControlChar(Attributes.ControlChar.VEOF, this.ctrl('D'));
        this.attributes.setControlChar(Attributes.ControlChar.VSUSP, this.ctrl('Z'));
        if (bl) {
            for (Terminal.Signal signal : Terminal.Signal.values()) {
                if (signalHandler == Terminal.SignalHandler.SIG_DFL) {
                    this.nativeHandlers.put(signal, Signals.registerDefault(signal.name()));
                    continue;
                }
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
        if (TYPE_WINDOWS_CONEMU.equals(this.getType()) && !Boolean.getBoolean("org.jline.terminal.conemu.disable-activate")) {
            writer.write("\u001b[9999E");
            writer.flush();
        }
    }

    private static Charset selectCharset(Charset charset, int n) {
        if (charset != null) {
            return charset;
        }
        if (n >= 0) {
            return AbstractWindowsTerminal.getCodepageCharset(n);
        }
        return StandardCharsets.UTF_8;
    }

    private static Charset getCodepageCharset(int n) {
        if (n == 65001) {
            return StandardCharsets.UTF_8;
        }
        String string = "ms" + n;
        if (Charset.isSupported(string)) {
            return Charset.forName(string);
        }
        String string2 = "cp" + n;
        if (Charset.isSupported(string2)) {
            return Charset.forName(string2);
        }
        return Charset.defaultCharset();
    }

    @Override
    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        Terminal.SignalHandler signalHandler2 = super.handle(signal, signalHandler);
        if (signalHandler2 != signalHandler) {
            if (signalHandler == Terminal.SignalHandler.SIG_DFL) {
                Signals.registerDefault(signal.name());
            } else {
                Signals.register(signal.name(), () -> this.raise(signal));
            }
        }
        return signalHandler2;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        int n = this.getConsoleMode();
        if ((n & 4) != 0) {
            this.attributes.setLocalFlag(Attributes.LocalFlag.ECHO, true);
        }
        if ((n & 2) != 0) {
            this.attributes.setLocalFlag(Attributes.LocalFlag.ICANON, true);
        }
        return new Attributes(this.attributes);
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes.copy(attributes);
        this.updateConsoleMode();
    }

    protected void updateConsoleMode() {
        int n = 8;
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            n |= 4;
        }
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ICANON)) {
            n |= 2;
        }
        if (this.tracking != Terminal.MouseTracking.Off) {
            n |= 0x10;
        }
        this.setConsoleMode(n);
    }

    protected int ctrl(char c) {
        return Character.toUpperCase(c) & 0x1F;
    }

    @Override
    public void setSize(Size size) {
        throw new UnsupportedOperationException("Can not resize windows terminal");
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        this.closing = true;
        if (this.pump != null) {
            this.pump.interrupt();
        }
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Terminal.Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        this.reader.close();
        this.writer.close();
        this.setConsoleMode(this.originalConsoleMode);
    }

    protected void processKeyEvent(boolean bl, short s, char c, int n) throws IOException {
        boolean bl2;
        boolean bl3 = (n & 0xC) > 0;
        boolean bl4 = (n & 3) > 0;
        boolean bl5 = bl2 = (n & 0x10) > 0;
        if (bl && c != '\u0003') {
            if (c != '\u0000' && (n & 0x1F) == 9) {
                this.processInputChar(c);
            } else {
                String string = this.getEscapeSequence(s, (bl3 ? 4 : 0) + (bl4 ? 2 : 0) + (bl2 ? 1 : 0));
                if (string != null) {
                    for (char c2 : string.toCharArray()) {
                        this.processInputChar(c2);
                    }
                    return;
                }
                if (c > '\u0000') {
                    if (bl4) {
                        this.processInputChar('\u001b');
                    }
                    if (bl3 && c != ' ' && c != '\n' && c != '\u007f') {
                        this.processInputChar((char)(c == '?' ? 127 : Character.toUpperCase(c) & 0x1F));
                    } else {
                        this.processInputChar(c);
                    }
                } else if (bl3) {
                    if (s >= 65 && s <= 90) {
                        c = (char)(s - 64);
                    } else if (s == 191) {
                        c = (char)127;
                    }
                    if (c > '\u0000') {
                        if (bl4) {
                            this.processInputChar('\u001b');
                        }
                        this.processInputChar(c);
                    }
                }
            }
        } else if (bl && c == '\u0003') {
            this.processInputChar('\u0003');
        } else if (s == 18 && c > '\u0000') {
            this.processInputChar(c);
        }
    }

    protected String getEscapeSequence(short s, int n) {
        String string = null;
        switch (s) {
            case 8: {
                string = (n & 2) > 0 ? "\\E^H" : this.getRawSequence(InfoCmp.Capability.key_backspace);
                break;
            }
            case 9: {
                string = (n & 1) > 0 ? this.getRawSequence(InfoCmp.Capability.key_btab) : null;
                break;
            }
            case 33: {
                string = this.getRawSequence(InfoCmp.Capability.key_ppage);
                break;
            }
            case 34: {
                string = this.getRawSequence(InfoCmp.Capability.key_npage);
                break;
            }
            case 35: {
                string = n > 0 ? "\\E[1;%p1%dF" : this.getRawSequence(InfoCmp.Capability.key_end);
                break;
            }
            case 36: {
                string = n > 0 ? "\\E[1;%p1%dH" : this.getRawSequence(InfoCmp.Capability.key_home);
                break;
            }
            case 37: {
                string = n > 0 ? "\\E[1;%p1%dD" : this.getRawSequence(InfoCmp.Capability.key_left);
                break;
            }
            case 38: {
                string = n > 0 ? "\\E[1;%p1%dA" : this.getRawSequence(InfoCmp.Capability.key_up);
                break;
            }
            case 39: {
                string = n > 0 ? "\\E[1;%p1%dC" : this.getRawSequence(InfoCmp.Capability.key_right);
                break;
            }
            case 40: {
                string = n > 0 ? "\\E[1;%p1%dB" : this.getRawSequence(InfoCmp.Capability.key_down);
                break;
            }
            case 45: {
                string = this.getRawSequence(InfoCmp.Capability.key_ic);
                break;
            }
            case 46: {
                string = this.getRawSequence(InfoCmp.Capability.key_dc);
                break;
            }
            case 112: {
                string = n > 0 ? "\\E[1;%p1%dP" : this.getRawSequence(InfoCmp.Capability.key_f1);
                break;
            }
            case 113: {
                string = n > 0 ? "\\E[1;%p1%dQ" : this.getRawSequence(InfoCmp.Capability.key_f2);
                break;
            }
            case 114: {
                string = n > 0 ? "\\E[1;%p1%dR" : this.getRawSequence(InfoCmp.Capability.key_f3);
                break;
            }
            case 115: {
                string = n > 0 ? "\\E[1;%p1%dS" : this.getRawSequence(InfoCmp.Capability.key_f4);
                break;
            }
            case 116: {
                string = n > 0 ? "\\E[15;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f5);
                break;
            }
            case 117: {
                string = n > 0 ? "\\E[17;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f6);
                break;
            }
            case 118: {
                string = n > 0 ? "\\E[18;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f7);
                break;
            }
            case 119: {
                string = n > 0 ? "\\E[19;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f8);
                break;
            }
            case 120: {
                string = n > 0 ? "\\E[20;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f9);
                break;
            }
            case 121: {
                string = n > 0 ? "\\E[21;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f10);
                break;
            }
            case 122: {
                string = n > 0 ? "\\E[23;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f11);
                break;
            }
            case 123: {
                string = n > 0 ? "\\E[24;%p1%d~" : this.getRawSequence(InfoCmp.Capability.key_f12);
                break;
            }
            default: {
                return null;
            }
        }
        return Curses.tputs(string, n + 1);
    }

    protected String getRawSequence(InfoCmp.Capability capability) {
        return (String)this.strings.get((Object)capability);
    }

    @Override
    public boolean hasFocusSupport() {
        return true;
    }

    @Override
    public boolean trackFocus(boolean bl) {
        this.focusTracking = bl;
        return true;
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(boolean bl) throws InterruptedException {
        Thread thread;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            thread = this.pump;
        }
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.pump == null) {
                this.pump = new Thread(this::pump, "WindowsStreamPump");
                this.pump.setDaemon(true);
                this.pump.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pump() {
        try {
            while (!this.closing) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.pump = null;
                        break;
                    }
                }
                if (!this.processConsoleInput()) continue;
                this.slaveInputPipe.flush();
            }
        }
        catch (IOException iOException) {
            if (!this.closing) {
                Log.warn("Error in WindowsStreamPump", iOException);
                try {
                    this.close();
                }
                catch (IOException iOException2) {
                    Log.warn("Error closing terminal", iOException);
                }
            }
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.pump = null;
            }
        }
    }

    public void processInputChar(char c) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Terminal.Signal.INT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Terminal.Signal.QUIT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Terminal.Signal.TSTP);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Terminal.Signal.INFO);
            }
        }
        if (c == '\r') {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                c = (char)10;
            }
        } else if (c == '\n' && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            c = (char)13;
        }
        this.slaveInputPipe.write(c);
    }

    @Override
    public boolean trackMouse(Terminal.MouseTracking mouseTracking) {
        this.tracking = mouseTracking;
        this.updateConsoleMode();
        return true;
    }

    protected abstract int getConsoleOutputCP();

    protected abstract int getConsoleMode();

    protected abstract void setConsoleMode(int var1);

    protected abstract boolean processConsoleInput() throws IOException;
}

