/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    static final boolean DISABLE_ALTERNATE_CHARSET = Boolean.getBoolean("org.jline.utils.disableAlternateCharset");

    public void print(Terminal terminal) {
        terminal.writer().print(this.toAnsi(terminal));
    }

    public void println(Terminal terminal) {
        terminal.writer().println(this.toAnsi(terminal));
    }

    public String toAnsi() {
        return this.toAnsi(null);
    }

    public String toAnsi(Terminal terminal) {
        if (terminal != null && "dumb".equals(terminal.getType())) {
            return this.toString();
        }
        int n = 256;
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (terminal != null) {
            Integer n2 = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
            if (n2 != null) {
                n = n2;
            }
            boolean bl2 = bl = "windows-256color".equals(terminal.getType()) || "windows-conemu".equals(terminal.getType());
            if (!DISABLE_ALTERNATE_CHARSET) {
                string = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.enter_alt_charset_mode), new Object[0]);
                string2 = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.exit_alt_charset_mode), new Object[0]);
            }
        }
        return this.toAnsi(n, bl, string, string2);
    }

    public String toAnsi(int n, boolean bl) {
        return this.toAnsi(n, bl, null, null);
    }

    public String toAnsi(int n, boolean bl, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < this.length(); ++i) {
            int n6;
            int n7;
            char c = this.charAt(i);
            if (string != null && string2 != null) {
                n7 = c;
                switch (c) {
                    case '\u2518': {
                        c = 'j';
                        break;
                    }
                    case '\u2510': {
                        c = 'k';
                        break;
                    }
                    case '\u250c': {
                        c = 'l';
                        break;
                    }
                    case '\u2514': {
                        c = 'm';
                        break;
                    }
                    case '\u253c': {
                        c = 'n';
                        break;
                    }
                    case '\u2500': {
                        c = 'q';
                        break;
                    }
                    case '\u251c': {
                        c = 't';
                        break;
                    }
                    case '\u2524': {
                        c = 'u';
                        break;
                    }
                    case '\u2534': {
                        c = 'v';
                        break;
                    }
                    case '\u252c': {
                        c = 'w';
                        break;
                    }
                    case '\u2502': {
                        c = 'x';
                    }
                }
                n6 = n5;
                int n8 = n5 = c != n7 ? 1 : 0;
                if ((n6 ^ n5) != 0) {
                    stringBuilder.append(n5 != 0 ? string : string2);
                }
            }
            if (n2 != (n7 = this.styleCodeAt(i) & 0xFFFFFBFF)) {
                int n9;
                n6 = (n2 ^ n7) & 0x7FF;
                int n10 = (n7 & 0x100) != 0 ? (n7 & 0xFF0000) >>> 16 : -1;
                int n11 = n9 = (n7 & 0x200) != 0 ? (n7 & 0xFF000000) >>> 24 : -1;
                if (n7 == 0) {
                    stringBuilder.append("\u001b[0m");
                    n4 = -1;
                    n3 = -1;
                } else {
                    int n12;
                    stringBuilder.append("\u001b[");
                    boolean bl2 = true;
                    if ((n6 & 4) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 4) != 0 ? "3" : "23", bl2);
                    }
                    if ((n6 & 8) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 8) != 0 ? "4" : "24", bl2);
                    }
                    if ((n6 & 0x10) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 0x10) != 0 ? "5" : "25", bl2);
                    }
                    if ((n6 & 0x20) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 0x20) != 0 ? "7" : "27", bl2);
                    }
                    if ((n6 & 0x40) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 0x40) != 0 ? "8" : "28", bl2);
                    }
                    if ((n6 & 0x80) != 0) {
                        bl2 = AttributedCharSequence.attr(stringBuilder, (n7 & 0x80) != 0 ? "9" : "29", bl2);
                    }
                    if (n3 != n10) {
                        if (n10 >= 0) {
                            n12 = Colors.roundColor(n10, n);
                            if (n12 < 8 && !bl) {
                                bl2 = AttributedCharSequence.attr(stringBuilder, "3" + Integer.toString(n12), bl2);
                                n6 |= n7 & 1;
                            } else if (n12 < 16 && !bl) {
                                bl2 = AttributedCharSequence.attr(stringBuilder, "9" + Integer.toString(n12 - 8), bl2);
                                n6 |= n7 & 1;
                            } else {
                                bl2 = AttributedCharSequence.attr(stringBuilder, "38;5;" + Integer.toString(n12), bl2);
                            }
                        } else {
                            bl2 = AttributedCharSequence.attr(stringBuilder, "39", bl2);
                        }
                        n3 = n10;
                    }
                    if (n4 != n9) {
                        bl2 = n9 >= 0 ? ((n12 = Colors.roundColor(n9, n)) < 8 && !bl ? AttributedCharSequence.attr(stringBuilder, "4" + Integer.toString(n12), bl2) : (n12 < 16 && !bl ? AttributedCharSequence.attr(stringBuilder, "10" + Integer.toString(n12 - 8), bl2) : AttributedCharSequence.attr(stringBuilder, "48;5;" + Integer.toString(n12), bl2))) : AttributedCharSequence.attr(stringBuilder, "49", bl2);
                        n4 = n9;
                    }
                    if ((n6 & 3) != 0) {
                        if ((n6 & 1) != 0 && (n7 & 1) == 0 || (n6 & 2) != 0 && (n7 & 2) == 0) {
                            bl2 = AttributedCharSequence.attr(stringBuilder, "22", bl2);
                        }
                        if ((n6 & 1) != 0 && (n7 & 1) != 0) {
                            bl2 = AttributedCharSequence.attr(stringBuilder, "1", bl2);
                        }
                        if ((n6 & 2) != 0 && (n7 & 2) != 0) {
                            bl2 = AttributedCharSequence.attr(stringBuilder, "2", bl2);
                        }
                    }
                    stringBuilder.append("m");
                }
                n2 = n7;
            }
            stringBuilder.append(c);
        }
        if (n5 != 0) {
            stringBuilder.append(string2);
        }
        if (n2 != 0) {
            stringBuilder.append("\u001b[0m");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static int rgbColor(int n) {
        return Colors.rgbColor(n);
    }

    @Deprecated
    public static int roundColor(int n, int n2) {
        return Colors.roundColor(n, n2);
    }

    @Deprecated
    public static int roundRgbColor(int n, int n2, int n3, int n4) {
        return Colors.roundRgbColor(n, n2, n3, n4);
    }

    private static boolean attr(StringBuilder stringBuilder, String string, boolean bl) {
        if (!bl) {
            stringBuilder.append(";");
        }
        stringBuilder.append(string);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    int styleCodeAt(int n) {
        return this.styleAt(n).getStyle();
    }

    public boolean isHidden(int n) {
        return (this.styleCodeAt(n) & 0x400) != 0;
    }

    public int runStart(int n) {
        AttributedStyle attributedStyle = this.styleAt(n);
        while (n > 0 && this.styleAt(n - 1).equals(attributedStyle)) {
            --n;
        }
        return n;
    }

    public int runLimit(int n) {
        AttributedStyle attributedStyle = this.styleAt(n);
        while (n < this.length() - 1 && this.styleAt(n + 1).equals(attributedStyle)) {
            ++n;
        }
        return n + 1;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int n, int n2) {
        return this.subSequence(n, n2);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int n) {
        return this.buffer()[this.offset() + n];
    }

    public int codePointAt(int n) {
        return Character.codePointAt(this.buffer(), n + this.offset());
    }

    public boolean contains(char c) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public int codePointBefore(int n) {
        return Character.codePointBefore(this.buffer(), n + this.offset());
    }

    public int codePointCount(int n, int n2) {
        return Character.codePointCount(this.buffer(), n + this.offset(), n2);
    }

    public int columnLength() {
        int n;
        int n2 = 0;
        int n3 = this.length();
        for (int i = 0; i < n3; i += Character.charCount(n)) {
            n = this.codePointAt(i);
            if (this.isHidden(i)) continue;
            n2 += WCWidth.wcwidth(n);
        }
        return n2;
    }

    public AttributedString columnSubSequence(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        while (n5 < this.length()) {
            n4 = this.codePointAt(n5);
            int n7 = n3 = this.isHidden(n5) ? 0 : WCWidth.wcwidth(n4);
            if (n6 + n3 > n) break;
            n5 += Character.charCount(n4);
            n6 += n3;
        }
        n4 = n5;
        while (n4 < this.length() && (n3 = this.codePointAt(n4)) != 10) {
            int n8;
            int n9 = n8 = this.isHidden(n4) ? 0 : WCWidth.wcwidth(n3);
            if (n6 + n8 > n2) break;
            n4 += Character.charCount(n3);
            n6 += n8;
        }
        return this.subSequence(n5, n4);
    }

    public List<AttributedString> columnSplitLength(int n) {
        return this.columnSplitLength(n, false, true);
    }

    public List<AttributedString> columnSplitLength(int n, boolean bl, boolean bl2) {
        int n2;
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        int n3 = n2 = 0;
        int n4 = 0;
        while (n2 < this.length()) {
            int n5;
            int n6 = this.codePointAt(n2);
            int n7 = n5 = this.isHidden(n2) ? 0 : WCWidth.wcwidth(n6);
            if (n6 == 10) {
                arrayList.add(this.subSequence(n3, bl ? n2 + 1 : n2));
                n3 = n2 + 1;
                n4 = 0;
            } else if ((n4 += n5) > n) {
                arrayList.add(this.subSequence(n3, n2));
                n3 = n2;
                n4 = n5;
            }
            n2 += Character.charCount(n6);
        }
        arrayList.add(this.subSequence(n3, n2));
        return arrayList;
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }
}

