/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Objects;
import org.jline.utils.Log;

public final class ExecHelper {
    private ExecHelper() {
    }

    public static String exec(boolean bl, String ... stringArray) throws IOException {
        Objects.requireNonNull(stringArray);
        try {
            Log.trace("Running: ", stringArray);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            if (bl) {
                processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            Process process = processBuilder.start();
            String string = ExecHelper.waitAndCapture(process);
            Log.trace("Result: ", string);
            if (process.exitValue() != 0) {
                if (string.endsWith("\n")) {
                    string = string.substring(0, string.length() - 1);
                }
                throw new IOException("Error executing '" + String.join((CharSequence)" ", stringArray) + "': " + string);
            }
            return string;
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitAndCapture(Process process) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream2 = process.getErrorStream();
            while ((n = inputStream2.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            outputStream = process.getOutputStream();
            process.waitFor();
        }
        catch (Throwable throwable) {
            ExecHelper.close(inputStream, outputStream, inputStream2);
            throw throwable;
        }
        ExecHelper.close(inputStream, outputStream, inputStream2);
        return byteArrayOutputStream.toString();
    }

    private static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

