/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingInputStreamImpl;
import org.jline.utils.NonBlockingPumpInputStream;
import org.jline.utils.NonBlockingPumpReader;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.NonBlockingReaderImpl;

public class NonBlocking {
    public static NonBlockingPumpReader nonBlockingPumpReader() {
        return new NonBlockingPumpReader();
    }

    public static NonBlockingPumpReader nonBlockingPumpReader(int n) {
        return new NonBlockingPumpReader(n);
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream() {
        return new NonBlockingPumpInputStream();
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream(int n) {
        return new NonBlockingPumpInputStream(n);
    }

    public static NonBlockingInputStream nonBlockingStream(NonBlockingReader nonBlockingReader, Charset charset) {
        return new NonBlockingReaderInputStream(nonBlockingReader, charset);
    }

    public static NonBlockingInputStream nonBlocking(String string, InputStream inputStream) {
        if (inputStream instanceof NonBlockingInputStream) {
            return (NonBlockingInputStream)inputStream;
        }
        return new NonBlockingInputStreamImpl(string, inputStream);
    }

    public static NonBlockingReader nonBlocking(String string, Reader reader) {
        if (reader instanceof NonBlockingReader) {
            return (NonBlockingReader)reader;
        }
        return new NonBlockingReaderImpl(string, reader);
    }

    public static NonBlockingReader nonBlocking(String string, InputStream inputStream, Charset charset) {
        return new NonBlockingInputStreamReader(NonBlocking.nonBlocking(string, inputStream), charset);
    }

    private static class NonBlockingInputStreamReader
    extends NonBlockingReader {
        private final NonBlockingInputStream input;
        private final CharsetDecoder decoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        public NonBlockingInputStreamReader(NonBlockingInputStream nonBlockingInputStream, Charset charset) {
            this(nonBlockingInputStream, (charset != null ? charset : Charset.defaultCharset()).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        public NonBlockingInputStreamReader(NonBlockingInputStream nonBlockingInputStream, CharsetDecoder charsetDecoder) {
            this.input = nonBlockingInputStream;
            this.decoder = charsetDecoder;
            this.bytes = ByteBuffer.allocate(4);
            this.chars = CharBuffer.allocate(2);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        protected int read(long l, boolean bl) throws IOException {
            boolean bl2;
            boolean bl3 = bl2 = l <= 0L;
            while (!this.chars.hasRemaining() && (bl2 || l > 0L)) {
                int n;
                long l2 = 0L;
                if (!bl2) {
                    l2 = System.currentTimeMillis();
                }
                if ((n = this.input.read(l)) == -1) {
                    return -1;
                }
                if (n >= 0) {
                    if (!this.bytes.hasRemaining()) {
                        this.bytes.position(0);
                        this.bytes.limit(0);
                    }
                    int n2 = this.bytes.limit();
                    this.bytes.array()[this.bytes.arrayOffset() + n2] = (byte)n;
                    this.bytes.limit(n2 + 1);
                    this.chars.clear();
                    this.decoder.decode(this.bytes, this.chars, false);
                    this.chars.flip();
                }
                if (bl2) continue;
                l -= System.currentTimeMillis() - l2;
            }
            if (this.chars.hasRemaining()) {
                if (bl) {
                    return this.chars.get(this.chars.position());
                }
                return this.chars.get();
            }
            return -2;
        }

        @Override
        public int readBuffered(char[] cArray) throws IOException {
            if (cArray == null) {
                throw new NullPointerException();
            }
            if (cArray.length == 0) {
                return 0;
            }
            if (this.chars.hasRemaining()) {
                int n = Math.min(cArray.length, this.chars.remaining());
                this.chars.get(cArray);
                return n;
            }
            byte[] byArray = new byte[cArray.length];
            int n = this.input.readBuffered(byArray);
            if (n < 0) {
                return n;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            this.decoder.decode(byteBuffer, charBuffer, false);
            charBuffer.flip();
            return charBuffer.remaining();
        }

        @Override
        public void shutdown() {
            this.input.shutdown();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class NonBlockingReaderInputStream
    extends NonBlockingInputStream {
        private final NonBlockingReader reader;
        private final CharsetEncoder encoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        private NonBlockingReaderInputStream(NonBlockingReader nonBlockingReader, Charset charset) {
            this.reader = nonBlockingReader;
            this.encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
            this.bytes = ByteBuffer.allocate(4);
            this.chars = CharBuffer.allocate(2);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        public int available() {
            return (int)((float)this.reader.available() * this.encoder.averageBytesPerChar()) + this.bytes.remaining();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public int read(long l, boolean bl) throws IOException {
            boolean bl2;
            boolean bl3 = bl2 = l <= 0L;
            while (!this.bytes.hasRemaining() && (bl2 || l > 0L)) {
                int n;
                long l2 = 0L;
                if (!bl2) {
                    l2 = System.currentTimeMillis();
                }
                if ((n = this.reader.read(l)) == -1) {
                    return -1;
                }
                if (n >= 0) {
                    if (!this.chars.hasRemaining()) {
                        this.chars.position(0);
                        this.chars.limit(0);
                    }
                    int n2 = this.chars.limit();
                    this.chars.array()[this.chars.arrayOffset() + n2] = (char)n;
                    this.chars.limit(n2 + 1);
                    this.bytes.clear();
                    this.encoder.encode(this.chars, this.bytes, false);
                    this.bytes.flip();
                }
                if (bl2) continue;
                l -= System.currentTimeMillis() - l2;
            }
            if (this.bytes.hasRemaining()) {
                if (bl) {
                    return this.bytes.get(this.bytes.position());
                }
                return this.bytes.get();
            }
            return -2;
        }
    }
}

