/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.BasicCommandStrings$;
import sbt.Def$;
import sbt.Exec;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Project$;
import sbt.Scope$;
import sbt.Scoped;
import sbt.SettingKey;
import sbt.SlashSyntax0$;
import sbt.StandardMain$;
import sbt.State;
import sbt.internal.CommandStrings$;
import sbt.internal.SysProp$;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileTreeRepository;
import sbt.internal.nio.FileTreeRepository$;
import sbt.internal.nio.Observer;
import sbt.internal.util.Terminal;
import sbt.nio.FileChanges;
import sbt.nio.FileStamp;
import sbt.nio.FileStamp$;
import sbt.nio.Keys;
import sbt.nio.Keys$ReloadOnSourceChanges$;
import sbt.nio.Settings$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!\u0002\r\u001a\u0001uy\u0002\"B\u0016\u0001\t\u0003i\u0003B\u0002\u0019\u0001A\u0003%\u0011\u0007\u0003\u0004F\u0001\u0001\u0006IA\u0012\u0005\u0007!\u0002\u0001\u000b\u0011B)\t\r\u0005\u0004\u0001\u0015!\u0003c\u0011\u0019)\u0007\u0001)A\u0005M\"1!\u000e\u0001Q\u0001\n-Daa\u001f\u0001\u0005\u0002ua\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!a\u0010\u0001\t\u0013\t\t\u0005\u0003\u0005\u0002L\u0001!\t!HA'\u0011\u001d\tY\u0005\u0001C\u0005\u00037Bq!a \u0001\t\u0003\n\ti\u0002\u0005\u0002\u0004fA\t!HAC\r\u001dA\u0012\u0004#\u0001\u001e\u0003\u000fCaaK\t\u0005\u0002\u0005=\u0005BCAI#\t\u0007I\u0011A\u000f\u0002\u0014\"A\u00111T\t!\u0002\u0013\t)\n\u0003\u0005\u0002\u001eF!\t!HAP\u0011!\t\u0019+\u0005C\u0001;\u0005\u0015\u0006\u0002CAb#\u0011\u0005Q$!2\u0003#\rCWmY6Ck&dGmU8ve\u000e,7O\u0003\u0002\u001b7\u0005\u0019a.[8\u000b\u0005qi\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003y\t1a\u001d2u'\r\u0001\u0001\u0005\u000b\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011%K\u0005\u0003U\t\u0012Q\"Q;u_\u000ecwn]3bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00039\u0002\"a\f\u0001\u000e\u0003e\t!B]3q_NLGo\u001c:z!\r\u0011\u0014hO\u0007\u0002g)\u0011A'N\u0001\u0007CR|W.[2\u000b\u0005Y:\u0014AC2p]\u000e,(O]3oi*\u0011\u0001\bJ\u0001\u0005kRLG.\u0003\u0002;g\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u00020yyJ!!P\r\u0003%\u0019KG.\u001a+sK\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\u007f\rk\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bAAZ5mK*\u0011!$H\u0005\u0003\t\u0002\u0013aBR5mK\u0006#HO]5ckR,7/A\u0007q_2d\u0017N\\4QKJLw\u000e\u001a\t\u0004ee:\u0005C\u0001%O\u001b\u0005I%B\u0001&L\u0003!!WO]1uS>t'B\u0001\u001cM\u0015\u0005i\u0015!B:dC2\f\u0017BA(J\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fqa]8ve\u000e,7\u000fE\u00023sI\u00032aU._\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002XY\u00051AH]8pizJ\u0011!T\u0005\u000352\u000bq\u0001]1dW\u0006<W-\u0003\u0002];\n\u00191+Z9\u000b\u0005ic\u0005CA `\u0013\t\u0001\u0007I\u0001\u0003HY>\u0014\u0017A\u00038fK\u0012,\u0006\u000fZ1uKB\u0011!gY\u0005\u0003IN\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017A\u00037bgR\u0004v\u000e\u001c7fIB\u0019!'O4\u0011\u0005!C\u0017BA5J\u0005!!U-\u00193mS:,\u0017A\u00049sKZLw.^:Ti\u0006l\u0007o\u001d\t\u0004eeb\u0007cA*\\[B!an\\9x\u001b\u0005a\u0015B\u00019M\u0005\u0019!V\u000f\u001d7feA\u0011!/^\u0007\u0002g*\u0011\u0011\t\u001e\u0006\u00035\u0011J!A^:\u0003\tA\u000bG\u000f\u001b\t\u0003qfl\u0011AQ\u0005\u0003u\n\u0013\u0011BR5mKN#\u0018-\u001c9\u0002%\u0019LG.\u001a+sK\u0016\u0014V\r]8tSR|'/_\u000b\u0002{B\u0019aN`\u001e\n\u0005}d%AB(qi&|g.A\u0005hKR\u001cF/Y7qgR\u0019A.!\u0002\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005)am\u001c:dKB\u0019a.a\u0003\n\u0007\u00055AJA\u0004C_>dW-\u00198\u0002\u000bI,7/\u001a;\u0015\t\u0005M\u0011\u0011\u0004\t\u0004]\u0006U\u0011bAA\f\u0019\n!QK\\5u\u0011\u001d\tYB\u0003a\u0001\u0003;\tQa\u001d;bi\u0016\u0004B!a\b\u0002\"5\tQ$C\u0002\u0002$u\u0011Qa\u0015;bi\u0016\f\u0011B\\3fI\u000eCWmY6\u0015\r\u0005%\u0011\u0011FA\u0016\u0011\u001d\tYb\u0003a\u0001\u0003;Aq!!\f\f\u0001\u0004\ty#A\u0002d[\u0012\u0004B!!\r\u0002:9!\u00111GA\u001b!\t)F*C\u0002\u000281\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001e\u0003{\u0011aa\u0015;sS:<'bAA\u001c\u0019\u0006Qam\u001c:dK\u000eCWmY6\u0016\u0005\u0005%\u0001f\u0001\u0007\u0002FA\u0019a.a\u0012\n\u0007\u0005%CJ\u0001\u0004j]2Lg.Z\u0001\f]\u0016,Gm\u001d*fY>\fG\r\u0006\u0004\u0002\n\u0005=\u0013\u0011\u000b\u0005\b\u00037i\u0001\u0019AA\u000f\u0011\u001d\t\u0019&\u0004a\u0001\u0003+\nA!\u001a=fGB!\u0011qDA,\u0013\r\tI&\b\u0002\u0005\u000bb,7\r\u0006\u0005\u0002\n\u0005u\u0013qLA?\u0011\u001d\tYB\u0004a\u0001\u0003;Aq!!\u0019\u000f\u0001\u0004\t\u0019'\u0001\tm_\u001e<WM](s)\u0016\u0014X.\u001b8bYB91+!\u001a\u0002j\u0005M\u0014bAA4;\n1Q)\u001b;iKJ\u0004B!a\u001b\u0002p5\u0011\u0011Q\u000e\u0006\u0003quIA!!\u001d\u0002n\t1Aj\\4hKJ\u0004B!!\u001e\u0002z5\u0011\u0011q\u000f\u0006\u0003qmIA!a\u001f\u0002x\tAA+\u001a:nS:\fG\u000eC\u0004\u0002.9\u0001\r!a\f\u0002\u000b\rdwn]3\u0015\u0005\u0005M\u0011!E\"iK\u000e\\')^5mIN{WO]2fgB\u0011q&E\n\u0004#\u0005%\u0005c\u00018\u0002\f&\u0019\u0011Q\u0012'\u0003\r\u0005s\u0017PU3g)\t\t))\u0001\u000bDQ\u0016\u001c7NQ;jY\u0012\u001cv.\u001e:dKN\\U-_\u000b\u0003\u0003+\u0003R!!\u001e\u0002\u0018:JA!!'\u0002x\ta\u0011\t\u001e;sS\n,H/Z&fs\u0006)2\t[3dW\n+\u0018\u000e\u001c3T_V\u00148-Z:LKf\u0004\u0013\u0001B5oSR$B!!\b\u0002\"\"9\u00111D\u000bA\u0002\u0005u\u0011A\u00048fK\u0012\u0014V\r\\8bI&k\u0007\u000f\\\u000b\u0003\u0003O\u0003b!!+\u00020\u0006]f\u0002BA\u0010\u0003WK1!!,\u001e\u0003\r!UMZ\u0005\u0005\u0003c\u000b\u0019L\u0001\u0006J]&$\u0018.\u00197ju\u0016LA!!.\u0002x\t!\u0011J\\5u!\u0019\ty\"!/\u0002>&\u0019\u00111X\u000f\u0003\tQ\u000b7o\u001b\t\u0005\u0003?\ty,C\u0002\u0002Bv\u0011ab\u0015;bi\u0016$&/\u00198tM>\u0014X.A\u000bck&dGmU8ve\u000e,g)\u001b7f\u0013:\u0004X\u000f^:\u0016\u0005\u0005\u001d\u0007#BAU\u0003_\u0013\u0006")
public class CheckBuildSources
implements AutoCloseable {
    private final AtomicReference<FileTreeRepository<FileAttributes>> repository = new AtomicReference();
    private final AtomicReference<FiniteDuration> pollingPeriod = new AtomicReference();
    private final AtomicReference<Seq<Glob>> sources = new AtomicReference<Nil$>(Nil$.MODULE$);
    private final AtomicBoolean needUpdate = new AtomicBoolean(true);
    private final AtomicReference<Deadline> lastPolled = new AtomicReference<Deadline>(Deadline$.MODULE$.now());
    private final AtomicReference<Seq<Tuple2<Path, FileStamp>>> previousStamps = new AtomicReference();

    public Option<FileTreeRepository<FileAttributes>> fileTreeRepository() {
        return Option$.MODULE$.apply(this.repository.get());
    }

    private Seq<Tuple2<Path, FileStamp>> getStamps(boolean force) {
        Deadline now = Deadline$.MODULE$.now();
        Deadline lp = this.lastPolled.getAndSet(now);
        if (force || lp.$plus(this.pollingPeriod.get()).$less$eq((Object)now)) {
            return (Seq)FileTreeView.Ops$.MODULE$.list$extension2(FileTreeView$.MODULE$.Ops(FileTreeView$.MODULE$.default()), (Traversable)this.sources.get()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Path p = (Path)tuple2._1();
                    FileAttributes a = (FileAttributes)tuple2._2();
                    if (a.isRegularFile()) {
                        return Option$.MODULE$.option2Iterable(FileStamp$.MODULE$.hash(p).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), x$1)));
                    }
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }, Seq$.MODULE$.canBuildFrom());
        }
        return this.previousStamps.get();
    }

    public void sbt$internal$nio$CheckBuildSources$$reset(State state) {
        Seq<Glob> previousSources;
        Extracted extracted = Project$.MODULE$.extract(state);
        FiniteDuration interval = (FiniteDuration)extracted.get((SettingKey)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichScopeFromScoped(sbt.nio.Keys$.MODULE$.checkBuildSources()).$div(Keys$.MODULE$.pollInterval()));
        Seq newSources = (Seq)extracted.get((SettingKey)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichScopeFromScoped((Scoped)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichScope(Scope$.MODULE$.Global()).$div(sbt.nio.Keys$.MODULE$.checkBuildSources())).$div(sbt.nio.Keys$.MODULE$.fileInputs()));
        if (interval.$greater$eq((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()) || "polling".equals(SysProp$.MODULE$.watchMode())) {
            Option$.MODULE$.apply(this.repository.getAndSet(null)).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.close();
                return BoxedUnit.UNIT;
            });
            this.pollingPeriod.set(interval);
        } else {
            this.pollingPeriod.set(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds());
            FileTreeRepository<FileAttributes> fileTreeRepository = this.repository.get();
            if (fileTreeRepository == null) {
                FileTreeRepository repo = FileTreeRepository$.MODULE$.default();
                repo.addObserver((Observer)new Observer<FileEvent<FileAttributes>>(this){
                    private final /* synthetic */ CheckBuildSources $outer;

                    public void close() {
                        Observer.close$((Observer)this);
                    }

                    public final void onNext(FileEvent<FileAttributes> t) {
                        this.$outer.sbt$internal$nio$CheckBuildSources$$$anonfun$reset$2(t);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        Observer.$init$((Observer)this);
                    }
                });
                this.repository.set((FileTreeRepository<FileAttributes>)repo);
                newSources.foreach((Function1 & Serializable & scala.Serializable)g -> {
                    CheckBuildSources.$anonfun$reset$3(repo, g);
                    return BoxedUnit.UNIT;
                });
            }
        }
        Seq<Glob> seq = previousSources = this.sources.getAndSet((Seq<Glob>)newSources);
        Seq seq2 = newSources;
        if (seq == null ? seq2 != null : !seq.equals((Object)seq2)) {
            this.fileTreeRepository().foreach((Function1 & Serializable & scala.Serializable)r -> {
                newSources.foreach((Function1 & Serializable & scala.Serializable)g -> {
                    CheckBuildSources.$anonfun$reset$6(r, g);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.previousStamps.set(this.getStamps(true));
            return;
        }
    }

    private boolean needCheck(State state, String cmd) {
        Function1 & Serializable & scala.Serializable filter;
        List allCmds = (List)((List)state.remainingCommands().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.commandLine(), List$.MODULE$.canBuildFrom())).dropWhile((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CheckBuildSources.$anonfun$needCheck$2(x$7))).$colon$plus((Object)cmd, List$.MODULE$.canBuildFrom());
        List commands = (List)allCmds.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8.split(";"))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$9.trim().split(" "))).headOption()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isEmpty())))), List$.MODULE$.canBuildFrom());
        boolean resetState = commands.exists((Function1)(filter = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CheckBuildSources.$anonfun$needCheck$6(c))));
        if (resetState) {
            this.previousStamps.set(this.getStamps(true));
            this.needUpdate.set(false);
        }
        return !resetState;
    }

    private boolean forceCheck() {
        return this.fileTreeRepository().isEmpty();
    }

    public boolean needsReload(State state, Exec exec) {
        Left left;
        Option name = exec.source().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.channelName());
        Option option = name.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> StandardMain$.MODULE$.exchange().channelForName((String)x$12).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.terminal()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Terminal t = (Terminal)some.value();
            left = package$.MODULE$.Right().apply((Object)t);
        } else {
            left = package$.MODULE$.Left().apply((Object)state.globalLogging().full());
        }
        Left loggerOrTerminal = left;
        return this.needsReload(state, (Either<Logger, Terminal>)loggerOrTerminal, exec.commandLine());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean needsReload(State state, Either<Logger, Terminal> loggerOrTerminal, String cmd) {
        if (!this.needCheck(state, cmd)) return false;
        if (!this.forceCheck()) {
            if (!this.needUpdate.compareAndSet(true, false)) return false;
        }
        Extracted extracted = Project$.MODULE$.extract(state);
        Keys.WatchBuildSourceOption onChanges = (Keys.WatchBuildSourceOption)extracted.get((SettingKey)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichScope(Scope$.MODULE$.Global()).$div(sbt.nio.Keys$.MODULE$.onChangedBuildSource()));
        Seq<Tuple2<Path, FileStamp>> current = this.getStamps(false);
        Seq<Tuple2<Path, FileStamp>> previous = this.previousStamps.getAndSet(current);
        FileChanges fileChanges = Settings$.MODULE$.changedFiles(previous, current);
        if (fileChanges == null) return false;
        Seq<Path> created = fileChanges.created();
        Seq<Path> deleted = fileChanges.deleted();
        Seq<Path> modified = fileChanges.modified();
        if (!fileChanges.hasChanges()) return false;
        String rawPrefix = new StringBuilder(32).append("build source files have changed\n").append((Object)(created.nonEmpty() ? new StringBuilder(11).append("new files: ").append(created.mkString("\n  ", "\n  ", "\n")).toString() : "")).append((Object)(deleted.nonEmpty() ? new StringBuilder(15).append("deleted files: ").append(deleted.mkString("\n  ", "\n  ", "\n")).toString() : "")).append((Object)(modified.nonEmpty() ? new StringBuilder(16).append("modified files: ").append(modified.mkString("\n  ", "\n  ", "\n")).toString() : "")).toString();
        String prefix = new StringOps(Predef$.MODULE$.augmentString(rawPrefix)).linesIterator().filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CheckBuildSources.$anonfun$needsReload$4(x$14))).mkString("\n");
        Keys.WatchBuildSourceOption watchBuildSourceOption = onChanges;
        Keys$ReloadOnSourceChanges$ keys$ReloadOnSourceChanges$ = Keys$ReloadOnSourceChanges$.MODULE$;
        if (!(watchBuildSourceOption != null ? !watchBuildSourceOption.equals(keys$ReloadOnSourceChanges$) : keys$ReloadOnSourceChanges$ != null)) {
            String msg = new StringBuilder(17).append(prefix).append("\nReloading sbt...").toString();
            Either<Logger, Terminal> either = loggerOrTerminal;
            if (either instanceof Right) {
                Right right = (Right)either;
                Terminal t = (Terminal)right.value();
                new StringOps(Predef$.MODULE$.augmentString(msg)).linesIterator().foreach((Function1 & Serializable & scala.Serializable)l -> {
                    CheckBuildSources.$anonfun$needsReload$5(t, l);
                    return BoxedUnit.UNIT;
                });
                return true;
            } else {
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                Logger l2 = (Logger)left.value();
                l2.info((Function0 & Serializable & scala.Serializable)() -> msg);
            }
            return true;
        }
        String tail = "Apply these changes by running `reload`.\nAutomatically reload the build when source changes are detected by setting `Global / onChangedBuildSource := ReloadOnSourceChanges`.\nDisable this warning by setting `Global / onChangedBuildSource := IgnoreSourceChanges`.";
        String msg = new StringBuilder(1).append(prefix).append("\n").append(tail).toString();
        Either<Logger, Terminal> either = loggerOrTerminal;
        if (either instanceof Right) {
            Right right = (Right)either;
            Terminal t = (Terminal)right.value();
            String prefix2 = new StringBuilder(2).append("[").append(Def$.MODULE$.withColor("warn", (Option)new Some((Object)"\u001b[33m"), t.isColorEnabled())).append("]").toString();
            new StringOps(Predef$.MODULE$.augmentString(msg)).linesIterator().foreach((Function1 & Serializable & scala.Serializable)l -> {
                CheckBuildSources.$anonfun$needsReload$7(t, prefix2, l);
                return BoxedUnit.UNIT;
            });
            return false;
        } else {
            if (!(either instanceof Left)) throw new MatchError(either);
            Left left = (Left)either;
            Logger l3 = (Logger)left.value();
            l3.warn((Function0 & Serializable & scala.Serializable)() -> msg);
        }
        return false;
    }

    @Override
    public void close() {
    }

    public final /* synthetic */ void sbt$internal$nio$CheckBuildSources$$$anonfun$reset$2(FileEvent x$3) {
        this.needUpdate.set(true);
    }

    public static final /* synthetic */ void $anonfun$reset$3(FileTreeRepository repo$1, Glob g) {
        repo$1.register(g).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reset$6(FileTreeRepository r$1, Glob g) {
        r$1.register(g).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$needCheck$2(String x$7) {
        return !x$7.startsWith(BasicCommandStrings$.MODULE$.MapExec());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$needCheck$6(String c) {
        String string = c;
        String string2 = CommandStrings$.MODULE$.LoadProject();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = c;
        String string4 = BasicCommandStrings$.MODULE$.RebootCommand();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = c;
        String string6 = BasicCommandStrings$.MODULE$.TerminateAction();
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        String string7 = c;
        String string8 = BasicCommandStrings$.MODULE$.Shutdown();
        if (string7 == null) {
            if (string8 == null) return true;
        } else if (string7.equals(string8)) return true;
        if (!c.startsWith("sbtReboot")) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$needsReload$4(String x$14) {
        return x$14.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$needsReload$5(Terminal t$1, String l) {
        t$1.printStream().println(new StringBuilder(7).append("[info] ").append(l).toString());
    }

    public static final /* synthetic */ void $anonfun$needsReload$7(Terminal t$2, String prefix$1, String l) {
        t$2.printStream().println(new StringBuilder(1).append(prefix$1).append(" ").append(l).toString());
    }
}

