/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import sbt.internal.ClassLoaderClose;
import sbt.internal.XMainClassLoader;
import xsbti.AppConfiguration;
import xsbti.AppMain;
import xsbti.AppProvider;
import xsbti.ApplicationID;
import xsbti.ComponentProvider;
import xsbti.GlobalLock;
import xsbti.Launcher;
import xsbti.MainResult;
import xsbti.Repository;
import xsbti.ScalaProvider;

public class XMainConfiguration {
    public MainResult run(String moduleName, AppConfiguration configuration) throws Throwable {
        try {
            ClassLoader topLoader = configuration.provider().scalaProvider().launcher().topLoader();
            AppConfiguration updatedConfiguration = null;
            try {
                int j;
                Method method = topLoader.getClass().getMethod("getJLineJars", new Class[0]);
                URL[] jars = (URL[])method.invoke((Object)topLoader, new Object[0]);
                boolean canReuseConfiguration = jars.length == 3;
                for (j = 0; j < jars.length && canReuseConfiguration; ++j) {
                    String s = jars[j].toString();
                    canReuseConfiguration = s.contains("jline") || s.contains("jansi");
                }
                updatedConfiguration = canReuseConfiguration && j == 3 ? configuration : this.makeConfiguration(configuration);
            }
            catch (NoSuchMethodException e) {
                updatedConfiguration = this.makeConfiguration(configuration);
            }
            ClassLoader loader = updatedConfiguration.provider().loader();
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass("sbt." + moduleName + "$");
            Object instance = clazz.getField("MODULE$").get(null);
            Method runMethod = clazz.getMethod("run", AppConfiguration.class);
            try {
                Class<?> clw = loader.loadClass("sbt.internal.ClassLoaderWarmup$");
                clw.getMethod("warmup", new Class[0]).invoke(clw.getField("MODULE$").get(null), new Object[0]);
                return (MainResult)runMethod.invoke(instance, updatedConfiguration);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private AppConfiguration makeConfiguration(AppConfiguration configuration) {
        try {
            ClassLoader baseLoader = XMainConfiguration.class.getClassLoader();
            String className = "sbt/internal/XMainConfiguration.class";
            URL url = baseLoader.getResource(className);
            String path = url.toString().replaceAll(className.concat("$"), "");
            URL[] urlArray = new URL[]{new URI(path).toURL()};
            ClassLoader topLoader = configuration.provider().scalaProvider().launcher().topLoader();
            XMainClassLoader modifiedLoader = new XMainClassLoader(urlArray, topLoader);
            Class<?> xMainConfigurationClass = modifiedLoader.loadClass("sbt.internal.XMainConfiguration");
            Object instance = xMainConfigurationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> metaBuildLoaderClass = modifiedLoader.loadClass("sbt.internal.MetaBuildLoader");
            Method method = metaBuildLoaderClass.getMethod("makeLoader", AppProvider.class);
            ClassLoader loader = (ClassLoader)method.invoke(null, configuration.provider());
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> modifiedConfigurationClass = modifiedLoader.loadClass("sbt.internal.XMainConfiguration$ModifiedConfiguration");
            Constructor<?> cons = modifiedConfigurationClass.getConstructors()[0];
            ClassLoaderClose.close(configuration.provider().loader());
            ScalaProvider scalaProvider = configuration.provider().scalaProvider();
            Class<?> providerClass = scalaProvider.getClass();
            try {
                Method method2 = providerClass.getMethod("loaderLibraryOnly", new Class[0]);
                ClassLoaderClose.close((ClassLoader)method2.invoke((Object)scalaProvider, new Object[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            ClassLoaderClose.close(scalaProvider.loader());
            ClassLoaderClose.close(configuration.provider().loader());
            return (AppConfiguration)cons.newInstance(instance, configuration, loader);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public class ModifiedConfiguration
    implements AppConfiguration {
        private AppConfiguration configuration;
        private ClassLoader metaLoader;

        public ModifiedConfiguration(AppConfiguration configuration, ClassLoader metaLoader) {
            this.configuration = configuration;
            this.metaLoader = metaLoader;
        }

        public String[] arguments() {
            return this.configuration.arguments();
        }

        public File baseDirectory() {
            return this.configuration.baseDirectory();
        }

        public AppProvider provider() {
            try {
                return new ModifiedAppProvider(this.configuration.provider());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public class ModifiedAppProvider
        implements AppProvider {
            private AppProvider appProvider;
            private ScalaProvider instance;

            public ModifiedAppProvider(AppProvider appProvider) throws ClassNotFoundException {
                this.appProvider = appProvider;
                final ScalaProvider delegate = ModifiedConfiguration.this.configuration.provider().scalaProvider();
                this.instance = new ScalaProvider(){
                    public Launcher _launcher = new Launcher(){
                        private Launcher delegateLauncher;
                        private ClassLoader interfaceLoader;
                        {
                            this.delegateLauncher = delegate.launcher();
                            this.interfaceLoader = ModifiedConfiguration.this.metaLoader.loadClass("sbt.testing.Framework").getClassLoader();
                        }

                        public ScalaProvider getScala(String version) {
                            return this.getScala(version, "");
                        }

                        public ScalaProvider getScala(String version, String reason) {
                            return this.getScala(version, reason, "org.scala-lang");
                        }

                        public ScalaProvider getScala(String version, String reason, String scalaOrg) {
                            return this.delegateLauncher.getScala(version, reason, scalaOrg);
                        }

                        public AppProvider app(ApplicationID id, String version) {
                            return this.delegateLauncher.app(id, version);
                        }

                        public ClassLoader topLoader() {
                            return this.interfaceLoader;
                        }

                        public GlobalLock globalLock() {
                            return this.delegateLauncher.globalLock();
                        }

                        public File bootDirectory() {
                            return this.delegateLauncher.bootDirectory();
                        }

                        public Repository[] ivyRepositories() {
                            return this.delegateLauncher.ivyRepositories();
                        }

                        public Repository[] appRepositories() {
                            return this.delegateLauncher.appRepositories();
                        }

                        public boolean isOverrideRepositories() {
                            return this.delegateLauncher.isOverrideRepositories();
                        }

                        public File ivyHome() {
                            return this.delegateLauncher.ivyHome();
                        }

                        public String[] checksums() {
                            return this.delegateLauncher.checksums();
                        }
                    };

                    public Launcher launcher() {
                        return this._launcher;
                    }

                    public String version() {
                        return delegate.version();
                    }

                    public ClassLoader loader() {
                        return ModifiedConfiguration.this.metaLoader.getParent();
                    }

                    public File[] jars() {
                        return delegate.jars();
                    }

                    @Deprecated
                    public File libraryJar() {
                        return delegate.libraryJar();
                    }

                    @Deprecated
                    public File compilerJar() {
                        return delegate.compilerJar();
                    }

                    public AppProvider app(ApplicationID id) {
                        return delegate.app(id);
                    }

                    private ClassLoader loaderLibraryOnly() {
                        return ModifiedConfiguration.this.metaLoader.getParent().getParent();
                    }
                };
            }

            public ScalaProvider scalaProvider() {
                return this.instance;
            }

            public ApplicationID id() {
                return this.appProvider.id();
            }

            public ClassLoader loader() {
                return ModifiedConfiguration.this.metaLoader;
            }

            @Deprecated
            public Class<? extends AppMain> mainClass() {
                return this.appProvider.mainClass();
            }

            public Class<?> entryPoint() {
                return this.appProvider.entryPoint();
            }

            public AppMain newMain() {
                return this.appProvider.newMain();
            }

            public File[] mainClasspath() {
                return this.appProvider.mainClasspath();
            }

            public ComponentProvider components() {
                return this.appProvider.components();
            }
        }
    }
}

