/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import sbt.BuildPaths$;
import sbt.BuildRef;
import sbt.Def$;
import sbt.Keys$;
import sbt.LocalProject;
import sbt.LocalRootProject$;
import sbt.Previous$;
import sbt.ProjectDefinition;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.ResolvedReference;
import sbt.RootProject;
import sbt.Scope;
import sbt.Scope$;
import sbt.ScopeAxis;
import sbt.Select;
import sbt.State;
import sbt.State$;
import sbt.This$;
import sbt.ThisBuild$;
import sbt.ThisProject$;
import sbt.Zero$;
import sbt.internal.InMemoryCacheStore;
import sbt.internal.InMemoryCacheStore$;
import sbt.internal.LoadedBuildUnit;
import sbt.internal.LogManager$;
import sbt.internal.util.AttributeEntry;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeMap;
import sbt.internal.util.Init;
import sbt.internal.util.Settings;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.std.Streams;
import sbt.std.Streams$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.math.Ordering;
import scala.sys.package$;

public final class BuildStreams$ {
    public static BuildStreams$ MODULE$;

    static {
        new BuildStreams$();
    }

    public final String GlobalPath() {
        return "_global";
    }

    public final String BuildUnitPath() {
        return "_build";
    }

    public final String StreamsDirectory() {
        return "streams";
    }

    private final String RootPath() {
        return "_root";
    }

    public Function1<State, Streams<Init.ScopedKey<?>>> mkStreams(Map<URI, LoadedBuildUnit> units, URI root, Settings<Scope> data) {
        return (Function1 & Serializable & scala.Serializable)s -> (Streams)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.stateStreams()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCacheStore.CacheStoreFactoryFactory factory = (InMemoryCacheStore.CacheStoreFactoryFactory)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.cacheStoreFactoryFactory()).getOrElse((Function0 & Serializable & scala.Serializable)() -> InMemoryCacheStore$.MODULE$.factory(0L));
            return Streams$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.path(units, root, data, (Init.ScopedKey<?>)x$12), (Function1 & Serializable & scala.Serializable)scoped -> Def$.MODULE$.displayFull(scoped), LogManager$.MODULE$.construct(data, (State)s), (Function1 & Serializable & scala.Serializable)file -> factory.apply(file.toPath()));
        });
    }

    public File path(Map<URI, LoadedBuildUnit> units, URI root, Settings<Scope> data, Init.ScopedKey<?> scoped) {
        return this.resolvePath(this.projectPath(units, root, scoped, data), this.nonProjectPath(scoped));
    }

    public File resolvePath(File base, Seq<String> components) {
        return (File)components.foldLeft((Object)base, (Function2 & Serializable & scala.Serializable)(b, p) -> new File((File)b, (String)p));
    }

    public <T> String pathComponent(ScopeAxis<T> axis, Init.ScopedKey<?> scoped, String label, Function1<T, String> show) {
        String string;
        ScopeAxis<T> scopeAxis = axis;
        if (Zero$.MODULE$.equals(scopeAxis)) {
            string = "_global";
        } else {
            if (This$.MODULE$.equals(scopeAxis)) {
                throw package$.MODULE$.error(new StringBuilder(34).append("Unresolved This reference for ").append(label).append(" in ").append(Def$.MODULE$.displayFull(scoped)).toString());
            }
            if (scopeAxis instanceof Select) {
                Select select = (Select)scopeAxis;
                Object t = select.s();
                string = (String)show.apply(t);
            } else {
                throw new MatchError(scopeAxis);
            }
        }
        return string;
    }

    public <T> Seq<String> nonProjectPath(Init.ScopedKey<T> scoped) {
        Scope scope = (Scope)scoped.scope();
        String string = this.pathComponent(scope.config(), scoped, "config", (Function1 & Serializable & scala.Serializable)x$13 -> x$13.name());
        String string2 = this.pathComponent(scope.task(), scoped, "task", (Function1 & Serializable & scala.Serializable)x$14 -> x$14.label());
        String string3 = this.pathComponent(scope.extra(), scoped, "extra", (Function1 & Serializable & scala.Serializable)a -> MODULE$.showAMap((AttributeMap)a));
        String string4 = scoped.key().label();
        return this.previousComponent((ScopeAxis<AttributeMap>)scope.extra()).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
    }

    /*
     * Unable to fully structure code
     */
    private List<String> previousComponent(ScopeAxis<AttributeMap> value) {
        block17: {
            block12: {
                block16: {
                    block13: {
                        block15: {
                            block14: {
                                var6_2 = value;
                                if (!(var6_2 instanceof Select)) break block12;
                                var7_3 = (Select)var6_2;
                                am = (AttributeMap)var7_3.s();
                                var9_5 = am.get(Previous$.MODULE$.scopedKeyAttribute());
                                if (!(var9_5 instanceof Some)) break block13;
                                var10_6 = (Some)var9_5;
                                sk = (Init.ScopedKey)var10_6.value();
                                var13_8 = false;
                                var14_9 = null;
                                var15_10 = ((Scope)sk.scope()).project();
                                if (!Zero$.MODULE$.equals(var15_10)) break block14;
                                var4_11 = "_global";
                                break block15;
                            }
                            if (!(var15_10 instanceof Select)) ** GOTO lbl-1000
                            var13_8 = true;
                            var14_9 = (Select)var15_10;
                            var16_12 = (Reference)var14_9.s();
                            if (var16_12 instanceof BuildRef) {
                                var4_11 = "_build";
                            } else if (var13_8 && (var17_13 = (Reference)var14_9.s()) instanceof ProjectRef) {
                                var18_14 = (ProjectRef)var17_13;
                                var4_11 = id = var18_14.project();
                            } else if (var13_8 && (var20_16 = (Reference)var14_9.s()) instanceof LocalProject) {
                                var21_17 = (LocalProject)var20_16;
                                var4_11 = id = var21_17.project();
                            } else if (var13_8 && (var23_19 = (Reference)var14_9.s()) instanceof RootProject) {
                                var4_11 = "_root";
                            } else if (var13_8 && LocalRootProject$.MODULE$.equals(var24_20 = (Reference)var14_9.s())) {
                                var4_11 = LocalRootProject$.MODULE$.toString();
                            } else {
                                var5_23 = var15_10 instanceof Select != false && ThisBuild$.MODULE$.equals(var26_22 = (Reference)(var25_21 = (Select)var15_10).s()) != false ? true : (var15_10 instanceof Select != false && ThisProject$.MODULE$.equals(var28_25 = (Reference)(var27_24 = (Select)var15_10).s()) != false ? true : This$.MODULE$.equals(var15_10) != false);
                                if (var5_23) {
                                    var4_11 = This$.MODULE$.toString();
                                } else {
                                    throw new MatchError((Object)var15_10);
                                }
                            }
                        }
                        project = var4_11;
                        var3_27 = (List)new .colon.colon((Object)"previous-dependencies", (List)new .colon.colon((Object)project, (List)Nil$.MODULE$)).$plus$plus(this.nonProjectPath(sk), List$.MODULE$.canBuildFrom());
                        break block16;
                    }
                    var3_27 = Nil$.MODULE$;
                }
                var2_28 = var3_27;
                break block17;
            }
            var2_28 = Nil$.MODULE$;
        }
        return var2_28;
    }

    public String showAMap(AttributeMap a) {
        return ((Stream)((Stream)a.entries().toStream().sortBy((Function1 & Serializable & scala.Serializable)x$19 -> x$19.key().label(), (Ordering)Ordering.String$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AttributeEntry attributeEntry = x0$1;
            if (attributeEntry != null) {
                AttributeKey key;
                AttributeKey attributeKey = key = attributeEntry.key();
                AttributeKey attributeKey2 = Previous$.MODULE$.scopedKeyAttribute();
                if (attributeKey == null) {
                    if (attributeKey2 == null) return Nil$.MODULE$;
                } else if (attributeKey.equals(attributeKey2)) {
                    return Nil$.MODULE$;
                }
            }
            if (attributeEntry == null) throw new MatchError((Object)attributeEntry);
            AttributeKey key = attributeEntry.key();
            Object value = attributeEntry.value();
            String string = new StringBuilder(1).append(key.label()).append("=").append(value).toString();
            return Nil$.MODULE$.$colon$colon((Object)string);
        }, Stream$.MODULE$.canBuildFrom())).mkString(" ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File projectPath(Map<URI, LoadedBuildUnit> units, URI root, Init.ScopedKey<?> scoped, Settings<Scope> data) {
        Reference pr;
        boolean bl = false;
        Select select = null;
        ScopeAxis scopeAxis = ((Scope)scoped.scope()).project();
        if (Zero$.MODULE$.equals(scopeAxis)) {
            return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.refTarget(Scope$.MODULE$.GlobalScope(), ((LoadedBuildUnit)units.apply((Object)root)).localBase(), data)), "_global");
        }
        if (scopeAxis instanceof Select) {
            bl = true;
            select = (Select)scopeAxis;
            Reference br = (Reference)select.s();
            if (br instanceof BuildRef) {
                BuildRef buildRef = (BuildRef)br;
                URI uri = buildRef.build();
                return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.refTarget((ResolvedReference)buildRef, ((LoadedBuildUnit)units.apply((Object)uri)).localBase(), data)), "_build");
            }
        }
        if (bl && (pr = (Reference)select.s()) instanceof ProjectRef) {
            ProjectRef projectRef = (ProjectRef)pr;
            URI uri = projectRef.build();
            String id = projectRef.project();
            return this.refTarget((ResolvedReference)projectRef, ((ProjectDefinition)((LoadedBuildUnit)units.apply((Object)uri)).defined().apply((Object)id)).base(), data);
        }
        if (bl) {
            Reference pr2 = (Reference)select.s();
            throw package$.MODULE$.error(new StringBuilder(35).append("Unresolved project reference (").append(pr2).append(") in ").append(Def$.MODULE$.displayFull(scoped)).toString());
        }
        if (!This$.MODULE$.equals(scopeAxis)) throw new MatchError((Object)scopeAxis);
        throw package$.MODULE$.error(new StringBuilder(39).append("Unresolved project reference (This) in ").append(Def$.MODULE$.displayFull(scoped)).toString());
    }

    public File refTarget(ResolvedReference ref, File fallbackBase, Settings<Scope> data) {
        return this.refTarget(Scope$.MODULE$.GlobalScope().copy((ScopeAxis)new Select((Object)ref), Scope$.MODULE$.GlobalScope().copy$default$2(), Scope$.MODULE$.GlobalScope().copy$default$3(), Scope$.MODULE$.GlobalScope().copy$default$4()), fallbackBase, data);
    }

    public File refTarget(Scope scope, File fallbackBase, Settings<Scope> data) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile((File)Keys$.MODULE$.target().in(scope).get(data).getOrElse((Function0 & Serializable & scala.Serializable)() -> BuildPaths$.MODULE$.outputDirectory(fallbackBase))), "streams");
    }

    private BuildStreams$() {
        MODULE$ = this;
    }
}

