/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import sbt.Result;
import sbt.Task;
import sbt.internal.AbstractTaskExecuteProgress;
import sbt.internal.ShutdownHooks$;
import sbt.internal.util.ConsoleOut;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.RMap;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sjsonnew.shaded.scalajson.ast.unsafe.JString;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;

@ScalaSignature(bytes="\u0006\u0001q3Qa\u0003\u0007\u0003\u001dAAQ\u0001\b\u0001\u0005\u0002yAa\u0001\t\u0001!B\u0013\t\u0003BB\u0014\u0001A\u0003%\u0001\u0006C\u0003/\u0001\u0011\u0005s\u0006C\u00034\u0001\u0011\u0005C\u0007C\u0003E\u0001\u0011\u0005S\tC\u0003R\u0001\u0011\u0005#\u000bC\u0003Z\u0001\u0011\u0005s\u0006\u0003\u0004[\u0001\u0001&Ia\f\u0005\u00077\u0002\u0001K\u0011B\u0018\u0003\u001dQ\u000b7o\u001b+sC\u000e,WI^3oi*\u0011QBD\u0001\tS:$XM\u001d8bY*\tq\"A\u0002tER\u001c2\u0001A\t\u0016!\t\u00112#D\u0001\r\u0013\t!BBA\u000eBEN$(/Y2u)\u0006\u001c8.\u0012=fGV$X\r\u0015:pOJ,7o\u001d\t\u0004-]IR\"\u0001\b\n\u0005aq!aD#yK\u000e,H/\u001a)s_\u001e\u0014Xm]:\u0011\u0005YQ\u0012BA\u000e\u000f\u0005\u0011!\u0016m]6\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\b\t\u0003%\u0001\tQa\u001d;beR\u0004\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A\u0001T8oO\u000691m\u001c8t_2,\u0007CA\u0015-\u001b\u0005Q#BA\u0016\r\u0003\u0011)H/\u001b7\n\u00055R#AC\"p]N|G.Z(vi\u00069\u0011N\\5uS\u0006dG#\u0001\u0019\u0011\u0005\t\n\u0014B\u0001\u001a$\u0005\u0011)f.\u001b;\u0002\u0015\u00054G/\u001a:SK\u0006$\u0017\u0010\u0006\u00021k!)a'\u0002a\u0001o\u0005!A/Y:la\tA4\bE\u0002\u00175e\u0002\"AO\u001e\r\u0001\u0011IA(NA\u0001\u0002\u0003\u0015\t!\u0010\u0002\u0004?\u0012\n\u0014C\u0001 B!\t\u0011s(\u0003\u0002AG\t9aj\u001c;iS:<\u0007C\u0001\u0012C\u0013\t\u00195EA\u0002B]f\fa\"\u00194uKJ\u001cu.\u001c9mKR,G-\u0006\u0002G\u0015R\u0019\u0001g\u0012'\t\u000bY2\u0001\u0019\u0001%\u0011\u0007YQ\u0012\n\u0005\u0002;\u0015\u0012)1J\u0002b\u0001{\t\tA\u000bC\u0003N\r\u0001\u0007a*\u0001\u0004sKN,H\u000e\u001e\t\u0004-=K\u0015B\u0001)\u000f\u0005\u0019\u0011Vm];mi\u0006\t\u0012M\u001a;fe\u0006cGnQ8na2,G/\u001a3\u0015\u0005A\u001a\u0006\"\u0002+\b\u0001\u0004)\u0016a\u0002:fgVdGo\u001d\t\u0005SYK\u0002,\u0003\u0002XU\t!!+T1q!\t1r*\u0001\u0003ti>\u0004\u0018A\u0002:fa>\u0014H/A\bxe&$X\r\u0016:bG\u0016,e/\u001a8u\u0001")
public final class TaskTraceEvent
extends AbstractTaskExecuteProgress {
    private long start = 0L;
    private final ConsoleOut console = ConsoleOut$.MODULE$.systemOut();

    public void initial() {
    }

    public void afterReady(Task<?> task) {
    }

    public <T> void afterCompleted(Task<T> task, Result<T> result) {
    }

    public void afterAllCompleted(RMap<Task, Result> results) {
    }

    public void stop() {
    }

    private void report() {
        block0: {
            if (!this.anyTimings()) break block0;
            this.writeTraceEvent();
        }
    }

    private void writeTraceEvent() {
        String fileName = "build.trace";
        File tracesDirectory = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(new File("target").getAbsoluteFile()), "traces");
        if (!tracesDirectory.exists()) {
            IO$.MODULE$.createDirectory(tracesDirectory);
        }
        File outFile = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(tracesDirectory), fileName);
        BufferedWriter trace = Files.newBufferedWriter(outFile.toPath(), new OpenOption[0]);
        try {
            trace.append("{\"traceEvents\": [");
            Iterator<Tuple2<Task<?>, AbstractTaskExecuteProgress.Timer>> entryIterator = this.currentTimings();
            while (entryIterator.hasNext()) {
                Tuple2 tuple2 = (Tuple2)entryIterator.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Task key = (Task)tuple2._1();
                AbstractTaskExecuteProgress.Timer value = (AbstractTaskExecuteProgress.Timer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
                Tuple2 tuple23 = tuple22;
                Task key2 = (Task)tuple23._1();
                AbstractTaskExecuteProgress.Timer value2 = (AbstractTaskExecuteProgress.Timer)tuple23._2();
                trace.append(TaskTraceEvent.durationEvent$1(this.taskName(key2), "task", value2));
                Object object = entryIterator.hasNext() ? trace.append(",") : BoxedUnit.UNIT;
            }
            trace.append("]}");
        }
        catch (Throwable throwable) {
            trace.close();
            try {
                this.console.println(new StringBuilder(6).append("wrote ").append(outFile).toString());
            }
            catch (ClosedChannelException closedChannelException) {}
            throw throwable;
        }
        trace.close();
        try {
            this.console.println(new StringBuilder(6).append("wrote ").append(outFile).toString());
        }
        catch (ClosedChannelException closedChannelException) {}
    }

    private static final String durationEvent$1(String name, String cat, AbstractTaskExecuteProgress.Timer t) {
        StringBuilder sb = new StringBuilder(name.length() + 2);
        CompactPrinter$.MODULE$.print((JValue)new JString(name), (Appendable)sb);
        return new StringBuilder(68).append("{\"name\": ").append(sb.toString()).append(", \"cat\": \"").append(cat).append("\", \"ph\": \"X\", \"ts\": ").append(t.startMicros()).append(", \"dur\": ").append(t.durationMicros()).append(", \"pid\": 0, \"tid\": ").append(t.threadId()).append("}").toString();
    }

    public TaskTraceEvent() {
        this.start = System.nanoTime();
        ShutdownHooks$.MODULE$.add((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.report());
    }
}

