/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import sbt.Result;
import sbt.StandardMain$;
import sbt.Task;
import sbt.internal.AbstractTaskExecuteProgress;
import sbt.internal.util.ProgressEvent;
import sbt.internal.util.ProgressEvent$;
import sbt.internal.util.ProgressItem$;
import sbt.internal.util.RMap;
import sbt.util.Logger;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=b!B\u000f\u001f\u0001\u0001\u0012\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\t\u0003!\u0011!Q\u0001\naB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0007!\u0002\u0001\u000b\u0011B)\t\re\u0003\u0001\u0015!\u0003[\u0011\u0019i\u0006\u0001)A\u0005=\"1\u0001\u000f\u0001Q\u0001\nEDa!\u001e\u0001!\u0002\u00131\bBB=\u0001A\u0003%!\u0010\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\tI\u0005\u0001C)\u0003\u0017Bq!!\u0014\u0001\t\u0003\n\t\u0005\u0003\u0005\u0002P\u0001\u0001K\u0011BA!\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002t\u0001!\t%!\u0011\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011q\u0012\u0001\u0005B\u0005E\u0005\u0002CAR\u0001\u0001\u0006I!!*\t\u0011\u0005m\u0006\u0001)A\u0005\u0003KC\u0001\"!0\u0001A\u0013%\u0011q\u0018\u0005\t\u0003\u0017\u0004\u0001\u0015\"\u0003\u0002B!A\u0011Q\u001a\u0001!\n\u0013\ty\r\u0003\u0005\u0002r\u0002\u0001K\u0011BAz\u00051!\u0016m]6Qe><'/Z:t\u0015\ty\u0002%\u0001\u0005j]R,'O\\1m\u0015\u0005\t\u0013aA:ciN!\u0001aI\u0014/!\t!S%D\u0001\u001f\u0013\t1cDA\u000eBEN$(/Y2u)\u0006\u001c8.\u0012=fGV$X\r\u0015:pOJ,7o\u001d\t\u0004Q%ZS\"\u0001\u0011\n\u0005)\u0002#aD#yK\u000e,H/\u001a)s_\u001e\u0014Xm]:\u0011\u0005!b\u0013BA\u0017!\u0005\u0011!\u0016m]6\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fQb\u001d7fKB$UO]1uS>t7\u0001\u0001\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0003{y\n!bY8oGV\u0014(/\u001a8u\u0015\u0005y\u0014!B:dC2\f\u0017BA!;\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0002\r1|wmZ3s!\t)\u0005*D\u0001G\u0015\t9\u0005%\u0001\u0003vi&d\u0017BA%G\u0005\u0019aunZ4fe\u00061A(\u001b8jiz\"B\u0001T'O\u001fB\u0011A\u0005\u0001\u0005\u0006m\u0011\u0001\r\u0001\u000f\u0005\u0006\u0005\u0012\u0001\r\u0001\u000f\u0005\u0006\u0007\u0012\u0001\r\u0001R\u0001\u000eY\u0006\u001cH\u000fV1tW\u000e{WO\u001c;\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016AB1u_6L7M\u0003\u0002>-*\u0011qIM\u0005\u00031N\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018A\u0003:fa>\u0014H\u000fT8paB\u0019!k\u0017\u0018\n\u0005q\u001b&aD!u_6L7MU3gKJ,gnY3\u0002\r\u0005\u001cG/\u001b<f!\u0011y\u0006M\u0019\u0018\u000e\u0003UK!!Y+\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\r\u0002dMB\u0019\u0001\u0006\f3\u0011\u0005\u00154G\u0002\u0001\u0003\nO\u001e\t\t\u0011!A\u0003\u0002!\u00141a\u0018\u00132#\tIW\u000e\u0005\u0002kW6\ta(\u0003\u0002m}\t9aj\u001c;iS:<\u0007C\u00016o\u0013\tygHA\u0002B]f\f!B\\3yiJ+\u0007o\u001c:u!\r\u00116L\u001d\t\u0003sML!\u0001\u001e\u001e\u0003\u0011\u0011+\u0017\r\u001a7j]\u0016\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005};\u0018B\u0001=V\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\ba\u0016tG-\u001b8h!\rYHP`\u0007\u0002-&\u0011QP\u0016\u0002\u0007-\u0016\u001cGo\u001c:1\u0007}\f9\u0001E\u0003`\u0003\u0003\t)!C\u0002\u0002\u0004U\u0013aAR;ukJ,\u0007cA3\u0002\b\u0011Q\u0011\u0011\u0002\u0006\u0002\u0002\u0003\u0005)\u0011\u00015\u0003\u0007}##'\u0001\u0004dY>\u001cX\r\u001a\t\u0004%\u0006=\u0011bAA\t'\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001b]2iK\u0012,H.Z\u000b\u0005\u0003/\t9\u0003\u0006\u0004\u0002\u001a\u0005-\u0012Q\u0006\u000b\u0004]\u0005m\u0001\u0002CA\u000f\u0019\u0011\u0005\r!a\b\u0002\u0003\u0019\u0004RA[A\u0011\u0003KI1!a\t?\u0005!a$-\u001f8b[\u0016t\u0004cA3\u0002(\u00111\u0011\u0011\u0006\u0007C\u0002!\u0014\u0011A\u0015\u0005\u0006w1\u0001\r\u0001\u000f\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003%\u0011XmY;se&tw\rE\u0002k\u0003gI1!!\u000e?\u0005\u001d\u0011un\u001c7fC:\f\u0001\"\u001a=fGV$xN\u001d\t\u0004?\u0006m\u0012bAA\u001f+\nyQ\t_3dkR|'oU3sm&\u001cW-A\u0003dY>\u001cX\r\u0006\u0002\u0002DA\u0019!.!\u0012\n\u0007\u0005\u001dcH\u0001\u0003V]&$\u0018\u0001D2mK\u0006\u0014H+[7j]\u001e\u001cXCAA\u0019\u0003\u001dIg.\u001b;jC2\f\u0001\u0002Z8SKB|'\u000f^\u0001\u000bE\u00164wN]3X_J\\G\u0003BA\"\u0003+Bq!a\u0016\u0013\u0001\u0004\tI&\u0001\u0003uCN\\\u0007\u0007BA.\u0003?\u0002B\u0001\u000b\u0017\u0002^A\u0019Q-a\u0018\u0005\u0017\u0005\u0005\u0014QKA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0002\u0004?\u0012\u001a\u0014AC1gi\u0016\u0014(+Z1esR!\u00111IA4\u0011\u001d\t9f\u0005a\u0001\u0003S\u0002D!a\u001b\u0002pA!\u0001\u0006LA7!\r)\u0017q\u000e\u0003\f\u0003c\n9'!A\u0001\u0002\u000b\u0005\u0001NA\u0002`IQ\nAa\u001d;pa\u0006q\u0011M\u001a;fe\u000e{W\u000e\u001d7fi\u0016$W\u0003BA=\u0003\u0003#b!a\u0011\u0002|\u0005\u0015\u0005bBA,+\u0001\u0007\u0011Q\u0010\t\u0005Q1\ny\bE\u0002f\u0003\u0003#a!a!\u0016\u0005\u0004A'!A!\t\u000f\u0005\u001dU\u00031\u0001\u0002\n\u00061!/Z:vYR\u0004R\u0001KAF\u0003\u007fJ1!!$!\u0005\u0019\u0011Vm];mi\u0006\t\u0012M\u001a;fe\u0006cGnQ8na2,G/\u001a3\u0015\t\u0005\r\u00131\u0013\u0005\b\u0003+3\u0002\u0019AAL\u0003\u001d\u0011Xm];miN\u0004r!!'\u0002\u001e.\n\t+\u0004\u0002\u0002\u001c*\u0011qIH\u0005\u0005\u0003?\u000bYJ\u0001\u0003S\u001b\u0006\u0004\bc\u0001\u0015\u0002\f\u0006y1o[5q%\u0016\u0004xN\u001d;UCN\\7\u000f\u0005\u0004\u0002(\u0006E\u0016QW\u0007\u0003\u0003SSA!a+\u0002.\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_s\u0014AC2pY2,7\r^5p]&!\u00111WAU\u0005\r\u0019V\r\u001e\t\u0004_\u0005]\u0016bAA]a\t11\u000b\u001e:j]\u001e\f1\u0002[5eI\u0016tG+Y:lg\u0006q\u0011\r\u001d9f]\u0012\u0004&o\\4sKN\u001cH\u0003BA\"\u0003\u0003Dq!a1\u001a\u0001\u0004\t)-A\u0003fm\u0016tG\u000f\u0005\u0003\u0002\u001a\u0006\u001d\u0017\u0002BAe\u00037\u0013Q\u0002\u0015:pOJ,7o]#wK:$\u0018A\u0002:fa>\u0014H/\u0001\u0007hKR\u001c\u0006n\u001c:u\u001d\u0006lW\r\u0006\u0003\u0002R\u0006\u0015\b\u0003BAj\u0003CtA!!6\u0002^B\u0019\u0011q\u001b \u000e\u0005\u0005e'bAAno\u00051AH]8pizJ1!a8?\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XAr\u0015\r\tyN\u0010\u0005\b\u0003/Z\u0002\u0019AAta\u0011\tI/!<\u0011\t!b\u00131\u001e\t\u0004K\u00065HaCAx\u0003K\f\t\u0011!A\u0003\u0002!\u00141a\u0018\u00137\u0003\u00191\u0017\u000e\u001c;feR!\u0011Q\u001fB\u000f!\u001dQ\u0017q_A~\u0003cI1!!??\u0005\u0019!V\u000f\u001d7feA1\u0011Q B\u0004\u0005\u0017qA!a@\u0003\u00049!\u0011q\u001bB\u0001\u0013\u0005y\u0014b\u0001B\u0003}\u00059\u0001/Y2lC\u001e,\u0017bA?\u0003\n)\u0019!Q\u0001 \u0011\u000f)\f9P!\u0004\u0003\u0018A\"!q\u0002B\n!\u0011ACF!\u0005\u0011\u0007\u0015\u0014\u0019\u0002\u0002\u0006\u0003\u0016q\t\t\u0011!A\u0003\u0002!\u00141a\u0018\u00139!\rQ'\u0011D\u0005\u0004\u00057q$\u0001\u0002'p]\u001eDqAa\b\u001d\u0001\u0004\u0011\t#A\u0003uCN\\7\u000f\u0005\u0004\u0002~\n\u001d!1\u0005\t\bU\u0006](Q\u0005B\fa\u0011\u00119Ca\u000b\u0011\t!b#\u0011\u0006\t\u0004K\n-Ba\u0003B\u0017\u0005;\t\t\u0011!A\u0003\u0002!\u00141a\u0018\u00138\u0001")
public class TaskProgress
extends AbstractTaskExecuteProgress
implements AutoCloseable {
    private final FiniteDuration sleepDuration;
    private final FiniteDuration threshold;
    private final Logger logger;
    private final AtomicInteger lastTaskCount;
    private final AtomicReference<AutoCloseable> reportLoop;
    private final ConcurrentHashMap<Task<?>, AutoCloseable> active;
    private final AtomicReference<Deadline> nextReport;
    private final ScheduledExecutorService scheduler;
    private final java.util.Vector<Future<?>> pending;
    private final AtomicBoolean closed;
    private final ExecutorService executor;
    private final Set<String> skipReportTasks;
    private final Set<String> hiddenTasks;

    private <R> AutoCloseable schedule(FiniteDuration duration, boolean recurring, Function0<R> f) {
        if (!this.closed.get()) {
            AutoCloseable autoCloseable;
            AtomicBoolean cancelled = new AtomicBoolean(false);
            Runnable runnable = () -> {
                if (!cancelled.get()) {
                    try {
                        f.apply();
                    }
                    catch (InterruptedException interruptedException) {}
                    return;
                }
            };
            long delay = duration.toMillis();
            try {
                ScheduledFuture<?> future = recurring ? this.scheduler.scheduleAtFixedRate(runnable, delay, delay, TimeUnit.MILLISECONDS) : this.scheduler.schedule(runnable, delay, TimeUnit.MILLISECONDS);
                this.pending.add(future);
                autoCloseable = () -> future.cancel(true);
            }
            catch (RejectedExecutionException e) {
                this.logger.trace((Function0 & Serializable & scala.Serializable)() -> e);
                autoCloseable = () -> {};
            }
            return autoCloseable;
        }
        this.logger.debug((Function0 & Serializable & scala.Serializable)() -> "tried to call schedule on closed TaskProgress");
        return () -> {};
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Option$.MODULE$.apply(this.reportLoop.getAndSet(null)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            this.pending.forEach((Consumer<Future<?>>)((Consumer<Future>)f -> f.cancel(true)));
            this.pending.clear();
            this.scheduler.shutdownNow();
            this.executor.shutdownNow();
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS) || !this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                Console$.MODULE$.err().println("timed out closing the executor of supershell");
                throw new TimeoutException();
            }
            return;
        }
    }

    @Override
    public boolean clearTimings() {
        return true;
    }

    public void initial() {
    }

    private void doReport() {
        Runnable runnable = () -> {
            if ($this.nextReport.get().isOverdue()) {
                this.report();
                return;
            }
        };
        this.pending.add(this.executor.submit(runnable));
    }

    @Override
    public void beforeWork(Task<?> task) {
        if (!this.closed.get()) {
            super.beforeWork(task);
            AutoCloseable autoCloseable = this.reportLoop.get();
            if (autoCloseable == null) {
                AutoCloseable loop = this.schedule(this.sleepDuration, true, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doReport());
                AutoCloseable autoCloseable2 = this.reportLoop.getAndSet(loop);
                if (autoCloseable2 == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.reportLoop.set(autoCloseable2);
                    loop.close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            return;
        }
        this.logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("called beforeWork for ").append(this.taskName(task)).append(" after task progress was closed").toString());
    }

    public void afterReady(Task<?> task) {
        if (!this.closed.get()) {
            try {
                this.executor.submit(() -> {
                    if ($this.skipReportTasks.contains((Object)this.getShortName(task))) {
                        $this.lastTaskCount.set(-1);
                        this.report();
                        return;
                    }
                    $this.active.put(task, this.schedule($this.threshold, false, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doReport()));
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
            return;
        }
        this.logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("called afterReady for ").append(this.taskName(task)).append(" after task progress was closed").toString());
    }

    public void stop() {
    }

    public <A> void afterCompleted(Task<A> task, Result<A> result) {
        AutoCloseable autoCloseable = this.active.remove(task);
        if (autoCloseable == null) {
            return;
        }
        autoCloseable.close();
        if (this.exceededThreshold(task, this.threshold)) {
            this.report();
            return;
        }
    }

    public void afterAllCompleted(RMap<Task, Result> results) {
        AutoCloseable autoCloseable = this.reportLoop.getAndSet(null);
        if (autoCloseable == null) {
        } else {
            autoCloseable.close();
        }
        this.appendProgress(ProgressEvent$.MODULE$.apply("Info", (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.lastTaskCount.get())), (Option)None$.MODULE$, (Option)None$.MODULE$));
    }

    private void appendProgress(ProgressEvent event) {
        StandardMain$.MODULE$.exchange().updateProgress(event);
    }

    private void report() {
        Tuple2<Vector<Tuple2<Task<?>, Object>>, Object> tuple2 = this.filter(this.timings(this.active.keySet(), this.threshold.toMicros()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector currentTasks = (Vector)tuple2._1();
        boolean skip = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)currentTasks, (Object)BoxesRunTime.boxToBoolean((boolean)skip));
        Vector currentTasks2 = (Vector)tuple22._1();
        boolean skip2 = tuple22._2$mcZ$sp();
        int ltc = this.lastTaskCount.get();
        if (currentTasks2.nonEmpty() || ltc != 0) {
            int currentTasksCount = currentTasks2.size();
            this.lastTaskCount.set(currentTasksCount);
            this.appendProgress(this.event$1(currentTasks2, ltc, skip2));
            return;
        }
    }

    private String getShortName(Task<?> task) {
        String name = this.taskName(task);
        int n = name.lastIndexOf(47);
        switch (n) {
            case -1: {
                return name;
            }
        }
        int j = n + 1;
        while (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), j) == ' ') {
            ++j;
        }
        return name.substring(j);
    }

    private Tuple2<Vector<Tuple2<Task<?>, Object>>, Object> filter(Vector<Tuple2<Task<?>, Object>> tasks) {
        return (Tuple2)tasks.foldLeft((Object)new Tuple2((Object)package$.MODULE$.Vector().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 pair = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Vector tasks = (Vector)tuple22._1();
                    boolean skip = tuple22._2$mcZ$sp();
                    if (pair != null) {
                        boolean newSkip;
                        Task t = (Task)pair._1();
                        String shortName = this.getShortName(t);
                        boolean bl = newSkip = skip || $this.skipReportTasks.contains((Object)shortName);
                        if ($this.hiddenTasks.contains((Object)shortName)) {
                            return new Tuple2((Object)tasks, (Object)BoxesRunTime.boxToBoolean((boolean)newSkip));
                        }
                        return new Tuple2(tasks.$colon$plus((Object)pair, Vector$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToBoolean((boolean)newSkip));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final ProgressEvent event$1(Vector tasks, int ltc$1, boolean skip$1) {
        if (tasks.nonEmpty()) {
            this.nextReport.set(Deadline$.MODULE$.now().$plus(this.sleepDuration));
        }
        Vector toWrite = (Vector)tasks.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$);
        LinkedHashMap distinct = new LinkedHashMap();
        toWrite.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Task task = (Task)tuple2._1();
                long elapsed = tuple2._2$mcJ$sp();
                String name = this.taskName(task);
                return distinct.put(name, ProgressItem$.MODULE$.apply(name, elapsed));
            }
            throw new MatchError((Object)tuple2);
        });
        return ProgressEvent$.MODULE$.apply("Info", ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(distinct.values()).asScala()).toVector(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ltc$1)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)skip$1)));
    }

    public TaskProgress(FiniteDuration sleepDuration, FiniteDuration threshold, Logger logger) {
        this.sleepDuration = sleepDuration;
        this.threshold = threshold;
        this.logger = logger;
        this.lastTaskCount = new AtomicInteger(0);
        this.reportLoop = new AtomicReference();
        this.active = new ConcurrentHashMap();
        this.nextReport = new AtomicReference<Deadline>(Deadline$.MODULE$.now());
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sbt-progress-report-scheduler"));
        this.pending = new java.util.Vector();
        this.closed = new AtomicBoolean(false);
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "sbt-task-progress-report-thread"));
        this.skipReportTasks = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"installSbtn", "run", "runMain", "bgRun", "fgRun", "scala", "console", "consoleProject", "consoleQuick", "state"}));
        this.hiddenTasks = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compileEarly", "pickleProducts"}));
    }
}

