/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sbt.BasicCommandStrings$;
import sbt.Command;
import sbt.Command$;
import sbt.CommandSource$;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Project$;
import sbt.StandardMain$;
import sbt.State;
import sbt.State$;
import sbt.internal.CommandChannel;
import sbt.internal.ConsoleUnpromptEvent;
import sbt.internal.Continuous;
import sbt.internal.Continuous$;
import sbt.internal.ContinuousCommands;
import sbt.internal.DynamicInput;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileTreeRepository;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.ui.UITask;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.Prompt;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import sbt.nio.FileStamp;
import sbt.nio.Watch;
import sbt.nio.Watch$CancelWatch$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.Glob;
import sbt.util.LoggerContext;
import sbt.util.LoggerContext$;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class ContinuousCommands$ {
    public static ContinuousCommands$ MODULE$;
    private final AttributeKey<Map<String, Tuple2<Function1<State, State>, Function1<State, State>>>> watchStateCallbacks;
    public final AttributeKey<scala.collection.immutable.Map<String, Continuous.ContinuousState>> sbt$internal$ContinuousCommands$$watchStates;
    private final String runWatch;
    private final String preWatch;
    private final String postWatch;
    private final String stopWatch;
    private final String failWatch;
    private final String waitWatch;
    private final Parser<Seq<Object>> space;
    private final AttributeKey<FileTreeRepository<FileAttributes>> stashedRepo;
    private final Function4<String, Object, Seq<String>, State, State> setupWatchState;
    private final Command runWatchCommand;
    private final Command preWatchCommand;
    private final Command postWatchCommand;
    private final Function1<Object, Function2<String, State, State>> exitWatchShared;
    private final Command stopWatchCommand;
    private final Command failWatchCommand;

    static {
        new ContinuousCommands$();
    }

    public Seq<Command> value() {
        return (Seq)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Command[]{this.failWatchCommand(), this.preWatchCommand(), this.postWatchCommand(), this.runWatchCommand(), this.stopWatchCommand()}));
    }

    public AttributeKey<Map<String, Tuple2<Function1<State, State>, Function1<State, State>>>> watchStateCallbacks() {
        return this.watchStateCallbacks;
    }

    public String runWatch() {
        return this.runWatch;
    }

    public String preWatch() {
        return this.preWatch;
    }

    public String postWatch() {
        return this.postWatch;
    }

    public String stopWatch() {
        return this.stopWatch;
    }

    public String failWatch() {
        return this.failWatch;
    }

    public String waitWatch() {
        return this.waitWatch;
    }

    private <T> Parser<T> noComplete(Parser<T> p) {
        return Parser$.MODULE$.richParser(p).examples((Seq)Nil$.MODULE$);
    }

    private Parser<String> cmdParser(String s) {
        return Parser$.MODULE$.richParser(this.noComplete(DefaultParsers$.MODULE$.matched(Parser$.MODULE$.literal(s), DefaultParsers$.MODULE$.matched$default$2(), DefaultParsers$.MODULE$.matched$default$3()))).$less$tilde(this.space);
    }

    private Parser<String> channelParser() {
        return this.noComplete(DefaultParsers$.MODULE$.matched(Parser$.MODULE$.richParser(Parser$.MODULE$.charClass((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ContinuousCommands$.$anonfun$channelParser$1(BoxesRunTime.unboxToChar((Object)c))), Parser$.MODULE$.charClass$default$2())).$plus(), DefaultParsers$.MODULE$.matched$default$2(), DefaultParsers$.MODULE$.matched$default$3()));
    }

    public Function4<String, Object, Seq<String>, State, State> setupWatchState() {
        return this.setupWatchState;
    }

    private Command watchCommand(String name, Function2<String, State, State> updateState) {
        return Command$.MODULE$.arb((Function1 & Serializable & scala.Serializable)state -> Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(MODULE$.cmdParser(name)).$tilde$greater(MODULE$.channelParser())).map((Function1 & Serializable & scala.Serializable)channel -> (Function0 & Serializable & scala.Serializable)() -> (State)updateState.apply(channel, state)), Command$.MODULE$.arb$default$2(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Function0 newState = (Function0)tuple2._2();
                return (State)newState.apply();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Command runWatchCommand() {
        return this.runWatchCommand;
    }

    public Option<UITask> watchUITaskFor(State state, CommandChannel channel) {
        return State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), this.sbt$internal$ContinuousCommands$$watchStates).flatMap((Function1 & Serializable & scala.Serializable)x$69 -> x$69.get((Object)channel.name())).map((Function1 & Serializable & scala.Serializable)x$70 -> new ContinuousCommands.WatchUITask(channel, (Continuous.ContinuousState)x$70, state));
    }

    public boolean isInWatch(State state, CommandChannel channel) {
        return State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), this.sbt$internal$ContinuousCommands$$watchStates).exists((Function1 & Serializable & scala.Serializable)x$71 -> BoxesRunTime.boxToBoolean((boolean)x$71.contains((Object)channel.name())));
    }

    public boolean isPending(State state, CommandChannel channel) {
        return State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), this.sbt$internal$ContinuousCommands$$watchStates).exists((Function1 & Serializable & scala.Serializable)x$72 -> BoxesRunTime.boxToBoolean((boolean)ContinuousCommands$.$anonfun$isPending$1(channel, x$72)));
    }

    private Continuous.ContinuousState watchState(State state, String channel) {
        Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), this.sbt$internal$ContinuousCommands$$watchStates).flatMap((Function1 & Serializable & scala.Serializable)x$89 -> x$89.get((Object)channel));
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(19).append("no watch state for ").append(channel).toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Continuous.ContinuousState s = (Continuous.ContinuousState)some.value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    public Command preWatchCommand() {
        return this.preWatchCommand;
    }

    public Command postWatchCommand() {
        return this.postWatchCommand;
    }

    public Command stopWatchCommand() {
        return this.stopWatchCommand;
    }

    public Command failWatchCommand() {
        return this.failWatchCommand;
    }

    private <T> FileTreeRepository<T> localRepo(FileTreeRepository<T> r) {
        return new FileTreeRepository<T>(r){
            private final ConcurrentHashMap.KeySetView<AutoCloseable, Boolean> closeables;
            private final FileTreeRepository r$2;

            public AutoCloseable addObserver(Observer<FileEvent<T>> observer) {
                AutoCloseable ac = this.r$2.addObserver(observer);
                AutoCloseable safeCloseable = () -> {
                    try {
                        ac.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                        }
                        throw throwable;
                    }
                };
                this.closeables.add(safeCloseable);
                return () -> {
                    $this.closeables.remove(safeCloseable);
                    safeCloseable.close();
                };
            }

            public Either<IOException, Observable<FileEvent<T>>> register(Glob glob) {
                return this.r$2.register(glob);
            }

            public void close() {
                this.closeables.forEach(c -> {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                        }
                        throw throwable;
                    }
                });
            }

            public Seq<Tuple2<Path, T>> list(Path path) {
                return this.r$2.list(path);
            }
            {
                this.r$2 = r$2;
                this.closeables = ConcurrentHashMap.newKeySet();
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$channelParser$1(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '-';
    }

    public static final /* synthetic */ void sbt$internal$ContinuousCommands$$$anonfun$setupWatchState$3(FileEvent t, FileStamp.Cache cache$1) {
        cache$1.invalidate(t.path());
    }

    private static final Continuous.Callbacks cb$1(State state$6, CommandChannel channel$3, Seq commands$3, FileStamp.Cache cache$1, Set dynamicInputs$2, LoggerContext context$1) {
        return Continuous$.MODULE$.getCallbacks(state$6, channel$3, (Seq<String>)commands$3, cache$1, (Set<DynamicInput>)dynamicInputs$2, context$1);
    }

    public static final /* synthetic */ State $anonfun$setupWatchState$1(String channelName, int count, Seq commands, State state2) {
        Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state2), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates).flatMap((Function1 & Serializable & scala.Serializable)x$59 -> x$59.get((Object)channelName));
        if (None$.MODULE$.equals(option)) {
            Extracted extracted = Project$.MODULE$.extract(state2);
            Option option2 = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state2), sbt.nio.Keys$.MODULE$.globalFileTreeRepository());
            if (!(option2 instanceof Some)) {
                throw new IllegalStateException(new StringBuilder(38).append("No file tree repository was found for ").append(state2).toString());
            }
            Some some = (Some)option2;
            FileTreeRepository r = (FileTreeRepository)some.value();
            Continuous.FileStampRepository repo = MODULE$.localRepo(r);
            FileStamp.Cache cache = new FileStamp.Cache();
            repo.addObserver((Observer)new Observer<FileEvent<FileAttributes>>(cache){
                private final FileStamp.Cache cache$1;

                public void close() {
                    Observer.close$((Observer)this);
                }

                public final void onNext(FileEvent<FileAttributes> t) {
                    ContinuousCommands$.sbt$internal$ContinuousCommands$$$anonfun$setupWatchState$3(t, this.cache$1);
                }
                {
                    this.cache$1 = cache$1;
                    Observer.$init$((Observer)this);
                }
            });
            boolean persistFileStamps = BoxesRunTime.unboxToBoolean((Object)extracted.get(sbt.nio.Keys$.MODULE$.watchPersistFileStamps()));
            Continuous.FileStampRepository cachingRepo = persistFileStamps ? repo : new Continuous.FileStampRepository(cache, repo);
            CommandChannel channel = (CommandChannel)StandardMain$.MODULE$.exchange().channelForName(channelName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(21).append("No channel with name ").append(channelName).toString());
            });
            Set dynamicInputs2 = Set$.MODULE$.empty();
            LoggerContext context = LoggerContext$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state2), Keys$.MODULE$.useLog4J().key()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
            Continuous.ContinuousState s = new Continuous.ContinuousState(count, (Seq<String>)commands, (Function2<State, Set<DynamicInput>, State>)(Function2 & Serializable & scala.Serializable)(state, dynamicInputs) -> {
                FileTreeRepository original = (FileTreeRepository)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), sbt.nio.Keys$.MODULE$.globalFileTreeRepository()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(41).append("No global file tree repository for state ").append(state).toString());
                });
                State stateWithRepo = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), sbt.nio.Keys$.MODULE$.globalFileTreeRepository(), (Object)cachingRepo)), ContinuousCommands$.MODULE$.stashedRepo, (Object)original);
                State stateWithCache = persistFileStamps ? State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(stateWithRepo), sbt.nio.Keys$.MODULE$.persistentFileStampCache(), (Object)cache) : stateWithRepo;
                return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(stateWithCache), Continuous$.MODULE$.DynamicInputs(), dynamicInputs);
            }, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> {
                State state2;
                Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates);
                if (None$.MODULE$.equals(option)) {
                    state2 = state;
                } else {
                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                    Some some = (Some)option;
                    scala.collection.immutable.Map ws = (scala.collection.immutable.Map)some.value();
                    Option option2 = ws.get((Object)channelName);
                    if (None$.MODULE$.equals(option2)) {
                        state2 = state;
                    } else {
                        if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                        Some some2 = (Some)option2;
                        Continuous.ContinuousState cs = (Continuous.ContinuousState)some2.value();
                        state2 = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)ws.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)channelName), (Object)cs.incremented())));
                    }
                }
                State newWatchState = state2;
                Option option3 = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(newWatchState), ContinuousCommands$.MODULE$.stashedRepo);
                if (None$.MODULE$.equals(option3)) {
                    throw new IllegalStateException(new StringBuilder(26).append("No stashed repository for ").append(state).toString());
                }
                if (!(option3 instanceof Some)) {
                    throw new MatchError((Object)option3);
                }
                Some some = (Some)option3;
                FileTreeRepository r = (FileTreeRepository)some.value();
                State restoredState = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(newWatchState), sbt.nio.Keys$.MODULE$.globalFileTreeRepository(), (Object)r);
                return State.StateOpsImpl$.MODULE$.remove$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.remove$extension(State$.MODULE$.StateOpsImpl(restoredState), sbt.nio.Keys$.MODULE$.persistentFileStampCache())), Continuous$.MODULE$.DynamicInputs());
            }, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> {
                context.clearAppenders(new StringBuilder(6).append(channelName).append("-watch").toString());
                repo.close();
                context.close();
                Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates);
                if (None$.MODULE$.equals(option)) {
                    return state;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Map ws = (scala.collection.immutable.Map)some.value();
                    return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)ws.$minus((Object)channelName));
                }
                throw new MatchError((Object)option);
            }, ContinuousCommands$.cb$1(state2, channel, commands, cache, dynamicInputs2, context), (Set<DynamicInput>)dynamicInputs2, false);
            Option option3 = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state2), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates);
            if (None$.MODULE$.equals(option3)) {
                return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state2), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)channelName), (Object)s)})));
            }
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                scala.collection.immutable.Map ws = (scala.collection.immutable.Map)some2.value();
                return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state2), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)ws.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)channelName), (Object)s)));
            }
            throw new MatchError((Object)option3);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Continuous.ContinuousState cs = (Continuous.ContinuousState)some.value();
            String cmd = cs.commands().mkString("; ");
            String msg = new StringBuilder(67).append("Tried to start new watch while channel, '").append(channelName).append("', was already watching '").append(cmd).append("'").toString();
            throw new IllegalStateException(msg);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$isPending$1(CommandChannel channel$8, scala.collection.immutable.Map x$72) {
        return x$72.get((Object)channel$8.name()).exists((Function1 & Serializable & scala.Serializable)x$73 -> BoxesRunTime.boxToBoolean((boolean)x$73.pending()));
    }

    public static final /* synthetic */ void $anonfun$postWatchCommand$2(CommandChannel c) {
        c.terminal().setPrompt((Prompt)Prompt.Pending$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$exitWatchShared$4(String channel$10, CommandChannel c) {
        c.terminal().setPrompt((Prompt)Prompt.Pending$.MODULE$);
        c.unprompt(new ConsoleUnpromptEvent((Option)new Some((Object)CommandSource$.MODULE$.apply(channel$10))));
    }

    public static final /* synthetic */ Function2 $anonfun$exitWatchShared$1(boolean error) {
        return (Function2 & Serializable & scala.Serializable)(channel, state) -> {
            Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates).flatMap((Function1 & Serializable & scala.Serializable)x$90 -> x$90.get(channel));
            if (option instanceof Some) {
                State state2;
                Some some = (Some)option;
                Continuous.ContinuousState cs = (Continuous.ContinuousState)some.value();
                State afterWatchState = (State)cs.afterWatch().apply(state);
                cs.callbacks().onExit().apply$mcV$sp();
                StandardMain$.MODULE$.exchange().channelForName((String)channel).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    ContinuousCommands$.$anonfun$exitWatchShared$4(channel, c);
                    return BoxedUnit.UNIT;
                });
                Option option2 = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(afterWatchState), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates);
                if (None$.MODULE$.equals(option2)) {
                    state2 = afterWatchState;
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    scala.collection.immutable.Map w = (scala.collection.immutable.Map)some2.value();
                    state2 = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(afterWatchState), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)w.$minus(channel));
                } else {
                    throw new MatchError((Object)option2);
                }
                State newState = state2;
                String commands = cs.commands().mkString("; ");
                int count = cs.count();
                Watch.Action action = (Watch.Action)cs.failAction().getOrElse((Function0 & Serializable & scala.Serializable)() -> Watch$CancelWatch$.MODULE$);
                State st = (State)cs.callbacks().onTermination().apply((Object)action, (Object)commands, (Object)BoxesRunTime.boxToInteger((int)count), (Object)newState);
                if (error) {
                    return State.StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(st));
                }
                return st;
            }
            if (error) {
                return State.StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(state));
            }
            return state;
        };
    }

    private ContinuousCommands$() {
        MODULE$ = this;
        this.watchStateCallbacks = AttributeKey$.MODULE$.apply("sbt-watch-state-callbacks", "", Integer.MAX_VALUE, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Tuple2.class, ManifestFactory$.MODULE$.classType(Function1.class, ManifestFactory$.MODULE$.classType(State.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(State.class)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Function1.class, ManifestFactory$.MODULE$.classType(State.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(State.class)}))}))})), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.sbt$internal$ContinuousCommands$$watchStates = AttributeKey$.MODULE$.apply("sbt-watch-states", Integer.MAX_VALUE, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Continuous.ContinuousState.class)})), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.runWatch = new StringBuilder(8).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("runWatch").toString();
        this.preWatch = new StringBuilder(8).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("preWatch").toString();
        this.postWatch = new StringBuilder(9).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("postWatch").toString();
        this.stopWatch = new StringBuilder(9).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("stopWatch").toString();
        this.failWatch = new StringBuilder(9).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("failWatch").toString();
        this.waitWatch = new StringBuilder(9).append(BasicCommandStrings$.MODULE$.networkExecPrefix()).append("waitWatch").toString();
        this.space = this.noComplete(DefaultParsers$.MODULE$.Space());
        this.stashedRepo = AttributeKey$.MODULE$.apply("stashed-file-tree-repository", "", Integer.MAX_VALUE, ManifestFactory$.MODULE$.classType(FileTreeRepository.class, ManifestFactory$.MODULE$.classType(FileAttributes.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.setupWatchState = (Function4 & Serializable & scala.Serializable)(channelName, count, commands, state) -> ContinuousCommands$.$anonfun$setupWatchState$1(channelName, BoxesRunTime.unboxToInt((Object)count), commands, state);
        this.runWatchCommand = this.watchCommand(this.runWatch(), (Function2<String, State, State>)(Function2 & Serializable & scala.Serializable)(channel, state) -> {
            Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates).flatMap((Function1 & Serializable & scala.Serializable)x$60 -> x$60.get(channel));
            if (None$.MODULE$.equals(option)) {
                return state;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Continuous.ContinuousState cs = (Continuous.ContinuousState)some.value();
                String string = BasicCommandStrings$.MODULE$.StashOnFailure();
                String string2 = new StringBuilder(1).append(MODULE$.preWatch()).append(" ").append((String)channel).toString();
                List pre = Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string);
                String string3 = BasicCommandStrings$.MODULE$.FailureWall();
                String string4 = BasicCommandStrings$.MODULE$.PopOnFailure();
                String string5 = new StringBuilder(1).append(MODULE$.postWatch()).append(" ").append((String)channel).toString();
                List post = Nil$.MODULE$.$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
                List list = pre;
                List list2 = cs.commands().toList();
                List list3 = post;
                return State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(state), list3)), list2)), list);
            }
            throw new MatchError((Object)option);
        });
        this.preWatchCommand = this.watchCommand(this.preWatch(), (Function2<String, State, State>)(Function2 & Serializable & scala.Serializable)(channel, state) -> {
            Continuous.ContinuousState ws = MODULE$.watchState((State)state, (String)channel);
            State newState = ws.beforeCommand((State)state);
            ws.callbacks().beforeCommand().apply$mcV$sp();
            return newState;
        });
        this.postWatchCommand = this.watchCommand(this.postWatch(), (Function2<String, State, State>)(Function2 & Serializable & scala.Serializable)(channel, state) -> {
            State state2;
            Continuous.ContinuousState cs = MODULE$.watchState((State)state, (String)channel);
            StandardMain$.MODULE$.exchange().channelForName((String)channel).foreach((Function1 & Serializable & scala.Serializable)c -> {
                ContinuousCommands$.$anonfun$postWatchCommand$2(c);
                return BoxedUnit.UNIT;
            });
            Option option = State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates);
            if (None$.MODULE$.equals(option)) {
                state2 = state;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Map ws = (scala.collection.immutable.Map)some.value();
                state2 = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), ContinuousCommands$.MODULE$.sbt$internal$ContinuousCommands$$watchStates, (Object)ws.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(channel), (Object)cs.withPending(false))));
            } else {
                throw new MatchError((Object)option);
            }
            State postState = state2;
            return (State)cs.afterCommand().apply((Object)postState);
        });
        this.exitWatchShared = (Function1 & Serializable & scala.Serializable)error -> ContinuousCommands$.$anonfun$exitWatchShared$1(BoxesRunTime.unboxToBoolean((Object)error));
        this.stopWatchCommand = this.watchCommand(this.stopWatch(), (Function2<String, State, State>)((Function2)this.exitWatchShared.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))));
        this.failWatchCommand = this.watchCommand(this.failWatch(), (Function2<String, State, State>)((Function2)this.exitWatchShared.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))));
    }
}

