/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.testing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.ContentLogger;
import sbt.TestDefinition;
import sbt.TestEvent;
import sbt.internal.testing.TestLogger;
import sbt.internal.testing.TestLogging;
import sbt.internal.util.BufferedAppender$;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.StringTypeTag;
import sbt.internal.util.Terminal$;
import sbt.protocol.testing.TestItemDetail;
import sbt.protocol.testing.TestItemDetail$;
import sbt.protocol.testing.TestItemEvent;
import sbt.protocol.testing.TestItemEvent$;
import sbt.protocol.testing.TestStringEvent;
import sbt.protocol.testing.TestStringEvent$;
import sbt.protocol.testing.codec.JsonProtocol$;
import sbt.testing.Logger;
import sbt.util.Level$;
import sbt.util.LoggerContext;
import sbt.util.ShowLines;
import sbt.util.ShowLines$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TestLogger$ {
    public static TestLogger$ MODULE$;
    private final ShowLines<TestStringEvent> testStringEventShowLines;
    private final AtomicInteger generateId;
    private final AtomicInteger generateBufferId;

    static {
        new TestLogger$();
    }

    public ShowLines<TestStringEvent> testStringEventShowLines() {
        return this.testStringEventShowLines;
    }

    private String generateName() {
        return new StringBuilder(5).append("test-").append(this.generateId().incrementAndGet()).toString();
    }

    private AtomicInteger generateId() {
        return this.generateId;
    }

    private String generateBufferName() {
        return new StringBuilder(11).append("testbuffer-").append(this.generateBufferId().incrementAndGet()).toString();
    }

    private AtomicInteger generateBufferId() {
        return this.generateBufferId;
    }

    public TestLogger make(ManagedLogger global, Function1<TestDefinition, TestLogger.PerTest> perTest) {
        return this.make(global, perTest, Level$.MODULE$.Debug());
    }

    public TestLogger make(ManagedLogger global, Function1<TestDefinition, TestLogger.PerTest> perTest, Enumeration.Value level) {
        LoggerContext context = global.context();
        Seq as = context.appenders(global.name());
        global.registerStringCodec(this.testStringEventShowLines(), new StringTypeTag("sbt.protocol.testing.TestStringEvent"));
        ShowLines showNoLinesTestInitEvent = TestLogger$.showNoLines$1();
        ShowLines showNoLinesStartTestGroupEvent = TestLogger$.showNoLines$1();
        ShowLines showNoLinesTestItemEvent = TestLogger$.showNoLines$1();
        ShowLines showNoLinesEndTestGroupEvent = TestLogger$.showNoLines$1();
        ShowLines showNoLinesTestCompleteEvent = TestLogger$.showNoLines$1();
        global.registerStringCodec(showNoLinesTestInitEvent, new StringTypeTag("sbt.protocol.testing.TestInitEvent"));
        global.registerStringCodec(showNoLinesStartTestGroupEvent, new StringTypeTag("sbt.protocol.testing.StartTestGroupEvent"));
        global.registerStringCodec(showNoLinesTestItemEvent, new StringTypeTag("sbt.protocol.testing.TestItemEvent"));
        global.registerStringCodec(showNoLinesEndTestGroupEvent, new StringTypeTag("sbt.protocol.testing.EndTestGroupEvent"));
        global.registerStringCodec(showNoLinesTestCompleteEvent, new StringTypeTag("sbt.protocol.testing.TestCompleteEvent"));
        TestLogging config = new TestLogging(this.wrap(global), global, (Function1<TestDefinition, ContentLogger>)(Function1 & Serializable & scala.Serializable)tdef -> this.makePerTest$1((TestDefinition)tdef, (Function1)perTest, as, context, level));
        return new TestLogger(config);
    }

    public Logger wrap(ManagedLogger logger) {
        return new Logger(logger){
            private final ManagedLogger logger$1;

            public void error(String s) {
                this.log(Level$.MODULE$.Error(), TestStringEvent$.MODULE$.apply(s));
            }

            public void warn(String s) {
                this.log(Level$.MODULE$.Warn(), TestStringEvent$.MODULE$.apply(s));
            }

            public void info(String s) {
                this.log(Level$.MODULE$.Info(), TestStringEvent$.MODULE$.apply(s));
            }

            public void debug(String s) {
                this.log(Level$.MODULE$.Debug(), TestStringEvent$.MODULE$.apply(s));
            }

            public void trace(Throwable t) {
                this.logger$1.trace((Function0 & Serializable & scala.Serializable)() -> t);
            }

            private void log(Enumeration.Value level, TestStringEvent event) {
                this.logger$1.logEvent(level, (Function0 & Serializable & scala.Serializable)() -> event, JsonProtocol$.MODULE$.TestStringEventFormat(), new StringTypeTag("sbt.protocol.testing.TestStringEvent"));
            }

            public boolean ansiCodesSupported() {
                return Terminal$.MODULE$.isAnsiSupported();
            }
            {
                this.logger$1 = logger$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$trace$1(java.lang.Throwable ), $anonfun$log$1(sbt.protocol.testing.TestStringEvent )}, serializedLambda);
            }
        };
    }

    public TestItemEvent toTestItemEvent(TestEvent event) {
        return TestItemEvent$.MODULE$.apply(event.result(), (Vector<TestItemDetail>)((Vector)event.detail().toVector().map((Function1 & Serializable & scala.Serializable)d -> {
            long l = d.duration();
            Object object = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)l));
            return TestItemDetail$.MODULE$.apply(d.fullyQualifiedName(), d.status(), (Option<Object>)object);
        }, Vector$.MODULE$.canBuildFrom())));
    }

    private final ContentLogger makePerTest$1(TestDefinition tdef, Function1 perTest$1, Seq as$1, LoggerContext context$1, Enumeration.Value level$1) {
        TestLogger.PerTest per = (TestLogger.PerTest)perTest$1.apply((Object)tdef);
        ManagedLogger l0 = per.log();
        List buffs = ((TraversableOnce)as$1.map((Function1 & Serializable & scala.Serializable)a -> BufferedAppender$.MODULE$.apply(MODULE$.generateBufferName(), a), Seq$.MODULE$.canBuildFrom())).toList();
        ManagedLogger newLog = context$1.logger(this.generateName(), l0.channelName(), l0.execId());
        context$1.clearAppenders(newLog.name());
        buffs.foreach((Function1 & Serializable & scala.Serializable)b -> {
            context$1.addAppender(newLog.name(), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)b), (Object)level$1));
            return BoxedUnit.UNIT;
        });
        if (per.buffered()) {
            buffs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.record();
                return BoxedUnit.UNIT;
            });
        }
        return new ContentLogger(this.wrap(newLog), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            buffs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stopQuietly();
                return BoxedUnit.UNIT;
            });
            per.flush().apply$mcV$sp();
        });
    }

    private static final ShowLines showNoLines$1() {
        return ShowLines$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$3 -> Nil$.MODULE$);
    }

    private TestLogger$() {
        MODULE$ = this;
        this.testStringEventShowLines = ShowLines$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestStringEvent testStringEvent = x0$1;
            if (testStringEvent == null) {
                throw new MatchError((Object)testStringEvent);
            }
            TestStringEvent testStringEvent2 = testStringEvent;
            .colon.colon colon2 = new .colon.colon((Object)testStringEvent2.value(), (List)Nil$.MODULE$);
            return colon2;
        });
        this.generateId = new AtomicInteger();
        this.generateBufferId = new AtomicInteger();
    }
}

