/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Parser$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.api.DependencyContext;
import xsbti.compile.Output;

public final class JavaAnalyze$ {
    public static final JavaAnalyze$ MODULE$ = new JavaAnalyze$();

    public <T> void apply(Seq<Path> newClasses, Seq<VirtualFile> sources, Logger log, Output output, Option<Path> finalJarOutput, AnalysisCallback analysis, ClassLoader loader, Function2<VirtualFileRef, Seq<Class<?>>, Set<Tuple2<String, String>>> readAPI) {
        Map sourceMap = sources.toSet().groupBy((Function1 & Serializable)x$1 -> x$1.name());
        Path singleOutputOrNull = output.getSingleOutputAsPath().orElse(null);
        Path directOutputJarOrNull = (Path)JarUtils$.MODULE$.getOutputJar(output).getOrElse((Function0 & Serializable)() -> null);
        Path mappedOutputJarOrNull = (Path)finalJarOutput.getOrElse((Function0 & Serializable)() -> null);
        HashMap sourceToClassFiles = (HashMap)HashMap$.MODULE$.apply((Seq)sources.map((Function1 & Serializable)vf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(vf), (Object)new ArrayBuffer())));
        HashMap binaryClassNameToLoadedClass = new HashMap();
        scala.collection.mutable.Map classfilesCache = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        ((IterableOnceOps)newClasses.map((Function1 & Serializable)newClass -> {
            ClassFile classFile = Parser$.MODULE$.apply((Path)newClass, log);
            return new Tuple2(newClass, (Object)classFile);
        })).foreach((Function1 & Serializable)x$4 -> {
            JavaAnalyze$.$anonfun$apply$8(this, sourceMap, log, binaryClassNameToLoadedClass, analysis, sourceToClassFiles, loader, directOutputJarOrNull, singleOutputOrNull, mappedOutputJarOrNull, x$4);
            return BoxedUnit.UNIT;
        });
        sourceToClassFiles.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$15(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            JavaAnalyze$.$anonfun$apply$16(this, analysis, binaryClassNameToLoadedClass, loader, log, finalJarOutput, classfilesCache, readAPI, directOutputJarOrNull, singleOutputOrNull, mappedOutputJarOrNull, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Path resolveFinalClassFile(Path realClassFile, Path outputDir, Path outputJar, Logger log) {
        Option option = IO$.MODULE$.relativize(JavaAnalyze$.toFile$1(outputDir), JavaAnalyze$.toFile$1(realClassFile));
        if (option instanceof Some) {
            Some some = (Some)option;
            String relativeClass = (String)some.value();
            return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.apply(outputJar, relativeClass));
        }
        if (None$.MODULE$.equals(option)) {
            return realClassFile;
        }
        throw new MatchError((Object)option);
    }

    private Option<Path> urlAsFile(URL url, Logger log, Option<Path> finalJarOutput) {
        None$ none$;
        try {
            none$ = this.urlAsFile(url, finalJarOutput);
        }
        catch (Exception e) {
            log.warn((Function0 & Serializable)() -> new StringBuilder(34).append("Could not convert URL '").append(url.toExternalForm()).append("' to File: ").append(e.toString()).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Path> urlAsFile(URL url, Option<Path> finalJarOutput) {
        return IO$.MODULE$.urlAsFile(url).map((Function1 & Serializable)file -> {
            Path p = file.toPath();
            if (finalJarOutput.exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$urlAsFile$3(p, x$10)))) {
                return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.fromURL(url, p));
            }
            return p;
        });
    }

    private void trapAndLog(Logger log, Function0<BoxedUnit> execute) {
        try {
            execute.apply$mcV$sp();
        }
        catch (Throwable e) {
            log.trace((Function0 & Serializable)() -> e);
            log.error((Function0 & Serializable)() -> e.toString());
        }
    }

    private Some<String> guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        if (dollar < 0) {
            return name;
        }
        return name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        if (name.endsWith(".class")) {
            return name.substring(0, name.length() - ".class".length());
        }
        return name;
    }

    private String classNameToClassFile(String name) {
        return new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
    }

    private Option<String> binaryToSourceName(Class<?> loadedClass) {
        return Option$.MODULE$.apply((Object)loadedClass.getCanonicalName());
    }

    private Option<String> loadEnclosingClass(Class<?> clazz) {
        Option<String> option;
        while (None$.MODULE$.equals(option = this.binaryToSourceName(clazz)) && clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        return option;
    }

    private List<VirtualFile> guessSourcePath(Map<String, Set<VirtualFile>> sourceNameMap, ClassFile classFile, Logger log) {
        .colon.colon colon2;
        List list;
        String[] classNameParts = classFile.className().split("\\.");
        String[] pkg = (String[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])classNameParts));
        String simpleClassName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])classNameParts));
        String sourceFileName = (String)classFile.sourceFile().getOrElse((Function0 & Serializable)() -> StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(simpleClassName), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$guessSourcePath$2(BoxesRunTime.unboxToChar((Object)x$11))))), "", "", ".java"));
        List<VirtualFile> candidates = this.findSource(sourceNameMap, (List<String>)Predef$.MODULE$.wrapRefArray((Object[])pkg).toList(), sourceFileName);
        List<VirtualFile> list2 = candidates;
        if (Nil$.MODULE$.equals(list2)) {
            log.warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not determine source for class ").append(classFile.className()).toString());
        } else if (list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
        } else {
            log.warn((Function0 & Serializable)() -> new StringBuilder(37).append("Multiple sources matched for class ").append(classFile.className()).append(": ").append(candidates.mkString(", ")).toString());
        }
        return candidates;
    }

    private List<VirtualFile> findSource(Map<String, Iterable<VirtualFile>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine$1(((List)sourceNameMap.get((Object)sourceFileName).toList().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x -> new Tuple2(x, (Object)Predef$.MODULE$.wrapRefArray((Object[])x.names()).toList().reverse().drop(1))), pkg.reverse());
    }

    private static final Option load$1(String tpe, Function0 errMsg, ClassLoader loader$1, Logger log$1) {
        Some some;
        if (tpe.endsWith("module-info")) {
            return None$.MODULE$;
        }
        try {
            some = new Some(Class.forName(tpe, false, loader$1));
        }
        catch (Throwable e) {
            ((Option)errMsg.apply()).foreach((Function1 & Serializable)msg -> {
                log$1.warn((Function0 & Serializable)() -> new StringBuilder(3).append(msg).append(" : ").append(e$1.toString()).toString());
                return BoxedUnit.UNIT;
            });
            some = None$.MODULE$;
        }
        return some;
    }

    private final Path remapClassFile$1(Path classFile, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Logger log$1) {
        if (directOutputJarOrNull$1 != null) {
            String string = classFile.getFileSystem().provider().getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.apply(directOutputJarOrNull$1, ((Object)classFile.getRoot().relativize(classFile)).toString()));
            }
        }
        if (singleOutputOrNull$1 != null && mappedOutputJarOrNull$1 != null) {
            return this.resolveFinalClassFile(classFile, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
        }
        return classFile;
    }

    public static final /* synthetic */ void $anonfun$apply$12(JavaAnalyze$ $this, HashMap binaryClassNameToLoadedClass$1, Path newClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassFile classFile$1, ClassLoader loader$1, Logger log$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            VirtualFile source = (VirtualFile)tuple2._1();
            String binaryClassName = (String)tuple2._2();
            JavaAnalyze$.load$1(binaryClassName, (Function0 & Serializable)() -> new Some((Object)new StringBuilder(35).append("Error reading API from class file: ").append(binaryClassName).toString()), loader$1, log$1).foreach((Function1 & Serializable)loadedClass -> {
                binaryClassNameToLoadedClass$1.update((Object)binaryClassName, loadedClass);
                Option<String> srcClassName = MODULE$.loadEnclosingClass((Class<?>)loadedClass);
                Path finalClassFile = $this.remapClassFile$1(newClass$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
                Option<String> option = srcClassName;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String className = (String)some.value();
                    analysis$1.generatedNonLocalClass((VirtualFileRef)source, finalClassFile, binaryClassName, className);
                } else if (None$.MODULE$.equals(option)) {
                    analysis$1.generatedLocalClass((VirtualFileRef)source, finalClassFile);
                } else {
                    throw new MatchError(option);
                }
                return (Buffer)((Growable)sourceToClassFiles$1.apply((Object)source)).$plus$eq((Object)classFile$1);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$10(JavaAnalyze$ $this, Map sourceMap$1, ClassFile classFile$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, Path newClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, String x$3) {
        String string = x$3;
        MODULE$.guessSourcePath((Map<String, Set<VirtualFile>>)sourceMap$1, classFile$1, log$1).map((Function1 & Serializable)source -> {
            String binaryClassName = classFile$1.className();
            return new Tuple2(source, (Object)binaryClassName);
        }).foreach((Function1 & Serializable)x$2 -> {
            JavaAnalyze$.$anonfun$apply$12($this, binaryClassNameToLoadedClass$1, newClass$1, analysis$1, sourceToClassFiles$1, classFile$1, loader$1, log$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$8(JavaAnalyze$ $this, Map sourceMap$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            Path newClass = (Path)tuple2._1();
            ClassFile classFile = (ClassFile)tuple2._2();
            classFile.sourceFile().orElse((Function0 & Serializable)() -> MODULE$.guessSourceName(((Object)newClass.getFileName()).toString())).foreach((Function1 & Serializable)x$3 -> {
                JavaAnalyze$.$anonfun$apply$10($this, sourceMap$1, classFile, log$1, binaryClassNameToLoadedClass$1, newClass, analysis$1, sourceToClassFiles$1, loader$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$apply$18(Class x$5) {
        return x$5.getCanonicalName() != null;
    }

    private static final Option getMappedSource$1(String className, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        Option nonLocalSourceName = binaryClassNameToLoadedClass$1.get((Object)className).flatMap((Function1 & Serializable)loadedClass -> MODULE$.binaryToSourceName((Class<?>)loadedClass).map((Function1 & Serializable)sourceName -> sourceName));
        return nonLocalSourceName.orElse((Function0 & Serializable)() -> localClassesToSources$1.get((Object)className));
    }

    private static final Option loadFromClassloader$1(ClassLoader loader$1, String onBinaryName$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1) {
        return Option$.MODULE$.apply((Object)loader$1.getResource(MODULE$.classNameToClassFile(onBinaryName$1))).flatMap((Function1 & Serializable)url -> MODULE$.urlAsFile((URL)url, log$1, (Option<Path>)finalJarOutput$1).map((Function1 & Serializable)file -> {
            classfilesCache$1.update((Object)onBinaryName$1, file);
            return file;
        }));
    }

    public static final /* synthetic */ void $anonfun$apply$29(JavaAnalyze$ $this, AnalysisCallback analysis$1, String onBinaryName$1, String fromClassName$2, VirtualFile source$2, DependencyContext context$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Logger log$1, Path file) {
        Path binaryFile = $this.remapClassFile$1(file, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
        analysis$1.binaryDependency(binaryFile, onBinaryName$1, fromClassName$2, (VirtualFileRef)source$2, context$1);
    }

    private final void processDependency$1(String onBinaryName, DependencyContext context, String fromBinaryName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1) {
        Option option;
        Tuple2 tuple2 = new Tuple2((Object)JavaAnalyze$.getMappedSource$1(fromBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1), (Object)JavaAnalyze$.getMappedSource$1(onBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1));
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String fromClassName = (String)some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    String onClassName = (String)some2.value();
                    this.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> analysis$1.classDependency(onClassName, fromClassName, context));
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option option4 = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                String fromClassName = (String)some.value();
                if (None$.MODULE$.equals(option5)) {
                    this.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        Option cachedOrigin = classfilesCache$1.get((Object)onBinaryName);
                        cachedOrigin.orElse((Function0 & Serializable)() -> JavaAnalyze$.loadFromClassloader$1(loader$1, onBinaryName, log$1, finalJarOutput$1, classfilesCache$1)).foreach((Function1 & Serializable)file -> {
                            JavaAnalyze$.$anonfun$apply$29(this, analysis$1, onBinaryName, fromClassName, source$2, context, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1, file);
                            return BoxedUnit.UNIT;
                        });
                    });
                    return;
                }
            }
        }
        if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void processDependencies$1(Iterable binaryClassNames, DependencyContext context, String fromBinaryClassName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1) {
        binaryClassNames.foreach((Function1 & Serializable)binaryClassName -> {
            this.processDependency$1(binaryClassName, context, fromBinaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$32(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String binaryClassName = (String)tuple2._1();
            Set binaryClassNameDeps = (Set)tuple2._2();
            $this.processDependencies$1((Iterable)binaryClassNameDeps, DependencyContext.DependencyByMemberRef, binaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Iterator readInheritanceDependencies$1(Seq classes, Function2 readAPI$1, VirtualFile source$2) {
        Set api = (Set)readAPI$1.apply((Object)source$2, (Object)classes);
        return api.groupBy((Function1 & Serializable)x$7 -> (String)x$7._1()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Set v = (Set)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.map((Function1 & Serializable)x$8 -> (String)x$8._2()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$apply$36(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            Set inheritanceDeps = (Set)tuple2._2();
            $this.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.DependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$38(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            Set inheritanceDeps = (Set)tuple2._2();
            $this.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.LocalDependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$16(JavaAnalyze$ $this, AnalysisCallback analysis$1, HashMap binaryClassNameToLoadedClass$1, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Function2 readAPI$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            VirtualFile source = (VirtualFile)tuple2._1();
            Buffer classFiles = (Buffer)tuple2._2();
            analysis$1.startSource(source);
            Buffer loadedClasses = (Buffer)classFiles.map((Function1 & Serializable)c -> (Class)binaryClassNameToLoadedClass$1.apply((Object)c.className()));
            Tuple2 tuple22 = loadedClasses.partition((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$18(x$5)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Buffer nonLocalClasses = (Buffer)tuple22._1();
            Buffer localClassesOrStale = (Buffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)nonLocalClasses, (Object)localClassesOrStale);
            Buffer nonLocalClasses2 = (Buffer)tuple23._1();
            Buffer localClassesOrStale2 = (Buffer)tuple23._2();
            Buffer localToSourcesSeq = (Buffer)localClassesOrStale2.flatMap((Function1 & Serializable)cls -> MODULE$.loadEnclosingClass((Class<?>)cls).map((Function1 & Serializable)sourceOfEnclosing -> new Tuple2((Object)cls.getName(), sourceOfEnclosing)));
            Map localClassesToSources = localToSourcesSeq.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map typesInSource = ((IterableOnceOps)classFiles.map((Function1 & Serializable)cf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cf.className()), cf.types()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            typesInSource.foreach((Function1 & Serializable)x0$1 -> {
                JavaAnalyze$.$anonfun$apply$32($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$1);
                return BoxedUnit.UNIT;
            });
            Map nonLocalInherited = JavaAnalyze$.readInheritanceDependencies$1(nonLocalClasses2.toSeq(), readAPI$1, source).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            nonLocalInherited.foreach((Function1 & Serializable)x0$2 -> {
                JavaAnalyze$.$anonfun$apply$36($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$2);
                return BoxedUnit.UNIT;
            });
            Buffer localClasses = (Buffer)localClassesOrStale2.filter((Function1 & Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)localClassesToSources.contains((Object)cls.getName())));
            Map localInherited = JavaAnalyze$.readInheritanceDependencies$1(localClasses.toSeq(), readAPI$1, source).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            localInherited.foreach((Function1 & Serializable)x0$3 -> {
                JavaAnalyze$.$anonfun$apply$38($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final File toFile$1(Path p) {
        if (p == null) {
            return null;
        }
        return p.toFile();
    }

    public static final /* synthetic */ boolean $anonfun$urlAsFile$3(Path p$1, Path x$10) {
        Path path = x$10;
        Path path2 = p$1;
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$guessSourcePath$2(char x$11) {
        return x$11 != '$';
    }

    private static final List make$1(List sources$1) {
        return sources$1.map((Function1 & Serializable)x$12 -> (VirtualFile)x$12._1());
    }

    private final List refine$1(List sources, List pkgRev) {
        List list;
        while (true) {
            if (sources.isEmpty() || ((List)sources.tail()).isEmpty()) {
                return JavaAnalyze$.make$1(sources);
            }
            list = pkgRev;
            if (Nil$.MODULE$.equals(list)) {
                return JavaAnalyze$.shortest$1(JavaAnalyze$.make$1(sources));
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String x = (String)colon2.head();
            List xs = colon2.next$access$1();
            List retain = sources.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    VirtualFile src = (VirtualFile)tuple2._1();
                    List list = (List)tuple2._2();
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        String string = (String)colon2.head();
                        List presRev = colon2.next$access$1();
                        String string2 = x;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            Tuple2 tuple22 = new Tuple2((Object)src, (Object)presRev);
                            return Nil$.MODULE$.$colon$colon((Object)tuple22);
                        }
                    }
                }
                return Nil$.MODULE$;
            });
            pkgRev = xs;
            sources = retain;
        }
        throw new MatchError((Object)list);
    }

    private static final List shortest$1(List files) {
        if (files.isEmpty()) {
            return files;
        }
        Map fs = files.groupBy((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])x.names()))));
        return (List)fs.apply(fs.keys().min((Ordering)Ordering.Int$.MODULE$));
    }

    private JavaAnalyze$() {
    }
}

