/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import sbt.internal.inc.classpath.ClasspathFilter;
import sbt.internal.inc.classpath.FixedResources;
import sbt.internal.inc.classpath.NativeCopyConfig;
import sbt.internal.inc.classpath.NativeCopyLoader;
import sbt.internal.inc.classpath.RawResources;
import sbt.io.IO$;
import sbt.io.PathFinder;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import scala.util.control.Exception$;
import xsbti.Launcher;
import xsbti.compile.ScalaInstance;

public final class ClasspathUtil$ {
    public static final ClasspathUtil$ MODULE$ = new ClasspathUtil$();
    private static ClassLoader rootLoader;
    private static ClassLoader xsbtiLoader;
    private static volatile byte bitmap$0;

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<Path> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<Path> paths, ClassLoader parent) {
        return new URLClassLoader((URL[])this.toURLs(paths).toArray(ClassTag$.MODULE$.apply(URL.class)), parent);
    }

    public ClassLoader toLoader(Seq<Path> paths, ClassLoader parent, Map<String, String> resourceMap) {
        return new RawResources(paths, parent, resourceMap){
            private Map<String, URL> resourceURL;
            private final Map resourceMap$1;

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$1;
            }
            {
                this.resourceMap$1 = resourceMap$1;
                super((URL[])ClasspathUtil$.MODULE$.toURLs((Seq<Path>)paths$1).toArray(ClassTag$.MODULE$.apply(URL.class)), parent$1);
                FixedResources.$init$(this);
                RawResources.$init$(this);
                Statics.releaseFence();
            }
        };
    }

    public ClassLoader toLoader(Seq<Path> paths, ClassLoader parent, Map<String, String> resourceMap, Path nativeTemp) {
        return new RawResources(paths, parent, resourceMap, nativeTemp){
            private final NativeCopyConfig config;
            private HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            private Map<String, URL> resourceURL;
            private final Map resourceMap$2;
            private final Path nativeTemp$1;
            private final Seq paths$2;
            private final ClassLoader parent$2;

            public String findLibrary(String name) {
                return NativeCopyLoader.findLibrary$(this, name);
            }

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped() {
                return this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            }

            public final void sbt$internal$inc$classpath$NativeCopyLoader$_setter_$sbt$internal$inc$classpath$NativeCopyLoader$$mapped_$eq(HashMap<String, String> x$1) {
                this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped = x$1;
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$2;
            }

            public NativeCopyConfig config() {
                return this.config;
            }

            public String toString() {
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|URLClassLoader with NativeCopyLoader with RawResources(\n            |  urls = ").append(this.paths$2).append(",\n            |  parent = ").append(this.parent$2).append(",\n            |  resourceMap = ").append(this.resourceMap$2.keySet()).append(",\n            |  nativeTemp = ").append(this.nativeTemp$1).append("\n            |)").toString()));
            }
            {
                this.resourceMap$2 = resourceMap$2;
                this.nativeTemp$1 = nativeTemp$1;
                this.paths$2 = paths$2;
                this.parent$2 = parent$2;
                super((URL[])ClasspathUtil$.MODULE$.toURLs((Seq<Path>)paths$2).toArray(ClassTag$.MODULE$.apply(URL.class)), parent$2);
                FixedResources.$init$(this);
                RawResources.$init$(this);
                NativeCopyLoader.$init$(this);
                this.config = new NativeCopyConfig(nativeTemp$1, (Seq<Path>)paths$2, ClasspathUtil$.MODULE$.javaLibraryPaths());
                Statics.releaseFence();
            }
        };
    }

    public Seq<Path> javaLibraryPaths() {
        return (Seq)IO$.MODULE$.parseClasspath(System.getProperty("java.library.path")).map((Function1 & Serializable)x$1 -> x$1.toPath());
    }

    private ClassLoader rootLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                rootLoader = systemLoader != null ? this.parent$3(systemLoader) : this.parent$3(this.getClass().getClassLoader());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return rootLoader;
    }

    public ClassLoader rootLoader() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.rootLoader$lzycompute();
        }
        return rootLoader;
    }

    private ClassLoader xsbtiLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                xsbtiLoader = Launcher.class.getClassLoader();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return xsbtiLoader;
    }

    public ClassLoader xsbtiLoader() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.xsbtiLoader$lzycompute();
        }
        return xsbtiLoader;
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<Path> classpath, ScalaInstance instance) {
        return this.createClasspathResources(classpath, (Seq<Path>)((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])instance.libraryJars())).map((Function1 & Serializable)x$2 -> x$2.toPath())));
    }

    public Map<String, String> createClasspathResources(Seq<Path> appPaths, Seq<Path> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.make$1("app.class.path", appPaths), this.make$1("boot.class.path", bootPaths)}));
    }

    public ClassLoader filterByClasspath(Seq<Path> classpath, ClassLoader loader) {
        return new ClasspathFilter(loader, this.xsbtiLoader(), (Set<Path>)classpath.toSet());
    }

    public ClassLoader makeLoader(Seq<Path> classpath, ScalaInstance instance) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance));
    }

    public ClassLoader makeLoader(Seq<Path> classpath, ScalaInstance instance, Path nativeTemp) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance, nativeTemp));
    }

    public ClassLoader makeLoader(Seq<Path> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public ClassLoader makeLoader(Seq<Path> classpath, ClassLoader parent, ScalaInstance instance, Path nativeTemp) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance), nativeTemp);
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder(18).append(c.getName()).append(" loader=").append(c.getClassLoader()).append(" location=").append(IO$.MODULE$.classLocationPath(c)).toString());
    }

    public boolean isArchive(Path file) {
        return this.isArchive(file, false);
    }

    public boolean isArchive(Path file, boolean contentFallback) {
        return Files.isRegularFile(file, new LinkOption[0]) && (this.isArchiveName(((Object)file.getFileName()).toString()) || contentFallback && this.hasZipContent(file));
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public boolean hasZipContent(Path file) {
        try {
            return BoxesRunTime.unboxToBoolean(this.usingFileInputStream(file, (Function1 & Serializable)in -> BoxesRunTime.boxToBoolean((boolean)ClasspathUtil$.$anonfun$hasZipContent$1(in))));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public <A> A usingFileInputStream(Path file, Function1<InputStream, A> f) {
        Object object;
        try (InputStream st = Files.newInputStream(file, new OpenOption[0]);){
            object = f.apply((Object)st);
        }
        return (A)object;
    }

    public Iterable<Path> compilerPlugins(Seq<Path> classpath, boolean isDotty) {
        URLClassLoader loader = new URLClassLoader((URL[])this.toURLs(classpath).toArray(ClassTag$.MODULE$.apply(URL.class)));
        String metaFile = isDotty ? "plugin.properties" : "scalac-plugin.xml";
        return ((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(loader.getResources(metaFile)).asScala()).toList().flatMap((Function1 & Serializable)url -> MODULE$.asFile(true, (URL)url));
    }

    public List<Path> asFile(URL url) {
        return this.asFile(false, url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> asFile(boolean jarOnly, URL url) {
        Nil$ nil$;
        try {
            String string = url.getProtocol();
            switch (string == null ? 0 : string.hashCode()) {
                case 104987: {
                    if (!"jar".equals(string)) break;
                    String path = url.getPath();
                    int end = path.indexOf(33);
                    Path path2 = Paths.get(new URI(end == -1 ? path : path.substring(0, end)));
                    nil$ = Nil$.MODULE$.$colon$colon((Object)path2);
                    return nil$;
                }
                case 3143036: {
                    if (!"file".equals(string) || jarOnly) break;
                    Path path = Paths.get(url.toURI());
                    nil$ = Nil$.MODULE$.$colon$colon((Object)path);
                    return nil$;
                }
            }
            nil$ = Nil$.MODULE$;
            return nil$;
        }
        catch (Exception exception) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Seq<URL> toURLs(Seq<Path> files) {
        return (Seq)files.map((Function1 & Serializable)x$3 -> x$3.toUri().toURL());
    }

    public String makeString(Seq<Path> paths) {
        return this.makeString(paths, File.pathSeparator);
    }

    public String makeString(Seq<Path> paths, String sep) {
        Seq separated = (Seq)paths.map((Function1 & Serializable)x$4 -> ((Object)x$4.toAbsolutePath()).toString());
        separated.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains(sep))).foreach((Function1 & Serializable)p -> package$.MODULE$.error(new StringBuilder(29).append("Path '").append((String)p).append("' contains separator '").append(sep).append("'").toString()));
        return separated.mkString(sep);
    }

    public Option<String> relativize(Path base, Path file) {
        Path basePath = ClasspathUtil$.toAbsolutePath$1(base).normalize();
        Path filePath = ClasspathUtil$.toAbsolutePath$1(file).normalize();
        if (filePath.startsWith(basePath)) {
            return Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt((Function0 & Serializable)() -> basePath.relativize(filePath)).map((Function1 & Serializable)x$6 -> ((Object)x$6).toString());
        }
        return None$.MODULE$;
    }

    private final ClassLoader parent$3(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private final Tuple2 make$1(String name, Seq paths) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)this.makeString((Seq<Path>)paths));
    }

    public static final /* synthetic */ boolean $anonfun$hasZipContent$1(InputStream in) {
        return in.read() == 80 && in.read() == 75 && in.read() == 3 && in.read() == 4;
    }

    private static final Path toAbsolutePath$1(Path x) {
        if (!x.isAbsolute()) {
            return x.toAbsolutePath();
        }
        return x;
    }

    private ClasspathUtil$() {
    }
}

