/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.ZincComponentCompiler$;
import sbt.internal.inc.ZincComponentManager;
import sbt.internal.inc.ZincComponentManager$;
import sbt.internal.inc.classpath.ClassLoaderCache;
import sbt.internal.util.MessageOnlyException;
import sbt.io.FileFilter$;
import sbt.io.NameFilter;
import sbt.librarymanagement.DependencyResolution;
import sbt.librarymanagement.ModuleDescriptor;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.ModuleID$;
import sbt.librarymanagement.ScalaArtifacts$;
import sbt.librarymanagement.SemanticSelector$;
import sbt.librarymanagement.UnresolvedWarningConfiguration;
import sbt.librarymanagement.UpdateConfiguration;
import sbt.librarymanagement.VersionNumber$;
import sbt.librarymanagement.syntax$;
import sbt.util.Logger$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import xsbti.ComponentProvider;
import xsbti.GlobalLock;
import xsbti.Logger;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompilerBridgeProvider;
import xsbti.compile.ScalaInstance;

public final class ZincLmUtil$ {
    public static ZincLmUtil$ MODULE$;

    static {
        new ZincLmUtil$();
    }

    public final String scala2SbtBridgeStart() {
        return "2.13.12";
    }

    public AnalyzingCompiler scalaCompiler(ScalaInstance scalaInstance, ClasspathOptions classpathOptions, GlobalLock globalLock, ComponentProvider componentProvider, Option<File> secondaryCacheDir, DependencyResolution dependencyResolution, ModuleID compilerBridgeSource, File scalaJarsTarget, Option<ClassLoaderCache> classLoaderCache, Logger log) {
        CompilerBridgeProvider compilerBridgeProvider = ZincComponentCompiler$.MODULE$.interfaceProvider(compilerBridgeSource, new ZincComponentManager(globalLock, componentProvider, secondaryCacheDir, log), dependencyResolution, scalaJarsTarget);
        return new AnalyzingCompiler(scalaInstance, compilerBridgeProvider, classpathOptions, (Function1 & Serializable & scala.Serializable)x$1 -> {
            ZincLmUtil$.$anonfun$scalaCompiler$1(x$1);
            return BoxedUnit.UNIT;
        }, classLoaderCache);
    }

    public File fetchDefaultBridgeModule(String scalaVersion, DependencyResolution dependencyResolution, UpdateConfiguration updateConfiguration, UnresolvedWarningConfiguration warningConfig, Logger logger) {
        ModuleID bridgeModule = this.getDefaultBridgeModule(scalaVersion);
        ModuleDescriptor descriptor = dependencyResolution.wrapDependencyInModule(bridgeModule);
        return (File)dependencyResolution.update(descriptor, updateConfiguration, warningConfig, Logger$.MODULE$.xlog2Log(logger)).toOption().flatMap((Function1 & Serializable & scala.Serializable)report -> {
            NameFilter x$1 = FileFilter$.MODULE$.globFilter("jar");
            NameFilter x$2 = FileFilter$.MODULE$.globFilter("");
            NameFilter x$3 = syntax$.MODULE$.artifactFilter$default$1();
            NameFilter x$4 = syntax$.MODULE$.artifactFilter$default$2();
            Vector jars = syntax$.MODULE$.richUpdateReport(report).select(syntax$.MODULE$.configurationFilter(FileFilter$.MODULE$.globFilter(syntax$.MODULE$.Compile().name())), syntax$.MODULE$.moduleFilter(FileFilter$.MODULE$.globFilter(bridgeModule.organization()), FileFilter$.MODULE$.globFilter(bridgeModule.name()), FileFilter$.MODULE$.globFilter(bridgeModule.revision())), syntax$.MODULE$.artifactFilter(x$3, x$4, x$1, x$2));
            if (jars.size() > 1) {
                throw package$.MODULE$.error(new StringBuilder(44).append("There should be only one jar for ").append(bridgeModule).append(" but found ").append(jars).toString());
            }
            return jars.headOption();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MessageOnlyException(new StringBuilder(8).append("Missing ").append(bridgeModule).toString());
        });
    }

    public ModuleID getDefaultBridgeModule(String scalaVersion) {
        if (ScalaArtifacts$.MODULE$.isScala3(scalaVersion)) {
            return ModuleID$.MODULE$.apply("org.scala-lang", "scala3-sbt-bridge", scalaVersion).withConfigurations((Option)new Some((Object)syntax$.MODULE$.Compile().name()));
        }
        if (VersionNumber$.MODULE$.apply(scalaVersion).matchesSemVer(SemanticSelector$.MODULE$.apply(new StringBuilder(15).append("=2.13 >=").append("2.13.12").toString()))) {
            return ModuleID$.MODULE$.apply("org.scala-lang", "scala2-sbt-bridge", scalaVersion).withConfigurations((Option)new Some((Object)syntax$.MODULE$.Compile().name()));
        }
        String string = scalaVersion;
        String compilerBridgeId = string.startsWith("2.10.") ? "compiler-bridge_2.10" : (string.startsWith("2.11.") ? "compiler-bridge_2.11" : (string.startsWith("2.12.") ? "compiler-bridge_2.12" : ("2.13.0-M1".equals(string) ? "compiler-bridge_2.12" : "compiler-bridge_2.13")));
        return ModuleID$.MODULE$.apply("org.scala-sbt", compilerBridgeId, ZincComponentManager$.MODULE$.version()).withConfigurations((Option)new Some((Object)syntax$.MODULE$.Compile().name()));
    }

    public ModuleID getDefaultBridgeSourceModule(String scalaVersion) {
        return this.getDefaultBridgeModule(scalaVersion).sources();
    }

    public static final /* synthetic */ void $anonfun$scalaCompiler$1(Seq x$1) {
    }

    private ZincLmUtil$() {
        MODULE$ = this;
    }
}

