/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.consistent;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import sbt.internal.inc.consistent.ParallelGzipOutputStream$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ex!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005b\u0002(\u0002\u0005\u0004%Ia\u0014\u0005\u0007'\u0006\u0001\u000b\u0011\u0002)\t\u000fQ\u000b!\u0019!C\u0005\u001f\"1Q+\u0001Q\u0001\nA3AAV\u0001\u0005/\"A\u0001m\u0002B\u0001B\u0003%\u0001\u000bC\u0003M\u000f\u0011\u0005\u0011\rC\u0003f\u000f\u0011\u0005aM\u0002\u0003s\u0003\u0011\u0019\b\"\u0002'\f\t\u0003!\bB\u0002<\fA\u0003%q\u000f\u0003\u0004l\u0017\u0001\u0006IA\u0019\u0005\b\u007f.\u0001\u000b\u0011BA\u0001\u0011\u001d\t9a\u0003C\u0001\u0003\u0013A\u0011\"a\f\u0002\u0005\u0004%I!!\r\t\u0011\u0005}\u0012\u0001)A\u0005\u0003g1a!!\u0005\u0002\t\u0005M\u0001B\u0002'\u0014\t\u0003\t)\u0002C\u0005\u0002\u0018M\u0001\r\u0011\"\u0001\u0002\u001a!I\u00111D\nA\u0002\u0013\u0005\u0011Q\u0004\u0005\b\u0003G\u0019\u0002\u0015)\u0003m\u0011!\t)c\u0005a\u0001\n\u0003y\u0005\"CA\u0014'\u0001\u0007I\u0011AA\u0015\u0011\u001d\tic\u0005Q!\nAC\u0011\"!\u0011\u0002\u0005\u0004%I!!\u0007\t\u000f\u0005\r\u0013\u0001)A\u0005Y\u001a)A)\u000f\u0002\u0002F!Iq0\bB\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003'j\"\u0011!Q\u0001\n\u0005U\u0003\"CA1;\t\u0005\t\u0015!\u0003Q\u0011\u0019aU\u0004\"\u0001\u0002d!I\u0011QN\u000fC\u0002\u00135\u0011q\u000e\u0005\t\u0003oj\u0002\u0015!\u0004\u0002r!A\u0011\u0011P\u000fC\u0002\u00135q\nC\u0004\u0002|u\u0001\u000bQ\u0002)\t\u0013\u0005uTD1A\u0005\u000e\u0005}\u0004\u0002CAN;\u0001\u0006i!!!\t\u0013\u0005uU\u00041A\u0005\n\u0005}\u0005\"CAQ;\u0001\u0007I\u0011BAR\u0011!\t9+\bQ!\n\u0005]\u0005bCAU;\u0001\u0007\t\u0019!C\u0005\u0003?C1\"a+\u001e\u0001\u0004\u0005\r\u0011\"\u0003\u0002.\"Y\u0011\u0011W\u000fA\u0002\u0003\u0005\u000b\u0015BAL\u0011%\t\u0019,\ba\u0001\n\u0013\t)\fC\u0005\u0002>v\u0001\r\u0011\"\u0003\u0002@\"A\u00111Y\u000f!B\u0013\t9\fC\u0004\u0002Fv!\t%a2\t\u000f\u0005\u0015W\u0004\"\u0011\u0002L\"9\u0011QY\u000f\u0005B\u0005=\u0007\u0002CAu;\u0001&I!a;\t\u000f\u00055X\u0004\"\u0003\u0002p\"9\u0011Q_\u000f\u0005B\u0005-\bbBA|;\u0011\u0005\u00131^\u0001\u0019!\u0006\u0014\u0018\r\u001c7fY\u001eS\u0018\u000e](viB,Ho\u0015;sK\u0006l'B\u0001\u001e<\u0003)\u0019wN\\:jgR,g\u000e\u001e\u0006\u0003yu\n1!\u001b8d\u0015\tqt(\u0001\u0005j]R,'O\\1m\u0015\u0005\u0001\u0015aA:ci\u000e\u0001\u0001CA\"\u0002\u001b\u0005I$\u0001\u0007)be\u0006dG.\u001a7Hu&\u0004x*\u001e;qkR\u001cFO]3b[N\u0011\u0011A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0015!\u00032m_\u000e\\7+\u001b>f+\u0005\u0001\u0006CA$R\u0013\t\u0011\u0006JA\u0002J]R\f!B\u00197pG.\u001c\u0016N_3!\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u0002\u0019\r|W\u000e\u001d:fgNLwN\u001c\u0011\u0003\r\t+hmT;u'\t9\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0011\u0011n\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&LA\u000bCsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y7\u0002\tML'0\u001a\u000b\u0003E\u0012\u0004\"aY\u0004\u000e\u0003\u0005AQ\u0001Y\u0005A\u0002A\u000bqa\u001e:ji\u0016$v\u000e\u0006\u0002hUB\u0011q\t[\u0005\u0003S\"\u0013A!\u00168ji\")1N\u0003a\u0001Y\u0006\u0019!-\u001e4\u0011\u0007\u001dkw.\u0003\u0002o\u0011\n)\u0011I\u001d:bsB\u0011q\t]\u0005\u0003c\"\u0013AAQ=uK\n1qk\u001c:lKJ\u001c\"a\u0003$\u0015\u0003U\u0004\"aY\u0006\u0002\t\u0011,g\r\u001c\t\u0003qvl\u0011!\u001f\u0006\u0003un\f1A_5q\u0015\taH,\u0001\u0003vi&d\u0017B\u0001@z\u0005!!UM\u001a7bi\u0016\u0014\u0018aA8viB\u0019\u00010a\u0001\n\u0007\u0005\u0015\u0011P\u0001\u000bEK\u001ad\u0017\r^3s\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\tG>l\u0007O]3tgR\u0019q-a\u0003\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010\u0005\t!\r\u0005\u0002d'\t)!\t\\8dWN\u00111C\u0012\u000b\u0003\u0003\u001f\tA\u0001Z1uCV\tA.\u0001\u0005eCR\fw\fJ3r)\r9\u0017q\u0004\u0005\t\u0003C1\u0012\u0011!a\u0001Y\u0006\u0019\u0001\u0010J\u0019\u0002\u000b\u0011\fG/\u0019\u0011\u0002\r1,gn\u001a;i\u0003)aWM\\4uQ~#S-\u001d\u000b\u0004O\u0006-\u0002\u0002CA\u00113\u0005\u0005\t\u0019\u0001)\u0002\u000f1,gn\u001a;iA\u0005YAn\\2bY^{'o[3s+\t\t\u0019\u0004E\u0003\u00026\u0005mR/\u0004\u0002\u00028)\u0019\u0011\u0011\b/\u0002\t1\fgnZ\u0005\u0005\u0003{\t9DA\u0006UQJ,\u0017\r\u001a'pG\u0006d\u0017\u0001\u00047pG\u0006dwk\u001c:lKJ\u0004\u0013A\u00025fC\u0012,'/A\u0004iK\u0006$WM\u001d\u0011\u0014\u0007u\t9\u0005E\u0002Z\u0003\u0013J1!a\u0013[\u0005I1\u0015\u000e\u001c;fe>+H\u000f];u'R\u0014X-Y7\u0011\u0007e\u000by%C\u0002\u0002Ri\u0013AbT;uaV$8\u000b\u001e:fC6\f!!Z2\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017I\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003?\nIF\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006Y\u0001/\u0019:bY2,G.[:n)!\t)'a\u001a\u0002j\u0005-\u0004CA\"\u001e\u0011\u0019y\u0018\u00051\u0001\u0002N!9\u00111K\u0011A\u0002\u0005U\u0003BBA1C\u0001\u0007\u0001+A\u0002de\u000e,\"!!\u001d\u0011\u0007a\f\u0019(C\u0002\u0002ve\u0014Qa\u0011*DgI\nAa\u0019:dA\u0005Q\u0011/^3vK2KW.\u001b;\u0002\u0017E,X-^3MS6LG\u000fI\u0001\ba\u0016tG-\u001b8h+\t\t\t\t\u0005\u0004\u0002\u0004\u00065\u0015\u0011S\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u00069Q.\u001e;bE2,'bAAF\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0015Q\u0011\u0002\u0006#V,W/\u001a\t\u0007\u0003/\n\u0019*a&\n\t\u0005U\u0015\u0011\f\u0002\u0007\rV$XO]3\u0011\u0007\u0005e5C\u0004\u0002D\u0001\u0005A\u0001/\u001a8eS:<\u0007%A\u0004dkJ\u0014XM\u001c;\u0016\u0005\u0005]\u0015aC2veJ,g\u000e^0%KF$2aZAS\u0011%\t\t#KA\u0001\u0002\u0004\t9*\u0001\u0005dkJ\u0014XM\u001c;!\u0003\u00111'/Z3\u0002\u0011\u0019\u0014X-Z0%KF$2aZAX\u0011%\t\t\u0003LA\u0001\u0002\u0004\t9*A\u0003ge\u0016,\u0007%A\u0003u_R\fG.\u0006\u0002\u00028B\u0019q)!/\n\u0007\u0005m\u0006J\u0001\u0003M_:<\u0017!\u0003;pi\u0006dw\fJ3r)\r9\u0017\u0011\u0019\u0005\n\u0003Cy\u0013\u0011!a\u0001\u0003o\u000ba\u0001^8uC2\u0004\u0013!B<sSR,GcA4\u0002J\"1\u0011QB\u0019A\u0002A#2aZAg\u0011\u0019\tiA\ra\u0001YR9q-!5\u0002T\u0006]\u0007BBA\u0007g\u0001\u0007A\u000e\u0003\u0004\u0002VN\u0002\r\u0001U\u0001\u0004_\u001a4\u0007BBAmg\u0001\u0007\u0001+A\u0002mK:D3aMAo!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAAr\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0018\u0011\u001d\u0002\bi\u0006LGN]3d\u0003\u0019\u0019XOY7jiR\tq-\u0001\u0006gYV\u001c\b.\u00168uS2$2aZAy\u0011\u0019\t\u00190\u000ea\u0001!\u0006I!/Z7bS:LgnZ\u0001\u0006M2,8\u000f[\u0001\u0006G2|7/\u001a")
public final class ParallelGzipOutputStream
extends FilterOutputStream {
    private final OutputStream out;
    private final ExecutionContext ec;
    private final CRC32 crc;
    private final int queueLimit;
    private final Queue<Future<Block>> pending;
    private Block current;
    private Block free;
    private long total;

    private final CRC32 crc() {
        return this.crc;
    }

    private final int queueLimit() {
        return this.queueLimit;
    }

    private final Queue<Future<Block>> pending() {
        return this.pending;
    }

    private Block current() {
        return this.current;
    }

    private void current_$eq(Block x$1) {
        this.current = x$1;
    }

    private Block free() {
        return this.free;
    }

    private void free_$eq(Block x$1) {
        this.free = x$1;
    }

    private long total() {
        return this.total;
    }

    private void total_$eq(long x$1) {
        this.total = x$1;
    }

    @Override
    public void write(int b) {
        this.write((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)(b & 0xFF)}), ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        while (true) {
            int copy = package$.MODULE$.min(len, ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$blockSize() - this.current().length());
            this.crc().update(b, off, copy);
            this.total_$eq(this.total() + (long)copy);
            System.arraycopy(b, off, this.current().data(), this.current().length(), copy);
            Block block = this.current();
            block.length_$eq(block.length() + copy);
            if (copy >= len) break;
            this.submit();
            len -= copy;
            off += copy;
        }
    }

    private void submit() {
        this.flushUntil(this.queueLimit() - 1);
        Block finalBlock = this.current();
        this.pending().$plus$eq((Object)Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$localWorker().get().compress(finalBlock);
            return finalBlock;
        }, this.ec));
        if (this.free() != null) {
            this.current_$eq(this.free());
            this.free_$eq(null);
            return;
        }
        this.current_$eq(new Block());
    }

    private void flushUntil(int remaining) {
        while (this.pending().length() > remaining || this.pending().headOption().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCompleted()))) {
            Block b = (Block)Await$.MODULE$.result((Awaitable)this.pending().dequeue(), (Duration)Duration$.MODULE$.Inf());
            this.out.write(b.data(), 0, b.length());
            b.length_$eq(0);
            this.free_$eq(b);
        }
    }

    @Override
    public void flush() {
        if (this.current().length() > 0) {
            this.submit();
        }
        this.flushUntil(0);
        super.flush();
    }

    @Override
    public void close() {
        this.flush();
        byte[] buf = new byte[10];
        buf[0] = 3;
        ParallelGzipOutputStream.int$1((int)this.crc().getValue(), 2, buf);
        ParallelGzipOutputStream.int$1((int)(this.total() & 0xFFFFFFFFL), 6, buf);
        this.out.write(buf);
        this.out.close();
        this.total_$eq(Integer.MIN_VALUE);
        this.free_$eq(null);
    }

    private static final void int$1(int i, int off, byte[] buf$1) {
        buf$1[off] = (byte)(i & 0xFF);
        buf$1[off + 1] = (byte)(i >>> 8 & 0xFF);
        buf$1[off + 2] = (byte)(i >>> 16 & 0xFF);
        buf$1[off + 3] = (byte)(i >>> 24 & 0xFF);
    }

    public ParallelGzipOutputStream(OutputStream out, ExecutionContext ec, int parallelism) {
        this.out = out;
        this.ec = ec;
        super(out);
        this.crc = new CRC32();
        this.queueLimit = parallelism * 3;
        this.pending = (Queue)Queue$.MODULE$.empty();
        this.current = new Block();
        this.total = 0L;
        out.write(ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$header());
    }

    private static class Block {
        private byte[] data = new byte[ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$blockSize() + (ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$blockSize() >> 3)];
        private int length = 0;

        public byte[] data() {
            return this.data;
        }

        public void data_$eq(byte[] x$1) {
            this.data = x$1;
        }

        public int length() {
            return this.length;
        }

        public void length_$eq(int x$1) {
            this.length = x$1;
        }
    }

    private static class BufOut
    extends ByteArrayOutputStream {
        public void writeTo(byte[] buf) {
            System.arraycopy(this.buf, 0, buf, 0, this.count);
        }

        public BufOut(int size) {
            super(size);
        }
    }

    private static class Worker {
        private final Deflater defl = new Deflater(ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$compression(), true);
        private final BufOut buf = new BufOut(ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$blockSize() + (ParallelGzipOutputStream$.MODULE$.sbt$internal$inc$consistent$ParallelGzipOutputStream$$blockSize() >> 3));
        private final DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)this.buf, this.defl, true);

        public void compress(Block b) {
            this.defl.reset();
            this.buf.reset();
            this.out.write(b.data(), 0, b.length());
            this.out.flush();
            b.length_$eq(this.buf.size());
            if (b.length() > b.data().length) {
                b.data_$eq(new byte[b.length()]);
            }
            this.buf.writeTo(b.data());
        }
    }
}

