/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.binary.converters;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sbt.internal.inc.APIs;
import sbt.internal.inc.APIs$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.Compilation;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Compilations$;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.ExternalDependencies;
import sbt.internal.inc.FarmHash$;
import sbt.internal.inc.Hash$;
import sbt.internal.inc.InternalDependencies;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.RelationBuilder;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Relations$;
import sbt.internal.inc.Schema;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.SourceInfos$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.UsedNames;
import sbt.internal.inc.UsedNames$;
import sbt.internal.inc.binary.converters.InternalApiProxy$Modifiers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$EmptyLazyCompanions$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$Readers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$ReadersConstants$;
import sbt.internal.util.Relation;
import sbt.util.InterfaceUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.Position;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.T2;
import xsbti.UseScope;
import xsbti.VirtualFileRef;
import xsbti.api.Access;
import xsbti.api.AnalyzedClass;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Companions;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.DefinitionType;
import xsbti.api.DependencyContext;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Lazy;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.NameHash;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Qualifier;
import xsbti.api.SafeLazyProxy$;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;
import xsbti.compile.CompileOrder;
import xsbti.compile.FileHash;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.analysis.ReadMapper;
import xsbti.compile.analysis.SourceInfo;
import xsbti.compile.analysis.Stamp;

@ScalaSignature(bytes="\u0006\u0001\u0011Uf\u0001B!C\u00055C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t?\u0002\u0011\t\u0011)A\u0005A\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C\u0001_\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003r\u0001!\tAa\u001d\u0007\r\tm\u0004!\u0001B?\u0011)\u0011\t)\u0007B\u0001B\u0003%!1\u0011\u0005\u0007Qf!\tA!*\t\u000f\t5\u0016\u0004\"\u0001\u00030\"I!Q\u001c\u0001\u0002\u0002\u0013\r!q\u001c\u0004\u0007\u0005[\u0004\u0011Aa<\t\u0015\tMhD!A!\u0002\u0013\u0011)\u0010\u0003\u0004i=\u0011\u0005!1 \u0005\b\u0007\u0003qB\u0011AB\u0002\u0011%\u0019Y\u0002AA\u0001\n\u0007\u0019i\u0002C\u0004\u0004,\u0001!\ta!\f\t\u000f\r}\u0002\u0001\"\u0001\u0004B!91\u0011\u000b\u0001\u0005\u0002\rM\u0003bBB6\u0001\u0011\u00051Q\u000e\u0005\b\u0007{\u0002A\u0011AB@\u0011\u001d\u0019y\t\u0001C\u0001\u0007#Cqa!)\u0001\t\u0003\u0019\u0019\u000bC\u0004\u00044\u0002!\ta!.\t\u000f\r\u0015\u0007\u0001\"\u0001\u0004H\"91q\u001b\u0001\u0005\u0002\re\u0007bBBu\u0001\u0011\u000511\u001e\u0005\b\u0007{\u0004A\u0011AB\u0000\u0011%!Y\u0004\u0001b\u0001\n\u001b!i\u0004\u0003\u0005\u0005B\u0001\u0001\u000bQ\u0002C \u0011%!\u0019\u0005\u0001b\u0001\n\u001b!)\u0005\u0003\u0005\u0005J\u0001\u0001\u000bQ\u0002C$\u0011%!Y\u0005\u0001b\u0001\n\u001b!)\u0005\u0003\u0005\u0005N\u0001\u0001\u000bQ\u0002C$\u0011%!y\u0005\u0001b\u0001\n\u001b!)\u0005\u0003\u0005\u0005R\u0001\u0001\u000bQ\u0002C$\u0011\u001d!\u0019\u0006\u0001C\u0001\t+Bq\u0001\"\u001a\u0001\t\u0003!9\u0007C\u0004\u0005|\u0001!\t\u0001\" \t\u000f\u0011E\u0005\u0001\"\u0001\u0005\u0014\"9A\u0011\u0015\u0001\u0005\u0002\u0011\rfA\u0002C\u0011\u0001\u0011!\u0019\u0003\u0003\u0004iy\u0011\u0005AQ\u0005\u0005\n\tOa$\u0019!C\u0005\tSA\u0001\u0002\"\r=A\u0003%A1\u0006\u0005\b\tgaD\u0011\u0001C\u001b\u0005=\u0001&o\u001c;pEV4'+Z1eKJ\u001c(BA\"E\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u000b\u001a\u000baAY5oCJL(BA$I\u0003\rIgn\u0019\u0006\u0003\u0013*\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u0017\u0006\u00191O\u0019;\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\r5\f\u0007\u000f]3s!\t1V,D\u0001X\u0015\tA\u0016,\u0001\u0005b]\u0006d\u0017p]5t\u0015\tQ6,A\u0004d_6\u0004\u0018\u000e\\3\u000b\u0003q\u000bQ\u0001_:ci&L!AX,\u0003\u0015I+\u0017\rZ'baB,'/\u0001\bdkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0011\u0005\u0005,gB\u00012d\u001b\u00051\u0015B\u00013G\u0003\u0019\u00196\r[3nC&\u0011am\u001a\u0002\b-\u0016\u00148/[8o\u0015\t!g)\u0001\u0004=S:LGO\u0010\u000b\u0004U2l\u0007CA6\u0001\u001b\u0005\u0011\u0005\"\u0002+\u0004\u0001\u0004)\u0006\"B0\u0004\u0001\u0004\u0001\u0017A\u00044s_6\u0004\u0016\r\u001e5TiJLgn\u001a\u000b\u0003aj\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\t\u0019LG.\u001a\u0006\u0003kZ\f1A\\5p\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f:\u0003\tA\u000bG\u000f\u001b\u0005\u0006w\u0012\u0001\r\u0001`\u0001\u0005a\u0006$\b\u000eE\u0002~\u0003\u0013q1A`A\u0003!\ty\b+\u0004\u0002\u0002\u0002)\u0019\u00111\u0001'\u0002\rq\u0012xn\u001c;?\u0013\r\t9\u0001U\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0001+A\bge>l\u0007+\u0019;i'R\u0014\u0018N\\4W)\u0011\t\u0019\"a\u0007\u0011\t\u0005U\u0011qC\u0007\u00027&\u0019\u0011\u0011D.\u0003\u001dYK'\u000f^;bY\u001aKG.\u001a*fM\")10\u0002a\u0001y\u0006iaM]8n'R\fW\u000e\u001d+za\u0016$B!!\t\u0002(A\u0019a+a\t\n\u0007\u0005\u0015rKA\u0003Ti\u0006l\u0007\u000fC\u0004\u0002*\u0019\u0001\r!a\u000b\u0002\u0013M$\u0018-\u001c9UsB,\u0007\u0003BA\u0017\u0003gq1!YA\u0018\u0013\r\t\tdZ\u0001\u0007'R\fW\u000e]:\n\t\u0005U\u0012q\u0007\u0002\n'R\fW\u000e\u001d+za\u0016T1!!\rh\u0003)1'o\\7Ti\u0006l\u0007o\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002c\u0003\u007fI1!!\u0011G\u0005\u0019\u0019F/Y7qg\"9\u0011QI\u0004A\u0002\u0005\u001d\u0013AB:uC6\u00048\u000fE\u0002b\u0003\u0013J1!!\u0011h\u0003=1'o\\7PkR\u0004X\u000f^$s_V\u0004H\u0003BA(\u0003/\u0002B!!\u0015\u0002T5\t\u0011,C\u0002\u0002Ve\u00131bT;uaV$xI]8va\"9\u0011\u0011\f\u0005A\u0002\u0005m\u0013aC8viB,Ho\u0012:pkB\u00042!YA/\u0013\r\t)fZ\u0001\u0016MJ|WnQ8na&d\u0017\r^5p]>+H\u000f];u)\u0011\t\u0019'!\u001b\u0011\t\u0005E\u0013QM\u0005\u0004\u0003OJ&AB(viB,H\u000fC\u0004\u0002l%\u0001\r!!\u001c\u0002\u0003\r\u00042!YA8\u0013\r\t\th\u001a\u0002\f\u0007>l\u0007/\u001b7bi&|g.A\bge>l7i\\7qS2\fG/[8o)\u0011\t9(a\u001f\u0011\u0007Y\u000bI(C\u0002\u0002r]Cq!! \u000b\u0001\u0004\ti'A\u0006d_6\u0004\u0018\u000e\\1uS>t\u0017\u0001\u00054s_6\u001cu.\u001c9jY\u0006$\u0018n\u001c8t)\u0011\t\u0019)!#\u0011\u0007\t\f))C\u0002\u0002\b\u001a\u0013AbQ8na&d\u0017\r^5p]NDq!a#\f\u0001\u0004\ti)A\u0007d_6\u0004\u0018\u000e\\1uS>t7\u000f\r\t\u0004C\u0006=\u0015bAADO\u0006aaM]8n!>\u001c\u0018\u000e^5p]R!\u0011QSAN!\u0011\t)\"a&\n\u0007\u0005e5L\u0001\u0005Q_NLG/[8o\u0011\u001d\ti\n\u0004a\u0001\u0003?\u000b\u0001\u0002]8tSRLwN\u001c\t\u0004C\u0006\u0005\u0016bAAMO\u0006aaM]8n'\u00164XM]5usR1\u0011qUAW\u0003k\u0003B!!\u0006\u0002*&\u0019\u00111V.\u0003\u0011M+g/\u001a:jifDq!a,\u000e\u0001\u0004\t\t,\u0001\u0005tKZ,'/\u001b;z!\r\t\u00171W\u0005\u0004\u0003W;\u0007bBA\\\u001b\u0001\u0007\u0011\u0011X\u0001\u0003S\u0012\u00042aTA^\u0013\r\ti\f\u0015\u0002\u0004\u0013:$\u0018A\u00034s_6\u001cFO]5oOR!\u00111YAe!\u0011y\u0015Q\u0019?\n\u0007\u0005\u001d\u0007K\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u0017t\u0001\u0019\u0001?\u0002\u000bY\fG.^3\u0002\u000f\u0019\u0014x.\\%oiR!\u0011\u0011[Ap!\u0015y\u0015QYAj!\u0011\t).a7\u000e\u0005\u0005]'bAAmm\u0006!A.\u00198h\u0013\u0011\ti.a6\u0003\u000f%sG/Z4fe\"9\u00111Z\bA\u0002\u0005e\u0016a\u00034s_6\u0004&o\u001c2mK6$B!!:\u0002lB!\u0011QCAt\u0013\r\tIo\u0017\u0002\b!J|'\r\\3n\u0011\u001d\ti\u000f\u0005a\u0001\u0003_\fq\u0001\u001d:pE2,W\u000eE\u0002b\u0003cL1!!;h\u000391'o\\7T_V\u00148-Z%oM>$B!a>\u0002~B\u0019a+!?\n\u0007\u0005mxK\u0001\u0006T_V\u00148-Z%oM>Dq!a@\u0012\u0001\u0004\u0011\t!\u0001\u0006t_V\u00148-Z%oM>\u00042!\u0019B\u0002\u0013\r\tYpZ\u0001\u0010MJ|WnU8ve\u000e,\u0017J\u001c4pgR!!\u0011\u0002B\b!\r\u0011'1B\u0005\u0004\u0005\u001b1%aC*pkJ\u001cW-\u00138g_NDqA!\u0005\u0013\u0001\u0004\u0011\u0019\"\u0001\u0007t_V\u00148-Z%oM>\u001c\b\u0007E\u0002b\u0005+I1A!\u0004h\u0003U1'o\\7DY\u0006\u001c8\u000f]1uQ\u001aKG.\u001a%bg\"$BAa\u0007\u0003\"A!\u0011\u0011\u000bB\u000f\u0013\r\u0011y\"\u0017\u0002\t\r&dW\rS1tQ\"9!1E\nA\u0002\t\u0015\u0012\u0001\u00034jY\u0016D\u0015m\u001d5\u0011\u0007\u0005\u00149#C\u0002\u0003 \u001d\fqB\u001a:p[6Kg.[(qi&|gn\u001d\u000b\u0005\u0005[\u0011\u0019\u0004\u0005\u0003\u0002R\t=\u0012b\u0001B\u00193\nYQ*\u001b8j\u001fB$\u0018n\u001c8t\u0011\u001d\u0011)\u0004\u0006a\u0001\u0005o\t1\"\\5oS>\u0003H/[8ogB\u0019\u0011M!\u000f\n\u0007\tEr-\u0001\tge>l7i\\7qS2,wJ\u001d3feR1!q\bB#\u0005\u001b\u0002B!!\u0015\u0003B%\u0019!1I-\u0003\u0019\r{W\u000e]5mK>\u0013H-\u001a:\t\u000f\t\u001dS\u00031\u0001\u0003J\u0005a1m\\7qS2,wJ\u001d3feB\u0019\u0011Ma\u0013\n\u0007\t\rs\rC\u0004\u00028V\u0001\r!!/\u0002\u001f\u0019\u0014x.\\*ue&tw\rV;qY\u0016$BAa\u0015\u0003ZA1\u0011Q\u0003B+yrL1Aa\u0016\\\u0005\t!&\u0007C\u0004\u0003\\Y\u0001\rA!\u0018\u0002\u000bQ,\b\u000f\\3\u0011\u0007\u0005\u0014y&C\u0002\u0003b\u001d\u0014Q\u0001V;qY\u0016\f1C\u001a:p[6Kg.[*fiV\u0004x*\u001e;qkR$B!a\u0019\u0003h!9!\u0011N\fA\u0002\t-\u0014!C7j]&\u001cV\r^;q!\r\t'QN\u0005\u0004\u0005_:'!C'j]&\u001cV\r^;q\u000351'o\\7NS:L7+\u001a;vaR!!Q\u000fB=!\u0011\t\tFa\u001e\n\u0007\t=\u0014\fC\u0004\u0003ja\u0001\rAa\u001b\u0003#\u00153g-[2jK:$HK]1wKJ\u001cX-\u0006\u0003\u0003\u0000\tM5CA\rO\u0003\r\u0019X-\u001d\t\u0007\u0005\u000b\u0013YIa$\u000e\u0005\t\u001d%b\u0001BEm\u0006!Q\u000f^5m\u0013\u0011\u0011iIa\"\u0003\t1K7\u000f\u001e\t\u0005\u0005#\u0013\u0019\n\u0004\u0001\u0005\u000f\tU\u0015D1\u0001\u0003\u0018\n\tA+\u0005\u0003\u0003\u001a\n}\u0005cA(\u0003\u001c&\u0019!Q\u0014)\u0003\u000f9{G\u000f[5oOB\u0019qJ!)\n\u0007\t\r\u0006KA\u0002B]f$BAa*\u0003,B)!\u0011V\r\u0003\u00106\t\u0001\u0001C\u0004\u0003\u0002n\u0001\rAa!\u0002\u0017Q|',\u001b8d\u0003J\u0014\u0018-_\u000b\u0005\u0005c\u0013i\f\u0006\u0003\u00034\nMG\u0003\u0002B[\u0005\u0007\u0004Ra\u0014B\\\u0005wK1A!/Q\u0005\u0015\t%O]1z!\u0011\u0011\tJ!0\u0005\u000f\t}FD1\u0001\u0003B\n\t!+E\u0002\u0003\u001a:C\u0011B!2\u001d\u0003\u0003\u0005\u001dAa2\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0003J\n='1X\u0007\u0003\u0005\u0017T1A!4Q\u0003\u001d\u0011XM\u001a7fGRLAA!5\u0003L\nA1\t\\1tgR\u000bw\rC\u0004\u0003Vr\u0001\rAa6\u0002\u0003\u0019\u0004ra\u0014Bm\u0005\u001f\u0013Y,C\u0002\u0003\\B\u0013\u0011BR;oGRLwN\\\u0019\u0002#\u00153g-[2jK:$HK]1wKJ\u001cX-\u0006\u0003\u0003b\n\u001dH\u0003\u0002Br\u0005S\u0004RA!+\u001a\u0005K\u0004BA!%\u0003h\u00129!QS\u000fC\u0002\t]\u0005b\u0002BA;\u0001\u0007!1\u001e\t\u0007\u0005\u000b\u0013YI!:\u0003\u0019=\u0003H/[8o%\u0016\fG-\u001a:\u0016\t\tE(\u0011`\n\u0003=9\u000baa\u001c9uS>t\u0007#B(\u0002F\n]\b\u0003\u0002BI\u0005s$qA!&\u001f\u0005\u0004\u00119\n\u0006\u0003\u0003~\n}\b#\u0002BU=\t]\bb\u0002BzA\u0001\u0007!Q_\u0001\u0005e\u0016\fG-\u0006\u0003\u0004\u0006\r%ACBB\u0004\u0007\u0017\u0019\t\u0002\u0005\u0003\u0003\u0012\u000e%Aa\u0002B`C\t\u0007!q\u0013\u0005\b\u0007\u001b\t\u0003\u0019AB\b\u0003\u00111'o\\7\u0011\u000f=\u0013INa>\u0004\b!A11C\u0011\u0005\u0002\u0004\u0019)\"\u0001\u0007feJ|'/T3tg\u0006<W\r\u0005\u0003P\u0007/a\u0018bAB\r!\nAAHY=oC6,g(\u0001\u0007PaRLwN\u001c*fC\u0012,'/\u0006\u0003\u0004 \r\u0015B\u0003BB\u0011\u0007O\u0001RA!+\u001f\u0007G\u0001BA!%\u0004&\u00119!Q\u0013\u0012C\u0002\t]\u0005b\u0002BzE\u0001\u00071\u0011\u0006\t\u0006\u001f\u0006\u001571E\u0001\tMJ|W\u000eU1uQR!1qFB\u001d!\u0011\u0019\tda\u000e\u000e\u0005\rM\"bAB\u001b7\u0006\u0019\u0011\r]5\n\u0007e\u001c\u0019\u0004\u0003\u0004|G\u0001\u000711\b\t\u0004C\u000eu\u0012BA=h\u000391'o\\7B]:|G/\u0019;j_:$Baa\u0011\u0004JA!1\u0011GB#\u0013\u0011\u00199ea\r\u0003\u0015\u0005sgn\u001c;bi&|g\u000eC\u0004\u0004L\u0011\u0002\ra!\u0014\u0002\u0015\u0005tgn\u001c;bi&|g\u000eE\u0002b\u0007\u001fJ1aa\u0012h\u000351'o\\7TiJ,8\r^;sKR!1QKB.!\u0011\u0019\tda\u0016\n\t\re31\u0007\u0002\n'R\u0014Xo\u0019;ve\u0016Dqa!\u0018&\u0001\u0004\u0019y&A\u0002ua\u0016\u0004Ba!\u0019\u0004h9\u0019\u0011ma\u0019\n\u0007\r\u0015t-\u0001\u0003UsB,\u0017\u0002BB-\u0007SR1a!\u001ah\u0003!1'o\\7UsB,G\u0003BB8\u0007k\u0002Ba!\r\u0004r%!11OB\u001a\u0005\u0011!\u0016\u0010]3\t\u000f\r]d\u00051\u0001\u0004z\u0005!A/\u001f9f!\r\t71P\u0005\u0004\u0007g:\u0017!\u00044s_6lu\u000eZ5gS\u0016\u00148\u000f\u0006\u0003\u0004\u0002\u000e\u001d\u0005\u0003BB\u0019\u0007\u0007KAa!\"\u00044\tIQj\u001c3jM&,'o\u001d\u0005\b\u0007\u0013;\u0003\u0019ABF\u0003%iw\u000eZ5gS\u0016\u00148\u000fE\u0002b\u0007\u001bK1a!\"h\u0003)1'o\\7BG\u000e,7o\u001d\u000b\u0005\u0007'\u001bI\n\u0005\u0003\u00042\rU\u0015\u0002BBL\u0007g\u0011a!Q2dKN\u001c\bbBBNQ\u0001\u00071QT\u0001\u0007C\u000e\u001cWm]:\u0011\u0007\u0005\u001cy*C\u0002\u0004\u0018\u001e\f!C\u001a:p[\u0012+g-\u001b8ji&|g\u000eV=qKR!1QUBV!\u0011\u0019\tda*\n\t\r%61\u0007\u0002\u000f\t\u00164\u0017N\\5uS>tG+\u001f9f\u0011\u001d\u0019i+\u000ba\u0001\u0007_\u000ba\u0002Z3gS:LG/[8o)f\u0004X\rE\u0002b\u0007cK1a!+h\u0003M1'o\\7DY\u0006\u001c8\u000fR3gS:LG/[8o)\u0011\u00199l!0\u0011\t\rE2\u0011X\u0005\u0005\u0007w\u001b\u0019DA\bDY\u0006\u001c8\u000fR3gS:LG/[8o\u0011\u001d\u0019yL\u000ba\u0001\u0007\u0003\fqb\u00197bgN$UMZ5oSRLwN\u001c\t\u0004C\u000e\r\u0017bAB^O\u0006\tbM]8n)f\u0004X\rU1sC6,G/\u001a:\u0015\t\r%7q\u001a\t\u0005\u0007c\u0019Y-\u0003\u0003\u0004N\u000eM\"!\u0004+za\u0016\u0004\u0016M]1nKR,'\u000fC\u0004\u0004R.\u0002\raa5\u0002\u001bQL\b/\u001a)be\u0006lW\r^3s!\r\t7Q[\u0005\u0004\u0007\u001b<\u0017!\u00044s_6\u001cE.Y:t\u0019&\\W\r\u0006\u0003\u0004\\\u000e\u0005\b\u0003BB\u0019\u0007;LAaa8\u00044\tI1\t\\1tg2K7.\u001a\u0005\b\u0007Gd\u0003\u0019ABs\u0003%\u0019G.Y:t\u0019&\\W\rE\u0002b\u0007OL1aa8h\u000311'o\\7Vg\u0016\u001c6m\u001c9f)\u0019\u0019ioa=\u0004|B!\u0011QCBx\u0013\r\u0019\tp\u0017\u0002\t+N,7kY8qK\"91Q_\u0017A\u0002\r]\u0018\u0001C;tKN\u001bw\u000e]3\u0011\u0007\u0005\u001cI0C\u0002\u0004r\u001eDq!a..\u0001\u0004\tI,A\tge>l\u0017I\\1msj,Gm\u00117bgN$b\u0001\"\u0001\u0005\u0012\u0011mA\u0003\u0002C\u0002\t\u0013\u0001Ba!\r\u0005\u0006%!AqAB\u001a\u00055\te.\u00197zu\u0016$7\t\\1tg\"9A1\u0002\u0018A\u0002\u00115\u0011!D1oC2L(0\u001a3DY\u0006\u001c8\u000fE\u0002b\t\u001fI1\u0001b\u0002h\u0011\u001d!\u0019B\fa\u0001\t+\tqb\u001d5pk2$7\u000b^8sK\u0006\u0003\u0018n\u001d\t\u0004\u001f\u0012]\u0011b\u0001C\r!\n9!i\\8mK\u0006t\u0007b\u0002C\u000f]\u0001\u0007AqD\u0001\fgR\u0014\u0018N\\4UC\ndW\rE\u0002\u0003*r\u00121b\u0015;sS:<G+\u00192mKN\u0011AH\u0014\u000b\u0003\t?\tqa\u001d;sS:<7/\u0006\u0002\u0005,A1!Q\u0011C\u0017yrLA\u0001b\f\u0003\b\n9\u0001*Y:i\u001b\u0006\u0004\u0018\u0001C:ue&twm\u001d\u0011\u0002\u001b1|wn[;q\u001fJ,e\u000e^3s)\raHq\u0007\u0005\u0007\ts\u0001\u0005\u0019\u0001?\u0002\rM$(/\u001b8h\u0003!\u0019HO]5oO&#WC\u0001C !\u0015y%\u0011\u001c?}\u0003%\u0019HO]5oO&#\u0007%\u0001\btiJLgn\u001a+p'>,(oY3\u0016\u0005\u0011\u001d\u0003CB(\u0003Zr\f\u0019\"A\btiJLgn\u001a+p'>,(oY3!\u0003=\u0019HO]5oOR{G*\u001b2sCJL\u0018\u0001E:ue&tw\rV8MS\n\u0014\u0018M]=!\u00031\u0019HO]5oOR{\u0007K]8e\u00035\u0019HO]5oOR{\u0007K]8eA\u0005iaM]8n%\u0016d\u0017\r^5p]N$B\u0001b\u0016\u0005^A\u0019!\r\"\u0017\n\u0007\u0011mcIA\u0005SK2\fG/[8og\"9AqL\u001cA\u0002\u0011\u0005\u0014!\u0003:fY\u0006$\u0018n\u001c8t!\r\tG1M\u0005\u0004\t7:\u0017\u0001\u00034s_6\f\u0005/[:\u0015\t\u0011%D\u0011\u0010\u000b\u0005\tW\"\t\bE\u0002c\t[J1\u0001b\u001cG\u0005\u0011\t\u0005+S:\t\u000f\u0011M\u0004\b1\u0001\u0005v\u0005!\u0011\r]5t!\r\tGqO\u0005\u0004\t_:\u0007b\u0002C\nq\u0001\u0007AQC\u0001\rMJ|W.\u00119jg\u001aKG.\u001a\u000b\u0007\t\u007f\")\tb$\u0011\r=#\t\tb\u001ba\u0013\r!\u0019\t\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0011\u001d\u0015\b1\u0001\u0005\n\u0006A\u0011\r]5t\r&dW\rE\u0002b\t\u0017K1\u0001\"$h\u0005!\t\u0005+S:GS2,\u0007b\u0002C\ns\u0001\u0007AQC\u0001\rMJ|W.\u00118bYf\u001c\u0018n\u001d\u000b\u0005\t+#Y\nE\u0002c\t/K1\u0001\"'G\u0005!\te.\u00197zg&\u001c\bB\u0002-;\u0001\u0004!i\nE\u0002b\t?K1\u0001\"'h\u0003A1'o\\7B]\u0006d\u0017p]5t\r&dW\r\u0006\u0003\u0005&\u0012-\u0006\u0003C(\u0005(\u0012U%Q\u000f1\n\u0007\u0011%\u0006K\u0001\u0004UkBdWm\r\u0005\b\t[[\u0004\u0019\u0001CX\u00031\tg.\u00197zg&\u001ch)\u001b7f!\r\tG\u0011W\u0005\u0004\tg;'\u0001D!oC2L8/[:GS2,\u0007")
public final class ProtobufReaders {
    private final ReadMapper mapper;
    private final Schema.Version currentVersion;
    private final Function1<String, String> stringId;
    private final Function1<String, VirtualFileRef> stringToSource;
    private final Function1<String, VirtualFileRef> stringToLibrary;
    private final Function1<String, VirtualFileRef> stringToProd;

    public java.nio.file.Path fromPathString(String path) {
        return Paths.get(path, new String[0]);
    }

    public VirtualFileRef fromPathStringV(String path) {
        return VirtualFileRef.of((String)path);
    }

    public Stamp fromStampType(Schema.Stamps.StampType stampType) {
        Schema.Stamps.StampType.TypeCase typeCase = stampType.getTypeCase();
        if (Schema.Stamps.StampType.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            return EmptyStamp$.MODULE$;
        }
        if (Schema.Stamps.StampType.TypeCase.FARMHASH.equals(typeCase)) {
            return FarmHash$.MODULE$.fromLong(stampType.getFarmHash().getHash());
        }
        if (Schema.Stamps.StampType.TypeCase.HASH.equals(typeCase)) {
            return Hash$.MODULE$.unsafeFromString(stampType.getHash().getHash());
        }
        if (Schema.Stamps.StampType.TypeCase.LASTMODIFIED.equals(typeCase)) {
            return new LastModified(stampType.getLastModified().getMillis());
        }
        throw new MatchError((Object)typeCase);
    }

    public Stamps fromStamps(Schema.Stamps stamps) {
        scala.collection.immutable.Map libraries = this.fromBinarySchemaMap$1(stamps.getBinaryStampsMap());
        scala.collection.immutable.Map sources = this.fromSourceSchemaMap$1(stamps.getSourceStampsMap());
        scala.collection.immutable.Map products = this.fromProductSchemaMap$1(stamps.getProductStampsMap());
        return Stamps$.MODULE$.apply(products, sources, libraries);
    }

    public OutputGroup fromOutputGroup(Schema.OutputGroup outputGroup) {
        java.nio.file.Path sourcePath = this.fromPathString(outputGroup.getSourcePath());
        java.nio.file.Path sourceDir = this.mapper.mapSourceDir(sourcePath);
        java.nio.file.Path targetPath = this.fromPathString(outputGroup.getTargetPath());
        java.nio.file.Path targetDir = this.mapper.mapOutputDir(targetPath);
        return CompileOutput$.MODULE$.outputGroup(sourceDir, targetDir);
    }

    public Output fromCompilationOutput(Schema.Compilation c) {
        Schema.Compilation.OutputCase outputCase = c.getOutputCase();
        if (Schema.Compilation.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            java.nio.file.Path target;
            Schema.SingleOutput single = c.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return CompileOutput$.MODULE$.empty();
            }
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
            return CompileOutput$.MODULE$.apply(outputDir);
        }
        if (Schema.Compilation.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = c.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            return CompileOutput$.MODULE$.apply(groups);
        }
        if (Schema.Compilation.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
        }
        throw new MatchError((Object)outputCase);
    }

    public xsbti.compile.analysis.Compilation fromCompilation(Schema.Compilation compilation) {
        Output output = this.fromCompilationOutput(compilation);
        return new Compilation(compilation.getStartTimeMillis(), output);
    }

    public Compilations fromCompilations(Schema.Compilations compilations0) {
        Iterator compilations = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(compilations0.getCompilationsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)compilation -> this.fromCompilation((Schema.Compilation)compilation));
        Seq castedCompilations = compilations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            xsbti.compile.analysis.Compilation compilation = x0$1;
            if (compilation instanceof Compilation) {
                Compilation compilation2 = (Compilation)compilation;
                return compilation2;
            }
            throw new MatchError((Object)compilation);
        }).toSeq();
        return Compilations$.MODULE$.of(castedCompilations);
    }

    public Position fromPosition(Schema.Position position) {
        return InterfaceUtil$.MODULE$.position(this.fromInt(position.getLine()), position.getLineContent(), this.fromInt(position.getOffset()), this.fromInt(position.getPointer()), this.fromString(position.getPointerSpace()), this.fromString(position.getSourcePath()), this.fromString(position.getSourceFilepath()).map((Function1 & Serializable & scala.Serializable)path -> this.fromPathString((String)path)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toFile()), this.fromInt(position.getStartOffset()), this.fromInt(position.getEndOffset()), this.fromInt(position.getStartLine()), this.fromInt(position.getStartColumn()), this.fromInt(position.getEndLine()), this.fromInt(position.getEndColumn()));
    }

    public Severity fromSeverity(Schema.Severity severity, int id) {
        Schema.Severity severity2 = severity;
        if (Schema.Severity.INFO.equals(severity2)) {
            return Severity.Info;
        }
        if (Schema.Severity.WARN.equals(severity2)) {
            return Severity.Warn;
        }
        if (Schema.Severity.ERROR.equals(severity2)) {
            return Severity.Error;
        }
        if (Schema.Severity.UNRECOGNIZED.equals(severity2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedSeverity(id)).$bang$bang();
        }
        throw new MatchError((Object)severity2);
    }

    private Option<String> fromString(String value) {
        String string = value;
        String string2 = ProtobufDefaults$.MODULE$.MissingString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)value);
    }

    private Option<Integer> fromInt(int value) {
        if (value == ProtobufDefaults$.MODULE$.MissingInt()) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef$.MODULE$.int2Integer(value));
    }

    public Problem fromProblem(Schema.Problem problem) {
        String category = problem.getCategory();
        String message = problem.getMessage();
        Severity severity = this.fromSeverity(problem.getSeverity(), problem.getSeverityValue());
        if (!problem.hasPosition()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPositionInProblem()).$bang$bang();
        }
        Position position = this.fromPosition(problem.getPosition());
        Option<String> rendered = this.fromString(problem.getRendered());
        return InterfaceUtil$.MODULE$.problem(category, position, message, severity, rendered);
    }

    public SourceInfo fromSourceInfo(Schema.SourceInfo sourceInfo) {
        Seq mainClasses = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)sourceInfo.getMainClassesList()).asScala()).toSeq();
        Seq reportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getReportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        Seq unreportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getUnreportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        return SourceInfos$.MODULE$.makeInfo(reportedProblems, unreportedProblems, mainClasses);
    }

    public SourceInfos fromSourceInfos(Schema.SourceInfos sourceInfos0) {
        Iterator sourceInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sourceInfos0.getSourceInfosMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.SourceInfo value = (Schema.SourceInfo)tuple2._2();
                VirtualFileRef file = $this.mapper.mapSourceFile(this.fromPathStringV(path));
                SourceInfo sourceInfo = this.fromSourceInfo(value);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)sourceInfo);
            }
            throw new MatchError((Object)tuple2);
        });
        return SourceInfos$.MODULE$.of(sourceInfos.toMap(Predef$.MODULE$.$conforms()));
    }

    public FileHash fromClasspathFileHash(Schema.FileHash fileHash) {
        int hash = fileHash.getHash();
        java.nio.file.Path classpathEntry = this.fromPathString(fileHash.getPath());
        java.nio.file.Path newClasspathEntry = this.mapper.mapClasspathEntry(classpathEntry);
        return FileHash.of((java.nio.file.Path)newClasspathEntry, (int)hash);
    }

    public MiniOptions fromMiniOptions(Schema.MiniOptions miniOptions) {
        FileHash[] classpathHash = (FileHash[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniOptions.getClasspathHashList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)fileHash -> this.fromClasspathFileHash((Schema.FileHash)fileHash)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
        String[] javacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getJavacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)javacOption -> $this.mapper.mapJavacOption((String)javacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] scalacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getScalacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)scalacOption -> $this.mapper.mapScalacOption((String)scalacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        return MiniOptions.of((FileHash[])classpathHash, (String[])scalacOptions, (String[])javacOptions);
    }

    public CompileOrder fromCompileOrder(Schema.CompileOrder compileOrder, int id) {
        Schema.CompileOrder compileOrder2 = compileOrder;
        if (Schema.CompileOrder.MIXED.equals(compileOrder2)) {
            return CompileOrder.Mixed;
        }
        if (Schema.CompileOrder.JAVATHENSCALA.equals(compileOrder2)) {
            return CompileOrder.JavaThenScala;
        }
        if (Schema.CompileOrder.SCALATHENJAVA.equals(compileOrder2)) {
            return CompileOrder.ScalaThenJava;
        }
        if (Schema.CompileOrder.UNRECOGNIZED.equals(compileOrder2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedOrder(id)).$bang$bang();
        }
        throw new MatchError((Object)compileOrder2);
    }

    public T2<String, String> fromStringTuple(Schema.Tuple tuple) {
        return InterfaceUtil$.MODULE$.t2(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tuple.getFirst()), (Object)tuple.getSecond()));
    }

    public Output fromMiniSetupOutput(Schema.MiniSetup miniSetup) {
        Schema.MiniSetup.OutputCase outputCase = miniSetup.getOutputCase();
        if (Schema.MiniSetup.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            java.nio.file.Path target;
            Schema.SingleOutput single = miniSetup.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return CompileOutput$.MODULE$.empty();
            }
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
            return CompileOutput$.MODULE$.apply(outputDir);
        }
        if (Schema.MiniSetup.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = miniSetup.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            return CompileOutput$.MODULE$.apply(groups);
        }
        if (Schema.MiniSetup.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
        }
        throw new MatchError((Object)outputCase);
    }

    public MiniSetup fromMiniSetup(Schema.MiniSetup miniSetup) {
        Output output = this.fromMiniSetupOutput(miniSetup);
        if (!miniSetup.hasMiniOptions()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedMiniOptionsInSetup()).$bang$bang();
        }
        MiniOptions miniOptions = this.fromMiniOptions(miniSetup.getMiniOptions());
        String compilerVersion = miniSetup.getCompilerVersion();
        CompileOrder compileOrder = this.fromCompileOrder(miniSetup.getCompileOrder(), miniSetup.getCompileOrderValue());
        boolean storeApis = miniSetup.getStoreApis();
        T2[] extra = (T2[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniSetup.getExtraList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)tuple -> this.fromStringTuple((Schema.Tuple)tuple)).toArray(ClassTag$.MODULE$.apply(T2.class));
        MiniSetup original = MiniSetup.of((Output)output, (MiniOptions)miniOptions, (String)compilerVersion, (CompileOrder)compileOrder, (boolean)storeApis, (T2[])extra);
        return this.mapper.mapMiniSetup(original);
    }

    public <T> EfficientTraverse<T> EfficientTraverse(List<T> seq) {
        return new EfficientTraverse<T>(this, seq);
    }

    public <T> OptionReader<T> OptionReader(Option<T> option) {
        return new OptionReader<T>(this, option);
    }

    public Path fromPath(Schema.Path path) {
        PathComponent[] components = (PathComponent[])this.EfficientTraverse(path.getComponentsList()).toZincArray((Function1 & Serializable & scala.Serializable)pathComponent -> this.fromPathComponent$1((Schema.Path.PathComponent)pathComponent), ClassTag$.MODULE$.apply(PathComponent.class));
        return Path.of((PathComponent[])components);
    }

    public Annotation fromAnnotation(Schema.Annotation annotation) {
        AnnotationArgument[] arguments = (AnnotationArgument[])this.EfficientTraverse(annotation.getArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)argument -> ProtobufReaders.fromAnnotationArgument$1(argument), ClassTag$.MODULE$.apply(AnnotationArgument.class));
        None$ b = annotation.hasBase() ? new Some((Object)annotation.getBase()) : None$.MODULE$;
        Type base = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Annotation.class));
        return Annotation.of((Type)base, (AnnotationArgument[])arguments);
    }

    public Structure fromStructure(Schema.Type.Structure tpe) {
        Lazy parents = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getParentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class)));
        Lazy declared = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getDeclaredList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        Lazy inherited = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getInheritedList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        return Structure.of((Lazy)parents, (Lazy)declared, (Lazy)inherited);
    }

    public Type fromType(Schema.Type type) {
        Schema.Type.ValueCase valueCase = type.getValueCase();
        if (Schema.Type.ValueCase.PARAMETERREF.equals(valueCase)) {
            return ProtobufReaders.fromParameterRef$1(type.getParameterRef());
        }
        if (Schema.Type.ValueCase.PARAMETERIZED.equals(valueCase)) {
            return this.fromParameterized$1(type.getParameterized());
        }
        if (Schema.Type.ValueCase.STRUCTURE.equals(valueCase)) {
            return this.fromStructure(type.getStructure());
        }
        if (Schema.Type.ValueCase.POLYMORPHIC.equals(valueCase)) {
            return this.fromPolymorphic$1(type.getPolymorphic());
        }
        if (Schema.Type.ValueCase.CONSTANT.equals(valueCase)) {
            return this.fromConstant$1(type.getConstant());
        }
        if (Schema.Type.ValueCase.EXISTENTIAL.equals(valueCase)) {
            return this.fromExistential$1(type.getExistential());
        }
        if (Schema.Type.ValueCase.SINGLETON.equals(valueCase)) {
            return this.fromSingleton$1(type.getSingleton());
        }
        if (Schema.Type.ValueCase.PROJECTION.equals(valueCase)) {
            return this.fromProjection$1(type.getProjection());
        }
        if (Schema.Type.ValueCase.ANNOTATED.equals(valueCase)) {
            return this.fromAnnotated$1(type.getAnnotated());
        }
        if (Schema.Type.ValueCase.EMPTYTYPE.equals(valueCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.EmptyType();
        }
        if (Schema.Type.ValueCase.VALUE_NOT_SET.equals(valueCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyType()).$bang$bang();
        }
        throw new MatchError((Object)valueCase);
    }

    public Modifiers fromModifiers(Schema.Modifiers modifiers) {
        return InternalApiProxy$Modifiers$.MODULE$.apply(modifiers.getFlags());
    }

    public Access fromAccess(Schema.Access access) {
        Schema.Access.TypeCase typeCase = access.getTypeCase();
        if (Schema.Access.TypeCase.PUBLIC.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.Public();
        }
        if (Schema.Access.TypeCase.PROTECTED.equals(typeCase)) {
            Schema.Protected a = access.getProtected();
            return Protected.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        }
        if (Schema.Access.TypeCase.PRIVATE.equals(typeCase)) {
            Schema.Private a = access.getPrivate();
            return Private.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        }
        if (Schema.Access.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedValidAccessType()).$bang$bang();
        }
        throw new MatchError((Object)typeCase);
    }

    public DefinitionType fromDefinitionType(Schema.DefinitionType definitionType) {
        Schema.DefinitionType definitionType2 = definitionType;
        if (Schema.DefinitionType.CLASSDEF.equals(definitionType2)) {
            return DefinitionType.ClassDef;
        }
        if (Schema.DefinitionType.MODULE.equals(definitionType2)) {
            return DefinitionType.Module;
        }
        if (Schema.DefinitionType.TRAIT.equals(definitionType2)) {
            return DefinitionType.Trait;
        }
        if (Schema.DefinitionType.PACKAGEMODULE.equals(definitionType2)) {
            return DefinitionType.PackageModule;
        }
        if (Schema.DefinitionType.UNRECOGNIZED.equals(definitionType2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedDefinitionType()).$bang$bang();
        }
        throw new MatchError((Object)definitionType2);
    }

    public ClassDefinition fromClassDefinition(Schema.ClassDefinition classDefinition) {
        String name = classDefinition.getName().intern();
        if (!classDefinition.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingAccessInDef()).$bang$bang();
        }
        Access access = this.fromAccess(classDefinition.getAccess());
        if (!classDefinition.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingModifiersInDef()).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classDefinition.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classDefinition.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        Schema.ClassDefinition.ExtraCase extraCase = classDefinition.getExtraCase();
        if (Schema.ClassDefinition.ExtraCase.CLASSLIKEDEF.equals(extraCase)) {
            return this.fromClassLikeDef$1(classDefinition.getClassLikeDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.DEFDEF.equals(extraCase)) {
            return this.fromDefDef$1(classDefinition.getDefDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.VALDEF.equals(extraCase)) {
            return this.fromValDef$1(classDefinition.getValDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.VARDEF.equals(extraCase)) {
            return this.fromVarDef$1(classDefinition.getVarDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.TYPEALIAS.equals(extraCase)) {
            return this.fromTypeAlias$1(classDefinition.getTypeAlias(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.TYPEDECLARATION.equals(extraCase)) {
            return this.fromTypeDeclaration$1(classDefinition.getTypeDeclaration(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.EXTRA_NOT_SET.equals(extraCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyDefType()).$bang$bang();
        }
        throw new MatchError((Object)extraCase);
    }

    public TypeParameter fromTypeParameter(Schema.TypeParameter typeParameter2) {
        String id = typeParameter2.getId();
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(typeParameter2.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeParameter2.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        Variance variance = ProtobufReaders.fromVariance$1(typeParameter2.getVariance());
        if (!typeParameter2.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeParameter()).$bang$bang();
        }
        Type lowerBound = this.fromType(typeParameter2.getLowerBound());
        if (!typeParameter2.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeParameter()).$bang$bang();
        }
        Type upperBound = this.fromType(typeParameter2.getUpperBound());
        return TypeParameter.of((String)id, (Annotation[])annotations, (TypeParameter[])typeParameters, (Variance)variance, (Type)lowerBound, (Type)upperBound);
    }

    public ClassLike fromClassLike(Schema.ClassLike classLike) {
        String name = classLike.getName().intern();
        if (!classLike.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Access.class)).$bang$bang();
        }
        Access access = this.fromAccess(classLike.getAccess());
        if (!classLike.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Modifiers.class)).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classLike.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classLike.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        DefinitionType definitionType = this.fromDefinitionType(classLike.getDefinitionType());
        if (!classLike.hasSelfType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expectedMsg$1("self type")).$bang$bang();
        }
        Lazy selfType = SafeLazyProxy$.MODULE$.strict((Object)this.fromType(classLike.getSelfType()));
        if (!classLike.hasStructure()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Type.Structure.class)).$bang$bang();
        }
        Lazy structure = SafeLazyProxy$.MODULE$.strict((Object)this.fromStructure(classLike.getStructure()));
        String[] savedAnnotations = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)classLike.getSavedAnnotationsList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        Type[] childrenOfSealedClass = (Type[])this.EfficientTraverse(classLike.getChildrenOfSealedClassList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        boolean topLevel = classLike.getTopLevel();
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(classLike.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLike.of((String)name, (Access)access, (Modifiers)modifiers, (Annotation[])annotations, (DefinitionType)definitionType, (Lazy)selfType, (Lazy)structure, (String[])savedAnnotations, (Type[])childrenOfSealedClass, (boolean)topLevel, (TypeParameter[])typeParameters);
    }

    public UseScope fromUseScope(Schema.UseScope useScope, int id) {
        Schema.UseScope useScope2 = useScope;
        if (Schema.UseScope.DEFAULT.equals(useScope2)) {
            return UseScope.Default;
        }
        if (Schema.UseScope.IMPLICIT.equals(useScope2)) {
            return UseScope.Implicit;
        }
        if (Schema.UseScope.PATMAT.equals(useScope2)) {
            return UseScope.PatMatTarget;
        }
        if (Schema.UseScope.UNRECOGNIZED.equals(useScope2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedUseScope(id)).$bang$bang();
        }
        throw new MatchError((Object)useScope2);
    }

    public AnalyzedClass fromAnalyzedClass(boolean shouldStoreApis, StringTable stringTable, Schema.AnalyzedClass analyzedClass) {
        ProtobufDefaults$EmptyLazyCompanions$ protobufDefaults$EmptyLazyCompanions$;
        long compilationTs = analyzedClass.getCompilationTimestamp();
        String name = analyzedClass.getName().intern();
        if (!shouldStoreApis) {
            protobufDefaults$EmptyLazyCompanions$ = ProtobufDefaults$EmptyLazyCompanions$.MODULE$;
        } else {
            if (!analyzedClass.hasApi()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedCompanionsInAnalyzedClass()).$bang$bang();
            }
            protobufDefaults$EmptyLazyCompanions$ = SafeLazyProxy$.MODULE$.strict((Object)this.fromCompanions$1(analyzedClass.getApi()));
        }
        ProtobufDefaults$EmptyLazyCompanions$ api = protobufDefaults$EmptyLazyCompanions$;
        int apiHash = analyzedClass.getApiHash();
        Schema.Version version = this.currentVersion;
        Schema.Version version2 = Schema.Version.V1;
        int extraHash = !(version != null ? !version.equals(version2) : version2 != null) ? 0 : analyzedClass.getExtraHash();
        NameHash[] nameHashes = (NameHash[])this.EfficientTraverse(analyzedClass.getNameHashesList()).toZincArray((Function1 & Serializable & scala.Serializable)nameHash -> this.fromNameHash$1((Schema.NameHash)nameHash, stringTable), ClassTag$.MODULE$.apply(NameHash.class));
        boolean hasMacro = analyzedClass.getHasMacro();
        String provenance = analyzedClass.getProvenance().intern();
        return AnalyzedClass.of((long)compilationTs, (String)name, (Lazy)api, (int)apiHash, (NameHash[])nameHashes, (boolean)hasMacro, (int)extraHash, (String)provenance);
    }

    private final Function1<String, String> stringId() {
        return this.stringId;
    }

    private final Function1<String, VirtualFileRef> stringToSource() {
        return this.stringToSource;
    }

    private final Function1<String, VirtualFileRef> stringToLibrary() {
        return this.stringToLibrary;
    }

    private final Function1<String, VirtualFileRef> stringToProd() {
        return this.stringToProd;
    }

    public Relations fromRelations(Schema.Relations relations) {
        Relation srcProd = ProtobufReaders.fromMap$1(relations.getSrcProdMap(), this.stringToSource(), this.stringToProd());
        Relation libraryDep = ProtobufReaders.fromMap$1(relations.getLibraryDepMap(), this.stringToSource(), this.stringToLibrary());
        Relation libraryClassName = ProtobufReaders.fromMap$1(relations.getLibraryClassNameMap(), this.stringToLibrary(), this.stringId());
        if (!relations.hasMemberRef()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("member refs")).$bang$bang();
        }
        Relations.ClassDependencies memberRef = this.fromClassDependencies$1(relations.getMemberRef());
        if (!relations.hasInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("inheritance")).$bang$bang();
        }
        Relations.ClassDependencies inheritance = this.fromClassDependencies$1(relations.getInheritance());
        if (!relations.hasLocalInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("local inheritance")).$bang$bang();
        }
        Relations.ClassDependencies localInheritance = this.fromClassDependencies$1(relations.getLocalInheritance());
        Relation classes = ProtobufReaders.fromMap$1(relations.getClassesMap(), this.stringToSource(), this.stringId());
        Relation productClassName = ProtobufReaders.fromMap$1(relations.getProductClassNameMap(), this.stringId(), this.stringId());
        UsedNames.JavaUsedNames names = UsedNames$.MODULE$.fromJavaMap(relations.getNamesMap());
        InternalDependencies internal = new InternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.internal())})));
        ExternalDependencies external = new ExternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.external())})));
        return Relations$.MODULE$.make(srcProd, libraryDep, libraryClassName, internal, external, classes, (UsedNames)names, productClassName);
    }

    public APIs fromApis(boolean shouldStoreApis, Schema.APIs apis) {
        StringTable stringTable = new StringTable();
        scala.collection.immutable.Map internal = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getInternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map external = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getExternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
        return APIs$.MODULE$.apply(internal, external);
    }

    public Tuple2<APIs, Schema.Version> fromApisFile(Schema.APIsFile apisFile, boolean shouldStoreApis) {
        if (!apisFile.hasApis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedApisInApisFile()).$bang$bang();
        }
        APIs apis = this.fromApis(shouldStoreApis, apisFile.getApis());
        Schema.Version version = apisFile.getVersion();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apis), (Object)version);
    }

    public Analysis fromAnalysis(Schema.Analysis analysis) {
        if (!analysis.hasStamps()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Stamps.class)).$bang$bang();
        }
        Stamps stamps = this.fromStamps(analysis.getStamps());
        if (!analysis.hasRelations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Relations.class)).$bang$bang();
        }
        Relations relations = this.fromRelations(analysis.getRelations());
        if (!analysis.hasSourceInfos()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.SourceInfos.class)).$bang$bang();
        }
        SourceInfos sourceInfos = this.fromSourceInfos(analysis.getSourceInfos());
        if (!analysis.hasCompilations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Compilations.class)).$bang$bang();
        }
        Compilations compilations = this.fromCompilations(analysis.getCompilations());
        Stamps x$1 = stamps;
        Relations x$2 = relations;
        SourceInfos x$3 = sourceInfos;
        Compilations x$4 = compilations;
        APIs x$5 = Analysis$.MODULE$.Empty().copy$default$2();
        return Analysis$.MODULE$.Empty().copy(x$1, x$5, x$2, x$3, x$4);
    }

    public Tuple3<Analysis, MiniSetup, Schema.Version> fromAnalysisFile(Schema.AnalysisFile analysisFile) {
        Schema.Version version = analysisFile.getVersion();
        if (!analysisFile.hasAnalysis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(49).append("The analysis file from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        Analysis analysis = this.fromAnalysis(analysisFile.getAnalysis());
        if (!analysisFile.hasMiniSetup()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(46).append("The mini setup from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        MiniSetup miniSetup = this.fromMiniSetup(analysisFile.getMiniSetup());
        return new Tuple3((Object)analysis, (Object)miniSetup, (Object)version);
    }

    private final scala.collection.immutable.Map fromBinarySchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapBinaryFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapBinaryStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromSourceSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapSourceFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapSourceStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromProductSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapProductFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapProductStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final PathComponent fromPathComponent$1(Schema.Path.PathComponent pathComponent) {
        Schema.Path.PathComponent.ComponentCase componentCase = pathComponent.getComponentCase();
        if (Schema.Path.PathComponent.ComponentCase.ID.equals(componentCase)) {
            Schema.Id c = pathComponent.getId();
            return Id.of((String)c.getId());
        }
        if (Schema.Path.PathComponent.ComponentCase.SUPER.equals(componentCase)) {
            Schema.Super c = pathComponent.getSuper();
            if (!c.hasQualifier()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSuper()).$bang$bang();
            }
            Path q = this.fromPath(c.getQualifier());
            return Super.of((Path)q);
        }
        if (Schema.Path.PathComponent.ComponentCase.THIS.equals(componentCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.This();
        }
        if (Schema.Path.PathComponent.ComponentCase.COMPONENT_NOT_SET.equals(componentCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expected(Schema.Path.PathComponent.ComponentCase.class, Schema.Path.PathComponent.class)).$bang$bang();
        }
        throw new MatchError((Object)componentCase);
    }

    private static final AnnotationArgument fromAnnotationArgument$1(Schema.AnnotationArgument argument) {
        String name = argument.getName().intern();
        String value = argument.getValue();
        return AnnotationArgument.of((String)name, (String)value);
    }

    private static final Lazy lazy$1(Object value) {
        return SafeLazyProxy$.MODULE$.strict(value);
    }

    private static final ParameterRef fromParameterRef$1(Schema.Type.ParameterRef tpe) {
        return ParameterRef.of((String)tpe.getId());
    }

    private final Parameterized fromParameterized$1(Schema.Type.Parameterized tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Parameterized.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Type[] typeArguments = (Type[])this.EfficientTraverse(tpe.getTypeArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        return Parameterized.of((Type)baseType, (Type[])typeArguments);
    }

    private final Polymorphic fromPolymorphic$1(Schema.Type.Polymorphic tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Polymorphic.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(tpe.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Polymorphic.of((Type)baseType, (TypeParameter[])typeParameters);
    }

    private final Constant fromConstant$1(Schema.Type.Constant tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Constant.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        String value = tpe.getValue();
        return Constant.of((Type)baseType, (String)value);
    }

    private final Existential fromExistential$1(Schema.Type.Existential tpe) {
        None$ b = tpe.hasBaseType() ? new Some((Object)tpe.getBaseType()) : None$.MODULE$;
        Type baseType = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Existential.class));
        TypeParameter[] clause = (TypeParameter[])this.EfficientTraverse(tpe.getClauseList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Existential.of((Type)baseType, (TypeParameter[])clause);
    }

    private final Singleton fromSingleton$1(Schema.Type.Singleton tpe) {
        if (!tpe.hasPath()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSingleton()).$bang$bang();
        }
        Path path = this.fromPath(tpe.getPath());
        return Singleton.of((Path)path);
    }

    private final Projection fromProjection$1(Schema.Type.Projection tpe) {
        String id = tpe.getId();
        if (!tpe.hasPrefix()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPrefixInProjection()).$bang$bang();
        }
        Type prefix = this.fromType(tpe.getPrefix());
        return Projection.of((Type)prefix, (String)id);
    }

    private final Annotated fromAnnotated$1(Schema.Type.Annotated tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Annotated.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(tpe.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        return Annotated.of((Type)baseType, (Annotation[])annotations);
    }

    private static final Qualifier fromQualifier$1(Schema.Qualifier qualifier) {
        Schema.Qualifier.TypeCase typeCase = qualifier.getTypeCase();
        if (Schema.Qualifier.TypeCase.IDQUALIFIER.equals(typeCase)) {
            Schema.IdQualifier q = qualifier.getIdQualifier();
            return IdQualifier.of((String)q.getValue());
        }
        if (Schema.Qualifier.TypeCase.THISQUALIFIER.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.ThisQualifier();
        }
        if (Schema.Qualifier.TypeCase.UNQUALIFIED.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.Unqualified();
        }
        if (Schema.Qualifier.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyQualifier()).$bang$bang();
        }
        throw new MatchError((Object)typeCase);
    }

    private final Qualifier readQualifier$1(Option qualifier2) {
        return (Qualifier)this.OptionReader(qualifier2).read((Function1 & Serializable & scala.Serializable)qualifier -> ProtobufReaders.fromQualifier$1(qualifier), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedQualifierInAccess());
    }

    private static final ParameterModifier fromParameterModifier$1(Schema.ParameterModifier modifier) {
        Schema.ParameterModifier parameterModifier = modifier;
        if (Schema.ParameterModifier.PLAIN.equals(parameterModifier)) {
            return ParameterModifier.Plain;
        }
        if (Schema.ParameterModifier.BYNAME.equals(parameterModifier)) {
            return ParameterModifier.ByName;
        }
        if (Schema.ParameterModifier.REPEATED.equals(parameterModifier)) {
            return ParameterModifier.Repeated;
        }
        if (Schema.ParameterModifier.UNRECOGNIZED.equals(parameterModifier)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedParamModifier()).$bang$bang();
        }
        throw new MatchError((Object)parameterModifier);
    }

    private final MethodParameter fromMethodParameter$1(Schema.MethodParameter methodParameter) {
        String name = methodParameter.getName().intern();
        boolean hasDefault = methodParameter.getHasDefault();
        if (!methodParameter.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.MethodParameter.class)).$bang$bang();
        }
        Type type = this.fromType(methodParameter.getType());
        ParameterModifier modifier = ProtobufReaders.fromParameterModifier$1(methodParameter.getModifier());
        return MethodParameter.of((String)name, (Type)type, (boolean)hasDefault, (ParameterModifier)modifier);
    }

    private final ParameterList fromParameterList$1(Schema.ParameterList parameterList) {
        boolean isImplicit = parameterList.getIsImplicit();
        MethodParameter[] parameters = (MethodParameter[])this.EfficientTraverse(parameterList.getParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)methodParameter -> this.fromMethodParameter$1((Schema.MethodParameter)methodParameter), ClassTag$.MODULE$.apply(MethodParameter.class));
        return ParameterList.of((MethodParameter[])parameters, (boolean)isImplicit);
    }

    private final ClassLikeDef fromClassLikeDef$1(Schema.ClassDefinition.ClassLikeDef defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        DefinitionType definitionType = this.fromDefinitionType(defDef.getDefinitionType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLikeDef.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (DefinitionType)definitionType);
    }

    private final Def fromDefDef$1(Schema.ClassDefinition.Def defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!defDef.hasReturnType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedReturnTypeInDef()).$bang$bang();
        }
        Type returnType = this.fromType(defDef.getReturnType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        ParameterList[] valueParameters = (ParameterList[])this.EfficientTraverse(defDef.getValueParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)parameterList -> this.fromParameterList$1((Schema.ParameterList)parameterList), ClassTag$.MODULE$.apply(ParameterList.class));
        return Def.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (ParameterList[])valueParameters, (Type)returnType);
    }

    private final Val fromValDef$1(Schema.ClassDefinition.Val valDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!valDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Val.class)).$bang$bang();
        }
        Type tpe = this.fromType(valDef.getType());
        return Val.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final Var fromVarDef$1(Schema.ClassDefinition.Var varDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!varDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Var.class)).$bang$bang();
        }
        Type tpe = this.fromType(varDef.getType());
        return Var.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final TypeAlias fromTypeAlias$1(Schema.ClassDefinition.TypeAlias typeAlias, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!typeAlias.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.TypeAlias.class)).$bang$bang();
        }
        Type tpe = this.fromType(typeAlias.getType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeAlias.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeAlias.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (Type)tpe);
    }

    private final TypeDeclaration fromTypeDeclaration$1(Schema.ClassDefinition.TypeDeclaration decl, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!decl.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeDeclaration()).$bang$bang();
        }
        Type lowerBound = this.fromType(decl.getLowerBound());
        if (!decl.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeDeclaration()).$bang$bang();
        }
        Type upperBound = this.fromType(decl.getUpperBound());
        TypeParameter[] typeParams = (TypeParameter[])this.EfficientTraverse(decl.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeDeclaration.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParams, (Type)lowerBound, (Type)upperBound);
    }

    private static final Variance fromVariance$1(Schema.Variance variance) {
        Schema.Variance variance2 = variance;
        if (Schema.Variance.INVARIANT.equals(variance2)) {
            return Variance.Invariant;
        }
        if (Schema.Variance.COVARIANT.equals(variance2)) {
            return Variance.Covariant;
        }
        if (Schema.Variance.CONTRAVARIANT.equals(variance2)) {
            return Variance.Contravariant;
        }
        if (Schema.Variance.UNRECOGNIZED.equals(variance2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedVariance()).$bang$bang();
        }
        throw new MatchError((Object)variance2);
    }

    private static final String expectedMsg$1(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.ClassLike.class);
    }

    private static final String expected$1(Class clazz) {
        return ProtobufReaders.expectedMsg$1(clazz.getName());
    }

    private static final String expected$2(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Companions.class);
    }

    private final Companions fromCompanions$1(Schema.Companions companions) {
        if (!companions.hasClassApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("class api")).$bang$bang();
        }
        ClassLike classApi = this.fromClassLike(companions.getClassApi());
        if (!companions.hasObjectApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("object api")).$bang$bang();
        }
        ClassLike objectApi = this.fromClassLike(companions.getObjectApi());
        return Companions.of((ClassLike)classApi, (ClassLike)objectApi);
    }

    private final NameHash fromNameHash$1(Schema.NameHash nameHash, StringTable stringTable$1) {
        String name = stringTable$1.lookupOrEnter(nameHash.getName());
        int hash = nameHash.getHash();
        UseScope scope = this.fromUseScope(nameHash.getScope(), nameHash.getScopeValue());
        return NameHash.of((String)name, (UseScope)scope, (int)hash);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$2(Function1 fk$1, RelationBuilder builder$1, Function1 fv$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String kString = (String)tuple2._1();
            Schema.Values vs = (Schema.Values)tuple2._2();
            if (!vs.getValuesList().isEmpty()) {
                Object k = fk$1.apply((Object)kString);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)vs.getValuesList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)vString -> {
                    builder$1.update(k, fv$1.apply((Object)vString));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Relation fromMap$1(Map map, Function1 fk, Function1 fv) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ProtobufReaders.$anonfun$fromRelations$2(fk, builder, fv, x$3);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private final Relations.ClassDependencies fromClassDependencies$1(Schema.ClassDependencies classDependencies) {
        Relation internal = ProtobufReaders.fromMap$1(classDependencies.getInternalMap(), this.stringId(), this.stringId());
        Relation external = ProtobufReaders.fromMap$1(classDependencies.getExternalMap(), this.stringId(), this.stringId());
        return new Relations.ClassDependencies(internal, external);
    }

    private static final String expected$3(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Relations.class);
    }

    private static final String expected$4(Class clazz) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(clazz, Schema.Analysis.class);
    }

    public ProtobufReaders(ReadMapper mapper, Schema.Version currentVersion) {
        this.mapper = mapper;
        this.currentVersion = currentVersion;
        this.stringId = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
        this.stringToSource = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapSourceFile(this.fromPathStringV((String)path));
        this.stringToLibrary = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapBinaryFile(this.fromPathStringV((String)path));
        this.stringToProd = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapProductFile(this.fromPathStringV((String)path));
    }

    public class EfficientTraverse<T> {
        private final List<T> seq;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R[] toZincArray(Function1<T, R> f, ClassTag<R> evidence$1) {
            return this.seq.stream().map(x -> f.apply(x)).toArray(x$2 -> (Object[])evidence$1.newArray(x$2));
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$EfficientTraverse$$$outer() {
            return this.$outer;
        }

        public EfficientTraverse(ProtobufReaders $outer, List<T> seq) {
            this.seq = seq;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class OptionReader<T> {
        private final Option<T> option;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R read(Function1<T, R> from, Function0<String> errorMessage) {
            return (R)this.option.fold((Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$.MODULE$.StringToException((String)errorMessage.apply()).$bang$bang(), from);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$OptionReader$$$outer() {
            return this.$outer;
        }

        public OptionReader(ProtobufReaders $outer, Option<T> option) {
            this.option = option;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class StringTable {
        private final HashMap<String, String> strings;

        private HashMap<String, String> strings() {
            return this.strings;
        }

        public String lookupOrEnter(String string) {
            String string2 = this.strings().putIfAbsent(string, string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$StringTable$$$outer() {
            return ProtobufReaders.this;
        }

        public StringTable() {
            if (ProtobufReaders.this == null) {
                throw null;
            }
            this.strings = new HashMap();
        }
    }
}

