/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.inc.APIs;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.CompanionsStore;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.binary.BinaryAnalysisFormat;
import sbt.internal.inc.text.TextAnalysisFormat;
import sbt.internal.shaded.com.google.protobuf.CodedInputStream;
import sbt.internal.shaded.com.google.protobuf.CodedOutputStream;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.api.Companions;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dw!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%iA\u0010\u0005\u0007\u0005\u0006\u0001\u000bQB \t\u000f\r\u000b!\u0019!C\u0007\t\"1\u0001+\u0001Q\u0001\u000e\u0015Cq!U\u0001C\u0002\u00135A\t\u0003\u0004S\u0003\u0001\u0006i!\u0012\u0005\u0006'\u0006!\t\u0001\u0016\u0005\u0006'\u0006!\ta\u001a\u0005\u0006c\u0006!\tA\u001d\u0005\u0006c\u0006!\t!\u001e\u0005\u0006c\u0006!\t\u0001\u001f\u0004\u0007\u0003\u0007\ta!!\u0002\t\u0011Qt!\u0011!Q\u0001\n}C\u0011\"a\u0005\u000f\u0005\u0003\u0005\u000b\u0011B6\t\rmrA\u0011AA\u000b\u0011!YhB1A\u0005\u000e\u0005}\u0001\u0002CA\u0016\u001d\u0001\u0006i!!\t\t\u0013\u00055bB1A\u0005\u000e\u0005=\u0002\u0002CA\u001c\u001d\u0001\u0006i!!\r\t\u000f\u0005eb\u0002\"\u0011\u0002<!9\u0011q\n\b\u0005B\u0005E\u0003bBA*\u001d\u0011\u0005\u0013Q\u000b\u0004\u0007\u0003C\na!a\u0019\t\u0011QL\"\u0011!Q\u0001\n}C\u0001b_\r\u0003\u0002\u0003\u0006I\u0001 \u0005\u0007we!\t!!\u001a\t\u0013\u00055\u0014D1A\u0005\u0002\u0005=\u0004\u0002CAT3\u0001\u0006I!!\u001d\t\u000f\u0005M\u0013\u0004\"\u0001\u0002*\"9\u0011\u0011H\r\u0005\u0002\u0005m\u0002bBA(3\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003_\u000bA\u0011BAY\r\u0019\t\u0019(\u0001\u0004\u0002v!AAo\tB\u0001B\u0003%q\f\u0003\u0005|G\t\u0005\t\u0015!\u0003}\u0011\u0019Y4\u0005\"\u0001\u0002~!9\u0011\u0011H\u0012\u0005\u0002\u0005\r\u0005bBARG\u0011\u0005\u0011QU\u0001\u0012\r&dW-\u00118bYf\u001c\u0018n]*u_J,'BA\u0016-\u0003\rIgn\u0019\u0006\u0003[9\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002_\u0005\u00191O\u0019;\u0004\u0001A\u0011!'A\u0007\u0002U\t\tb)\u001b7f\u0003:\fG._:jgN#xN]3\u0014\u0005\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002c\u0005a!)\u001b8FqR,gn]5p]V\tqhD\u0001AC\u0005\t\u0015a\u00012j]\u0006i!)\u001b8FqR,gn]5p]\u0002\n\u0001#\u00198bYf\u001c\u0018n\u001d$jY\u0016t\u0015-\\3\u0016\u0003\u0015\u0003\"AR'\u000f\u0005\u001d[\u0005C\u0001%8\u001b\u0005I%B\u0001&1\u0003\u0019a$o\\8u}%\u0011AjN\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002Mo\u0005\t\u0012M\\1msNL7OR5mK:\u000bW.\u001a\u0011\u0002%\r|W\u000e]1oS>t7OR5mK:\u000bW.Z\u0001\u0014G>l\u0007/\u00198j_:\u001ch)\u001b7f\u001d\u0006lW\rI\u0001\u0007E&t\u0017M]=\u0015\u0005Uk\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011AW\u0001\u0006qN\u0014G/[\u0005\u00039^\u0013Q\"\u00118bYf\u001c\u0018n]*u_J,\u0007\"\u00020\n\u0001\u0004y\u0016\u0001D1oC2L8/[:GS2,\u0007C\u00011f\u001b\u0005\t'B\u00012d\u0003\tIwNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019\f'\u0001\u0002$jY\u0016$2!\u00165j\u0011\u0015q&\u00021\u0001`\u0011\u0015Q'\u00021\u0001l\u0003\u001di\u0017\r\u001d9feN\u0004\"\u0001\\8\u000e\u00035T!A\\,\u0002\u0011\u0005t\u0017\r\\=tSNL!\u0001]7\u0003!I+\u0017\rZ,sSR,W*\u00199qKJ\u001c\u0018\u0001\u0002;fqR$\"!V:\t\u000bQ\\\u0001\u0019A0\u0002\t\u0019LG.\u001a\u000b\u0004+Z<\b\"\u0002;\r\u0001\u0004y\u0006\"\u00026\r\u0001\u0004YGcA+zu\")A/\u0004a\u0001?\")10\u0004a\u0001y\u00061am\u001c:nCR\u0004\"!`@\u000e\u0003yT!!\u001d\u0016\n\u0007\u0005\u0005aP\u0001\nUKb$\u0018I\\1msNL7OR8s[\u0006$(a\u0004\"j]\u0006\u0014\u0018PR5mKN#xN]3\u0014\t9\t9!\u0016\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB2\u0002\t1\fgnZ\u0005\u0005\u0003#\tYA\u0001\u0004PE*,7\r^\u0001\u0011e\u0016\fGm\u0016:ji\u0016l\u0015\r\u001d9feN$b!a\u0006\u0002\u001c\u0005u\u0001cAA\r\u001d5\t\u0011\u0001C\u0003u#\u0001\u0007q\f\u0003\u0004\u0002\u0014E\u0001\ra[\u000b\u0003\u0003C\u0001B!a\t\u0002(5\u0011\u0011Q\u0005\u0006\u0003'*JA!!\u000b\u0002&\t!\")\u001b8bef\fe.\u00197zg&\u001chi\u001c:nCR\fqAZ8s[\u0006$\b%A\u0005U[B,e\u000eZ5oOV\u0011\u0011\u0011G\b\u0003\u0003g\t#!!\u000e\u0002\t9\"X\u000e]\u0001\u000b)6\u0004XI\u001c3j]\u001e\u0004\u0013aA4fiR\u0011\u0011Q\b\t\u0007\u0003\u007f\t)%!\u0013\u000e\u0005\u0005\u0005#bAA\"G\u0006!Q\u000f^5m\u0013\u0011\t9%!\u0011\u0003\u0011=\u0003H/[8oC2\u00042AVA&\u0013\r\tie\u0016\u0002\u0011\u0003:\fG._:jg\u000e{g\u000e^3oiN\f\u0011\"\u001e8tC\u001a,w)\u001a;\u0015\u0005\u0005%\u0013aA:fiR!\u0011qKA/!\r1\u0014\u0011L\u0005\u0004\u00037:$\u0001B+oSRDq!a\u0018\u0019\u0001\u0004\tI%\u0001\u0005d_:$XM\u001c;t\u0005I1\u0015\u000e\\3CCN,Gm\u0015;pe\u0016LU\u000e\u001d7\u0014\te\t9!\u0016\u000b\u0007\u0003O\nI'a\u001b\u0011\u0007\u0005e\u0011\u0004C\u0003u9\u0001\u0007q\fC\u0003|9\u0001\u0007A0A\bd_6\u0004\u0018M\\5p]N\u001cFo\u001c:f+\t\t\t\bE\u0002\u0002\u001a\r\u00121DR5mK\n\u000b7/\u001a3D_6\u0004\u0018M\\5p]Nl\u0015\r]*u_J,7\u0003B\u00126\u0003o\u00022AMA=\u0013\r\tYH\u000b\u0002\u0010\u0007>l\u0007/\u00198j_:\u001c8\u000b^8sKR1\u0011\u0011OA@\u0003\u0003CQ\u0001\u001e\u0014A\u0002}CQa\u001f\u0014A\u0002q$\"!!\"\u0011\u000bY\n9)a#\n\u0007\u0005%uG\u0001\u0004PaRLwN\u001c\t\bm\u00055\u0015\u0011SAI\u0013\r\tyi\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0019\u000b\u0019*RAL\u0013\r\t)j\u0014\u0002\u0004\u001b\u0006\u0004\b\u0003BAM\u0003?k!!a'\u000b\u0007\u0005u\u0015,A\u0002ba&LA!!)\u0002\u001c\nQ1i\\7qC:LwN\\:\u0002\u0017\u001d,G/\u00168dCV<\u0007\u000e\u001e\u000b\u0003\u0003\u0017\u000b\u0001cY8na\u0006t\u0017n\u001c8t'R|'/\u001a\u0011\u0015\t\u0005]\u00131\u0016\u0005\b\u0003[{\u0002\u0019AA%\u0003A\tg.\u00197zg&\u001c8i\u001c8uK:$8/A\u0006m_>\\W\u000f]#oiJLHCBA,\u0003g\u000b\u0019\rC\u0004\u00026\n\u0002\r!a.\u0002\u0005%t\u0007\u0003BA]\u0003\u007fk!!a/\u000b\t\u0005u\u0016\u0011I\u0001\u0004u&\u0004\u0018\u0002BAa\u0003w\u0013aBW5q\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002F\n\u0002\r!R\u0001\u0005]\u0006lW\r")
public final class FileAnalysisStore {
    public static AnalysisStore text(File file, TextAnalysisFormat textAnalysisFormat) {
        return FileAnalysisStore$.MODULE$.text(file, textAnalysisFormat);
    }

    public static AnalysisStore text(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.text(file, readWriteMappers);
    }

    public static AnalysisStore text(File file) {
        return FileAnalysisStore$.MODULE$.text(file);
    }

    public static AnalysisStore binary(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.binary(file, readWriteMappers);
    }

    public static AnalysisStore binary(File file) {
        return FileAnalysisStore$.MODULE$.binary(file);
    }

    public static final class BinaryFileStore
    implements AnalysisStore {
        private final File file;
        private final BinaryAnalysisFormat format;

        private final BinaryAnalysisFormat format() {
            return this.format;
        }

        private final String TmpEnding() {
            return ".tmp";
        }

        public Optional<AnalysisContents> get() {
            Option nestedRead = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> (Option)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream($this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                CodedInputStream reader = CodedInputStream.newInstance((InputStream)inputStream);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = this.format().read(reader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis2 = (CompileAnalysis)tuple2._1();
                MiniSetup miniSetup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis2, (Object)miniSetup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis3 = (CompileAnalysis)tuple23._1();
                MiniSetup miniSetup2 = (MiniSetup)tuple23._2();
                Option analysisWithAPIs = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                    FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                    return this.format().readAPIs(reader, analysis3, miniSetup2.storeApis());
                });
                return analysisWithAPIs.map((Function1 & Serializable)analysis -> AnalysisContents.create((CompileAnalysis)analysis, (MiniSetup)miniSetup2));
            }));
            return JavaInterfaceUtil$.MODULE$.EnrichOption(nestedRead.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return this.get().get();
        }

        public void set(AnalysisContents contents) {
            CompileAnalysis analysis = contents.getAnalysis();
            MiniSetup setup = contents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            FileOutputStream outputStream2 = new FileOutputStream(tmpAnalysisFile);
            Using$.MODULE$.zipOutputStream().apply((Object)outputStream2, (Function1 & Serializable)outputStream -> {
                BinaryFileStore.$anonfun$set$1(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public static final /* synthetic */ void $anonfun$set$1(BinaryFileStore $this, CompileAnalysis analysis$2, MiniSetup setup$1, ZipOutputStream outputStream) {
            CodedOutputStream protobufWriter = CodedOutputStream.newInstance((OutputStream)outputStream);
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
            $this.format().write(protobufWriter, analysis$2, setup$1);
            outputStream.closeEntry();
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
            $this.format().writeAPIs(protobufWriter, analysis$2, setup$1.storeApis());
            outputStream.closeEntry();
        }

        public BinaryFileStore(File file, ReadWriteMappers readWriteMappers) {
            this.file = file;
            this.format = new BinaryAnalysisFormat(readWriteMappers);
        }
    }

    public static final class FileBasedCompanionsMapStore
    implements CompanionsStore {
        private final File file;
        private final TextAnalysisFormat format;

        public Option<Tuple2<Map<String, Companions>, Map<String, Companions>>> get() {
            return Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.getUncaught());
        }

        public Tuple2<Map<String, Companions>, Map<String, Companions>> getUncaught() {
            return (Tuple2)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                return $this.format.readCompanionMap(reader);
            });
        }

        public FileBasedCompanionsMapStore(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
        }
    }

    public static final class FileBasedStoreImpl
    implements AnalysisStore {
        private final File file;
        private final TextAnalysisFormat format;
        private final FileBasedCompanionsMapStore companionsStore;

        public FileBasedCompanionsMapStore companionsStore() {
            return this.companionsStore;
        }

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            Using$.MODULE$.zipOutputStream().apply((Object)new FileOutputStream(tmpAnalysisFile), (Function1 & Serializable)outputStream -> {
                FileBasedStoreImpl.$anonfun$set$2(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.unsafeGet())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return (AnalysisContents)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                BufferedReader writer = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read(writer, this.companionsStore());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis2 = (CompileAnalysis)tuple23._1();
                MiniSetup setup2 = (MiniSetup)tuple23._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public static final /* synthetic */ void $anonfun$set$2(FileBasedStoreImpl $this, CompileAnalysis analysis$3, MiniSetup setup$2, ZipOutputStream outputStream) {
            block1: {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, IO$.MODULE$.utf8()));
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
                $this.format.write(writer, analysis$3, setup$2);
                outputStream.closeEntry();
                if (!setup$2.storeApis()) break block1;
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
                CompileAnalysis compileAnalysis = analysis$3;
                if (!(compileAnalysis instanceof Analysis)) {
                    throw new MatchError((Object)compileAnalysis);
                }
                Analysis analysis = (Analysis)compileAnalysis;
                APIs aPIs = analysis.apis();
                $this.format.writeCompanionMap(writer, aPIs);
                outputStream.closeEntry();
            }
        }

        public FileBasedStoreImpl(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
            this.companionsStore = new FileBasedCompanionsMapStore(file, format);
        }
    }
}

