/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]b!B\u0007\u000f\u000191\u0002\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011A\u000f\t\u0011\u0005\u0002!\u0011!Q\u0001\nyA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)q\b\u0001C\u0001\u0001\")!\n\u0001C\u0001\u0017\")!\r\u0001C\u0005G\")!\u000e\u0001C\u0005W\"I\u0011\u0011\u0001\u0001\u0012\u0002\u0013%\u00111\u0001\u0005\n\u0003+\u0001\u0011\u0013!C\u0005\u0003/Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u00024\u0001!I!!\u000e\u0003\u0011I+GO]=TKRT!a\u0004\t\u0002\u000b\r\u001c7\u000f^7\u000b\u0005E\u0011\u0012aA:u[*\u00111\u0003F\u0001\u000bG>t7-\u001e:sK:$(\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u0005!\u0012B\u0001\u000e\u0015\u0005\u0019\te.\u001f*fM\u0006!1/\u001b>f\u0007\u0001)\u0012A\b\t\u00031}I!\u0001\t\u000b\u0003\u0007%sG/A\u0003tSj,\u0007%A\u0004iC:$G.Z:\u0011\u0007a!c%\u0003\u0002&)\t)\u0011I\u001d:bsB\u0012q%\f\t\u0004Q%ZS\"\u0001\b\n\u0005)r!A\u0002%b]\u0012dW\r\u0005\u0002-[1\u0001A!\u0003\u0018\u0004\u0003\u0003\u0005\tQ!\u00010\u0005\ryF%M\t\u0003aM\u0002\"\u0001G\u0019\n\u0005I\"\"a\u0002(pi\"Lgn\u001a\t\u00031QJ!!\u000e\u000b\u0003\u0007\u0005s\u00170\u0001\u0005wKJ\u001c\u0018n\u001c8t!\rAB\u0005\u000f\t\u0003sqr!\u0001\u000b\u001e\n\u0005mr\u0011!B\"D'Rk\u0015BA\u001f?\u0005\u001d1VM]:j_:T!a\u000f\b\u0002\rqJg.\u001b;?)\u0011\t%iQ%\u0011\u0005!\u0002\u0001\"B\u000e\u0006\u0001\u0004q\u0002\"\u0002\u0012\u0006\u0001\u0004!\u0005c\u0001\r%\u000bB\u0012a\t\u0013\t\u0004Q%:\u0005C\u0001\u0017I\t%q3)!A\u0001\u0002\u000b\u0005q\u0006C\u00037\u000b\u0001\u0007q'\u0001\u0006bo\u0006LGOU3uef$\"\u0001T(\u0011\u0005ai\u0015B\u0001(\u0015\u0005\u0011auN\\4\t\u000bA3\u0001\u0019\u0001'\u0002\u0019QLW.Z8vi:\u000bgn\\:)\u0007\u0019\u0011\u0016\rE\u0002\u0019'VK!\u0001\u0016\u000b\u0003\rQD'o\\<t!\t1fL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!\fH\u0001\u0007yI|w\u000e\u001e \n\u0003UI!!\u0018\u000b\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\u0015\u0013:$XM\u001d:vaR,G-\u0012=dKB$\u0018n\u001c8\u000b\u0005u#2%A+\u0002\u0019\u0005$H/Z7qi\u0006;\u0018-\u001b;\u0015\u0005\u0011<\u0007C\u0001\rf\u0013\t1GCA\u0004C_>dW-\u00198\t\u000b!<\u0001\u0019\u0001'\u0002\u00199\fgn\u001c#fC\u0012d\u0017N\\3)\u0007\u001d\u0011\u0016-\u0001\u000bcY>\u001c7.\u001b8h\u0003R$X-\u001c9u\u0003^\f\u0017\u000e\u001e\u000b\u0005I2lg\u000fC\u0003i\u0011\u0001\u0007A\nC\u0004o\u0011A\u0005\t\u0019A8\u0002\u000b\u00154XM\u001c;\u0011\u0005A\u001chB\u0001\u0015r\u0013\t\u0011h\"A\u0007XC.,W\u000f]'b]\u0006<WM]\u0005\u0003iV\u0014Q!\u0012<f]RT!A\u001d\b\t\u000f]D\u0001\u0013!a\u0001=\u0005\t\u0011\u000e\u000b\u0002\tsB\u0011!0`\u0007\u0002w*\u0011A\u0010F\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001@|\u0005\u001d!\u0018-\u001b7sK\u000eD3\u0001\u0003*b\u0003y\u0011Gn\\2lS:<\u0017\t\u001e;f[B$\u0018i^1ji\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0006)\u001aq.a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=10A\u0005v]\u000eDWmY6fI&!\u00111CA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001fE2|7m[5oO\u0006#H/Z7qi\u0006;\u0018-\u001b;%I\u00164\u0017-\u001e7uIM*\"!!\u0007+\u0007y\t9!\u0001\tbI\u0012\u0004VM\u001c3j]\u001e<\u0016m[3vaR)A-a\b\u0002.!9\u0011\u0011E\u0006A\u0002\u0005\r\u0012A\u00025b]\u0012dW\r\r\u0003\u0002&\u0005%\u0002\u0003\u0002\u0015*\u0003O\u00012\u0001LA\u0015\t-\tY#a\b\u0002\u0002\u0003\u0005)\u0011A\u0018\u0003\u0007}##\u0007\u0003\u0004\u00020-\u0001\r\u0001O\u0001\u0004m\u0016\u0014\bFA\u0006z\u0003\u001d\u0019\u0007.\u00198hK\u0012,\u0012\u0001\u001a")
public class RetrySet {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        long actualElapsed;
        long deadline;
        long begin;
        block1: {
            if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
                throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
            }
            begin = System.nanoTime();
            long d = begin + timeoutNanos;
            deadline = d < 0L ? Long.MAX_VALUE : d;
            this.attemptAwait(deadline);
            actualElapsed = System.nanoTime() - begin;
            if (Stats$.MODULE$.top() == null) break block1;
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        boolean bl;
        while (true) {
            if (i < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) {
                    bl = false;
                    break;
                }
                if (!this.changed()) {
                    i = this.blockingAttemptAwait$default$3();
                    event = this.blockingAttemptAwait$default$2();
                    continue;
                }
                bl = true;
                break;
            }
            Handle<?> h = this.handles[i];
            if (!event.addSource(h)) {
                if (!this.changed()) {
                    i = this.blockingAttemptAwait$default$3();
                    event = this.blockingAttemptAwait$default$2();
                    continue;
                }
                bl = true;
                break;
            }
            if (!this.addPendingWakeup(h, this.versions[i])) {
                bl = true;
                break;
            }
            --i;
        }
        return bl;
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        boolean bl;
        while (true) {
            long m;
            if (CCSTM$.MODULE$.changing(m = handle.meta()) || CCSTM$.MODULE$.version(m) != ver) {
                bl = false;
                break;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }
}

