/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ma!\u0002\r\u001a\u0001m\t\u0003\"B\u0014\u0001\t\u0003I\u0003bB\u001c\u0001\u0005\u0004%i\u0001\u000f\u0005\u0007w\u0001\u0001\u000bQB\u001d\t\u000fq\u0002!\u0019!C\u0007{!1\u0001\t\u0001Q\u0001\u000eyBq!\u0011\u0001A\u0002\u0013%!\tC\u0004G\u0001\u0001\u0007I\u0011B$\t\r5\u0003\u0001\u0015)\u0003D\u0011\u001dq\u0005\u00011A\u0005\n=CqA\u0016\u0001A\u0002\u0013%q\u000b\u0003\u0004Z\u0001\u0001\u0006K\u0001\u0015\u0005\u00065\u0002!\ta\u0017\u0005\u0006?\u0002!\tA\u0011\u0005\u0006A\u0002!\t!\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006S\u0002!\tA\u001b\u0005\u0006[\u0002!I\u0001\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006e\u0002!I\u0001 \u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\u0011AbQ1mY\n\f7m\u001b'jgRT!AG\u000e\u0002\tM\\W\r\u001c\u0006\u00039u\t1a\u001d;n\u0015\tqr$\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u000b\u0003E9\u001a\"\u0001A\u0012\u0011\u0005\u0011*S\"A\u0010\n\u0005\u0019z\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0003cA\u0016\u0001Y5\t\u0011\u0004\u0005\u0002.]1\u0001A!B\u0018\u0001\u0005\u0004\u0001$!A!\u0012\u0005E\"\u0004C\u0001\u00133\u0013\t\u0019tDA\u0004O_RD\u0017N\\4\u0011\u0005\u0011*\u0014B\u0001\u001c \u0005\r\te._\u0001\u0010\u0013:LG/[1m\u0007\u0006\u0004\u0018mY5usV\t\u0011hD\u0001;;\t\u0001\u00011\u0001\tJ]&$\u0018.\u00197DCB\f7-\u001b;zA\u0005\u0001R*\u0019=F[B$\u0018pQ1qC\u000eLG/_\u000b\u0002}=\tq(\b\u0002!\u0001\u0005\tR*\u0019=F[B$\u0018pQ1qC\u000eLG/\u001f\u0011\u0002\u000b}\u001b\u0018N_3\u0016\u0003\r\u0003\"\u0001\n#\n\u0005\u0015{\"aA%oi\u0006Iql]5{K~#S-\u001d\u000b\u0003\u0011.\u0003\"\u0001J%\n\u0005){\"\u0001B+oSRDq\u0001T\u0004\u0002\u0002\u0003\u00071)A\u0002yIE\naaX:ju\u0016\u0004\u0013!B0eCR\fW#\u0001)\u0011\u0007\u0011\n6+\u0003\u0002S?\t)\u0011I\u001d:bsB!A\u0005\u0016\u0017I\u0013\t)vDA\u0005Gk:\u001cG/[8oc\u0005Iq\fZ1uC~#S-\u001d\u000b\u0003\u0011bCq\u0001\u0014\u0006\u0002\u0002\u0003\u0007\u0001+\u0001\u0004`I\u0006$\u0018\rI\u0001\bSN,U\u000e\u001d;z+\u0005a\u0006C\u0001\u0013^\u0013\tqvDA\u0004C_>dW-\u00198\u0002\tML'0Z\u0001\tg&TXm\u0018\u0013fcR\u0011\u0001J\u0019\u0005\u0006G:\u0001\raQ\u0001\b]\u0016<8+\u001b>f\u0003)\u0019\u0007.\u00198hKNK'0\u001a\u000b\u0003\u0011\u001aDQaY\bA\u0002\r\u000bQA]3tKR$\u0012\u0001S\u0001\tIAdWo\u001d\u0013fcR\u0011\u0001j\u001b\u0005\u0006YF\u0001\raU\u0001\bQ\u0006tG\r\\3s\u0003\u00119'o\\<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005M\u0003\b\"B9\u0014\u0001\u0004\u0019\u0015!A5\u0002\t\u0019L'/\u001a\u000b\u0004\u0011RT\b\"B;\u0015\u0001\u00041\u0018!\u00027fm\u0016d\u0007CA<y\u001b\u0005Y\u0012BA=\u001c\u00051qUm\u001d;j]\u001edUM^3m\u0011\u0015YH\u00031\u0001-\u0003\r\t'o\u001a\u000b\u0005\u0011vtx\u0010C\u0003v+\u0001\u0007a\u000fC\u0003|+\u0001\u0007A\u0006C\u0003r+\u0001\u00071\tK\u0002\u0016\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013y\u0012AC1o]>$\u0018\r^5p]&!\u0011QBA\u0004\u0005\u001d!\u0018-\u001b7sK\u000e\f!b\u001d5pk2$g)\u001b:f)\ra\u00161\u0003\u0005\u0006kZ\u0001\rA^\u0001\tiJ,hnY1uKR\u0019\u0001+!\u0007\t\u000b\r<\u0002\u0019A\"")
public class CallbackList<A> {
    private int _size = 0;
    private Function1<A, BoxedUnit>[] _data = new Function1[128];

    private final int InitialCapacity() {
        return 128;
    }

    private final int MaxEmptyCapacity() {
        return 8192;
    }

    private int _size() {
        return this._size;
    }

    private void _size_$eq(int x$1) {
        this._size = x$1;
    }

    private Function1<A, BoxedUnit>[] _data() {
        return this._data;
    }

    private void _data_$eq(Function1<A, BoxedUnit>[] x$1) {
        this._data = x$1;
    }

    public boolean isEmpty() {
        return this._size() == 0;
    }

    public int size() {
        return this._size();
    }

    public void size_$eq(int newSize) {
        block0: {
            if (newSize == this._size()) break block0;
            this.changeSize(newSize);
        }
    }

    private void changeSize(int newSize) {
        if (newSize < 0 || newSize > this._size()) {
            throw new IllegalArgumentException();
        }
        if (newSize == 0 && this._data().length > 8192) {
            this.reset();
        } else {
            Arrays.fill(this._data(), newSize, this._size(), null);
            this._size_$eq(newSize);
        }
    }

    private void reset() {
        this._data_$eq(new Function1[128]);
        this._size_$eq(0);
    }

    public void $plus$eq(Function1<A, BoxedUnit> handler) {
        if (this._size() == this._data().length) {
            this.grow();
        }
        this._data()[this._size()] = handler;
        this._size_$eq(this._size() + 1);
    }

    private void grow() {
        Function1[] a = new Function1[this._data().length * 2];
        System.arraycopy(this._data(), 0, a, 0, this._data().length);
        this._data_$eq(a);
    }

    public Function1<A, BoxedUnit> apply(int i) {
        return this._data()[i];
    }

    public void fire(NestingLevel level, A arg) {
        block0: {
            if (this._size() <= 0) break block0;
            this.fire(level, arg, 0);
        }
    }

    private void fire(NestingLevel level, A arg, int i) {
        while (i < this._size() && this.shouldFire(level)) {
            Object object;
            try {
                object = this._data()[i].apply(arg);
            }
            catch (Throwable x) {
                Txn.Status s = level.requestRollback(new Txn.UncaughtExceptionCause(x));
                Predef$.MODULE$.assert(s instanceof Txn.RolledBack);
                object = BoxedUnit.UNIT;
            }
            ++i;
        }
    }

    private boolean shouldFire(NestingLevel level) {
        return !(level.status() instanceof Txn.RolledBack);
    }

    /*
     * WARNING - void declaration
     */
    public Function1<A, BoxedUnit>[] truncate(int newSize) {
        Function1<A, BoxedUnit>[] function1Array;
        if (this._size() == newSize) {
            function1Array = null;
        } else {
            void var2_2;
            Function1[] z = new Function1[this._size() - newSize];
            System.arraycopy(this._data(), newSize, z, 0, z.length);
            this.size_$eq(newSize);
            function1Array = var2_2;
        }
        return function1Array;
    }
}

