/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.scalafmt.dynamic.BuildInfo$;
import org.scalafmt.dynamic.ConsoleScalafmtReporter$;
import org.scalafmt.dynamic.ScalafmtDynamic$;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader$;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtReflect;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.exceptions.ReflectionException$;
import org.scalafmt.dynamic.exceptions.ScalafmtConfigException;
import org.scalafmt.dynamic.utils.ReentrantCache;
import org.scalafmt.dynamic.utils.ReentrantCache$;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rMc\u0001B A\u0005\u001eC\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t!\u001b\u0005\t[\u0002\u0011\t\u0012)A\u0005U\"Aa\u000e\u0001BK\u0002\u0013\u0005q\u000e\u0003\u0005z\u0001\tE\t\u0015!\u0003q\u0011!Q\bA!f\u0001\n\u0003Y\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u0013\u0005\u0005\u0001A!f\u0001\n\u0003Y\b\"CA\u0002\u0001\tE\t\u0015!\u0003}\u0011)\t)\u0001\u0001BK\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u00033\u0001!\u0011#Q\u0001\n\u0005%\u0001BCA\u000e\u0001\tU\r\u0011\"\u0001\u0002\u001e!Q\u00111\u001e\u0001\u0003\u0012\u0003\u0006I!a\b\t\u0013\u0005\u0005\u0006A!f\u0001\n\u0003Y\b\"CAw\u0001\tE\t\u0015!\u0003}\u0011)\t)\u000b\u0001BK\u0002\u0013\u0005\u0011q\u001e\u0005\u000b\u0003k\u0004!\u0011#Q\u0001\n\u0005E\bbBA*\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0003'\u0002A\u0011\u0001B\u0005\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqA!\u0006\u0001\t\u0003\u00129\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!q\u0005\u0001\u0005B\t%\u0002b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!\u0011\u000e\u0001\u0005\n\t-\u0004b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003.\u0002!IAa,\t\u000f\tU\u0006\u0001\"\u0011\u00038\"I!\u0011\u0019\u0001\u0002\u0002\u0013\u0005!1\u0019\u0005\n\u0005+\u0004\u0011\u0013!C\u0001\u0005/D\u0011B!<\u0001#\u0003%\tAa<\t\u0013\tM\b!%A\u0005\u0002\tU\b\"\u0003B}\u0001E\u0005I\u0011\u0001B{\u0011%\u0011Y\u0010AI\u0001\n\u0003\u0011i\u0010C\u0005\u0004\u0002\u0001\t\n\u0011\"\u0001\u0004\u0004!I1q\u0001\u0001\u0012\u0002\u0013\u0005!Q\u001f\u0005\n\u0007\u0013\u0001\u0011\u0013!C\u0001\u0007\u0017A\u0011ba\u0004\u0001\u0003\u0003%\te!\u0005\t\u0013\r]\u0001!!A\u0005\u0002\re\u0001\"CB\u0011\u0001\u0005\u0005I\u0011AB\u0012\u0011%\u0019I\u0003AA\u0001\n\u0003\u001aY\u0003C\u0005\u0004:\u0001\t\t\u0011\"\u0001\u0004<!I1q\b\u0001\u0002\u0002\u0013\u00053\u0011\t\u0005\n\u0007\u000b\u0002\u0011\u0011!C!\u0007\u000fB\u0011b!\u0013\u0001\u0003\u0003%\tea\u0013\t\u0013\r5\u0003!!A\u0005B\r=saBA\u001e\u0001\"\u0005\u0011Q\b\u0004\u0007\u007f\u0001C\t!!\u0011\t\u000f\u0005M\u0003\b\"\u0001\u0002V\u00151\u0011q\u000b\u001d\u0001\u00033*a!!\u001a9\t\u0005\u001d\u0004\"CAAq\u0005\u0005I\u0011QAB\u0011%\t\u0019\u000eOA\u0001\n\u0003\u000b)\u000eC\u0005\u0002hb\n\t\u0011\"\u0003\u0002j\ny1kY1mC\u001alG\u000fR=oC6L7M\u0003\u0002B\u0005\u00069A-\u001f8b[&\u001c'BA\"E\u0003!\u00198-\u00197bM6$(\"A#\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001A\u0005K\u0016/\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001\u00027b]\u001eT\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n1qJ\u00196fGR\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\u0015%tG/\u001a:gC\u000e,7/\u0003\u0002V%\nA1kY1mC\u001alG\u000f\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006LA\u0004Qe>$Wo\u0019;\u0011\u0005u+gB\u00010d\u001d\ty&-D\u0001a\u0015\t\tg)\u0001\u0004=e>|GOP\u0005\u00023&\u0011A\rW\u0001\ba\u0006\u001c7.Y4f\u0013\t1wM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002e1\u0006A!/\u001a9peR,'/F\u0001k!\t\t6.\u0003\u0002m%\n\u00012kY1mC\u001alGOU3q_J$XM]\u0001\ne\u0016\u0004xN\u001d;fe\u0002\nAB]3q_NLGo\u001c:jKN,\u0012\u0001\u001d\t\u0004;F\u001c\u0018B\u0001:h\u0005\u0011a\u0015n\u001d;\u0011\u0005Q<X\"A;\u000b\u0003Y\f1bY8veNLWM]1qS&\u0011\u00010\u001e\u0002\u000b%\u0016\u0004xn]5u_JL\u0018!\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001c\b%\u0001\bsKN\u0004Xm\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0003q\u0004\"aV?\n\u0005yD&a\u0002\"p_2,\u0017M\\\u0001\u0010e\u0016\u001c\b/Z2u-\u0016\u00148/[8oA\u0005)\"/Z:qK\u000e$X\t_2mk\u0012,g)\u001b7uKJ\u001c\u0018A\u0006:fgB,7\r^#yG2,H-\u001a$jYR,'o\u001d\u0011\u0002\u001d\u0011,g-Y;miZ+'o]5p]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001CA0Y\u0013\r\t\t\u0002W\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0001,A\beK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8!\u0003-1wN]7bi\u000e\u000b7\r[3\u0016\u0005\u0005}\u0001\u0003CA\u0011\u0003O\tI!a\u000b\u000e\u0005\u0005\r\"bAA\u0013\u0001\u0006)Q\u000f^5mg&!\u0011\u0011FA\u0012\u00059\u0011V-\u001a8ue\u0006tGoQ1dQ\u0016\u0004R!!\f<\u00033s1!a\f8\u001d\u0011\t\t$!\u000f\u000f\t\u0005M\u0012q\u0007\b\u0004?\u0006U\u0012\"A#\n\u0005\r#\u0015BA!C\u0003=\u00196-\u00197bM6$H)\u001f8b[&\u001c\u0007cAA q5\t\u0001iE\u00039\u0003\u0007\nI\u0005E\u0002X\u0003\u000bJ1!a\u0012Y\u0005\u0019\te.\u001f*fMB!\u00111JA)\u001b\t\tiEC\u0002\u0002P1\u000b!![8\n\u0007\u0019\fi%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003{\u0011ABR8s[\u0006$(+Z:vYR\u0004r!XA.\u0003?\nI!C\u0002\u0002^\u001d\u0014a!R5uQ\u0016\u0014\b\u0003BA \u0003CJ1!a\u0019A\u0005Q\u00196-\u00197bM6$H)\u001f8b[&\u001cWI\u001d:pe\nQai\u001c:nCR,e/\u00197\u0016\t\u0005%\u0014q\u000e\t\b;\u0006m\u0013qLA6!\u0011\ti'a\u001c\r\u0001\u00119\u0011\u0011O\u001eC\u0002\u0005M$!\u0001+\u0012\t\u0005U\u00141\u0010\t\u0004/\u0006]\u0014bAA=1\n9aj\u001c;iS:<\u0007cA,\u0002~%\u0019\u0011q\u0010-\u0003\u0007\u0005s\u00170A\u0003baBd\u0017\u0010\u0006\n\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by)!%\u0002 \u0006\r\u0006cAA \u0001!)\u0001\u000e\u0010a\u0001U\")a\u000e\u0010a\u0001a\")!\u0010\u0010a\u0001y\"1\u0011\u0011\u0001\u001fA\u0002qDq!!\u0002=\u0001\u0004\tI\u0001C\u0004\u0002\u001cq\u0002\r!a%\u0011\u0011\u0005\u0005\u0012qEA\u0005\u0003+\u0003R!a&<\u00033k\u0011\u0001\u000f\t\u0005\u0003\u007f\tY*C\u0002\u0002\u001e\u0002\u0013qbU2bY\u00064W\u000e\u001e*fM2,7\r\u001e\u0005\u0007\u0003Cc\u0004\u0019\u0001?\u0002\u0019\r\f7\r[3D_:4\u0017nZ:\t\u000f\u0005\u0015F\b1\u0001\u0002(\u0006a1m\u001c8gS\u001e\u001c8)Y2iKBA\u0011\u0011EA\u0014\u0003S\u000bI\f\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\t\u0019LG.\u001a\u0006\u0004\u0003gc\u0015a\u00018j_&!\u0011qWAW\u0005\u0011\u0001\u0016\r\u001e5\u0011\u000b\u0005]5(a/\u0011\u000f]\u000bi,!1\u0002H&\u0019\u0011q\u0018-\u0003\rQ+\b\u000f\\33!\u0011\ty$a1\n\u0007\u0005\u0015\u0007IA\u000bTG\u0006d\u0017MZ7u%\u00164G.Z2u\u0007>tg-[4\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002.\u0006I\u0011\r\u001e;sS\n,H/Z\u0005\u0005\u0003#\fYM\u0001\u0005GS2,G+[7f\u0003\u001d)h.\u00199qYf$B!a6\u0002dB)q+!7\u0002^&\u0019\u00111\u001c-\u0003\r=\u0003H/[8o!99\u0016q\u001c6qyr\fI!a%}\u0003OK1!!9Y\u0005\u0019!V\u000f\u001d7fq!I\u0011Q]\u001f\u0002\u0002\u0003\u0007\u0011QQ\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#\u0001%\u0002\u0019\u0019|'/\\1u\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001b\r\f7\r[3D_:4\u0017nZ:!+\t\t\t\u0010\u0005\u0005\u0002\"\u0005\u001d\u0012\u0011VAz!\u0015\ticOA^\u00035\u0019wN\u001c4jON\u001c\u0015m\u00195fAQ\u0011\u0012QQA}\u0003w\fi0a@\u0003\u0002\t\r!Q\u0001B\u0004\u0011\u0015A\u0017\u00031\u0001k\u0011\u0015q\u0017\u00031\u0001q\u0011\u0015Q\u0018\u00031\u0001}\u0011\u0019\t\t!\u0005a\u0001y\"9\u0011QA\tA\u0002\u0005%\u0001bBA\u000e#\u0001\u0007\u0011q\u0004\u0005\u0007\u0003C\u000b\u0002\u0019\u0001?\t\u000f\u0005\u0015\u0016\u00031\u0001\u0002rR\u0011\u0011QQ\u0001\u0006G2,\u0017M\u001d\u000b\u0003\u0005\u001f\u00012a\u0016B\t\u0013\r\u0011\u0019\u0002\u0017\u0002\u0005+:LG/\u0001\u0007xSRD'+\u001a9peR,'\u000f\u0006\u0003\u0002\u0006\ne\u0001\"\u00025\u0015\u0001\u0004Q\u0017!G<ji\"\u0014Vm\u001d9fGR\u0004&o\u001c6fGR4\u0015\u000e\u001c;feN$B!!\"\u0003 !1\u0011\u0011A\u000bA\u0002q\f!c^5uQJ+7\u000f]3diZ+'o]5p]R!\u0011Q\u0011B\u0013\u0011\u0015Qh\u00031\u0001}\u0003I9\u0018\u000e\u001e5EK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8\u0015\t\u0005\u0015%1\u0006\u0005\b\u0003\u000b9\u0002\u0019AA\u0005\u0003E9\u0018\u000e\u001e5D_:4\u0017nZ\"bG\"Lgn\u001a\u000b\u0005\u0003\u000b\u0013\t\u0004\u0003\u0004\u0002\"b\u0001\r\u0001`\u0001\u0007M>\u0014X.\u0019;\u0015\u0011\u0005%!q\u0007B\u001e\u0005{AqA!\u000f\u001a\u0001\u0004\tI+\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003_K\u0002\u0019AAU\u0011\u001d\u0011y$\u0007a\u0001\u0003\u0013\tAaY8eK\u0006Y!/\u001a9peR,%O]8s)\u0019\u0011yA!\u0012\u0003H!9\u0011q\u0016\u000eA\u0002\u0005%\u0006b\u0002B%5\u0001\u0007\u0011qL\u0001\u0006KJ\u0014xN]\u0001\u000fM>\u0014X.\u0019;EKR\f\u0017\u000e\\3e)!\u0011yE!\u0015\u0003V\t]\u0003cAA\u0017u!9!1K\u000eA\u0002\u0005%\u0016AC2p]\u001aLw\rU1uQ\"9\u0011qV\u000eA\u0002\u0005%\u0006b\u0002B 7\u0001\u0007\u0011\u0011B\u0001\u000ee\u0016\u001cx\u000e\u001c<f\u0007>tg-[4\u0015\t\tu#q\f\t\b;\u0006m\u0013qLAa\u0011\u001d\u0011\u0019\u0006\ba\u0001\u0003S\u000b\u0011D]3t_24XmQ8oM&<w+\u001b;i'\u000e\fG.\u00194niR!!Q\rB4!\u0015\ticOAa\u0011\u001d\u0011\u0019&\ba\u0001\u0003S\u000b1\u0002]1sg\u0016\u001cuN\u001c4jOR1!Q\rB7\u0005_BqAa\u0015\u001f\u0001\u0004\tI\u000bC\u0004\u0003ry\u0001\r!!'\u0002\u0015\u0019lGOU3gY\u0016\u001cG/\u0001\tsKN|GN^3G_Jl\u0017\r\u001e;feR1\u00111\u0006B<\u0005sBqAa\u0015 \u0001\u0004\tI\u000bC\u0004\u0003|}\u0001\r!!\u0003\u0002\u000fY,'o]5p]\u0006\u0001\"/Z:pYZ,7\t\\1tgB\u000bG\u000f\u001b\u000b\u0007\u0003W\u0011\tIa!\t\u000f\tM\u0003\u00051\u0001\u0002*\"9!Q\u0011\u0011A\u0002\t\u001d\u0015a\u00043po:dw.\u00193Tk\u000e\u001cWm]:\u0011\t\t%%q\u0012\b\u0005\u0003_\u0011Y)C\u0002\u0003\u000e\u0002\u000b\u0011dU2bY\u00064W\u000e\u001e#z]\u0006l\u0017n\u0019#po:dw.\u00193fe&!!\u0011\u0013BJ\u0005=!un\u001e8m_\u0006$7+^2dKN\u001c(b\u0001BG\u0001\u0006IAO]=G_Jl\u0017\r\u001e\u000b\u000b\u0005\u001f\u0012IJa'\u0003\u001e\n\u0005\u0006bBAXC\u0001\u0007\u0011\u0011\u0016\u0005\b\u0005\u007f\t\u0003\u0019AA\u0005\u0011\u001d\u0011y*\ta\u0001\u00033\u000bqA]3gY\u0016\u001cG\u000fC\u0004\u0003:\u0005\u0002\r!!1\u0002\u001b%\u001c\u0018j\u001a8pe\u0016$g)\u001b7f)\u0015a(q\u0015BV\u0011\u001d\u0011IK\ta\u0001\u0003\u0013\t\u0001BZ5mK:\fW.\u001a\u0005\b\u0005s\u0011\u0003\u0019AAa\u0003-\u0011X-\u00193WKJ\u001c\u0018n\u001c8\u0015\t\tE&1\u0017\t\u0006/\u0006e\u0017\u0011\u0002\u0005\b\u0005s\u0019\u0003\u0019AAU\u0003U9\u0018\u000e\u001e5NCZ,gNU3q_NLGo\u001c:jKN$2\u0001\u0015B]\u0011\u0019qG\u00051\u0001\u0003<B)qK!0\u0002\n%\u0019!q\u0018-\u0003\u0015q\u0012X\r]3bi\u0016$g(\u0001\u0003d_BLHCEAC\u0005\u000b\u00149M!3\u0003L\n5'q\u001aBi\u0005'Dq\u0001[\u0013\u0011\u0002\u0003\u0007!\u000eC\u0004oKA\u0005\t\u0019\u00019\t\u000fi,\u0003\u0013!a\u0001y\"A\u0011\u0011A\u0013\u0011\u0002\u0003\u0007A\u0010C\u0005\u0002\u0006\u0015\u0002\n\u00111\u0001\u0002\n!I\u00111D\u0013\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\t\u0003C+\u0003\u0013!a\u0001y\"I\u0011QU\u0013\u0011\u0002\u0003\u0007\u0011\u0011_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011INK\u0002k\u00057\\#A!8\u0011\t\t}'\u0011^\u0007\u0003\u0005CTAAa9\u0003f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005OD\u0016AC1o]>$\u0018\r^5p]&!!1\u001eBq\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tPK\u0002q\u00057\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003x*\u001aAPa7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0000U\u0011\tIAa7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u00111Q\u0001\u0016\u0005\u0003?\u0011Y.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u00111Q\u0002\u0016\u0005\u0003c\u0014Y.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007'\u00012!SB\u000b\u0013\r\t)BS\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00077\u00012aVB\u000f\u0013\r\u0019y\u0002\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\u001a)\u0003C\u0005\u0004(A\n\t\u00111\u0001\u0004\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\f\u0011\r\r=2QGA>\u001b\t\u0019\tDC\u0002\u00044a\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199d!\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004y\u000eu\u0002\"CB\u0014e\u0005\u0005\t\u0019AA>\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\rM11\t\u0005\n\u0007O\u0019\u0014\u0011!a\u0001\u00077\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00077\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007'\ta!Z9vC2\u001cHc\u0001?\u0004R!I1q\u0005\u001c\u0002\u0002\u0003\u0007\u00111\u0010")
public final class ScalafmtDynamic
implements Scalafmt,
Product,
Serializable {
    private final ScalafmtReporter reporter;
    private final List<Repository> repositories;
    private final boolean respectVersion;
    private final boolean respectExcludeFilters;
    private final String defaultVersion;
    private final ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache;
    private final boolean cacheConfigs;
    private final ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache;

    public static Option<Tuple8<ScalafmtReporter, List<Repository>, Object, Object, String, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>>, Object, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>>> unapply(ScalafmtDynamic scalafmtDynamic) {
        return ScalafmtDynamic$.MODULE$.unapply(scalafmtDynamic);
    }

    public static ScalafmtDynamic apply(ScalafmtReporter scalafmtReporter, List<Repository> list, boolean bl, boolean bl2, String string, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache, boolean bl3, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache2) {
        return ScalafmtDynamic$.MODULE$.apply(scalafmtReporter, list, bl, bl2, string, reentrantCache, bl3, reentrantCache2);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ScalafmtReporter reporter() {
        return this.reporter;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public boolean respectVersion() {
        return this.respectVersion;
    }

    public boolean respectExcludeFilters() {
        return this.respectExcludeFilters;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache() {
        return this.formatCache;
    }

    public boolean cacheConfigs() {
        return this.cacheConfigs;
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache() {
        return this.configsCache;
    }

    public void clear() {
        this.formatCache().clear().foreach((Function1 & Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable)x$2 -> {
                ScalafmtDynamic.$anonfun$clear$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
    }

    public ScalafmtDynamic withReporter(ScalafmtReporter reporter) {
        return this.copy(reporter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public ScalafmtDynamic withRespectProjectFilters(boolean respectExcludeFilters) {
        boolean x$1 = respectExcludeFilters;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withRespectVersion(boolean respectVersion) {
        boolean x$1 = respectVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withDefaultVersion(String defaultVersion) {
        String x$1 = defaultVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withConfigCaching(boolean cacheConfigs) {
        boolean x$1 = cacheConfigs;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        String x$6 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$7 = this.copy$default$6();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String format(Path config, Path file, String code) {
        String string;
        Either<ScalafmtDynamicError, String> either = this.formatDetailed(config, file, code);
        if (either instanceof Right) {
            String codeFormatted;
            Right right = (Right)either;
            string = codeFormatted = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ScalafmtDynamicError error = (ScalafmtDynamicError)left.value();
            this.reportError(file, error);
            string = code;
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    private void reportError(Path file, ScalafmtDynamicError error) {
        ScalafmtDynamicError scalafmtDynamicError = error;
        if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigParseError) {
            ScalafmtDynamicError.ConfigParseError configParseError = (ScalafmtDynamicError.ConfigParseError)scalafmtDynamicError;
            Path configPath = configParseError.configPath();
            ScalafmtConfigException cause = configParseError.cause();
            this.reporter().error(configPath, cause.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigDoesNotExist) {
            ScalafmtDynamicError.ConfigDoesNotExist configDoesNotExist = (ScalafmtDynamicError.ConfigDoesNotExist)scalafmtDynamicError;
            Path configPath = configDoesNotExist.configPath();
            this.reporter().error(configPath, "file does not exist");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigMissingVersion) {
            ScalafmtDynamicError.ConfigMissingVersion configMissingVersion = (ScalafmtDynamicError.ConfigMissingVersion)scalafmtDynamicError;
            Path configPath = configMissingVersion.configPath();
            this.reporter().missingVersion(configPath, this.defaultVersion());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CannotDownload) {
            ScalafmtDynamicError.CannotDownload cannotDownload = (ScalafmtDynamicError.CannotDownload)scalafmtDynamicError;
            Path configPath = cannotDownload.configPath();
            String version = cannotDownload.version();
            Option<Throwable> cause = cannotDownload.cause();
            String message = new StringBuilder(37).append("failed to resolve Scalafmt version '").append(version).append("'").toString();
            Option<Throwable> option = cause;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable e = (Throwable)some.value();
                this.reporter().error(configPath, message, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.reporter().error(configPath, message);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CorruptedClassPath) {
            ScalafmtDynamicError.CorruptedClassPath corruptedClassPath = (ScalafmtDynamicError.CorruptedClassPath)scalafmtDynamicError;
            Path configPath = corruptedClassPath.configPath();
            String version = corruptedClassPath.version();
            Throwable cause = corruptedClassPath.cause();
            String message = new StringBuilder(40).append("scalafmt version ").append(version).append(" classpath is corrupted").toString();
            this.reporter().error(configPath, message, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.UnknownError) {
            ScalafmtDynamicError.UnknownError unknownError = (ScalafmtDynamicError.UnknownError)scalafmtDynamicError;
            Throwable cause = unknownError.cause();
            this.reporter().error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafmtDynamicError);
        }
    }

    public Either<ScalafmtDynamicError, String> formatDetailed(Path configPath, Path file, String code) {
        return this.resolveConfig(configPath).flatMap((Function1 & Serializable)config -> this.tryFormat(file, code, config.fmtReflect(), (ScalafmtReflectConfig)config).map((Function1 & Serializable)codeFormatted -> codeFormatted));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfig(Path configPath) {
        Left left;
        if (!Files.exists(configPath, new LinkOption[0])) {
            left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigDoesNotExist(configPath));
        } else if (this.cacheConfigs()) {
            FileTime currentTimestamp = Files.getLastModifiedTime(configPath, new LinkOption[0]);
            left = this.configsCache().getOrAddToCache(configPath, (Function1<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$1(currentTimestamp, x$4)), (Function0<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>)(Function0 & Serializable)() -> this.resolveConfigWithScalafmt(configPath).map((Function1 & Serializable)config -> {
                this.reporter().parsedConfig(configPath, config.version());
                return new Tuple2(config, (Object)currentTimestamp);
            })).map((Function1 & Serializable)x$7 -> (ScalafmtReflectConfig)x$7._1());
        } else {
            left = this.resolveConfigWithScalafmt(configPath);
        }
        return left;
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfigWithScalafmt(Path configPath) {
        return this.readVersion(configPath).toRight((Function0 & Serializable)() -> new ScalafmtDynamicError.ConfigMissingVersion(configPath)).flatMap((Function1 & Serializable)version -> this.resolveFormatter(configPath, (String)version).flatMap((Function1 & Serializable)fmtReflect -> this.parseConfig(configPath, (ScalafmtReflect)fmtReflect).map((Function1 & Serializable)config -> config)));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> parseConfig(Path configPath, ScalafmtReflect fmtReflect) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> fmtReflect.parseConfig(configPath)).toEither().left().map((Function1 & Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ScalafmtConfigException) {
                ScalafmtConfigException scalafmtConfigException = (ScalafmtConfigException)throwable;
                product = new ScalafmtDynamicError.ConfigParseError(configPath, scalafmtConfigException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveFormatter(Path configPath, String version) {
        return this.formatCache().getOrAddToCache(version, this.formatCache().getOrAddToCache$default$2(), (Function0<Either<ScalafmtDynamicError, ScalafmtReflect>>)(Function0 & Serializable)() -> {
            OutputStreamWriter writer = this.reporter().downloadOutputStreamWriter();
            ScalafmtDynamicDownloader downloader = new ScalafmtDynamicDownloader(writer, this.repositories(), ScalafmtDynamicDownloader$.MODULE$.$lessinit$greater$default$3());
            return downloader.download(version).left().map((Function1 & Serializable)x0$1 -> {
                ScalafmtDynamicError.CannotDownload cannotDownload;
                ScalafmtDynamicDownloader.DownloadFailure downloadFailure = x0$1;
                if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadResolutionError) {
                    ScalafmtDynamicDownloader.DownloadResolutionError downloadResolutionError = (ScalafmtDynamicDownloader.DownloadResolutionError)downloadFailure;
                    String v = downloadResolutionError.version();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)None$.MODULE$);
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadUnknownError) {
                    ScalafmtDynamicDownloader.DownloadUnknownError downloadUnknownError = (ScalafmtDynamicDownloader.DownloadUnknownError)downloadFailure;
                    String v = downloadUnknownError.version();
                    Throwable cause = downloadUnknownError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.InvalidVersionError) {
                    ScalafmtDynamicDownloader.InvalidVersionError invalidVersionError = (ScalafmtDynamicDownloader.InvalidVersionError)downloadFailure;
                    String v = invalidVersionError.version();
                    ScalafmtVersion.InvalidVersionException cause = invalidVersionError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else {
                    throw new MatchError((Object)downloadFailure);
                }
                return cannotDownload;
            }).flatMap((Function1 & Serializable)x$8 -> this.resolveClassPath(configPath, (ScalafmtDynamicDownloader.DownloadSuccess)x$8));
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveClassPath(Path configPath, ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess) {
        ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess2 = downloadSuccess;
        if (downloadSuccess2 == null) {
            throw new MatchError((Object)downloadSuccess2);
        }
        String version = downloadSuccess2.version();
        Seq<URL> urls = downloadSuccess2.jarUrls();
        Tuple2 tuple2 = new Tuple2((Object)version, urls);
        Tuple2 tuple22 = tuple2;
        String version2 = (String)tuple22._1();
        Seq urls2 = (Seq)tuple22._2();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URLClassLoader classloader = new URLClassLoader((URL[])urls2.toArray(ClassTag$.MODULE$.apply(URL.class)), null);
            return new ScalafmtReflect(classloader, version2, this.respectVersion());
        }).toEither().left().map((Function1 & Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ReflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)throwable;
                product = new ScalafmtDynamicError.CorruptedClassPath(configPath, version2, (Seq<URL>)urls2, reflectiveOperationException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    private Either<ScalafmtDynamicError, String> tryFormat(Path file, String code, ScalafmtReflect reflect, ScalafmtReflectConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string;
            ScalafmtReflectConfig configWithDialect;
            String filename = ((Object)file).toString();
            ScalafmtReflectConfig scalafmtReflectConfig = configWithDialect = filename.endsWith(".sbt") || filename.endsWith(".sc") ? config.withSbtDialect() : config;
            if (this.isIgnoredFile(filename, configWithDialect)) {
                this.reporter().excluded(file);
                string = code;
            } else {
                string = reflect.format(code, configWithDialect, (Option<Path>)new Some((Object)file));
            }
            return string;
        }).toEither().left().map((Function1 & Serializable)x0$1 -> {
            ScalafmtDynamicError.UnknownError unknownError;
            Option<Throwable> option;
            Throwable throwable = x0$1;
            if (throwable != null && !(option = ReflectionException$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                unknownError = new ScalafmtDynamicError.UnknownError(e);
            } else {
                unknownError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return unknownError;
        });
    }

    private boolean isIgnoredFile(String filename, ScalafmtReflectConfig config) {
        return this.respectExcludeFilters() && !config.isIncludedInProject(filename);
    }

    private Option<String> readVersion(Path config) {
        Some some;
        try {
            some = new Some((Object)ConfigFactory.parseFile((File)config.toFile()).getString("version"));
        }
        catch (Throwable throwable) {
            Option option;
            Some some2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ConfigException.Missing && !this.respectVersion()) {
                some2 = new Some((Object)this.defaultVersion());
            } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                some2 = None$.MODULE$;
            } else {
                throw throwable;
            }
            some = some2;
        }
        return some;
    }

    public Scalafmt withMavenRepositories(Seq<String> repositories) {
        List x$12 = ((IterableOnceOps)repositories.map((Function1 & Serializable)x$1 -> MavenRepository.of((String)x$1))).toList();
        ScalafmtReporter x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, (List<Repository>)x$12, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic copy(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        return new ScalafmtDynamic(reporter, repositories, respectVersion, respectExcludeFilters, defaultVersion, formatCache, cacheConfigs, configsCache);
    }

    public ScalafmtReporter copy$default$1() {
        return this.reporter();
    }

    public List<Repository> copy$default$2() {
        return this.repositories();
    }

    public boolean copy$default$3() {
        return this.respectVersion();
    }

    public boolean copy$default$4() {
        return this.respectExcludeFilters();
    }

    public String copy$default$5() {
        return this.defaultVersion();
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> copy$default$6() {
        return this.formatCache();
    }

    public boolean copy$default$7() {
        return this.cacheConfigs();
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> copy$default$8() {
        return this.configsCache();
    }

    public String productPrefix() {
        return "ScalafmtDynamic";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.reporter();
                break;
            }
            case 1: {
                object = this.repositories();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectVersion());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectExcludeFilters());
                break;
            }
            case 4: {
                object = this.defaultVersion();
                break;
            }
            case 5: {
                object = this.formatCache();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cacheConfigs());
                break;
            }
            case 7: {
                object = this.configsCache();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalafmtDynamic;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "reporter";
                break;
            }
            case 1: {
                string = "repositories";
                break;
            }
            case 2: {
                string = "respectVersion";
                break;
            }
            case 3: {
                string = "respectExcludeFilters";
                break;
            }
            case 4: {
                string = "defaultVersion";
                break;
            }
            case 5: {
                string = "formatCache";
                break;
            }
            case 6: {
                string = "cacheConfigs";
                break;
            }
            case 7: {
                string = "configsCache";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.repositories()));
        n = Statics.mix((int)n, (int)(this.respectVersion() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.respectExcludeFilters() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultVersion()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.formatCache()));
        n = Statics.mix((int)n, (int)(this.cacheConfigs() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.configsCache()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalafmtDynamic)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalafmtDynamic scalafmtDynamic = (ScalafmtDynamic)x$1;
        if (this.respectVersion() != scalafmtDynamic.respectVersion()) return false;
        if (this.respectExcludeFilters() != scalafmtDynamic.respectExcludeFilters()) return false;
        if (this.cacheConfigs() != scalafmtDynamic.cacheConfigs()) return false;
        ScalafmtReporter scalafmtReporter = this.reporter();
        ScalafmtReporter scalafmtReporter2 = scalafmtDynamic.reporter();
        if (scalafmtReporter == null) {
            if (scalafmtReporter2 != null) {
                return false;
            }
        } else if (!scalafmtReporter.equals(scalafmtReporter2)) return false;
        List<Repository> list = this.repositories();
        List<Repository> list2 = scalafmtDynamic.repositories();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        String string = this.defaultVersion();
        String string2 = scalafmtDynamic.defaultVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache = this.formatCache();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache2 = scalafmtDynamic.formatCache();
        if (reentrantCache == null) {
            if (reentrantCache2 != null) {
                return false;
            }
        } else if (!reentrantCache.equals(reentrantCache2)) return false;
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache3 = this.configsCache();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache4 = scalafmtDynamic.configsCache();
        if (reentrantCache3 == null) {
            if (reentrantCache4 == null) return true;
            return false;
        } else {
            if (!reentrantCache3.equals(reentrantCache4)) return false;
            return true;
        }
    }

    public Scalafmt withMavenRepositories(String[] repositories) {
        return this.withMavenRepositories((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])repositories));
    }

    public static final /* synthetic */ void $anonfun$clear$3(ScalafmtReflect x$3) {
        x$3.classLoader().close();
    }

    public static final /* synthetic */ void $anonfun$clear$2(Either x$2) {
        x$2.right().foreach((Function1 & Serializable)x$3 -> {
            ScalafmtDynamic.$anonfun$clear$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$2(ScalafmtDynamicError x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$3(FileTime currentTimestamp$1, Tuple2 x$6) {
        return ((FileTime)x$6._2()).compareTo(currentTimestamp$1) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$1(FileTime currentTimestamp$1, Either x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.fold((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$2(x$5)), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$3(currentTimestamp$1, x$6))));
    }

    public ScalafmtDynamic(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        this.reporter = reporter;
        this.repositories = repositories;
        this.respectVersion = respectVersion;
        this.respectExcludeFilters = respectExcludeFilters;
        this.defaultVersion = defaultVersion;
        this.formatCache = formatCache;
        this.cacheConfigs = cacheConfigs;
        this.configsCache = configsCache;
        Product.$init$((Product)this);
    }

    public ScalafmtDynamic() {
        this(ConsoleScalafmtReporter$.MODULE$, (List<Repository>)Nil$.MODULE$, true, true, BuildInfo$.MODULE$.stable(), ReentrantCache$.MODULE$.apply(), true, ReentrantCache$.MODULE$.apply());
    }
}

