/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics.financial;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.argmin$;
import breeze.linalg.eig;
import breeze.linalg.eig$;
import breeze.linalg.eig$Eig_DM_Impl$;
import breeze.linalg.reverse$;
import breeze.math.Complex;
import breeze.math.Complex$ComplexZero$;
import breeze.numerics.financial.package;
import breeze.numerics.financial.package$End$;
import breeze.numerics.financial.package$Start$;
import breeze.numerics.financial.package$netPresentValue$;
import breeze.numerics.package$abs$;
import breeze.numerics.package$abs$absDoubleImpl$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import breeze.numerics.package$pow$;
import breeze.numerics.package$pow$powDoubleDoubleImpl$;
import breeze.storage.Zero;
import breeze.storage.Zero$DoubleZero$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public double futureValue(double rate, int numPeriods, double payment, double presentValue, package.PaymentTime when) {
        double d;
        Predef$.MODULE$.require(numPeriods >= 0);
        if (rate == 0.0) {
            d = (double)-1 * (presentValue + payment * (double)numPeriods);
        } else {
            double fromPv = presentValue * scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods);
            double fromPayments = payment * ((1.0 + rate * (double)when.t()) / rate) * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (fromPv + fromPayments);
        }
        return d;
    }

    public package.PaymentTime futureValue$default$5() {
        return package$End$.MODULE$;
    }

    public double presentValue(double rate, int numPeriods, double payment, double futureValue, package.PaymentTime when) {
        double d;
        Predef$.MODULE$.require(numPeriods >= 0);
        if (rate == 0.0) {
            d = (double)-1 * (futureValue + payment * (double)numPeriods);
        } else {
            double denominator = scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods);
            double fromPayments = payment * ((1.0 + rate * (double)when.t()) / rate) * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (futureValue + fromPayments) / denominator;
        }
        return d;
    }

    public package.PaymentTime presentValue$default$5() {
        return package$End$.MODULE$;
    }

    public double payment(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        double d;
        if (rate == 0.0) {
            d = (double)-1 * (futureValue + presentValue) / (double)numPeriods;
        } else {
            double denominator = (1.0 + rate * (double)when.t()) / rate * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (futureValue + presentValue * scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods)) / denominator;
        }
        return d;
    }

    public double payment$default$4() {
        return 0.0;
    }

    public package.PaymentTime payment$default$5() {
        return package$End$.MODULE$;
    }

    public Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> principalInterest(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        package.PaymentTime paymentTime = when;
        package$Start$ package$Start$2 = package$Start$.MODULE$;
        if (!(paymentTime != null ? !paymentTime.equals(package$Start$2) : package$Start$2 != null)) {
            throw new IllegalArgumentException("This method is broken for payment at the start of the period!");
        }
        double pmt = this.payment(rate, numPeriods, presentValue, futureValue, when);
        DenseVector<Object> interestPayment = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        DenseVector<Object> principalPayment = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        DenseVector<Object> principalRemaining = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        double principal = presentValue;
        double interest = presentValue * rate;
        for (int index$macro$4724 = 0; index$macro$4724 < numPeriods; ++index$macro$4724) {
            double ip = (double)-1 * scala.math.package$.MODULE$.max(interest, 0.0);
            interest += ip;
            principalRemaining.update$mcD$sp(index$macro$4724, principal += pmt - ip);
            interestPayment.update$mcD$sp(index$macro$4724, ip);
            principalPayment.update$mcD$sp(index$macro$4724, pmt - ip);
            interest += (principal + interest) * rate;
        }
        return new Tuple3(principalPayment, interestPayment, principalRemaining);
    }

    public double principalInterest$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalInterest$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> interestPayments(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._1();
    }

    public double interestPayments$default$4() {
        return 0.0;
    }

    public package.PaymentTime interestPayments$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> principalPayments(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._2();
    }

    public double principalPayments$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalPayments$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> principalRemaining(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._3();
    }

    public double principalRemaining$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalRemaining$default$5() {
        return package$End$.MODULE$;
    }

    private DenseVector<Complex> roots(DenseVector<Object> coeffs) {
        Vector<Complex> vector;
        int tailZerosIdx;
        double[] coeffsArray = coeffs.toArray$mcD$sp((ClassTag<Object>)ClassTag$.MODULE$.Double());
        int trailingZeros = Predef$.MODULE$.doubleArrayOps(coeffsArray).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$1) {
                return this.apply$mcZD$sp(x$1);
            }

            public boolean apply$mcZD$sp(double x$1) {
                return 0.0 != x$1;
            }
        });
        DenseVector<Object> nonZeroCoeffs = coeffs.slice$mcD$sp(trailingZeros, (tailZerosIdx = Predef$.MODULE$.doubleArrayOps(coeffsArray).lastIndexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$2) {
                return this.apply$mcZD$sp(x$2);
            }

            public boolean apply$mcZD$sp(double x$2) {
                return 0.0 != x$2;
            }
        })) + 1, coeffs.slice$default$3());
        int N = nonZeroCoeffs.length() - 1;
        if (0 < N) {
            Matrix A = DenseMatrix$.MODULE$.zeros$mDc$sp(N, N, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$);
            IndexedSeq downDiagIdxs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), N).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int i) {
                    return new Tuple2.mcII.sp(i, i - 1);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((NumericOps)((DenseMatrix)A).apply(downDiagIdxs, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).$colon$eq(BoxesRunTime.boxToDouble((double)1.0), Vector$.MODULE$.v_s_UpdateOp_Double_OpSet());
            ((NumericOps)((DenseMatrix)A).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1), scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRows())).$colon$eq(((ImmutableNumericOps)nonZeroCoeffs.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), N), DenseVector$.MODULE$.canSlice())).$colon$div(BoxesRunTime.boxToDouble((double)(-nonZeroCoeffs.apply$mcD$sp(0))), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv()), DenseMatrix$.MODULE$.setMV_D());
            eig.Eig<DenseVector<Object>, DenseMatrix<Object>> rootEig = eig$.MODULE$.apply(A, eig$Eig_DM_Impl$.MODULE$);
            int nonZeroEigNum = rootEig.eigenvalues().length();
            Vector complexEig = DenseVector$.MODULE$.zeros(nonZeroEigNum, ClassTag$.MODULE$.apply(Complex.class), (Zero)Complex$ComplexZero$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nonZeroEigNum).foreach$mVc$sp((Function1)new Serializable(rootEig, (DenseVector)complexEig){
                public static final long serialVersionUID = 0L;
                private final eig.Eig rootEig$1;
                private final DenseVector complexEig$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.complexEig$1.update(i, new Complex(((DenseVector)this.rootEig$1.eigenvalues()).apply$mcD$sp(i), ((DenseVector)this.rootEig$1.eigenvaluesComplex()).apply$mcD$sp(i)));
                }
                {
                    this.rootEig$1 = rootEig$1;
                    this.complexEig$1 = complexEig$1;
                }
            });
            vector = complexEig;
        } else {
            vector = DenseVector$.MODULE$.zeros(N + 1, ClassTag$.MODULE$.apply(Complex.class), (Zero)Complex$ComplexZero$.MODULE$);
        }
        DenseVector<Complex> complexRoots = vector;
        DenseVector<Complex> fullRoots = 0 < trailingZeros ? DenseVector$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{complexRoots, DenseVector$.MODULE$.zeros(trailingZeros, ClassTag$.MODULE$.apply(Complex.class), (Zero)Complex$ComplexZero$.MODULE$)}), DenseVector$.MODULE$.implOpSet_DV_DV_InPlace(), ClassTag$.MODULE$.apply(Complex.class), Complex$ComplexZero$.MODULE$) : complexRoots;
        return fullRoots;
    }

    public Option<Object> interalRateReturn(DenseVector<Object> cashflow) {
        Predef$.MODULE$.require(cashflow.apply$mcD$sp(0) < 0.0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Input cash flows per time period. The cashflow(0) represent the initial invesment which should be negative!";
            }
        });
        DenseVector<Complex> res = this.roots(reverse$.MODULE$.apply(cashflow, reverse$.MODULE$.dvReverse(ClassTag$.MODULE$.Double())));
        Vector realRes = DenseVector$.MODULE$.apply(Predef$.MODULE$.refArrayOps((Object[])res.toArray((ClassTag<Complex>)ClassTag$.MODULE$.apply(Complex.class))).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Complex check$ifrefutable$1) {
                Complex complex = check$ifrefutable$1;
                boolean bl = complex != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Complex c) {
                return c.im() == 0.0 && 0.0 < c.re();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Complex c) {
                return c.re();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        DenseVector<Object> rates = ((DenseVector)realRes).mapValues$mcD$sp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return 1.0 / v - 1.0;
            }
        }, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double()));
        None$ rate = rates.length() <= 0 ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)rates.apply$mcD$sp(BoxesRunTime.unboxToInt((Object)argmin$.MODULE$.apply(package$abs$.MODULE$.apply(rates, package$abs$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), package$abs$absDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double()))), argmin$.MODULE$.reduce_Double(DenseVector$.MODULE$.canTraverseKeyValuePairs()))))));
        return rate;
    }

    public double modifiedInternalRateReturn(DenseVector<Object> values, double financeRate, double reinvestRate) {
        int n = values.length();
        int posCnt = values.valuesIterator().count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$3) {
                return this.apply$mcZD$sp(x$3);
            }

            public boolean apply$mcZD$sp(double x$3) {
                return 0.0 < x$3;
            }
        });
        DenseVector<Object> positives = values.mapValues$mcD$sp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return 0.0 < x ? x : 0.0;
            }
        }, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double()));
        int negCnt = values.valuesIterator().count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$4) {
                return this.apply$mcZD$sp(x$4);
            }

            public boolean apply$mcZD$sp(double x$4) {
                return x$4 < 0.0;
            }
        });
        DenseVector<Object> negatives = values.mapValues$mcD$sp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x < 0.0 ? x : 0.0;
            }
        }, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double()));
        if (posCnt == 0 || negCnt == 0) {
            throw new IllegalArgumentException("The values must has one positive and negative value!");
        }
        double inflowNPV = BoxesRunTime.unboxToDouble((Object)package$netPresentValue$.MODULE$.apply(BoxesRunTime.boxToDouble((double)reinvestRate), positives, package$netPresentValue$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        double outflowNPV = BoxesRunTime.unboxToDouble((Object)package$netPresentValue$.MODULE$.apply(BoxesRunTime.boxToDouble((double)financeRate), negatives, package$netPresentValue$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        double mirr = package$pow$.MODULE$.apply$mDDDc$sp(scala.math.package$.MODULE$.abs(inflowNPV / outflowNPV), 1.0 / (double)(n - 1), package$pow$powDoubleDoubleImpl$.MODULE$) * (1.0 + reinvestRate) - 1.0;
        return mirr;
    }

    public double modifiedInternalRateReturn$default$3() {
        return 0.0;
    }

    public double numberPeriodicPayments(double rate, double pmt, double pv, double fv, package.PaymentTime when) {
        double d;
        Predef$.MODULE$.require(pmt != 0.0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The payment of annuity(pmt) can not be zero!";
            }
        });
        if (0.0 == rate) {
            d = (-fv + pv) / pmt;
        } else {
            double z = pmt * (1.0 + rate * (double)when.t()) / rate;
            d = package$log$.MODULE$.apply$mDDc$sp((z - fv) / (z + pv), package$log$logDoubleImpl$.MODULE$) / package$log$.MODULE$.apply$mDDc$sp(1.0 + rate, package$log$logDoubleImpl$.MODULE$);
        }
        double nper = d;
        return nper;
    }

    public double numberPeriodicPayments$default$4() {
        return 0.0;
    }

    public package.PaymentTime numberPeriodicPayments$default$5() {
        return package$End$.MODULE$;
    }

    public Option<Object> ratePeriodicPayments(double nper, double pmt, double pv, double fv, package.PaymentTime when, double guess, double tol, int maxiter) {
        double rate = guess;
        boolean close = false;
        for (int iter = 0; iter < maxiter && !close; ++iter) {
            double nextRate = rate - this.annuityFDivGradf(nper, pmt, pv, fv, when, rate);
            double diff2 = package$abs$.MODULE$.apply$mDDc$sp(nextRate - rate, package$abs$absDoubleImpl$.MODULE$);
            close = diff2 < tol;
            rate = nextRate;
        }
        return close ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)rate)) : None$.MODULE$;
    }

    public package.PaymentTime ratePeriodicPayments$default$5() {
        return package$End$.MODULE$;
    }

    public double ratePeriodicPayments$default$6() {
        return 0.1;
    }

    public double ratePeriodicPayments$default$7() {
        return 1.0E-6;
    }

    public int ratePeriodicPayments$default$8() {
        return 100;
    }

    private double annuityFDivGradf(double nper, double pmt, double pv, double fv, package.PaymentTime when, double rate) {
        double t1 = package$pow$.MODULE$.apply$mDDDc$sp(1.0 + rate, nper, package$pow$powDoubleDoubleImpl$.MODULE$);
        double t2 = package$pow$.MODULE$.apply$mDDDc$sp(1.0 + rate, nper - 1.0, package$pow$powDoubleDoubleImpl$.MODULE$);
        double annuityF = fv + pv * t1 + pmt * (t1 - 1.0) * (1.0 + rate * (double)when.t()) / rate;
        double gradAnnuityF = nper * t2 * pv - pmt * (t1 - 1.0) * (1.0 + rate * (double)when.t()) / package$pow$.MODULE$.apply$mDDDc$sp(rate, 2.0, package$pow$powDoubleDoubleImpl$.MODULE$) + nper * pmt * t2 * (1.0 + rate * (double)when.t()) / rate + pmt * (t1 - 1.0) * (double)when.t() / rate;
        double fDivGradF = annuityF / gradAnnuityF;
        return fDivGradF;
    }

    private package$() {
        MODULE$ = this;
    }
}

