/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics;

import breeze.linalg.package$;
import breeze.linalg.scaleAdd$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054q!\u0001\u0002\u0011\u0002\u0007\u0005qAA\u0004TG\u0006d\u0017N\\4\u000b\u0005\r!\u0011\u0001\u00038v[\u0016\u0014\u0018nY:\u000b\u0003\u0015\taA\u0019:fKj,7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u0013j]&$H\u0005F\u0001\u0012!\tI!#\u0003\u0002\u0014\u0015\t!QK\\5u\u0011\u001d)\u0002A1A\u0007\u0002Y\tQb]2bY\u0016\u001cuN\\:uC:$X#A\f\u0011\u0005%A\u0012BA\r\u000b\u0005\rIe\u000e\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u000bg\u000e\fG.Z!se\u0006LHcA\f\u001eK!)aD\u0007a\u0001?\u000511oY8sKN\u00042!\u0003\u0011#\u0013\t\t#BA\u0003BeJ\f\u0017\u0010\u0005\u0002\nG%\u0011AE\u0003\u0002\u0007\t>,(\r\\3\t\u000b\u0019R\u0002\u0019A\f\u0002\u0019\r,(O]3oiN\u001b\u0017\r\\3\t\u000b!\u0002A\u0011A\u0015\u0002#\r|W\u000e];uKN\u001b\u0017\r\\3EK2$\u0018\r\u0006\u0002\u0018U!)ad\na\u0001?!)A\u0006\u0001C\u0001[\u0005qA-\u001a;fe6Lg.Z*dC2,GcA\f/a!)qf\u000ba\u0001E\u0005)1oY8sK\")\u0011g\u000ba\u0001/\u0005Aq\u000e\u001c3TG\u0006dW\rC\u00034\u0001\u0011\u0005A'A\ttG\u0006dW-\u0011:sCf$vnU2bY\u0016$B!E\u001b7o!)aD\ra\u0001?!)aE\ra\u0001/!)\u0001H\ra\u0001/\u0005YA/\u0019:hKR\u001c6-\u00197f\u0011\u0015Q\u0004\u0001\"\u0001<\u0003%\u0019X/\\!se\u0006L8\u000fF\u0003\u0018yy\u0002%\tC\u0003>s\u0001\u0007q$A\u0002te\u000eDQaP\u001dA\u0002]\t\u0001b\u001d:d'\u000e\fG.\u001a\u0005\u0006\u0003f\u0002\raH\u0001\u0005I\u0016\u001cH\u000fC\u0003Ds\u0001\u0007q#A\u0005eKN$8kY1mK\")Q\t\u0001C\u0001\r\u0006aQO\\:dC2,g+\u00197vKR\u0019!e\u0012%\t\u000b=\"\u0005\u0019\u0001\u0012\t\u000b\u0019\"\u0005\u0019A\f\t\u000b)\u0003A\u0011A&\u0002\u0015M\u001c\u0017\r\\3WC2,X\r\u0006\u0003#\u00196s\u0005\"B\u0018J\u0001\u0004\u0011\u0003\"\u0002\u0014J\u0001\u00049\u0002\"\u0002\u001dJ\u0001\u00049\u0002\"\u0002)\u0001\t\u0003\t\u0016A\u0003;p\u0019><7\u000b]1dKR\u0019!EU*\t\u000b=z\u0005\u0019\u0001\u0012\t\u000b\u0019z\u0005\u0019A\f\b\u000bU\u0013\u0001\u0012\u0001,\u0002\u000fM\u001b\u0017\r\\5oOB\u0011q\u000bW\u0007\u0002\u0005\u0019)\u0011A\u0001E\u00013N\u0019\u0001\f\u0003.\u0011\u0005]\u0003\u0001\"\u0002/Y\t\u0003i\u0016A\u0002\u001fj]&$h\bF\u0001W\u0011\u001d)\u0002L1A\u0005\u0002YAa\u0001\u0019-!\u0002\u00139\u0012AD:dC2,7i\u001c8ti\u0006tG\u000f\t")
public interface Scaling {
    public int scaleConstant();

    public static /* synthetic */ int scaleArray$(Scaling $this, double[] scores, int currentScale) {
        return $this.scaleArray(scores, currentScale);
    }

    default public int scaleArray(double[] scores, int currentScale) {
        int scaleDelta = this.computeScaleDelta(scores);
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
        return currentScale + scaleDelta;
    }

    public static /* synthetic */ int computeScaleDelta$(Scaling $this, double[] scores) {
        return $this.computeScaleDelta(scores);
    }

    default public int computeScaleDelta(double[] scores) {
        int maxScale = -10000;
        for (int i = 0; i < scores.length; ++i) {
            double score = scores[i];
            if (score == 0.0) continue;
            int exp = Math.getExponent(score);
            maxScale = scala.math.package$.MODULE$.max(maxScale, exp);
        }
        return maxScale == -10000 ? 0 : (maxScale > this.scaleConstant() ? this.scaleConstant() * (maxScale / this.scaleConstant()) : (maxScale < -this.scaleConstant() ? this.scaleConstant() * (maxScale / this.scaleConstant()) : 0));
    }

    public static /* synthetic */ int determineScale$(Scaling $this, double score, int oldScale) {
        return $this.determineScale(score, oldScale);
    }

    default public int determineScale(double score, int oldScale) {
        int maxScale;
        return score != 0.0 ? ((maxScale = Math.getExponent(score)) == -10000 ? oldScale : (maxScale > this.scaleConstant() ? oldScale + this.scaleConstant() * (maxScale / this.scaleConstant()) : (maxScale < -this.scaleConstant() ? oldScale + this.scaleConstant() * (maxScale / this.scaleConstant()) : oldScale))) : Integer.MIN_VALUE;
    }

    public static /* synthetic */ void scaleArrayToScale$(Scaling $this, double[] scores, int currentScale, int targetScale) {
        $this.scaleArrayToScale(scores, currentScale, targetScale);
    }

    default public void scaleArrayToScale(double[] scores, int currentScale, int targetScale) {
        int scaleDelta = targetScale - currentScale;
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
    }

    public static /* synthetic */ int sumArrays$(Scaling $this, double[] src, int srcScale, double[] dest, int destScale) {
        return $this.sumArrays(src, srcScale, dest, destScale);
    }

    default public int sumArrays(double[] src, int srcScale, double[] dest, int destScale) {
        int n;
        if (destScale == srcScale) {
            package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)1.0), src, dest, scaleAdd$.MODULE$.scaleAddArray_Double());
            n = destScale;
        } else if (destScale - srcScale > 53 + 2 * this.scaleConstant()) {
            n = destScale;
        } else if (srcScale - destScale > 53 + 2 * this.scaleConstant()) {
            System.arraycopy(src, 0, dest, 0, dest.length);
            n = srcScale;
        } else if (srcScale > destScale) {
            this.scaleArrayToScale(dest, destScale, srcScale);
            for (int i = 0; i < dest.length; ++i) {
                int n2 = i;
                dest[n2] = dest[n2] + src[i];
            }
            n = srcScale;
        } else {
            int scaleDelta = destScale - srcScale;
            for (int i = 0; i < dest.length; ++i) {
                int n3 = i;
                dest[n3] = dest[n3] + Math.scalb(src[i], -scaleDelta);
            }
            n = destScale;
        }
        return n;
    }

    public static /* synthetic */ double unscaleValue$(Scaling $this, double score, int currentScale) {
        return $this.unscaleValue(score, currentScale);
    }

    default public double unscaleValue(double score, int currentScale) {
        return Math.scalb(score, currentScale);
    }

    public static /* synthetic */ double scaleValue$(Scaling $this, double score, int currentScale, int targetScale) {
        return $this.scaleValue(score, currentScale, targetScale);
    }

    default public double scaleValue(double score, int currentScale, int targetScale) {
        return Math.scalb(score, currentScale - targetScale);
    }

    public static /* synthetic */ double toLogSpace$(Scaling $this, double score, int currentScale) {
        return $this.toLogSpace(score, currentScale);
    }

    default public double toLogSpace(double score, int currentScale) {
        return package$log$.MODULE$.apply$mDDc$sp(score, package$log$logDoubleImpl$.MODULE$) + (double)currentScale * package$log$.MODULE$.apply$mDDc$sp(2.0, package$log$logDoubleImpl$.MODULE$);
    }

    public static void $init$(Scaling $this) {
    }
}

