/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.io.FileStreams$;
import breeze.linalg.Counter2;
import breeze.linalg.Counter2$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import epic.trees.HeadDB;
import epic.trees.HeadDB$;
import epic.trees.HeadFinder;
import epic.trees.PartialTreeProcessor;
import epic.trees.SimpleTreebank;
import epic.trees.Span$;
import epic.trees.SupervisedHeadFinder;
import epic.trees.SupervisedHeadFinderInnards;
import epic.trees.SupervisedHeadFinderInnards$;
import epic.trees.SupervisedHeadFinderInnards$class;
import epic.trees.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import scala.Console$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SupervisedHeadFinder$ {
    public static final SupervisedHeadFinder$ MODULE$;

    static {
        new SupervisedHeadFinder$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public HeadFinder<String> trainHeadFinderFromFiles(String ptbPath, String conllPath) {
        String string = new StringBuilder().append((Object)"Training supervised head finder from PTB trees at ").append((Object)ptbPath).append((Object)" and CoNLL trees at ").append((Object)conllPath).toString();
        Predef$ predef$ = Predef$.MODULE$;
        Console$.MODULE$.println((Object)string);
        SimpleTreebank treebank = new SimpleTreebank(new File(ptbPath), new File(ptbPath), new File(ptbPath));
        PartialTreeProcessor process = new PartialTreeProcessor();
        Seq processedTrees = (Seq)treebank.train().trees().toSeq().map((Function1)new Serializable(process){
            public static final long serialVersionUID = 0L;
            private final PartialTreeProcessor process$1;

            public final Tree<String> apply(Tuple2<Tree<String>, IndexedSeq<String>> treeWordsPair) {
                return this.process$1.apply((Tree)treeWordsPair._1());
            }
            {
                this.process$1 = process$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Seq<Object>> conllTrees = this.readDepTrees(conllPath);
        if (processedTrees.size() != conllTrees.size()) {
            throw new RuntimeException(new StringBuilder().append((Object)"Error in training the supervised head finder: dep and const trees don't match: ").append((Object)BoxesRunTime.boxToInteger((int)processedTrees.size())).append((Object)" const but ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" dep").toString());
        }
        Counter2 symbolArityHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$, Semiring$.MODULE$.semiringInt());
        Counter2 ruleHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$, Semiring$.MODULE$.semiringInt());
        IntRef numMatched = new IntRef(0);
        Predef$ predef$2 = Predef$.MODULE$;
        int n = conllTrees.size();
        Serializable serializable = new Serializable(processedTrees, conllTrees, symbolArityHeadChildCounts, ruleHeadChildCounts, numMatched){
            public static final long serialVersionUID = 0L;
            public final Seq processedTrees$1;
            public final Seq conllTrees$1;
            public final Counter2 symbolArityHeadChildCounts$1;
            public final Counter2 ruleHeadChildCounts$1;
            public final IntRef numMatched$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Seq conllTree = (Seq)this.conllTrees$1.apply(i);
                Tree constTree = (Tree)this.processedTrees$1.apply(i);
                if (conllTree.size() == Span$.MODULE$.length$extension(constTree.span())) {
                    SupervisedHeadFinder$.MODULE$.epic$trees$SupervisedHeadFinder$$rec$1(constTree, conllTree, this.symbolArityHeadChildCounts$1, this.ruleHeadChildCounts$1);
                    ++this.numMatched$1.elem;
                }
            }
            {
                this.processedTrees$1 = processedTrees$1;
                this.conllTrees$1 = conllTrees$1;
                this.symbolArityHeadChildCounts$1 = symbolArityHeadChildCounts$1;
                this.ruleHeadChildCounts$1 = ruleHeadChildCounts$1;
                this.numMatched$1 = numMatched$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (range.validateRangeBoundaries((Function1)serializable)) {
            int n2 = range.terminalElement();
            int n3 = range.step();
            for (int i = range.start(); i != n2; i += n3) {
                void var26_11;
                void var25_10;
                void var24_9;
                void var18_7;
                void var17_8;
                Seq conllTree1 = (Seq)var17_8.apply(i);
                Tree constTree1 = (Tree)var18_7.apply(i);
                long l = constTree1.span();
                Span$ span$ = Span$.MODULE$;
                if (conllTree1.size() != (int)l - (int)(l >>> 32)) continue;
                this.epic$trees$SupervisedHeadFinder$$rec$1(constTree1, conllTree1, (Counter2)var24_9, (Counter2)var25_10);
                ++var26_11.elem;
            }
        }
        String string2 = new StringBuilder().append((Object)"Head finder trained; lengths matched on ").append((Object)BoxesRunTime.boxToInteger((int)numMatched.elem)).append((Object)" / ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" trees").toString();
        Predef$ predef$3 = Predef$.MODULE$;
        Console$.MODULE$.println((Object)string2);
        HeadDB$ headDB$ = HeadDB$.MODULE$;
        HeadDB headDB = new HeadDB(symbolArityHeadChildCounts, ruleHeadChildCounts, true);
        SupervisedHeadFinderInnards$ supervisedHeadFinderInnards$ = SupervisedHeadFinderInnards$.MODULE$;
        return new SupervisedHeadFinder<String>(new SupervisedHeadFinderInnards<B, B>(headDB){
            private final HeadDB db$1;

            public int findHeadChild(B l, Seq<B> children) {
                return SupervisedHeadFinderInnards$class.findHeadChild(this, l, children);
            }

            public <U> SupervisedHeadFinderInnards<U, B> projected(Function1<U, B> f) {
                return SupervisedHeadFinderInnards$class.projected(this, f);
            }

            public B proj(B l) {
                return l;
            }

            public HeadDB<B> getHeadDB() {
                return this.db$1;
            }
            {
                this.db$1 = db$1;
                SupervisedHeadFinderInnards$class.$init$(this);
            }
        });
    }

    public Seq<Seq<Object>> readDepTrees(String conllPath) {
        InputStream in = FileStreams$.MODULE$.input(new File(conllPath));
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        ArrayBuffer trees2 = new ArrayBuffer();
        ArrayBuffer currSent = new ArrayBuffer();
        while (br.ready()) {
            ArrayBuffer arrayBuffer;
            String line = br.readLine();
            if (line.trim().isEmpty()) {
                Object object = currSent.isEmpty() ? BoxedUnit.UNIT : trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
                currSent = new ArrayBuffer();
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            arrayBuffer = currSent.$plus$eq((Object)Predef$.MODULE$.wrapRefArray((Object[])line.split("\\s+")));
        }
        Object object = currSent.isEmpty() ? BoxedUnit.UNIT : trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
        return trees2;
    }

    public Seq<Object> conllToTree(Seq<Seq<String>> sent) {
        return (Seq)sent.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$3) {
                String string = (String)x$3.apply(6);
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(string).toInt() - 1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public final void epic$trees$SupervisedHeadFinder$$rec$1(Tree tree, Seq conllTree, Counter2 symbolArityHeadChildCounts$1, Counter2 ruleHeadChildCounts$1) {
        if (tree.isLeaf()) return;
        String label2 = (String)tree.label();
        IntRef headIdx = new IntRef(-1);
        long l = tree.span();
        Span$ span$ = Span$.MODULE$;
        int n = (int)(l >>> 32);
        Predef$ predef$ = Predef$.MODULE$;
        long l2 = tree.span();
        Span$ span$2 = Span$.MODULE$;
        int n2 = (int)l2;
        Serializable serializable = new Serializable(tree, conllTree, headIdx){
            public static final long serialVersionUID = 0L;
            public final Tree tree$1;
            public final Seq conllTree$1;
            public final IntRef headIdx$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                if (BoxesRunTime.unboxToInt((Object)this.conllTree$1.apply(idx)) < Span$.MODULE$.begin$extension(this.tree$1.span()) || BoxesRunTime.unboxToInt((Object)this.conllTree$1.apply(idx)) >= Span$.MODULE$.end$extension(this.tree$1.span())) {
                    this.headIdx$1.elem = idx;
                }
            }
            {
                this.tree$1 = tree$1;
                this.conllTree$1 = conllTree$1;
                this.headIdx$1 = headIdx$1;
            }
        };
        boolean bl = true;
        while (true) {
            int n3;
            block13: {
                int n4;
                block12: {
                    block11: {
                        block10: {
                            int n5;
                            block9: {
                                if (!bl || (bl = false)) break block9;
                                Range range = Range$.MODULE$.apply(n, n2);
                                if (!range.validateRangeBoundaries((Function1)serializable)) break block10;
                                n4 = range.start();
                                n5 = range.terminalElement();
                                n3 = range.step();
                            }
                            if (n4 != n5) break block11;
                        }
                        if (headIdx.elem != -1) {
                            int childIdx = 0;
                            while (true) {
                                long l3 = ((Tree)tree.children().apply(childIdx)).span();
                                Span$ span$3 = Span$.MODULE$;
                                if ((int)l3 > headIdx.elem) break;
                                ++childIdx;
                            }
                            Predef$ predef$2 = Predef$.MODULE$;
                            Integer n6 = BoxesRunTime.boxToInteger((int)tree.children().size());
                            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                            Tuple2 tuple2 = new Tuple2((Object)label2, (Object)n6);
                            symbolArityHeadChildCounts$1.update((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)symbolArityHeadChildCounts$1.apply((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                            Predef$ predef$3 = Predef$.MODULE$;
                            Object object = tree.children().map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Tree<String> x$1) {
                                    return x$1.label();
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                            Tuple2 tuple22 = new Tuple2((Object)label2, object);
                            ruleHeadChildCounts$1.update((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)ruleHeadChildCounts$1.apply((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                        }
                        tree.children().foreach((Function1)new Serializable(symbolArityHeadChildCounts$1, ruleHeadChildCounts$1, conllTree){
                            public static final long serialVersionUID = 0L;
                            private final Counter2 symbolArityHeadChildCounts$1;
                            private final Counter2 ruleHeadChildCounts$1;
                            private final Seq conllTree$1;

                            public final void apply(Tree<String> x$2) {
                                SupervisedHeadFinder$.MODULE$.epic$trees$SupervisedHeadFinder$$rec$1(x$2, this.conllTree$1, this.symbolArityHeadChildCounts$1, this.ruleHeadChildCounts$1);
                            }
                            {
                                this.symbolArityHeadChildCounts$1 = symbolArityHeadChildCounts$1;
                                this.ruleHeadChildCounts$1 = ruleHeadChildCounts$1;
                                this.conllTree$1 = conllTree$1;
                            }
                        });
                        return;
                    }
                    long l4 = tree.span();
                    Span$ span$4 = Span$.MODULE$;
                    if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n4)) < (int)(l4 >>> 32)) break block12;
                    long l5 = tree.span();
                    Span$ span$5 = Span$.MODULE$;
                    if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n4)) < (int)l5) break block13;
                }
                var36_6.elem = n4;
            }
            n4 += n3;
        }
    }

    private SupervisedHeadFinder$() {
        MODULE$ = this;
    }
}

