/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.io.FileStreams$;
import breeze.linalg.Counter2;
import breeze.linalg.Counter2$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import epic.trees.HeadDB;
import epic.trees.HeadDB$;
import epic.trees.HeadFinder;
import epic.trees.PartialTreeProcessor;
import epic.trees.SimpleTreebank;
import epic.trees.Span$;
import epic.trees.SupervisedHeadFinder;
import epic.trees.SupervisedHeadFinderInnards;
import epic.trees.SupervisedHeadFinderInnards$;
import epic.trees.SupervisedHeadFinderInnards$class;
import epic.trees.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import scala.Console$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SupervisedHeadFinder$ {
    public static final SupervisedHeadFinder$ MODULE$;

    static {
        new SupervisedHeadFinder$();
    }

    /*
     * WARNING - void declaration
     */
    public HeadFinder<String> trainHeadFinderFromFiles(String ptbPath, String conllPath) {
        String string = new StringBuilder().append((Object)"Training supervised head finder from PTB trees at ").append((Object)ptbPath).append((Object)" and CoNLL trees at ").append((Object)conllPath).toString();
        Predef$ predef$ = Predef$.MODULE$;
        Console$.MODULE$.println((Object)string);
        SimpleTreebank treebank = new SimpleTreebank(new File(ptbPath), new File(ptbPath), new File(ptbPath));
        PartialTreeProcessor process = new PartialTreeProcessor();
        Seq processedTrees = (Seq)treebank.train().trees().toSeq().map((Function1)new Serializable(process){
            private final PartialTreeProcessor process$1;

            public final Tree<String> apply(Tuple2<Tree<String>, IndexedSeq<String>> treeWordsPair) {
                return this.process$1.apply((Tree)treeWordsPair._1());
            }
            {
                this.process$1 = process$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Seq<Object>> conllTrees = this.readDepTrees(conllPath);
        if (processedTrees.size() != conllTrees.size()) {
            throw new RuntimeException(new StringBuilder().append((Object)"Error in training the supervised head finder: dep and const trees don't match: ").append((Object)BoxesRunTime.boxToInteger((int)processedTrees.size())).append((Object)" const but ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" dep").toString());
        }
        Counter2 symbolArityHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$, Semiring$.MODULE$.semiringInt());
        Counter2 ruleHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$, Semiring$.MODULE$.semiringInt());
        IntRef numMatched = IntRef.create((int)0);
        Predef$ predef$2 = Predef$.MODULE$;
        int n = conllTrees.size();
        Range range = Range$.MODULE$.apply(0, n);
        range.scala$collection$immutable$Range$$validateMaxLength();
        boolean bl = range.start() != Integer.MIN_VALUE || range.end() != Integer.MIN_VALUE;
        int n2 = range.start();
        int n3 = 0;
        int n4 = range.terminalElement();
        int n5 = range.step();
        while (true) {
            void var18_7;
            void var17_8;
            if (!(!bl ? n3 < range.numRangeElements() : n2 != n4)) {
                String string2 = new StringBuilder().append((Object)"Head finder trained; lengths matched on ").append((Object)BoxesRunTime.boxToInteger((int)numMatched.elem)).append((Object)" / ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" trees").toString();
                Predef$ predef$3 = Predef$.MODULE$;
                Console$.MODULE$.println((Object)string2);
                HeadDB$ headDB$ = HeadDB$.MODULE$;
                HeadDB headDB = new HeadDB(symbolArityHeadChildCounts, ruleHeadChildCounts, true);
                SupervisedHeadFinderInnards$ supervisedHeadFinderInnards$ = SupervisedHeadFinderInnards$.MODULE$;
                return new SupervisedHeadFinder<String>(new SupervisedHeadFinderInnards<B, B>(headDB){
                    private final HeadDB db$1;

                    public int findHeadChild(B l, Seq<B> children) {
                        return SupervisedHeadFinderInnards$class.findHeadChild(this, l, children);
                    }

                    public <U> SupervisedHeadFinderInnards<U, B> projected(Function1<U, B> f) {
                        return SupervisedHeadFinderInnards$class.projected(this, f);
                    }

                    public B proj(B l) {
                        return l;
                    }

                    public HeadDB<B> getHeadDB() {
                        return this.db$1;
                    }
                    {
                        this.db$1 = db$1;
                        SupervisedHeadFinderInnards$class.$init$(this);
                    }
                });
            }
            Seq conllTree1 = (Seq)var17_8.apply(n2);
            Tree constTree1 = (Tree)var18_7.apply(n2);
            long l = constTree1.span();
            Span$ span$ = Span$.MODULE$;
            if (conllTree1.size() == (int)l - (int)(l >>> 32)) {
                void var26_11;
                void var25_10;
                void var24_9;
                this.epic$trees$SupervisedHeadFinder$$rec$1(constTree1, conllTree1, (Counter2)var24_9, (Counter2)var25_10);
                ++var26_11.elem;
            }
            ++n3;
            n2 += n5;
        }
    }

    public Seq<Seq<Object>> readDepTrees(String conllPath) {
        InputStream in = FileStreams$.MODULE$.input(new File(conllPath));
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        ArrayBuffer trees2 = new ArrayBuffer();
        ArrayBuffer currSent = new ArrayBuffer();
        while (br.ready()) {
            ArrayBuffer arrayBuffer;
            String line = br.readLine();
            if (line.trim().isEmpty()) {
                Object object = currSent.isEmpty() ? BoxedUnit.UNIT : trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
                currSent = new ArrayBuffer();
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            arrayBuffer = currSent.$plus$eq((Object)Predef$.MODULE$.wrapRefArray((Object[])line.split("\\s+")));
        }
        Object object = currSent.isEmpty() ? BoxedUnit.UNIT : trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
        return trees2;
    }

    public Seq<Object> conllToTree(Seq<Seq<String>> sent) {
        return (Seq)sent.map((Function1)new Serializable(){

            public final int apply(Seq<String> x$3) {
                String string = (String)x$3.apply(6);
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(string).toInt() - 1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void epic$trees$SupervisedHeadFinder$$rec$1(Tree tree, Seq conllTree, Counter2 symbolArityHeadChildCounts$1, Counter2 ruleHeadChildCounts$1) {
        if (tree.isLeaf()) return;
        String label2 = (String)tree.label();
        IntRef headIdx = IntRef.create((int)-1);
        long l = tree.span();
        Span$ span$ = Span$.MODULE$;
        int n = (int)(l >>> 32);
        Predef$ predef$ = Predef$.MODULE$;
        long l2 = tree.span();
        Span$ span$2 = Span$.MODULE$;
        int n2 = (int)l2;
        Range range = Range$.MODULE$.apply(n, n2);
        range.scala$collection$immutable$Range$$validateMaxLength();
        boolean bl = range.start() != Integer.MIN_VALUE || range.end() != Integer.MIN_VALUE;
        int n3 = range.start();
        int n4 = 0;
        int n5 = range.terminalElement();
        int n6 = range.step();
        while (true) {
            block8: {
                block7: {
                    if (!(!bl ? n4 < range.numRangeElements() : n3 != n5)) {
                        if (headIdx.elem != -1) {
                            int childIdx = 0;
                            while (true) {
                                long l3 = ((Tree)tree.children().apply(childIdx)).span();
                                Span$ span$3 = Span$.MODULE$;
                                if ((int)l3 > headIdx.elem) break;
                                ++childIdx;
                            }
                            Predef$ predef$2 = Predef$.MODULE$;
                            Integer n7 = BoxesRunTime.boxToInteger((int)tree.children().size());
                            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                            Tuple2 tuple2 = new Tuple2((Object)label2, (Object)n7);
                            symbolArityHeadChildCounts$1.update((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)symbolArityHeadChildCounts$1.apply((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                            Predef$ predef$3 = Predef$.MODULE$;
                            Object object = tree.children().map((Function1)new Serializable(){

                                public final String apply(Tree<String> x$1) {
                                    return x$1.label();
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                            Tuple2 tuple22 = new Tuple2((Object)label2, object);
                            ruleHeadChildCounts$1.update((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)ruleHeadChildCounts$1.apply((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                        }
                        tree.children().foreach((Function1)new Serializable(symbolArityHeadChildCounts$1, ruleHeadChildCounts$1, conllTree){
                            private final Counter2 symbolArityHeadChildCounts$1;
                            private final Counter2 ruleHeadChildCounts$1;
                            private final Seq conllTree$1;

                            public final void apply(Tree<String> x$2) {
                                SupervisedHeadFinder$.MODULE$.epic$trees$SupervisedHeadFinder$$rec$1(x$2, this.conllTree$1, this.symbolArityHeadChildCounts$1, this.ruleHeadChildCounts$1);
                            }
                            {
                                this.symbolArityHeadChildCounts$1 = symbolArityHeadChildCounts$1;
                                this.ruleHeadChildCounts$1 = ruleHeadChildCounts$1;
                                this.conllTree$1 = conllTree$1;
                            }
                        });
                        return;
                    }
                    long l4 = tree.span();
                    Span$ span$4 = Span$.MODULE$;
                    if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n3)) < (int)(l4 >>> 32)) break block7;
                    long l5 = tree.span();
                    Span$ span$5 = Span$.MODULE$;
                    if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n3)) < (int)l5) break block8;
                }
                var36_6.elem = n3;
            }
            ++n4;
            n3 += n6;
        }
    }

    private SupervisedHeadFinder$() {
        MODULE$ = this;
    }
}

