/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.ArraySorter;
import nak.liblinear.DoubleArrayPointer;
import nak.liblinear.Feature;
import nak.liblinear.IntArrayPointer;
import nak.liblinear.Linear;
import nak.liblinear.Problem;

class SolverMCSVM_CS {
    private final double[] B;
    private final double[] C;
    private final double eps;
    private final double[] G;
    private final int max_iter;
    private final int w_size;
    private final int l;
    private final int nr_class;
    private final Problem prob;

    public SolverMCSVM_CS(Problem problem, int n, double[] dArray) {
        this(problem, n, dArray, 0.1);
    }

    public SolverMCSVM_CS(Problem problem, int n, double[] dArray, double d) {
        this(problem, n, dArray, d, 100000);
    }

    public SolverMCSVM_CS(Problem problem, int n, double[] dArray, double d, int n2) {
        this.w_size = problem.n;
        this.l = problem.l;
        this.nr_class = n;
        this.eps = d;
        this.max_iter = n2;
        this.prob = problem;
        this.C = dArray;
        this.B = new double[n];
        this.G = new double[n];
    }

    private int GETI(int n) {
        return (int)this.prob.y[n];
    }

    private boolean be_shrunk(int n, int n2, int n3, double d, double d2) {
        double d3 = 0.0;
        if (n2 == n3) {
            d3 = this.C[this.GETI(n)];
        }
        return d == d3 && this.G[n2] < d2;
    }

    public void solve(double[] dArray) {
        int n;
        int n2;
        int n3 = 0;
        double[] dArray2 = new double[this.l * this.nr_class];
        double[] dArray3 = new double[this.nr_class];
        int[] nArray = new int[this.l];
        double[] dArray4 = new double[this.l];
        int[] nArray2 = new int[this.nr_class];
        double[] dArray5 = new double[this.nr_class];
        int[] nArray3 = new int[this.nr_class * this.l];
        int[] nArray4 = new int[this.l];
        int n4 = this.l;
        int[] nArray5 = new int[this.l];
        double d = Math.max(10.0 * this.eps, 1.0);
        boolean bl = true;
        for (n2 = 0; n2 < this.l * this.nr_class; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.w_size * this.nr_class; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.l; ++n2) {
            for (n = 0; n < this.nr_class; ++n) {
                nArray3[n2 * this.nr_class + n] = n;
            }
            dArray4[n2] = 0.0;
            for (Feature feature : this.prob.x[n2]) {
                double d2 = feature.getValue();
                int n5 = n2;
                dArray4[n5] = dArray4[n5] + d2 * d2;
            }
            nArray5[n2] = this.nr_class;
            nArray4[n2] = (int)this.prob.y[n2];
            nArray[n2] = n2;
        }
        Feature[] featureArray = new DoubleArrayPointer(dArray2, 0);
        IntArrayPointer intArrayPointer = new IntArrayPointer(nArray3, 0);
        while (n3 < this.max_iter) {
            double d3 = Double.NEGATIVE_INFINITY;
            for (n2 = 0; n2 < n4; ++n2) {
                int n6 = n2 + Linear.random.nextInt(n4 - n2);
                Linear.swap(nArray, n2, n6);
            }
            for (int i = 0; i < n4; ++i) {
                int n7;
                n2 = nArray[i];
                double d4 = dArray4[n2];
                featureArray.setOffset(n2 * this.nr_class);
                intArrayPointer.setOffset(n2 * this.nr_class);
                if (!(d4 > 0.0)) continue;
                for (n = 0; n < nArray5[n2]; ++n) {
                    this.G[n] = 1.0;
                }
                if (nArray4[n2] < nArray5[n2]) {
                    this.G[nArray4[n2]] = 0.0;
                }
                for (Feature feature : this.prob.x[n2]) {
                    n7 = (feature.getIndex() - 1) * this.nr_class;
                    for (n = 0; n < nArray5[n2]; ++n) {
                        int n8 = n;
                        this.G[n8] = this.G[n8] + dArray[n7 + intArrayPointer.get(n)] * feature.getValue();
                    }
                }
                double d5 = Double.POSITIVE_INFINITY;
                double d6 = Double.NEGATIVE_INFINITY;
                for (n = 0; n < nArray5[n2]; ++n) {
                    if (featureArray.get(intArrayPointer.get(n)) < 0.0 && this.G[n] < d5) {
                        d5 = this.G[n];
                    }
                    if (!(this.G[n] > d6)) continue;
                    d6 = this.G[n];
                }
                if (nArray4[n2] < nArray5[n2] && featureArray.get((int)this.prob.y[n2]) < this.C[this.GETI(n2)] && this.G[nArray4[n2]] < d5) {
                    d5 = this.G[nArray4[n2]];
                }
                block12: for (n = 0; n < nArray5[n2]; ++n) {
                    if (!this.be_shrunk(n2, n, nArray4[n2], featureArray.get(intArrayPointer.get(n)), d5)) continue;
                    int n9 = n2;
                    nArray5[n9] = nArray5[n9] - 1;
                    while (nArray5[n2] > n) {
                        if (!this.be_shrunk(n2, nArray5[n2], nArray4[n2], featureArray.get(intArrayPointer.get(nArray5[n2])), d5)) {
                            Linear.swap(intArrayPointer, n, nArray5[n2]);
                            Linear.swap(this.G, n, nArray5[n2]);
                            if (nArray4[n2] == nArray5[n2]) {
                                nArray4[n2] = n;
                                continue block12;
                            }
                            if (nArray4[n2] != n) continue block12;
                            nArray4[n2] = nArray5[n2];
                            continue block12;
                        }
                        int n10 = n2;
                        nArray5[n10] = nArray5[n10] - 1;
                    }
                }
                if (nArray5[n2] <= 1) {
                    Linear.swap(nArray, i, --n4);
                    --i;
                    continue;
                }
                if (d6 - d5 <= 1.0E-12) continue;
                d3 = Math.max(d6 - d5, d3);
                for (n = 0; n < nArray5[n2]; ++n) {
                    this.B[n] = this.G[n] - d4 * featureArray.get(intArrayPointer.get(n));
                }
                this.solve_sub_problem(d4, nArray4[n2], this.C[this.GETI(n2)], nArray5[n2], dArray3);
                n7 = 0;
                for (n = 0; n < nArray5[n2]; ++n) {
                    double d7 = dArray3[n] - featureArray.get(intArrayPointer.get(n));
                    featureArray.set(intArrayPointer.get(n), dArray3[n]);
                    if (!(Math.abs(d7) >= 1.0E-12)) continue;
                    nArray2[n7] = intArrayPointer.get(n);
                    dArray5[n7] = d7;
                    ++n7;
                }
                for (Feature feature : this.prob.x[n2]) {
                    int n11 = (feature.getIndex() - 1) * this.nr_class;
                    for (n = 0; n < n7; ++n) {
                        int n12 = n11 + nArray2[n];
                        dArray[n12] = dArray[n12] + dArray5[n] * feature.getValue();
                    }
                }
            }
            if (++n3 % 10 == 0) {
                Linear.info(".");
            }
            if (d3 < d) {
                if (d3 < this.eps && bl) break;
                n4 = this.l;
                for (n2 = 0; n2 < this.l; ++n2) {
                    nArray5[n2] = this.nr_class;
                }
                Linear.info("*");
                d = Math.max(d / 2.0, this.eps);
                bl = true;
                continue;
            }
            bl = false;
        }
        Linear.info("%noptimization finished, #iter = %d%n", n3);
        if (n3 >= this.max_iter) {
            Linear.info("%nWARNING: reaching max number of iterations%n");
        }
        double d8 = 0.0;
        int n13 = 0;
        for (n2 = 0; n2 < this.w_size * this.nr_class; ++n2) {
            d8 += dArray[n2] * dArray[n2];
        }
        d8 = 0.5 * d8;
        for (n2 = 0; n2 < this.l * this.nr_class; ++n2) {
            d8 += dArray2[n2];
            if (!(Math.abs(dArray2[n2]) > 0.0)) continue;
            ++n13;
        }
        for (n2 = 0; n2 < this.l; ++n2) {
            d8 -= dArray2[n2 * this.nr_class + (int)this.prob.y[n2]];
        }
        Linear.info("Objective value = %f%n", d8);
        Linear.info("nSV = %d%n", n13);
    }

    private void solve_sub_problem(double d, int n, double d2, int n2, double[] dArray) {
        int n3;
        assert (n2 <= this.B.length);
        double[] dArray2 = Linear.copyOf(this.B, n2);
        if (n < n2) {
            int n4 = n;
            dArray2[n4] = dArray2[n4] + d * d2;
        }
        ArraySorter.reversedMergesort(dArray2);
        double d3 = dArray2[0] - d * d2;
        for (n3 = 1; n3 < n2 && d3 < (double)n3 * dArray2[n3]; d3 += dArray2[n3], ++n3) {
        }
        d3 /= (double)n3;
        for (n3 = 0; n3 < n2; ++n3) {
            dArray[n3] = n3 == n ? Math.min(d2, (d3 - this.B[n3]) / d) : Math.min(0.0, (d3 - this.B[n3]) / d);
        }
    }
}

