/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import nak.liblinear.Feature;
import nak.liblinear.FeatureNode;
import nak.liblinear.Linear;
import nak.liblinear.Model;

public class Predict {
    private static boolean flag_predict_probability = false;
    private static final Pattern COLON = Pattern.compile(":");

    static void doPredict(BufferedReader bufferedReader, Writer writer, Model model) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = model.getNrClass();
        double[] dArray = null;
        int n4 = model.getNrFeature();
        int n5 = model.bias >= 0.0 ? n4 + 1 : n4;
        if (flag_predict_probability && !model.isProbabilityModel()) {
            throw new IllegalArgumentException("probability output is only supported for logistic regression");
        }
        Formatter formatter = new Formatter(writer);
        if (flag_predict_probability) {
            object = model.getLabels();
            dArray = new double[n3];
            Linear.printf(formatter, "labels", new Object[0]);
            for (int i = 0; i < n3; ++i) {
                Linear.printf(formatter, " %d", object[i]);
            }
            Linear.printf(formatter, "\n", new Object[0]);
        }
        object = null;
        while (true) {
            double d7;
            double d8;
            Object object2;
            String string = bufferedReader.readLine();
            object = string;
            if (string == null) break;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \t\n");
            try {
                object2 = stringTokenizer.nextToken();
                d8 = Linear.atof((String)object2);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new RuntimeException("Wrong input format at line " + (n2 + 1), noSuchElementException);
            }
            while (stringTokenizer.hasMoreTokens()) {
                object2 = COLON.split(stringTokenizer.nextToken(), 2);
                if (object2 == null || ((String[])object2).length < 2) {
                    throw new RuntimeException("Wrong input format at line " + (n2 + 1));
                }
                try {
                    int n6 = Linear.atoi((String)object2[0]);
                    double d9 = Linear.atof((String)object2[1]);
                    if (n6 > n4) continue;
                    FeatureNode featureNode = new FeatureNode(n6, d9);
                    arrayList.add(featureNode);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("Wrong input format at line " + (n2 + 1), numberFormatException);
                }
            }
            if (model.bias >= 0.0) {
                object2 = new FeatureNode(n5, model.bias);
                arrayList.add(object2);
            }
            object2 = new Feature[arrayList.size()];
            object2 = (Feature[])arrayList.toArray((T[])object2);
            if (flag_predict_probability) {
                assert (dArray != null);
                d7 = Linear.predictProbability(model, (Feature[])object2, dArray);
                Linear.printf(formatter, "%g", d7);
                for (int i = 0; i < model.nr_class; ++i) {
                    Linear.printf(formatter, " %g", dArray[i]);
                }
                Linear.printf(formatter, "\n", new Object[0]);
            } else {
                d7 = Linear.predict(model, (Feature[])object2);
                Linear.printf(formatter, "%g\n", d7);
            }
            if (d7 == d8) {
                ++n;
            }
            d += (d7 - d8) * (d7 - d8);
            d2 += d7;
            d3 += d8;
            d4 += d7 * d7;
            d5 += d8 * d8;
            d6 += d7 * d8;
            ++n2;
        }
        if (model.solverType.isSupportVectorRegression()) {
            Linear.info("Mean squared error = %g (regression)%n", d / (double)n2);
            Linear.info("Squared correlation coefficient = %g (regression)%n", ((double)n2 * d6 - d2 * d3) * ((double)n2 * d6 - d2 * d3) / (((double)n2 * d4 - d2 * d2) * ((double)n2 * d5 - d3 * d3)));
        } else {
            Linear.info("Accuracy = %g%% (%d/%d)%n", (double)n / (double)n2 * 100.0, n, n2);
        }
    }

    private static void exit_with_help() {
        System.out.printf("Usage: predict [options] test_file model_file output_file%noptions:%n-b probability_estimates: whether to output probability estimates, 0 or 1 (default 0); currently for logistic regression only%n-q quiet mode (no outputs)%n", new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        int n;
        block8: for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            switch (stringArray[++n - 1].charAt(1)) {
                case 'b': {
                    try {
                        flag_predict_probability = Linear.atoi(stringArray[n]) != 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Predict.exit_with_help();
                    }
                    continue block8;
                }
                case 'q': {
                    --n;
                    Linear.disableDebugOutput();
                    continue block8;
                }
                default: {
                    System.err.printf("unknown option: -%d%n", Character.valueOf(stringArray[n - 1].charAt(1)));
                    Predict.exit_with_help();
                }
            }
        }
        if (n >= stringArray.length || stringArray.length <= n + 2) {
            Predict.exit_with_help();
        }
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stringArray[n]), Linear.FILE_CHARSET));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stringArray[n + 2]), Linear.FILE_CHARSET));
            Model model = Linear.loadModel(new File(stringArray[n + 1]));
            Predict.doPredict(bufferedReader, bufferedWriter, model);
        }
        catch (Throwable throwable) {
            Linear.closeQuietly(bufferedReader);
            Linear.closeQuietly(bufferedWriter);
            throw throwable;
        }
        Linear.closeQuietly(bufferedReader);
        Linear.closeQuietly(bufferedWriter);
    }
}

