/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nak.liblinear.Feature;
import nak.liblinear.FeatureNode;
import nak.liblinear.InvalidInputDataException;
import nak.liblinear.Linear;
import nak.liblinear.Model;
import nak.liblinear.Parameter;
import nak.liblinear.Problem;
import nak.liblinear.SolverType;

public class Train {
    private double bias = 1.0;
    private boolean cross_validation = false;
    private String inputFilename;
    private String modelFilename;
    private int nr_fold;
    private Parameter param = null;
    private Problem prob = null;

    public static void main(String[] stringArray) throws IOException, InvalidInputDataException {
        new Train().run(stringArray);
    }

    private void do_cross_validation() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = new double[this.prob.l];
        long l = System.currentTimeMillis();
        Linear.crossValidation(this.prob, this.param, this.nr_fold, dArray);
        long l2 = System.currentTimeMillis();
        System.out.println("time: " + (l2 - l) + " ms");
        if (this.param.solverType.isSupportVectorRegression()) {
            for (int i = 0; i < this.prob.l; ++i) {
                double d7 = this.prob.y[i];
                double d8 = dArray[i];
                d += (d8 - d7) * (d8 - d7);
                d2 += d8;
                d3 += d7;
                d4 += d8 * d8;
                d5 += d7 * d7;
                d6 += d8 * d7;
            }
            System.out.printf("Cross Validation Mean squared error = %g%n", d / (double)this.prob.l);
            System.out.printf("Cross Validation Squared correlation coefficient = %g%n", ((double)this.prob.l * d6 - d2 * d3) * ((double)this.prob.l * d6 - d2 * d3) / (((double)this.prob.l * d4 - d2 * d2) * ((double)this.prob.l * d5 - d3 * d3)));
        } else {
            int n = 0;
            for (int i = 0; i < this.prob.l; ++i) {
                if (dArray[i] != this.prob.y[i]) continue;
                ++n;
            }
            System.out.printf("correct: %d%n", n);
            System.out.printf("Cross Validation Accuracy = %g%%%n", 100.0 * (double)n / (double)this.prob.l);
        }
    }

    private void exit_with_help() {
        System.out.printf("Usage: train [options] training_set_file [model_file]%noptions:%n-s type : set type of solver (default 1)%n  for multi-class classification%n    0 -- L2-regularized logistic regression (primal)%n    1 -- L2-regularized L2-loss support vector classification (dual)%n    2 -- L2-regularized L2-loss support vector classification (primal)%n    3 -- L2-regularized L1-loss support vector classification (dual)%n    4 -- support vector classification by Crammer and Singer%n    5 -- L1-regularized L2-loss support vector classification%n    6 -- L1-regularized logistic regression%n    7 -- L2-regularized logistic regression (dual)%n  for regression%n   11 -- L2-regularized L2-loss support vector regression (primal)%n   12 -- L2-regularized L2-loss support vector regression (dual)%n   13 -- L2-regularized L1-loss support vector regression (dual)%n-c cost : set the parameter C (default 1)%n-p epsilon : set the epsilon in loss function of SVR (default 0.1)%n-e epsilon : set tolerance of termination criterion%n   -s 0 and 2%n       |f'(w)|_2 <= eps*min(pos,neg)/l*|f'(w0)|_2,%n       where f is the primal function and pos/neg are # of%n       positive/negative data (default 0.01)%n   -s 11%n       |f'(w)|_2 <= eps*|f'(w0)|_2 (default 0.001)%n   -s 1, 3, 4 and 7%n       Dual maximal violation <= eps; similar to libsvm (default 0.1)%n   -s 5 and 6%n       |f'(w)|_1 <= eps*min(pos,neg)/l*|f'(w0)|_1,%n       where f is the primal function (default 0.01)%n   -s 12 and 13\n       |f'(alpha)|_1 <= eps |f'(alpha0)|,\n       where f is the dual function (default 0.1)\n-B bias : if bias >= 0, instance x becomes [x; bias]; if < 0, no bias term added (default -1)%n-wi weight: weights adjust the parameter C of different classes (see README for details)%n-v n: n-fold cross validation mode%n-q : quiet mode (no outputs)%n", new Object[0]);
        System.exit(1);
    }

    Problem getProblem() {
        return this.prob;
    }

    double getBias() {
        return this.bias;
    }

    Parameter getParameter() {
        return this.param;
    }

    void parse_command_line(String[] stringArray) {
        int n;
        int n2;
        this.param = new Parameter(SolverType.L2R_L2LOSS_SVC_DUAL, 1.0, Double.POSITIVE_INFINITY, 0.1);
        this.bias = -1.0;
        this.cross_validation = false;
        block17: for (n2 = 0; n2 < stringArray.length && stringArray[n2].charAt(0) == '-'; ++n2) {
            if (++n2 >= stringArray.length) {
                this.exit_with_help();
            }
            switch (stringArray[n2 - 1].charAt(1)) {
                case 's': {
                    this.param.solverType = SolverType.getById(Linear.atoi(stringArray[n2]));
                    continue block17;
                }
                case 'c': {
                    this.param.setC(Linear.atof(stringArray[n2]));
                    continue block17;
                }
                case 'p': {
                    this.param.setP(Linear.atof(stringArray[n2]));
                    continue block17;
                }
                case 'e': {
                    this.param.setEps(Linear.atof(stringArray[n2]));
                    continue block17;
                }
                case 'B': {
                    this.bias = Linear.atof(stringArray[n2]);
                    continue block17;
                }
                case 'w': {
                    n = Linear.atoi(stringArray[n2 - 1].substring(2));
                    double d = Linear.atof(stringArray[n2]);
                    this.param.weightLabel = Train.addToArray(this.param.weightLabel, n);
                    this.param.weight = Train.addToArray(this.param.weight, d);
                    continue block17;
                }
                case 'v': {
                    this.cross_validation = true;
                    this.nr_fold = Linear.atoi(stringArray[n2]);
                    if (this.nr_fold >= 2) continue block17;
                    System.err.println("n-fold cross validation: n must >= 2");
                    this.exit_with_help();
                    continue block17;
                }
                case 'q': {
                    --n2;
                    Linear.disableDebugOutput();
                    continue block17;
                }
                default: {
                    System.err.println("unknown option");
                    this.exit_with_help();
                }
            }
        }
        if (n2 >= stringArray.length) {
            this.exit_with_help();
        }
        this.inputFilename = stringArray[n2];
        if (n2 < stringArray.length - 1) {
            this.modelFilename = stringArray[n2 + 1];
        } else {
            n = stringArray[n2].lastIndexOf(47);
            this.modelFilename = stringArray[n2].substring(++n) + ".model";
        }
        if (this.param.eps == Double.POSITIVE_INFINITY) {
            switch (this.param.solverType) {
                case L2R_LR: 
                case L2R_L2LOSS_SVC: {
                    this.param.setEps(0.01);
                    break;
                }
                case L2R_L2LOSS_SVR: {
                    this.param.setEps(0.001);
                    break;
                }
                case L2R_L2LOSS_SVC_DUAL: 
                case L2R_L1LOSS_SVC_DUAL: 
                case MCSVM_CS: 
                case L2R_LR_DUAL: {
                    this.param.setEps(0.1);
                    break;
                }
                case L1R_L2LOSS_SVC: 
                case L1R_LR: {
                    this.param.setEps(0.01);
                    break;
                }
                case L2R_L1LOSS_SVR_DUAL: 
                case L2R_L2LOSS_SVR_DUAL: {
                    this.param.setEps(0.1);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown solver type: " + (Object)((Object)this.param.solverType));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Problem readProblem(File file, double d) throws IOException, InvalidInputDataException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Feature[]> arrayList2 = new ArrayList<Feature[]>();
        int n = 0;
        int n2 = 0;
        try {
            Object object;
            while ((object = bufferedReader.readLine()) != null) {
                String string;
                ++n2;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \t\n\r\f:");
                try {
                    string = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new InvalidInputDataException("empty line", file, n2, (Exception)noSuchElementException);
                }
                try {
                    arrayList.add(Linear.atof(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputDataException("invalid label: " + string, file, n2, (Exception)numberFormatException);
                }
                int n3 = stringTokenizer.countTokens() / 2;
                Feature[] featureArray = d >= 0.0 ? new Feature[n3 + 1] : new Feature[n3];
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n5;
                    string = stringTokenizer.nextToken();
                    try {
                        n5 = Linear.atoi(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidInputDataException("invalid index: " + string, file, n2, (Exception)numberFormatException);
                    }
                    if (n5 < 0) {
                        throw new InvalidInputDataException("invalid index: " + n5, file, n2);
                    }
                    if (n5 <= n4) {
                        throw new InvalidInputDataException("indices must be sorted in ascending order", file, n2);
                    }
                    n4 = n5;
                    string = stringTokenizer.nextToken();
                    try {
                        double d2 = Linear.atof(string);
                        featureArray[i] = new FeatureNode(n5, d2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidInputDataException("invalid value: " + string, file, n2);
                    }
                }
                if (n3 > 0) {
                    n = Math.max(n, featureArray[n3 - 1].getIndex());
                }
                arrayList2.add(featureArray);
            }
            object = Train.constructProblem(arrayList, arrayList2, n, d);
            return object;
        }
        finally {
            bufferedReader.close();
        }
    }

    void readProblem(String string) throws IOException, InvalidInputDataException {
        this.prob = Train.readProblem(new File(string), this.bias);
    }

    private static int[] addToArray(int[] nArray, int n) {
        int n2 = nArray != null ? nArray.length : 0;
        int[] nArray2 = new int[n2 + 1];
        if (nArray != null && n2 > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        nArray2[n2] = n;
        return nArray2;
    }

    private static double[] addToArray(double[] dArray, double d) {
        int n = dArray != null ? dArray.length : 0;
        double[] dArray2 = new double[n + 1];
        if (dArray != null && n > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n);
        }
        dArray2[n] = d;
        return dArray2;
    }

    private static Problem constructProblem(List<Double> list, List<Feature[]> list2, int n, double d) {
        int n2;
        Problem problem = new Problem();
        problem.bias = d;
        problem.l = list.size();
        problem.n = n;
        if (d >= 0.0) {
            ++problem.n;
        }
        problem.x = new Feature[problem.l][];
        for (n2 = 0; n2 < problem.l; ++n2) {
            problem.x[n2] = list2.get(n2);
            if (!(d >= 0.0)) continue;
            assert (problem.x[n2][problem.x[n2].length - 1] == null);
            problem.x[n2][problem.x[n2].length - 1] = new FeatureNode(n + 1, d);
        }
        problem.y = new double[problem.l];
        for (n2 = 0; n2 < problem.l; ++n2) {
            problem.y[n2] = list.get(n2);
        }
        return problem;
    }

    private void run(String[] stringArray) throws IOException, InvalidInputDataException {
        this.parse_command_line(stringArray);
        this.readProblem(this.inputFilename);
        if (this.cross_validation) {
            this.do_cross_validation();
        } else {
            Model model = Linear.train(this.prob, this.param);
            Linear.saveModel(new File(this.modelFilename), model);
        }
    }
}

