/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools.maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.scalatest.tools.maven.MojoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractScalaTestMojo
extends AbstractMojo {
    MavenProject project;
    File testOutputDirectory;
    File outputDirectory;
    String runpath;
    String suites;
    String tests;
    String suffixes;
    String tagsToInclude;
    String tagsToExclude;
    String config;
    boolean parallel;
    String membersOnlySuites;
    String wildcardSuites;
    String testNGConfigFiles;
    String memoryFiles;
    String testsFiles;
    String jUnitClasses;
    String forkMode;
    String argLine;
    Map<String, String> environmentVariables;
    Map<String, String> systemProperties;
    boolean debugForkedProcess;
    String debugArgLine;
    int debuggerPort = 5005;
    int forkedProcessTimeoutInSeconds = 0;
    boolean logForkedProcessCommand;
    double spanScaleFactor = 1.0;

    AbstractScalaTestMojo() {
    }

    boolean runScalaTest(String[] args) throws MojoFailureException {
        this.getLog().debug((CharSequence)Arrays.toString(args));
        if (this.forkMode.equals("never")) {
            return this.runWithoutForking(args);
        }
        if (!this.forkMode.equals("once")) {
            this.getLog().error((CharSequence)("Invalid forkMode: \"" + this.forkMode + "\"; Using once instead."));
        }
        return this.runForkingOnce(args);
    }

    private boolean runWithoutForking(String[] args) {
        try {
            return (Boolean)this.run().invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new IllegalArgumentException(target);
        }
    }

    private boolean runForkingOnce(String[] args) throws MojoFailureException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.setExecutable("java");
        if (this.environmentVariables != null) {
            for (Map.Entry<String, String> entry : this.environmentVariables.entrySet()) {
                cli.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cli.addEnvironment("CLASSPATH", this.buildClassPathEnvironment());
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                cli.createArg().setValue(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        cli.createArg().setValue(String.format("-Dbasedir=%s", this.project.getBasedir().getAbsolutePath()));
        if (this.argLine != null) {
            cli.createArg().setLine(this.argLine);
        }
        if (this.debugForkedProcess) {
            cli.createArg().setLine(this.forkedProcessDebuggingArguments());
        }
        cli.createArg().setValue("org.scalatest.tools.Runner");
        for (String arg : args) {
            cli.createArg().setValue(arg);
        }
        String commandLogStatement = "Forking ScalaTest via: " + cli;
        if (this.logForkedProcessCommand) {
            this.getLog().info((CharSequence)commandLogStatement);
        } else {
            this.getLog().debug((CharSequence)commandLogStatement);
        }
        StreamConsumer streamConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                System.out.println(line);
            }
        };
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)streamConsumer, (StreamConsumer)streamConsumer, (int)this.forkedProcessTimeoutInSeconds);
            return result == 0;
        }
        catch (CommandLineTimeOutException e) {
            throw new MojoFailureException(String.format("Timed out after %d seconds waiting for forked process to complete.", this.forkedProcessTimeoutInSeconds));
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("Exception while executing forked process.", (Throwable)e);
        }
    }

    private String buildClassPathEnvironment() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String e : this.testClasspathElements()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(e);
        }
        return buf.toString();
    }

    private String forkedProcessDebuggingArguments() {
        if (this.debugArgLine == null) {
            return String.format("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=%s", this.debuggerPort);
        }
        return this.debugArgLine;
    }

    private Method run() {
        try {
            Class<?> runner = this.classLoader().loadClass("org.scalatest.tools.Runner");
            return runner.getMethod("run", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("scalatest is missing from classpath");
        }
    }

    private ClassLoader classLoader() {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String element : this.testClasspathElements()) {
                File file = new File(element);
                if (!file.isFile()) continue;
                urls.add(file.toURI().toURL());
            }
            URL[] u = urls.toArray(new URL[urls.size()]);
            return new URLClassLoader(u);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<String> testClasspathElements() {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    List<String> sharedConfiguration() {
        return new ArrayList<String>(){
            {
                this.addAll(AbstractScalaTestMojo.this.runpath());
                this.addAll(AbstractScalaTestMojo.this.config());
                this.addAll(AbstractScalaTestMojo.this.tagsToInclude());
                this.addAll(AbstractScalaTestMojo.this.tagsToExclude());
                this.addAll(AbstractScalaTestMojo.this.parallel());
                this.addAll(AbstractScalaTestMojo.this.tests());
                this.addAll(AbstractScalaTestMojo.this.suites());
                this.addAll(AbstractScalaTestMojo.this.suffixes());
                this.addAll(AbstractScalaTestMojo.this.membersOnlySuites());
                this.addAll(AbstractScalaTestMojo.this.wildcardSuites());
                this.addAll(AbstractScalaTestMojo.this.testNGConfigFiles());
                this.addAll(AbstractScalaTestMojo.this.memoryFiles());
                this.addAll(AbstractScalaTestMojo.this.testsFiles());
                this.addAll(AbstractScalaTestMojo.this.junitClasses());
                this.addAll(AbstractScalaTestMojo.this.spanScaleFactor());
            }
        };
    }

    private List<String> config() {
        ArrayList<String> c = new ArrayList<String>();
        for (String pair : MojoUtils.splitOnComma(this.config)) {
            c.add("-D" + pair);
        }
        return c;
    }

    private List<String> runpath() {
        return MojoUtils.compoundArg("-R", this.outputDirectory.getAbsolutePath(), this.testOutputDirectory.getAbsolutePath(), this.runpath);
    }

    private List<String> tagsToInclude() {
        return MojoUtils.compoundArg("-n", this.tagsToInclude);
    }

    private List<String> tagsToExclude() {
        return MojoUtils.compoundArg("-l", this.tagsToExclude);
    }

    private List<String> parallel() {
        return this.parallel ? Collections.singletonList("-P") : Collections.emptyList();
    }

    private List<String> suites() {
        ArrayList<String> list = new ArrayList<String>();
        for (String suite : MojoUtils.splitOnComma(this.suites)) {
            SuiteTestPair pair = new SuiteTestPair(suite);
            if (pair.suite == null) continue;
            list.add("-s");
            list.add(pair.suite);
            if (pair.test == null) continue;
            this.addTest(list, pair.test);
        }
        return list;
    }

    private void addTest(List list, String testParm) {
        String test;
        if (testParm != null && (test = testParm.trim()).length() > 0) {
            if (test.charAt(0) == '@') {
                String atTest = test.substring(1).trim();
                if (atTest.length() > 0) {
                    list.add("-t");
                    list.add(atTest);
                }
            } else {
                list.add("-z");
                list.add(test);
            }
        }
    }

    private List<String> tests() {
        ArrayList<String> list = new ArrayList<String>();
        for (String test : MojoUtils.splitOnComma(this.tests)) {
            this.addTest(list, test);
        }
        return list;
    }

    private List<String> spanScaleFactor() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.spanScaleFactor != 1.0) {
            list.add("-F");
            list.add(this.spanScaleFactor + "");
        }
        return list;
    }

    private List<String> suffixes() {
        return MojoUtils.compoundArg("-q", this.suffixes);
    }

    private List<String> membersOnlySuites() {
        return MojoUtils.suiteArg("-m", this.membersOnlySuites);
    }

    private List<String> wildcardSuites() {
        return MojoUtils.suiteArg("-w", this.wildcardSuites);
    }

    private List<String> testNGConfigFiles() {
        return MojoUtils.suiteArg("-b", this.testNGConfigFiles);
    }

    private List<String> memoryFiles() {
        return MojoUtils.suiteArg("-M", this.memoryFiles);
    }

    private List<String> testsFiles() {
        ArrayList<String> list = new ArrayList<String>();
        for (String param : MojoUtils.splitOnComma(this.testsFiles)) {
            File file = new File(param);
            if (!file.exists()) continue;
            list.add("-A");
            list.add(param);
        }
        return list;
    }

    private List<String> junitClasses() {
        return MojoUtils.suiteArg("-j", this.jUnitClasses);
    }

    private static class SuiteTestPair {
        String suite;
        String test;

        SuiteTestPair(String str) {
            String trimStr;
            if (str != null && (trimStr = str.trim()).length() > 0) {
                String[] splits = trimStr.split("(?s)\\s", 2);
                if (splits.length > 1) {
                    this.suite = splits[0];
                    this.test = splits[1].trim();
                } else {
                    this.suite = trimStr;
                }
            }
        }
    }
}

