/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.enablers;

import org.scalactic.Bad;
import org.scalactic.Good;
import org.scalactic.Or;
import org.scalatest.Exceptional$;
import org.scalatest.FutureOutcome;
import org.scalatest.Outcome;
import org.scalatest.Timer;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.SignalerTimeoutTask;
import org.scalatest.enablers.Timed;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.compat.Platform$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Timed$ {
    public static final Timed$ MODULE$;

    static {
        new Timed$();
    }

    public <T> Timed<T> timed() {
        return new Timed<T>(){

            public T timeoutAfter(Span timeout, Function0<T> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                Timer timer = new Timer();
                SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                timer.schedule(task, maxDuration);
                long startTime = Platform$.MODULE$.currentTime();
                try {
                    Outcome outcome;
                    Option<Throwable> option;
                    Object result = f.apply();
                    long endTime = Platform$.MODULE$.currentTime();
                    task.cancel();
                    timer.cancel();
                    Object object = result;
                    if (object instanceof Outcome && !(option = Exceptional$.MODULE$.unapply(outcome = (Outcome)object)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        throw ex;
                    }
                    if (task.timedOut() || endTime - startTime > maxDuration) {
                        Object object2 = task.needToResetInterruptedStatus() ? BoxesRunTime.boxToBoolean((boolean)Thread.interrupted()) : BoxedUnit.UNIT;
                        throw (Throwable)exceptionFun.apply((Object)None$.MODULE$);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (T)result;
                }
                catch (Throwable throwable) {
                    long endTime = Platform$.MODULE$.currentTime();
                    task.cancel();
                    timer.cancel();
                    if (task.timedOut() || endTime - startTime > maxDuration) {
                        Object object = task.needToResetInterruptedStatus() ? BoxesRunTime.boxToBoolean((boolean)Thread.interrupted()) : BoxedUnit.UNIT;
                        throw (Throwable)exceptionFun.apply((Object)new Some((Object)throwable));
                    }
                    throw throwable;
                }
            }
        };
    }

    public <T> Timed<Future<T>> timedFutureOf(ExecutionContext executionContext) {
        return new Timed<Future<T>>(executionContext){
            private final ExecutionContext executionContext$2;

            public Future<T> timeoutAfter(Span timeout, Function0<Future<T>> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                Timer timer = new Timer();
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                long startTime = Platform$.MODULE$.currentTime();
                try {
                    Future result = (Future)f.apply();
                    long endTime = Platform$.MODULE$.currentTime();
                    if (endTime - startTime > maxDuration) {
                        throw (Throwable)exceptionFun.apply((Object)None$.MODULE$);
                    }
                    Promise promise = Promise$.MODULE$.apply();
                    SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                    long delay = maxDuration - (Platform$.MODULE$.currentTime() - startTime);
                    Timer timer2 = new Timer();
                    result.onComplete((Function1)new Serializable(this, exceptionFun, maxDuration, startTime, promise, task, timer2){
                        public static final long serialVersionUID = 0L;
                        private final Function1 exceptionFun$1;
                        private final long maxDuration$1;
                        private final long startTime$1;
                        private final Promise promise$1;
                        private final SignalerTimeoutTask task$1;
                        private final Timer timer$1;

                        public final Object apply(Try<T> t) {
                            Try<T> try_;
                            block4: {
                                BoxedUnit boxedUnit;
                                block3: {
                                    long endTime;
                                    long duration;
                                    block2: {
                                        long endTime2;
                                        long duration2;
                                        try_ = t;
                                        if (!(try_ instanceof Success)) break block2;
                                        Success success2 = (Success)try_;
                                        Object r = success2.value();
                                        this.task$1.cancel();
                                        this.timer$1.cancel();
                                        boxedUnit = this.promise$1.isCompleted() ? BoxedUnit.UNIT : ((duration2 = (endTime2 = Platform$.MODULE$.currentTime()) - this.startTime$1) > this.maxDuration$1 ? this.promise$1.complete((Try)new Failure((Throwable)this.exceptionFun$1.apply((Object)None$.MODULE$))) : this.promise$1.success(r));
                                        break block3;
                                    }
                                    if (!(try_ instanceof Failure)) break block4;
                                    Failure failure2 = (Failure)try_;
                                    Throwable e = failure2.exception();
                                    this.task$1.cancel();
                                    this.timer$1.cancel();
                                    boxedUnit = this.promise$1.isCompleted() ? BoxedUnit.UNIT : ((duration = (endTime = Platform$.MODULE$.currentTime()) - this.startTime$1) > this.maxDuration$1 ? this.promise$1.complete((Try)new Failure((Throwable)this.exceptionFun$1.apply((Object)new Some((Object)e)))) : this.promise$1.failure(e));
                                }
                                return boxedUnit;
                            }
                            throw new MatchError(try_);
                        }
                        {
                            this.exceptionFun$1 = exceptionFun$1;
                            this.maxDuration$1 = maxDuration$1;
                            this.startTime$1 = startTime$1;
                            this.promise$1 = promise$1;
                            this.task$1 = task$1;
                            this.timer$1 = timer$1;
                        }
                    }, this.executionContext$2);
                    timer2.schedule(task, delay);
                    return promise.future();
                }
                catch (Throwable throwable) {
                    long endTime = Platform$.MODULE$.currentTime();
                    if (endTime - startTime > maxDuration) {
                        throw (Throwable)exceptionFun.apply((Object)new Some((Object)throwable));
                    }
                    throw throwable;
                }
            }
            {
                this.executionContext$2 = executionContext$2;
            }
        };
    }

    public Timed<FutureOutcome> timedFutureOutcome(ExecutionContext executionContext) {
        return new Timed<FutureOutcome>(executionContext){
            private final ExecutionContext executionContext$1;

            public FutureOutcome timeoutAfter(Span timeout, Function0<FutureOutcome> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                Timer timer = new Timer();
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                long startTime = Platform$.MODULE$.currentTime();
                FutureOutcome result = (FutureOutcome)f.apply();
                long endTime = Platform$.MODULE$.currentTime();
                if (endTime - startTime > maxDuration) {
                    throw (Throwable)exceptionFun.apply((Object)None$.MODULE$);
                }
                SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                long delay = maxDuration - (Platform$.MODULE$.currentTime() - startTime);
                FutureOutcome futureOutcome = result.onCompletedThen((Function1<Or<Outcome, Throwable>, BoxedUnit>)new Serializable(this, exceptionFun, timer, maxDuration, startTime, task){
                    public static final long serialVersionUID = 0L;
                    private final Function1 exceptionFun$2;
                    private final Timer timer$2;
                    private final long maxDuration$2;
                    private final long startTime$2;
                    private final SignalerTimeoutTask task$2;

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void apply(Or<Outcome, Throwable> t) {
                        Or<Outcome, Throwable> or = t;
                        if (or instanceof Good) {
                            this.task$2.cancel();
                            this.timer$2.cancel();
                            long endTime = Platform$.MODULE$.currentTime();
                            long duration = endTime - this.startTime$2;
                            if (duration > this.maxDuration$2) {
                                throw (Throwable)this.exceptionFun$2.apply((Object)None$.MODULE$);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        if (!(or instanceof Bad)) {
                            throw new MatchError(or);
                        }
                        Bad bad = (Bad)or;
                        Throwable e = (Throwable)bad.b();
                        this.task$2.cancel();
                        this.timer$2.cancel();
                        long endTime = Platform$.MODULE$.currentTime();
                        long duration = endTime - this.startTime$2;
                        if (duration > this.maxDuration$2) {
                            throw (Throwable)this.exceptionFun$2.apply((Object)None$.MODULE$);
                        }
                        throw e;
                    }
                    {
                        this.exceptionFun$2 = exceptionFun$2;
                        this.timer$2 = timer$2;
                        this.maxDuration$2 = maxDuration$2;
                        this.startTime$2 = startTime$2;
                        this.task$2 = task$2;
                    }
                }, this.executionContext$1);
                timer.schedule(task, delay);
                return futureOutcome;
            }
            {
                this.executionContext$1 = executionContext$1;
            }
        };
    }

    private Timed$() {
        MODULE$ = this;
    }
}

