/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.ScalaTestStatefulStatus;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.Location;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.exceptions.PayloadField;
import org.scalatest.junit.JUnitHelper$;
import org.scalatest.junit.Resources$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!\u0002\n\u0014\u0001UI\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011%\u0002!\u0011!Q\u0001\n)B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")a\t\u0001C\u0001\u000f\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002-\u0001A\u0003%\u0001\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003s\u0001\u0011\u00053\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u001a!9\u0011q\u0005\u0001\u0005\n\u0005%\"!D'z%VtG*[:uK:,'O\u0003\u0002\u0015+\u0005)!.\u001e8ji*\u0011acF\u0001\ng\u000e\fG.\u0019;fgRT\u0011\u0001G\u0001\u0004_J<7C\u0001\u0001\u001b!\tY\u0012%D\u0001\u001d\u0015\tib$\u0001\u0007o_RLg-[2bi&|gN\u0003\u0002 A\u00051!/\u001e8oKJT!\u0001F\f\n\u0005\tb\"a\u0003*v]2K7\u000f^3oKJ\faA]3q_J$8\u0001\u0001\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011\u0001BU3q_J$XM]\u0001\u0007G>tg-[4\u0011\t-\"tG\u000f\b\u0003YI\u0002\"!\f\u0019\u000e\u00039R!a\f\u0013\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0004\u001b\u0006\u0004(BA\u001a1!\tY\u0003(\u0003\u0002:m\t11\u000b\u001e:j]\u001e\u0004\"a\u000f\u001f\u000e\u0003AJ!!\u0010\u0019\u0003\u0007\u0005s\u00170\u0001\u0006uQ\u0016$&/Y2lKJ\u0004\"A\n!\n\u0005\u0005+\"a\u0002+sC\u000e\\WM]\u0001\u0007gR\fG/^:\u0011\u0005\u0019\"\u0015BA#\u0016\u0005]\u00196-\u00197b)\u0016\u001cHo\u0015;bi\u00164W\u000f\\*uCR,8/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011*[E*\u0014\t\u0003\u0013\u0002i\u0011a\u0005\u0005\u0006G\u0015\u0001\r!\n\u0005\u0006S\u0015\u0001\rA\u000b\u0005\u0006}\u0015\u0001\ra\u0010\u0005\u0006\u0005\u0016\u0001\raQ\u0001\fM\u0006LG.\u001a3UKN$8/F\u0001Q!\r\tfkN\u0007\u0002%*\u00111\u000bV\u0001\u0005kRLGNC\u0001V\u0003\u0011Q\u0017M^1\n\u0005]\u0013&aA*fi\u0006aa-Y5mK\u0012$Vm\u001d;tA\u0005qq-\u001a;U_B|e-T3uQ>$GcA.eMB\u00191\b\u00180\n\u0005u\u0003$\u0001B*p[\u0016\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u000b\u0002\r\u00154XM\u001c;t\u0013\t\u0019\u0007MA\u0006U_B|e-T3uQ>$\u0007\"B3\t\u0001\u00049\u0014!C2mCN\u001ch*Y7f\u0011\u00159\u0007\u00021\u00018\u0003)iW\r\u001e5pI:\u000bW.Z\u0001\fi\u0016\u001cHOR1jYV\u0014X\r\u0006\u0002k[B\u00111h[\u0005\u0003YB\u0012A!\u00168ji\")a.\u0003a\u0001_\u00069a-Y5mkJ,\u0007CA\u000eq\u0013\t\tHDA\u0004GC&dWO]3\u0002\u0019Q,7\u000f\u001e$j]&\u001c\b.\u001a3\u0015\u0005)$\b\"B;\u000b\u0001\u00041\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"a\u001e=\u000e\u0003yI!!\u001f\u0010\u0003\u0017\u0011+7o\u0019:jaRLwN\\\u0001\fi\u0016\u001cH/S4o_J,G\r\u0006\u0002ky\")Qo\u0003a\u0001m\u0006yA/Z:u%Vtg)\u001b8jg\",G\r\u0006\u0002k\u007f\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0011A\u0002:fgVdG\u000fE\u0002x\u0003\u000bI1!a\u0002\u001f\u0005\u0019\u0011Vm];mi\u0006qA/Z:u%Vt7\u000b^1si\u0016$Gc\u00016\u0002\u000e!)Q/\u0004a\u0001m\u0006YA/Z:u'R\f'\u000f^3e)\rQ\u00171\u0003\u0005\u0006k:\u0001\rA^\u0001\u0019)\u0016\u001bFk\u0018#F'\u000e\u0013\u0016\n\u0015+J\u001f:{\u0006+\u0011+U\u000bJsUCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010%\u0006)!/Z4fq&!\u00111EA\u000f\u0005\u001d\u0001\u0016\r\u001e;fe:\f\u0011\u0004V#T)~#UiU\"S\u0013B#\u0016j\u0014(`!\u0006#F+\u0012*OA\u0005!\u0002/\u0019:tKR+7\u000f\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!a\u000b\u00022A11(!\f8o]J1!a\f1\u0005\u0019!V\u000f\u001d7fg!)Q/\u0005a\u0001m\u0002")
public class MyRunListener
extends RunListener {
    private final Reporter report;
    private final Tracker theTracker;
    private final ScalaTestStatefulStatus status;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return new Some((Object)new TopOfMethod(className, new StringBuilder(15).append("public void ").append(className).append(".").append(methodName).append("()").toString()));
    }

    public void testFailure(Failure failure) {
        Option<Object> option;
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        Throwable throwableOrNull = failure.getException();
        None$ throwable = throwableOrNull != null ? new Some((Object)throwableOrNull) : None$.MODULE$;
        String message = throwableOrNull != null ? throwableOrNull.toString() : Resources$.MODULE$.jUnitTestFailed();
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        None$ none$ = throwable;
        if (none$ instanceof PayloadField) {
            None$ none$2 = none$;
            option = ((PayloadField)none$2).payload();
        } else {
            option = None$.MODULE$;
        }
        Option<Object> payload = option;
        this.report.apply(new TestFailed(this.theTracker.nextOrdinal(), message, testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), (Option<String>)None$.MODULE$, payload, TestFailed$.MODULE$.apply$default$15(), TestFailed$.MODULE$.apply$default$16()));
    }

    public void testFinished(Description description) {
        if (!this.failedTests().contains(description.getDisplayName())) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
            Tuple3 tuple33 = tuple32;
            String testName2 = (String)tuple33._1();
            String testClass2 = (String)tuple33._2();
            String testClassName2 = (String)tuple33._3();
            IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
            this.report.apply(new TestSucceeded(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestSucceeded$.MODULE$.apply$default$11(), TestSucceeded$.MODULE$.apply$default$12(), TestSucceeded$.MODULE$.apply$default$13(), TestSucceeded$.MODULE$.apply$default$14()));
        } else {
            this.status.setFailed();
        }
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        this.report.apply(new TestIgnored(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestIgnored$.MODULE$.apply$default$9(), TestIgnored$.MODULE$.apply$default$10(), TestIgnored$.MODULE$.apply$default$11()));
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        this.report.apply(new TestStarting(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestStarting$.MODULE$.apply$default$9(), TestStarting$.MODULE$.apply$default$10(), TestStarting$.MODULE$.apply$default$11(), TestStarting$.MODULE$.apply$default$12()));
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (!matcher.find()) {
            throw new RuntimeException(new StringBuilder(25).append("unexpected displayName [").append(description.getDisplayName()).append("]").toString());
        }
        String testName = matcher.group(1);
        String testClass = matcher.group(2);
        String testClassName = testClass.replaceAll(".*\\.", "");
        return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker, ScalaTestStatefulStatus status) {
        this.report = report;
        this.theTracker = theTracker;
        this.status = status;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

