/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator.impl;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rdf2go.RepositoryModel;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.nrl.validator.ModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.StandaloneValidator;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.exception.StandaloneValidatorException;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;
import org.semanticdesktop.nepomuk.openrdf.UnionMemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneValidatorImpl
implements StandaloneValidator {
    private Logger log = LoggerFactory.getLogger(StandaloneValidatorImpl.class);
    private Set<String> ontologies;
    private Sail baseSail;
    private Repository baseRepository;
    private InfSail infSail;
    private Repository infRepository;
    private org.openrdf.model.URI ontologiesInferenceClosureURI;
    private ModelTester[] testers;

    public StandaloneValidatorImpl() {
        this.initialize(null);
    }

    public StandaloneValidatorImpl(InfSail store) {
        this.initialize(store);
    }

    private void initialize(InfSail sail) {
        if (sail == null) {
            try {
                this.baseSail = new UnionMemoryStore();
                this.infSail = new InfSail(this.baseSail);
                this.infSail.initialize();
            }
            catch (Exception e) {
                this.log.error("Couldn't initialize a memory store", (Throwable)e);
            }
        } else {
            this.infSail = sail;
            this.baseSail = sail.getBaseSail();
        }
        this.infRepository = new SailRepository((Sail)this.infSail);
        this.baseRepository = new SailRepository(this.baseSail);
        this.ontologies = new TreeSet<String>();
        this.ontologiesInferenceClosureURI = null;
    }

    @Override
    public void addOntology(Reader reader, String syntax, String ontologyURI) throws StandaloneValidatorException {
        if (reader == null) {
            throw new NullPointerException("The reader cannot be null");
        }
        URIImpl uri = new URIImpl(ontologyURI);
        RDFFormat format = this.stringToFormat(syntax);
        Repository tempRepository = this.readFromReaderToTempRepository(reader, format, (org.openrdf.model.URI)uri);
        this.addTempRepositoryToRawRepository(tempRepository, (org.openrdf.model.URI)uri);
        this.ontologies.add(ontologyURI);
        if (this.ontologiesInferenceClosureURI != null) {
            this.refreshOntologiesInferenceClosure();
        }
    }

    @Override
    public void addOntology(InputStream stream, String syntax, String ontologyURI) throws StandaloneValidatorException {
        if (stream == null) {
            throw new NullPointerException("The stream cannot be null");
        }
        URIImpl uri = new URIImpl(ontologyURI);
        RDFFormat format = this.stringToFormat(syntax);
        Repository tempRepository = this.readFromStreamToTempRepository(stream, format, (org.openrdf.model.URI)uri);
        this.addTempRepositoryToRawRepository(tempRepository, (org.openrdf.model.URI)uri);
        this.ontologies.add(ontologyURI);
        if (this.ontologiesInferenceClosureURI != null) {
            this.refreshOntologiesInferenceClosure();
        }
    }

    @Override
    public void addOntology(Model model, String ontologyURI) throws StandaloneValidatorException {
        if (model == null) {
            throw new NullPointerException("The model cannot be null");
        }
        URIImpl uri = new URIImpl(ontologyURI);
        Repository tempRepository = this.readFromModelToTempRepository(model);
        this.addTempRepositoryToRawRepository(tempRepository, (org.openrdf.model.URI)uri);
        this.ontologies.add(ontologyURI);
        if (this.ontologiesInferenceClosureURI != null) {
            this.refreshOntologiesInferenceClosure();
        }
    }

    @Override
    public List<String> listOntologyUris() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.ontologies);
        return result;
    }

    @Override
    public void removeOntology(String uriString) throws StandaloneValidatorException {
        if (this.ontologies.contains(uriString)) {
            URIImpl uri = new URIImpl(uriString);
            this.removeGraph((org.openrdf.model.URI)uri);
            this.ontologies.remove(uriString);
            if (this.ontologiesInferenceClosureURI != null) {
                this.refreshOntologiesInferenceClosure();
            }
        } else {
            throw new StandaloneValidatorException("The URI: " + uriString + " does note denote an ontology within the validator");
        }
    }

    @Override
    public ValidationReport validate(String dataGraphContent, String syntax) throws StandaloneValidatorException {
        return this.performValidation(new StringReader(dataGraphContent), syntax);
    }

    @Override
    public ValidationReport validate(File file, String syntax) throws StandaloneValidatorException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            ValidationReport validationReport = this.performValidation(stream, syntax);
            return validationReport;
        }
        catch (Exception e) {
            throw new StandaloneValidatorException(e);
        }
        finally {
            this.closeStream(stream);
        }
    }

    @Override
    public ValidationReport validate(InputStream stream, String syntax) throws StandaloneValidatorException {
        return this.performValidation(stream, syntax);
    }

    @Override
    public ValidationReport validate(Reader reader, String syntax) throws StandaloneValidatorException {
        return this.performValidation(reader, syntax);
    }

    @Override
    public ValidationReport validate(Model model) throws StandaloneValidatorException {
        return this.performValidation(model, null);
    }

    private ValidationReport performValidation(Object inputStreamOrReaderOrModel, String syntax) throws StandaloneValidatorException {
        if (inputStreamOrReaderOrModel == null) {
            throw new StandaloneValidatorException("The InputStream or Reader parameter cannot be null");
        }
        this.checkTesterArray();
        if (this.ontologiesInferenceClosureURI == null) {
            this.refreshOntologiesInferenceClosure();
        }
        URIImpl dataUri = new URIImpl("urn:" + UUID.randomUUID().toString());
        URIImpl unionUri = new URIImpl("urn:" + UUID.randomUUID().toString());
        URIImpl semanticViewUri = new URIImpl("urn:" + UUID.randomUUID().toString());
        RepositoryModel dataModel = null;
        RepositoryModel semanticViewModel = null;
        try {
            RDFFormat format;
            Repository tempRepository = null;
            if (inputStreamOrReaderOrModel instanceof Reader) {
                format = this.stringToFormat(syntax);
                tempRepository = this.readFromReaderToTempRepository((Reader)inputStreamOrReaderOrModel, format, (org.openrdf.model.URI)dataUri);
            } else if (inputStreamOrReaderOrModel instanceof InputStream) {
                format = this.stringToFormat(syntax);
                tempRepository = this.readFromStreamToTempRepository((InputStream)inputStreamOrReaderOrModel, format, (org.openrdf.model.URI)dataUri);
            } else if (inputStreamOrReaderOrModel instanceof Model) {
                tempRepository = this.readFromModelToTempRepository((Model)inputStreamOrReaderOrModel);
            }
            this.addTempRepositoryToRawRepository(tempRepository, (org.openrdf.model.URI)dataUri);
            this.infSail.importGraph((Resource)unionUri, new Resource[]{dataUri, this.ontologiesInferenceClosureURI});
            this.infSail.createSemanticView((org.openrdf.model.URI)unionUri, (org.openrdf.model.URI)semanticViewUri, SemanticViewSpecification.getNRL());
            dataModel = new RepositoryModel((URI)new org.ontoware.rdf2go.model.node.impl.URIImpl(dataUri.toString()), this.infRepository);
            semanticViewModel = new RepositoryModel((URI)new org.ontoware.rdf2go.model.node.impl.URIImpl(semanticViewUri.toString()), this.infRepository);
            dataModel.open();
            semanticViewModel.open();
            ValidationReport report = this.testers[0].performTests((Model)semanticViewModel, (Model)dataModel);
            int i = 1;
            while (i < this.testers.length) {
                this.testers[i].performTests((Model)semanticViewModel, (Model)dataModel, report);
                ++i;
            }
            ValidationReport validationReport = report;
            this.closeModel((Model)dataModel);
            this.closeModel((Model)semanticViewModel);
            this.removeGraph((org.openrdf.model.URI)semanticViewUri);
            this.removeGraph((org.openrdf.model.URI)unionUri);
            this.removeGraph((org.openrdf.model.URI)dataUri);
            return validationReport;
        }
        catch (Exception e) {
            try {
                throw new StandaloneValidatorException(e);
            }
            catch (Throwable throwable) {
                this.closeModel((Model)dataModel);
                this.closeModel((Model)semanticViewModel);
                this.removeGraph((org.openrdf.model.URI)semanticViewUri);
                this.removeGraph((org.openrdf.model.URI)unionUri);
                this.removeGraph((org.openrdf.model.URI)dataUri);
                throw throwable;
            }
        }
    }

    private void checkTesterArray() throws StandaloneValidatorException {
        if (this.testers == null || this.testers.length == 0) {
            throw new StandaloneValidatorException("no model testers set");
        }
        int i = 0;
        while (i < this.testers.length) {
            if (this.testers[i] == null) {
                throw new StandaloneValidatorException("model tester number " + (i + 1) + " is null");
            }
            ++i;
        }
    }

    private void closeModel(Model model) {
        if (model != null) {
            try {
                model.close();
            }
            catch (Exception e) {
                this.log.warn("Couldn't close a model", (Throwable)e);
            }
        }
    }

    @Override
    public ModelTester[] getModelTesters() {
        return this.testers;
    }

    @Override
    public void setModelTesters(ModelTester ... testers) {
        this.testers = testers;
    }

    private void removeGraph(org.openrdf.model.URI graphUri) {
        try {
            this.infSail.removeGraph((Resource)graphUri);
        }
        catch (SailException se) {
            this.log.error("Couldn't remove a graph", (Throwable)se);
        }
    }

    /*
     * Exception decompiling
     */
    private void removeOntology(org.openrdf.model.URI graphUri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void refreshOntologiesInferenceClosure() throws StandaloneValidatorException {
        URIImpl tempOntologyUnionUri = new URIImpl("urn:" + UUID.randomUUID().toString());
        URIImpl tempOntologyViewUri = new URIImpl("urn:" + UUID.randomUUID().toString());
        Resource[] contexts = new Resource[this.ontologies.size()];
        Iterator<String> stringIterator = this.ontologies.iterator();
        int i = 0;
        while (i < contexts.length) {
            contexts[i] = new URIImpl(stringIterator.next());
            ++i;
        }
        RepositoryConnection connection = null;
        RepositoryResult statements = null;
        try {
            try {
                this.infSail.importGraph((Resource)tempOntologyUnionUri, contexts);
                this.infSail.createSemanticView((org.openrdf.model.URI)tempOntologyUnionUri, (org.openrdf.model.URI)tempOntologyViewUri, SemanticViewSpecification.getNRL());
                connection = this.infRepository.getConnection();
                if (this.ontologiesInferenceClosureURI != null) {
                    connection.clear(new Resource[]{this.ontologiesInferenceClosureURI});
                } else {
                    this.ontologiesInferenceClosureURI = new URIImpl("urn:" + UUID.randomUUID().toString());
                }
                statements = connection.getStatements(null, null, null, true, new Resource[]{tempOntologyViewUri});
                LinkedList<Statement> statementsToAdd = new LinkedList<Statement>();
                while (statements.hasNext()) {
                    statementsToAdd.add((Statement)statements.next());
                }
                this.closeIteration((CloseableIteration)statements);
                for (Statement statement : statementsToAdd) {
                    connection.add(statement, new Resource[]{this.ontologiesInferenceClosureURI});
                }
            }
            catch (SailException se) {
                throw new StandaloneValidatorException("Couldn't refresh the ontology union", se);
            }
            catch (RepositoryException re) {
                throw new StandaloneValidatorException("Couldn't refresh the ontology union", re);
            }
        }
        catch (Throwable throwable) {
            this.closeIteration((CloseableIteration)statements);
            this.closeConnection(connection);
            this.removeGraph((org.openrdf.model.URI)tempOntologyViewUri);
            this.removeGraph((org.openrdf.model.URI)tempOntologyUnionUri);
            throw throwable;
        }
        this.closeIteration((CloseableIteration)statements);
        this.closeConnection(connection);
        this.removeGraph((org.openrdf.model.URI)tempOntologyViewUri);
        this.removeGraph((org.openrdf.model.URI)tempOntologyUnionUri);
    }

    private Repository readFromStreamToTempRepository(InputStream stream, RDFFormat format, org.openrdf.model.URI baseURI) throws StandaloneValidatorException {
        SailRepository tempRepository = new SailRepository((Sail)new MemoryStore());
        RepositoryConnection tempConnection = null;
        try {
            try {
                tempRepository.initialize();
                tempConnection = tempRepository.getConnection();
                tempConnection.add(stream, baseURI.toString(), format, new Resource[0]);
            }
            catch (Exception e) {
                throw new StandaloneValidatorException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(tempConnection);
            throw throwable;
        }
        this.closeConnection(tempConnection);
        return tempRepository;
    }

    private Repository readFromReaderToTempRepository(Reader reader, RDFFormat format, org.openrdf.model.URI baseURI) throws StandaloneValidatorException {
        SailRepository tempRepository = new SailRepository((Sail)new MemoryStore());
        RepositoryConnection tempConnection = null;
        try {
            try {
                tempRepository.initialize();
                tempConnection = tempRepository.getConnection();
                tempConnection.add(reader, baseURI.toString(), format, new Resource[0]);
            }
            catch (Exception e) {
                throw new StandaloneValidatorException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(tempConnection);
            throw throwable;
        }
        this.closeConnection(tempConnection);
        return tempRepository;
    }

    private Repository readFromModelToTempRepository(Model inputModel) throws StandaloneValidatorException {
        SailRepository tempRepository = null;
        RepositoryModel tempModel = null;
        ClosableIterator iterator = null;
        try {
            try {
                tempRepository = new SailRepository((Sail)new MemoryStore());
                tempRepository.initialize();
                tempModel = new RepositoryModel((Repository)tempRepository);
                tempModel.open();
                iterator = inputModel.iterator();
                tempModel.addAll((Iterator)iterator);
            }
            catch (Exception e) {
                throw new StandaloneValidatorException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeClosableIterator(iterator);
            this.closeModel((Model)tempModel);
            throw throwable;
        }
        this.closeClosableIterator((ClosableIterator<? extends org.ontoware.rdf2go.model.Statement>)iterator);
        this.closeModel((Model)tempModel);
        return tempRepository;
    }

    private void addTempRepositoryToRawRepository(Repository tempRepository, org.openrdf.model.URI contextURI) {
        block5: {
            RepositoryConnection connection = null;
            RepositoryConnection tempConnection = null;
            RepositoryResult res = null;
            try {
                try {
                    connection = this.infRepository.getConnection();
                    tempConnection = tempRepository.getConnection();
                    res = tempConnection.getStatements(null, null, null, false, new Resource[0]);
                    connection.add((Iteration)res, new Resource[]{contextURI});
                }
                catch (RepositoryException e) {
                    this.log.warn("Couldn't add an ontology to the repository", (Throwable)e);
                    this.closeIteration((CloseableIteration)res);
                    this.closeConnection(tempConnection);
                    this.closeConnection(connection);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeIteration((CloseableIteration)res);
                this.closeConnection(tempConnection);
                this.closeConnection(connection);
                throw throwable;
            }
            this.closeIteration((CloseableIteration)res);
            this.closeConnection(tempConnection);
            this.closeConnection(connection);
        }
    }

    private RDFFormat stringToFormat(String string) {
        if (string == null) {
            throw new NullPointerException("the string cannot be null");
        }
        if (string.equals(RDFFormat.N3.getDefaultMIMEType())) {
            return RDFFormat.N3;
        }
        if (string.equals(RDFFormat.NTRIPLES.getDefaultMIMEType())) {
            return RDFFormat.NTRIPLES;
        }
        if (string.equals(RDFFormat.RDFXML.getDefaultMIMEType())) {
            return RDFFormat.RDFXML;
        }
        if (string.equals(RDFFormat.TURTLE.getDefaultMIMEType())) {
            return RDFFormat.TURTLE;
        }
        if (string.equals(RDFFormat.TRIX.getDefaultMIMEType())) {
            throw new UnsupportedRDFormatException("Context-aware syntaxes aren't supported at the moment");
        }
        if (string.equals(RDFFormat.TRIG.getDefaultMIMEType())) {
            throw new UnsupportedRDFormatException("Context-aware syntaxes aren't supported at the moment");
        }
        throw new UnsupportedRDFormatException(string);
    }

    private void closeConnection(RepositoryConnection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (RepositoryException re) {
                this.log.warn("Couldn't close a connection", (Throwable)re);
            }
        }
    }

    private void closeIteration(CloseableIteration iter) {
        if (iter != null) {
            try {
                iter.close();
            }
            catch (Exception e) {
                this.log.warn("Couldn't close an iteration", (Throwable)e);
            }
        }
    }

    private void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                this.log.warn("Couldn't close a stream", (Throwable)e);
            }
        }
    }

    private void closeClosableIterator(ClosableIterator<? extends org.ontoware.rdf2go.model.Statement> iterator) {
        if (iterator != null) {
            try {
                iterator.close();
            }
            catch (Exception e) {
                this.log.warn("Couldn't close a closable iterator", (Throwable)e);
            }
        }
    }
}

