/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator.testers;

import java.io.IOException;
import java.util.ArrayList;
import org.ontoware.aifbcommons.collection.ClosableIterable;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.nepomuk.nrl.validator.ModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationMessage;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.exception.ModelTesterException;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.XSDDatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRLClosedWorldModelTester
implements ModelTester {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NRL_NS = "http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#";
    private static final String NAO_NS = "http://www.semanticdesktop.org/ontologies/2007/08/15/nao#";
    private static final URI NRL_CARDINALITY_URI = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#cardinality");
    private static final URI NRL_MIN_CARDINALITY_URI = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#minCardinality");
    private static final URI NRL_MAX_CARDINALITY_URI = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#maxCardinality");
    private Model _unionModel;
    private Model _dataModel;
    private ValidationReport _report;

    @Override
    public ValidationReport performTests(Model unionModel, Model dataModel) throws ModelTesterException {
        ValidationReport report = new ValidationReport();
        this.performTests(unionModel, dataModel, report);
        return report;
    }

    @Override
    public void performTests(Model unionModel, Model dataModel, ValidationReport report) throws ModelTesterException {
        this._unionModel = unionModel;
        this._dataModel = dataModel;
        this._report = report;
        try {
            this.checkIsDefinedBy();
            this.checkBNodes();
            this.checkContainers();
            this.checkDomainsAndRanges();
            this.checkCardinality();
        }
        catch (Exception mqe) {
            throw new ModelTesterException(mqe);
        }
    }

    private void checkIsDefinedBy() throws IOException, ModelException, ModelRuntimeException {
        ClosableIterator iter = null;
        try {
            iter = this._dataModel.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDFS.isDefinedBy, (NodeOrVariable)Variable.ANY);
            while (iter.hasNext()) {
                Statement st = (Statement)iter.next();
                this.repErrInvD("RDFS.isDefinedBy is legal but not valid NRL", st);
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iter);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iter);
    }

    private void checkBNodes() throws ModelTesterException {
        String blankFilter = "FILTER ( isBlank(?s) || isBlank(?o) )";
        String sparqlQuery = "CONSTRUCT {?s ?p ?o} \n" + (this._dataModel.getContextURI() != null ? "WHERE { GRAPH <" + this._dataModel.getContextURI() + "> " + "{?s ?p ?o . " + blankFilter + "}} " : "WHERE { ?s ?p ?o . " + blankFilter + "} ");
        ClosableIterable iterable = null;
        ClosableIterator iterator = null;
        try {
            try {
                iterable = this._dataModel.sparqlConstruct(sparqlQuery);
                iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Statement st = (Statement)iterator.next();
                    this._report.addMessage(ValidationMessage.MessageType.WARNING, "INVALID DATA", "Blank Nodes are not valid NRL", st);
                }
            }
            catch (Exception e) {
                throw new ModelTesterException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
    }

    private void checkContainers() throws ModelTesterException {
        String containersFilter = "FILTER ( (?o = rdf:Bag) || (?o = rdf:Seq) || (?o = rdf:Alt))";
        String graph = "GRAPH <" + this._dataModel.getContextURI() + ">";
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nCONSTRUCT {?s ?p ?o} " + (this._dataModel.getContextURI() != null ? "WHERE { " + graph + " {?s ?p ?o . " + containersFilter + "}} " : "WHERE { ?s ?p ?o . " + containersFilter + "} ");
        ClosableIterable iterable = null;
        ClosableIterator iterator = null;
        try {
            try {
                iterable = this._dataModel.sparqlConstruct(query);
                iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Statement st = (Statement)iterator.next();
                    String subject = st.getSubject().toString();
                    String object = st.getObject().toString();
                    if (subject == null || object == null) continue;
                    if (object.toString().equals(RDF.Bag.toString())) {
                        this._report.addMessage(ValidationMessage.MessageType.WARNING, "CONTAINER WARNING", "RDF.Bag is not valid NRL", st);
                        continue;
                    }
                    if (object.toString().equals(RDF.Seq.toString())) {
                        this._report.addMessage(ValidationMessage.MessageType.WARNING, "CONTAINER WARNING", "RDF.Seq is not valid NRL", st);
                        continue;
                    }
                    if (!object.toString().equals(RDF.Alt.toString())) continue;
                    this._report.addMessage(ValidationMessage.MessageType.WARNING, "CONTAINER WARNING", "RDF.Alt is not valid NRL", st);
                }
            }
            catch (Exception e) {
                throw new ModelTesterException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
    }

    private void checkDomainsAndRanges() throws IOException {
        String predicateFilter = "FILTER (!(regex(str(?p), \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\")) &&!(regex(str(?p), \"http://www.w3.org/2000/01/rdf-schema#\")) &&!(regex(str(?p), \"http://www.semanticdesktop.org/ontologies/2007/08/15/nao#\")) &&!(regex(str(?p), \"http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#\")) &&!(regex(str(?p), \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\")))";
        String graph = "GRAPH <" + this._dataModel.getContextURI() + ">";
        String query = "CONSTRUCT {?s ?p ?o} " + (this._dataModel.getContextURI() != null ? "WHERE { " + graph + " {?s ?p ?o . " + predicateFilter + "}} " : "WHERE { ?s ?p ?o . " + predicateFilter + "} ");
        ClosableIterable iterable = null;
        ClosableIterator iterator = null;
        try {
            iterable = this._dataModel.sparqlConstruct(query);
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Statement st = (Statement)iterator.next();
                Resource propertySubject = st.getSubject();
                URI property = st.getPredicate();
                Node propertyValue = st.getObject();
                boolean propertyDefined = this.checkIfAResourceHasAGivenType((Resource)property, RDF.Property);
                if (propertyDefined) {
                    Resource propertyDomain = this.retrieve_domain((Resource)property);
                    Resource propertyRange = this.retrieve_range((Resource)property);
                    if (propertyDomain != null) {
                        this.checkDomain(st, property, propertySubject, propertyDomain);
                    }
                    if (propertyRange == null) continue;
                    this.checkRange(st, property, propertyValue, propertyRange);
                    continue;
                }
                this._report.addMessage(ValidationMessage.MessageType.WARNING, "CWA WARNING", "Property not defined, cannot be validated", st);
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
    }

    private void checkDomain(Statement st, URI property, Resource propertySubject, Resource propertyDomain) {
        if (propertyDomain == null) {
            this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Domain not specified for " + property, st);
        } else if (propertyDomain instanceof URI) {
            URI domainURI = (URI)propertyDomain;
            if (!this.checkIfAResourceHasAGivenType(propertySubject, domainURI)) {
                this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Property domain invalid", st);
            }
        } else {
            this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Property domain is a blank node", st);
        }
    }

    private void checkRange(Statement st, URI property, Node propertyValue, Resource propertyRange) {
        if (propertyRange == null) {
            this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID ONTOLOGY", "Range not specified for " + property, st);
        } else if (propertyRange instanceof URI) {
            URI rangeURI = (URI)propertyRange;
            if (propertyValue instanceof Resource) {
                if (!this.checkIfAResourceHasAGivenType((Resource)propertyValue, rangeURI)) {
                    this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Property range violated, the object should be an instance of " + rangeURI.toString(), st);
                }
            } else {
                this.checkLiteralRange((Literal)propertyValue, rangeURI, st);
            }
        } else {
            this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID ONTOLOGY", "Range of this property has been specified as a blank node", st);
        }
    }

    private boolean checkIfAResourceHasAGivenType(Resource resource, URI typeUri) {
        ClosableIterator iterator = null;
        try {
            iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)RDF.type, (NodeOrVariable)typeUri);
            if (iterator.hasNext()) {
                this.closeIterator((ClosableIterator<? extends Object>)iterator);
                return true;
            }
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
            return false;
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
    }

    private boolean checkLiteralRange(Literal value, URI expectedRange, Statement st) {
        boolean result = false;
        if (expectedRange.equals(RDFS.Literal)) {
            return true;
        }
        if (!expectedRange.toString().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            this.repErrInvD("The object of a statement should be an instance of " + expectedRange, st);
            return false;
        }
        if (expectedRange.equals(XSD._string) && (this.isLanguageLiteral(value) || this.isPlainLiteral(value))) {
            return true;
        }
        if (!this.isDatatypeLiteral(value)) {
            this.repErrInvD("Expected literal with a datatype xsd:" + this.getLocalName(expectedRange), st);
            return false;
        }
        DatatypeLiteral dataTypeLit = value.asDatatypeLiteral();
        URI typeUri = dataTypeLit.getDatatype();
        if (typeUri != null) {
            if (typeUri.equals(XSD._duration)) {
                this._report.addMessage(ValidationMessage.MessageType.WARNING, "xsd:duration warning", "Usage of xsd:duration datatype is discouraged.", st);
            }
            boolean typeCorrect = XSDDatatypeHelper.isCorrect(dataTypeLit.getDatatype(), expectedRange);
            boolean stringCorrect = XSDDatatypeHelper.isCorrectString(dataTypeLit);
            if (typeCorrect && stringCorrect) {
                return true;
            }
            if (!typeCorrect) {
                this.repErrInvD("Literal datatype invalid, expected xsd:" + this.getLocalName(expectedRange), st);
                result = false;
            } else if (!stringCorrect) {
                this.repErrInvD("The literal is invalid for the given datatype", st);
                result = false;
            }
        } else {
            this.repErrInvD("Expected datatype literal", st);
            result = false;
        }
        return result;
    }

    private String getLocalName(URI typeUri) {
        String string = typeUri.toString();
        int hashIndex = string.indexOf(35);
        if (hashIndex == -1) {
            hashIndex = string.lastIndexOf(47);
        }
        if (hashIndex != -1) {
            return string.substring(hashIndex + 1, string.length());
        }
        return "";
    }

    private boolean isPlainLiteral(Literal value) {
        try {
            PlainLiteral plLit = (PlainLiteral)value;
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private void repErrInvD(String string, Statement st) {
        this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", string, st);
    }

    private boolean isDatatypeLiteral(Literal value) {
        try {
            DatatypeLiteral dataTypeLit = value.asDatatypeLiteral();
            return dataTypeLit.getDatatype() != null;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private boolean isLanguageLiteral(Literal value) {
        try {
            LanguageTagLiteral langLit = value.asLanguageTagLiteral();
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource retrieve_range(Resource resource) {
        ClosableIterator iterator = null;
        try {
            iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)RDFS.range, (NodeOrVariable)Variable.ANY);
            if (!iterator.hasNext()) {
                this._report.addMessage(ValidationMessage.MessageType.WARNING, "Ontology warning", "The property " + resource + " doesn't have a range", new Statement[0]);
            } else {
                Statement st = (Statement)iterator.next();
                Node node = st.getObject();
                if (node instanceof Resource) {
                    Resource resource2 = (Resource)node;
                    this.closeIterator((ClosableIterator<? extends Object>)iterator);
                    return resource2;
                }
                this.logger.warn("Weird, range of " + resource + " is a blank node");
            }
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
            return null;
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource retrieve_domain(Resource resource) {
        ClosableIterator iterator = null;
        try {
            iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)RDFS.domain, (NodeOrVariable)Variable.ANY);
            if (!iterator.hasNext()) {
                this._report.addMessage(ValidationMessage.MessageType.ERROR, "Ontology error", "The property " + resource + " doesn't have a domain", new Statement[0]);
            } else {
                Statement st = (Statement)iterator.next();
                Node node = st.getObject();
                if (node instanceof Resource) {
                    Resource resource2 = (Resource)node;
                    this.closeIterator((ClosableIterator<? extends Object>)iterator);
                    return resource2;
                }
                this.logger.warn("Weird, domain of " + resource + " is a blank node");
            }
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
            return null;
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int retrieveMinCardinality(Resource resource) {
        ClosableIterator iterator;
        block5: {
            iterator = null;
            try {
                iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)NRL_MIN_CARDINALITY_URI, (NodeOrVariable)Variable.ANY);
                if (!iterator.hasNext()) {
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeIterator(iterator);
                throw throwable;
            }
            {
                Statement st = (Statement)iterator.next();
                Node node = st.getObject();
                if (!(node instanceof Literal)) {
                    this.logger.warn("Weird, minimum cardinality of " + resource + " is not a literal");
                    break block5;
                }
                if (!this.checkLiteralRange(node.asLiteral(), RDFS.Literal, st)) break block5;
                int n = Integer.parseInt(node.asLiteral().getValue());
                this.closeIterator((ClosableIterator<? extends Object>)iterator);
                return n;
            }
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int retrieveMaxCardinality(Resource resource) {
        ClosableIterator iterator;
        block5: {
            iterator = null;
            try {
                iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)NRL_MAX_CARDINALITY_URI, (NodeOrVariable)Variable.ANY);
                if (!iterator.hasNext()) {
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeIterator(iterator);
                throw throwable;
            }
            {
                Statement st = (Statement)iterator.next();
                Node node = st.getObject();
                if (!(node instanceof Literal)) {
                    this.logger.warn("Weird, maximum cardinality of " + resource + " is not a literal");
                    break block5;
                }
                if (!this.checkLiteralRange(node.asLiteral(), RDFS.Literal, st)) break block5;
                int n = Integer.parseInt(node.asLiteral().getValue());
                this.closeIterator((ClosableIterator<? extends Object>)iterator);
                return n;
            }
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int retrieveCardinality(Resource resource) {
        ClosableIterator iterator;
        block5: {
            iterator = null;
            try {
                iterator = this._unionModel.findStatements((ResourceOrVariable)resource, (UriOrVariable)NRL_CARDINALITY_URI, (NodeOrVariable)Variable.ANY);
                if (!iterator.hasNext()) {
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeIterator(iterator);
                throw throwable;
            }
            {
                Statement st = (Statement)iterator.next();
                Node node = st.getObject();
                if (!(node instanceof Literal)) {
                    this.logger.warn("Weird, cardinality of " + resource + " is not a literal");
                    break block5;
                }
                if (!this.checkLiteralRange(node.asLiteral(), RDFS.Literal, st)) break block5;
                int n = Integer.parseInt(node.asLiteral().getValue());
                this.closeIterator((ClosableIterator<? extends Object>)iterator);
                return n;
            }
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return 0;
    }

    private void checkCardinality() {
        String predicateFilter = "FILTER (!(regex(str(?p), \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\")) &&!(regex(str(?p), \"http://www.w3.org/2000/01/rdf-schema#\")) &&!(regex(str(?p), \"http://www.semanticdesktop.org/ontologies/2007/08/15/nao#\")) &&!(regex(str(?p), \"http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#\")) &&!(regex(str(?p), \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\")))";
        String graph = "GRAPH <" + this._dataModel.getContextURI() + ">";
        String query = "SELECT DISTINCT ?s ?p " + (this._dataModel.getContextURI() != null ? "WHERE { " + graph + " { ?s ?p ?o . " + predicateFilter + "}} " : "WHERE { ?s ?p ?o . " + predicateFilter + "} ");
        QueryResultTable iterable = null;
        ClosableIterator iterator = null;
        try {
            iterable = this._dataModel.sparqlSelect(query);
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                QueryRow row = (QueryRow)iterator.next();
                URI s = row.getValue("s").asURI();
                URI p = row.getValue("p").asURI();
                Statement[] statements = this.retrieveStatementBlock((Resource)s, p);
                boolean propertyDefined = this.checkIfAResourceHasAGivenType((Resource)p, RDF.Property);
                if (propertyDefined) {
                    int propertyCard = this.retrieveCardinality((Resource)p);
                    int propertyMinCard = this.retrieveMinCardinality((Resource)p);
                    int propertyMaxCard = this.retrieveMaxCardinality((Resource)p);
                    if (propertyCard > 0 && statements.length != propertyCard) {
                        this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Cardinality for " + p + " must be " + propertyCard, statements);
                    }
                    if (propertyCard > 0 && (propertyMinCard > 0 || propertyMaxCard > 0)) {
                        this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Property " + p + " cannot have a fixed cardinality and a minimum " + "or maximum cardinality", statements);
                    }
                    if (propertyMinCard > 0 && propertyMaxCard > 0 && propertyMinCard > propertyMaxCard) {
                        this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Minimum cardinality cannot be higher than maximum cardinality for " + p, statements);
                    }
                    if (propertyMinCard > 0 && statements.length < propertyMinCard) {
                        this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Minimum cardinality for " + p + " is " + propertyMinCard, statements);
                    }
                    if (propertyMaxCard <= 0 || statements.length <= propertyMaxCard) continue;
                    this._report.addMessage(ValidationMessage.MessageType.ERROR, "INVALID DATA", "Maximum cardinality for " + p + " is " + propertyMaxCard, statements);
                    continue;
                }
                this._report.addMessage(ValidationMessage.MessageType.WARNING, "CWA WARNING", "Property not defined, cannot be validated", statements);
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
    }

    private Statement[] retrieveStatementBlock(Resource s, URI p) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String graph = "GRAPH <" + this._dataModel.getContextURI() + ">";
        String query = "CONSTRUCT {" + s.toSPARQL() + " " + p.toSPARQL() + " ?o} " + (this._dataModel.getContextURI() != null ? "WHERE { " + graph + " {" + s.toSPARQL() + " " + p.toSPARQL() + " ?o . }} " : "WHERE { ?s ?p ?o . } ");
        ClosableIterable iterable = null;
        ClosableIterator iterator = null;
        try {
            iterable = this._dataModel.sparqlConstruct(query);
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                statements.add((Statement)iterator.next());
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        Statement[] array = statements.toArray(new Statement[statements.size()]);
        return array;
    }

    private void closeIterator(ClosableIterator<? extends Object> iter) {
        if (iter != null) {
            try {
                iter.close();
            }
            catch (Exception e) {
                this.logger.warn("Couldn't close an iterator", (Throwable)e);
            }
        }
    }
}

