/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.DatatypeValueChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.BooleanChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.DateChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.DateTimeChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.DayTimeDurationChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.DecimalChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.DurationChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.IntegerChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.LongChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.NonNegativeIntegerChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.PositiveIntegerChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.StringChecker;
import org.semanticdesktop.nepomuk.nrl.validator.xsdhelpers.checkers.YearMonthDurationChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDatatypeHelper {
    public static final URI XSD_DAY_TIME_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    public static final URI XSD_YEAR_MONTH_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#yearMonthDuration");
    private static Map<URI, Set<URI>> ancestorsMap = XSDDatatypeHelper.prepareAncestorsMap();
    private static CheckersMap checkersMap = XSDDatatypeHelper.prepareCheckersMap();

    public static boolean isCorrect(URI actualType, URI formalType) {
        Set<URI> ancestorsSet = null;
        if (actualType.equals(formalType)) {
            return true;
        }
        ancestorsSet = ancestorsMap.get(actualType);
        if (ancestorsSet != null) {
            return ancestorsSet.contains(formalType);
        }
        return false;
    }

    public static boolean isCorrectString(DatatypeLiteral literal) {
        URI type = literal.getDatatype();
        String value = literal.getValue();
        DatatypeValueChecker checker = (DatatypeValueChecker)checkersMap.get(type);
        if (checker == null) {
            throw new RuntimeException("No checker found for type " + type);
        }
        return checker.checkString(value);
    }

    private static Map<URI, Set<URI>> prepareAncestorsMap() {
        HashMap<URI, Set<URI>> result = new HashMap<URI, Set<URI>>();
        result.put(XSD._normalizedString, XSDDatatypeHelper.createSet(XSD._string));
        result.put(XSD._token, XSDDatatypeHelper.createSet(XSD._normalizedString, XSD._string));
        result.put(XSD._language, XSDDatatypeHelper.createSet(XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._Name, XSDDatatypeHelper.createSet(XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._NCName, XSDDatatypeHelper.createSet(XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._ID, XSDDatatypeHelper.createSet(XSD._NCName, XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._IDREF, XSDDatatypeHelper.createSet(XSD._NCName, XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._IDREFS, XSDDatatypeHelper.createSet(XSD._IDREF, XSD._NCName, XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._ENTITY, XSDDatatypeHelper.createSet(XSD._NCName, XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._ENTITIES, XSDDatatypeHelper.createSet(XSD._ENTITY, XSD._NCName, XSD._Name, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._NMTOKEN, XSDDatatypeHelper.createSet(XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._NMTOKENS, XSDDatatypeHelper.createSet(XSD._NMTOKEN, XSD._token, XSD._normalizedString, XSD._string));
        result.put(XSD._integer, XSDDatatypeHelper.createSet(XSD._decimal));
        result.put(XSD._nonPositiveInteger, XSDDatatypeHelper.createSet(XSD._integer, XSD._decimal));
        result.put(XSD._negativeInteger, XSDDatatypeHelper.createSet(XSD._nonPositiveInteger, XSD._integer, XSD._decimal));
        result.put(XSD._long, XSDDatatypeHelper.createSet(XSD._integer, XSD._decimal));
        result.put(XSD._int, XSDDatatypeHelper.createSet(XSD._long, XSD._integer, XSD._decimal));
        result.put(XSD._short, XSDDatatypeHelper.createSet(XSD._int, XSD._long, XSD._integer, XSD._decimal));
        result.put(XSD._byte, XSDDatatypeHelper.createSet(XSD._short, XSD._int, XSD._long, XSD._integer, XSD._decimal));
        result.put(XSD._nonNegativeInteger, XSDDatatypeHelper.createSet(XSD._integer, XSD._decimal));
        result.put(XSD._unsignedLong, XSDDatatypeHelper.createSet(XSD._nonNegativeInteger, XSD._integer, XSD._decimal));
        result.put(XSD._positiveInteger, XSDDatatypeHelper.createSet(XSD._nonNegativeInteger, XSD._integer, XSD._decimal));
        result.put(XSD._unsignedInt, XSDDatatypeHelper.createSet(XSD._unsignedLong, XSD._nonNegativeInteger, XSD._integer, XSD._decimal));
        result.put(XSD._unsignedShort, XSDDatatypeHelper.createSet(XSD._unsignedInt, XSD._unsignedLong, XSD._nonNegativeInteger, XSD._integer, XSD._decimal));
        result.put(XSD._unsignedByte, XSDDatatypeHelper.createSet(XSD._unsignedShort, XSD._unsignedInt, XSD._unsignedLong, XSD._nonNegativeInteger, XSD._integer, XSD._decimal));
        result.put(XSD_DAY_TIME_DURATION, XSDDatatypeHelper.createSet(XSD._duration));
        result.put(XSD_YEAR_MONTH_DURATION, XSDDatatypeHelper.createSet(XSD._duration));
        return result;
    }

    private static CheckersMap prepareCheckersMap() {
        CheckersMap checkers = new CheckersMap();
        checkers.putChecker(new BooleanChecker());
        checkers.putChecker(new DateTimeChecker());
        checkers.putChecker(new DecimalChecker());
        checkers.putChecker(new IntegerChecker());
        checkers.putChecker(new LongChecker());
        checkers.putChecker(new NonNegativeIntegerChecker());
        checkers.putChecker(new PositiveIntegerChecker());
        checkers.putChecker(new StringChecker());
        checkers.putChecker(new DateChecker());
        checkers.putChecker(new DurationChecker());
        checkers.putChecker(new DayTimeDurationChecker());
        checkers.putChecker(new YearMonthDurationChecker());
        return checkers;
    }

    private static Set<URI> createSet(URI ... uris) {
        HashSet<URI> result = new HashSet<URI>();
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            result.add(uri);
            ++n2;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckersMap
    extends HashMap<URI, DatatypeValueChecker> {
        public void putChecker(DatatypeValueChecker checker) {
            this.put(checker.getType(), checker);
        }
    }
}

