/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.node.impl;

import java.net.URISyntaxException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.NodeUtils;
import org.ontoware.rdf2go.model.node.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIImpl
extends ResourceImpl
implements URI {
    private static final Logger log = LoggerFactory.getLogger(URIImpl.class);
    private String uriString;

    public URIImpl(String uriString) {
        this(uriString, true);
    }

    public URIImpl(String uriString, boolean createURIWithChecking) {
        if (createURIWithChecking) {
            try {
                new java.net.URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.uriString = uriString;
    }

    public static URI create(String uriString) {
        return new URIImpl(uriString);
    }

    public static URI createURIWithoutChecking(String uriString) {
        return new URIImpl(uriString, false);
    }

    public String toString() {
        return this.uriString;
    }

    public URI asURI() throws ClassCastException {
        return this;
    }

    public BlankNode asBlankNode() throws ClassCastException {
        throw new ClassCastException("Cannot cast a URI to a BlankNode");
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        log.debug("comparing for equal: " + this + " and " + other + " of type " + other.getClass());
        if (other instanceof URI) {
            boolean equal = ((URI)other).toString().equals(this.toString());
            log.debug("they are equal? " + equal);
            return equal;
        }
        log.debug("URIImpl cannot compare with type " + other.getClass() + " so this is false");
        return false;
    }

    public java.net.URI toJavaURI() throws URISyntaxException {
        return new java.net.URI(this.uriString);
    }

    public int hashCode() {
        return this.uriString.hashCode();
    }

    public int compareTo(Node other) {
        if (other instanceof URI) {
            return this.uriString.compareTo(((URI)other).toString());
        }
        return NodeUtils.compareByType(this, other);
    }

    public String toSPARQL() {
        return "<" + this.uriString + ">";
    }

    public java.net.URI asJavaURI() {
        try {
            return new java.net.URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new ModelRuntimeException(e);
        }
    }
}

