/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util.transform;

import java.util.Iterator;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Diff;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.impl.DiffImpl;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.util.transform.TransformerRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceSearchReplaceRule
implements TransformerRule {
    private String searchURIPrefix;
    private String replaceURIPrefix;

    public NamespaceSearchReplaceRule(String searchURIPrefix, String replaceURIPrefix) {
        this.searchURIPrefix = searchURIPrefix;
        this.replaceURIPrefix = replaceURIPrefix;
    }

    @Override
    public void applyRule(Model model, Map<String, URI> namespaceMap) {
        NamespaceSearchReplaceRule.searchAndReplace(model, this.searchURIPrefix, this.replaceURIPrefix);
    }

    public static void searchAndReplace(Model model, String searchURIPrefix, String replaceURIPrefix) {
        Model add = RDF2Go.getModelFactory().createModel();
        add.open();
        Model remove = RDF2Go.getModelFactory().createModel();
        remove.open();
        ClosableIterator it = model.iterator();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            Resource s = stmt.getSubject();
            URI p = stmt.getPredicate();
            Node o = stmt.getObject();
            boolean match = false;
            if (s instanceof URI && s.asURI().toString().startsWith(searchURIPrefix)) {
                match = true;
                String sURI = s.asURI().toString().replace(searchURIPrefix, replaceURIPrefix);
                s = new URIImpl(sURI);
            }
            if (p.toString().startsWith(searchURIPrefix)) {
                match = true;
                String pURI = p.toString().replace(searchURIPrefix, replaceURIPrefix);
                p = new URIImpl(pURI);
            }
            if (o instanceof URI && o.asURI().toString().startsWith(searchURIPrefix)) {
                match = true;
                String oURI = o.asURI().toString().replace(searchURIPrefix, replaceURIPrefix);
                o = new URIImpl(oURI);
            }
            if (!match) continue;
            remove.addStatement(stmt);
            add.addStatement(s, p, o);
        }
        it.close();
        ClosableIterator addIt = add.iterator();
        ClosableIterator removeIt = remove.iterator();
        model.update((Diff)new DiffImpl((Iterator)addIt, (Iterator)removeIt));
        addIt.close();
        removeIt.close();
        add.close();
        remove.close();
    }
}

