/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.pebble;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.connector.NetworkSettings;

public class PebbleHttpConnector
extends HttpConnector {
    private static final AtomicReference<SSLContext> SSL_CONTEXT_REF = new AtomicReference();

    public PebbleHttpConnector(NetworkSettings settings) {
        super(settings);
    }

    @Override
    public HttpClient.Builder createClientBuilder() {
        HttpClient.Builder builder = super.createClientBuilder();
        builder.sslContext(this.createSSLContext());
        return builder;
    }

    protected SSLContext createSSLContext() {
        if (SSL_CONTEXT_REF.get() == null) {
            try (InputStream in = this.getClass().getResourceAsStream("/org/shredzone/acme4j/provider/pebble/pebble.truststore");){
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(in, "acme4j".toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keystore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), null);
                SSL_CONTEXT_REF.set(sslContext);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new RuntimeException("Could not create truststore", ex);
            }
        }
        return Objects.requireNonNull(SSL_CONTEXT_REF.get());
    }
}

