/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import junit.framework.TestCase;
import org.slf4j.helpers.MessageFormatter;

public class MessageFormatterTest
extends TestCase {
    Integer i1 = new Integer(1);
    Integer i2 = new Integer(2);
    Integer i3 = new Integer(3);
    Integer[] ia0 = new Integer[]{this.i1, this.i2, this.i3};
    Integer[] ia1 = new Integer[]{new Integer(10), new Integer(20), new Integer(30)};

    public void testNull() {
        String result = MessageFormatter.format(null, (Object)this.i1);
        MessageFormatterTest.assertEquals(null, (String)result);
    }

    public void testNullParam() {
        String result = MessageFormatter.format((String)"Value is {}.", null);
        MessageFormatterTest.assertEquals((String)"Value is null.", (String)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, null);
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null.", (String)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", (Object)this.i1, null);
        MessageFormatterTest.assertEquals((String)"Val1 is 1, val2 is null.", (String)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is 2.", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, null});
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null, val3 is null", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, this.i2, this.i3});
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is 2, val3 is 3", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, this.i3});
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null, val3 is 3", (String)result);
    }

    public void testOneParameter() {
        String result = MessageFormatter.format((String)"Value is {}.", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"Value is 3.", (String)result);
        result = MessageFormatter.format((String)"Value is {", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"Value is {", (String)result);
        result = MessageFormatter.format((String)"{} is larger than 2.", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"3 is larger than 2.", (String)result);
        result = MessageFormatter.format((String)"No subst", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"No subst", (String)result);
        result = MessageFormatter.format((String)"Incorrect {subst", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"Incorrect {subst", (String)result);
        result = MessageFormatter.format((String)"Value is {bla} {}", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"Value is {bla} 3", (String)result);
        result = MessageFormatter.format((String)"Escaped \\{} subst", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"Escaped {} subst", (String)result);
        result = MessageFormatter.format((String)"{Escaped", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"{Escaped", (String)result);
        result = MessageFormatter.format((String)"\\{}Escaped", (Object)this.i3);
        MessageFormatterTest.assertEquals((String)"{}Escaped", (String)result);
        result = MessageFormatter.format((String)"File name is {{}}.", (Object)"App folder.zip");
        MessageFormatterTest.assertEquals((String)"File name is {App folder.zip}.", (String)result);
        result = MessageFormatter.format((String)"File name is C:\\\\{}.", (Object)"App folder.zip");
        MessageFormatterTest.assertEquals((String)"File name is C:\\App folder.zip.", (String)result);
    }

    public void testTwoParameters() {
        String result = MessageFormatter.format((String)"Value {} is smaller than {}.", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2.", (String)result);
        result = MessageFormatter.format((String)"Value {} is smaller than {}", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2", (String)result);
        result = MessageFormatter.format((String)"{}{}", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"12", (String)result);
        result = MessageFormatter.format((String)"Val1={}, Val2={", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Val1=1, Val2={", (String)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{}", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {}", (String)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{} tail", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {} tail", (String)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than \\{", (String)result);
        result = MessageFormatter.format((String)"Value {} is smaller than {tail", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {tail", (String)result);
        result = MessageFormatter.format((String)"Value \\{} is smaller than {}", (Object)this.i1, (Object)this.i2);
        MessageFormatterTest.assertEquals((String)"Value {} is smaller than 1", (String)result);
    }

    public void testNullArray() {
        String msg0 = "msg0";
        String msg1 = "msg1 {}";
        String msg2 = "msg2 {} {}";
        String msg3 = "msg3 {} {} {}";
        Object[] args = null;
        String result = MessageFormatter.arrayFormat((String)msg0, args);
        MessageFormatterTest.assertEquals((String)msg0, (String)result);
        result = MessageFormatter.arrayFormat((String)msg1, args);
        MessageFormatterTest.assertEquals((String)msg1, (String)result);
        result = MessageFormatter.arrayFormat((String)msg2, args);
        MessageFormatterTest.assertEquals((String)msg2, (String)result);
        result = MessageFormatter.arrayFormat((String)msg3, args);
        MessageFormatterTest.assertEquals((String)msg3, (String)result);
    }

    public void testArrayFormat() {
        String result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2 and 3.", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"123", (String)result);
        result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2.", (String)result);
        result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Val=1, {, Val=2", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Val=1, {, Val=2", (String)result);
        result = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])this.ia0);
        MessageFormatterTest.assertEquals((String)"Val1=1, Val2={", (String)result);
    }

    public void testArrayValues() {
        Integer p0 = this.i1;
        Integer[] p1 = new Integer[]{this.i2, this.i3};
        String result = MessageFormatter.format((String)"{}{}", (Object)p0, (Object)p1);
        MessageFormatterTest.assertEquals((String)"1[2, 3]", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", p1});
        MessageFormatterTest.assertEquals((String)"a[2, 3]", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new byte[]{1, 2}});
        MessageFormatterTest.assertEquals((String)"a[1, 2]", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new int[]{1, 2}});
        MessageFormatterTest.assertEquals((String)"a[1, 2]", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new float[]{1.0f, 2.0f}});
        MessageFormatterTest.assertEquals((String)"a[1.0, 2.0]", (String)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new double[]{1.0, 2.0}});
        MessageFormatterTest.assertEquals((String)"a[1.0, 2.0]", (String)result);
    }

    public void testMultiDimensionalArrayValues() {
        Integer[][] multiIntegerA = new Integer[][]{this.ia0, this.ia1};
        String result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntegerA});
        MessageFormatterTest.assertEquals((String)"a[[1, 2, 3], [10, 20, 30]]", (String)result);
        int[][] multiIntA = new int[][]{{1, 2}, {10, 20}};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntA});
        MessageFormatterTest.assertEquals((String)"a[[1, 2], [10, 20]]", (String)result);
        float[][] multiFloatA = new float[][]{{1.0f, 2.0f}, {10.0f, 20.0f}};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiFloatA});
        MessageFormatterTest.assertEquals((String)"a[[1.0, 2.0], [10.0, 20.0]]", (String)result);
        Object[][] multiOA = new Object[][]{this.ia0, this.ia1};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiOA});
        MessageFormatterTest.assertEquals((String)"a[[1, 2, 3], [10, 20, 30]]", (String)result);
        Object[][][] _3DOA = new Object[][][]{multiOA, multiOA};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", _3DOA});
        MessageFormatterTest.assertEquals((String)"a[[[1, 2, 3], [10, 20, 30]], [[1, 2, 3], [10, 20, 30]]]", (String)result);
    }

    public void testCyclicArrays() {
        Object[] b;
        Object[] cyclicA;
        cyclicA[0] = cyclicA = new Object[1];
        MessageFormatterTest.assertEquals((String)"[[...]]", (String)MessageFormatter.arrayFormat((String)"{}", (Object[])cyclicA));
        Object[] a = new Object[2];
        a[0] = this.i1;
        Object[] c = new Object[]{this.i3, a};
        a[1] = b = new Object[]{this.i2, c};
        MessageFormatterTest.assertEquals((String)"1[2, [3, [1, [...]]]]", (String)MessageFormatter.arrayFormat((String)"{}{}", (Object[])a));
    }
}

