/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.edi;

import java.util.List;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.dfdl.parser.DfdlReaderConfigurator;
import org.smooks.engine.resource.config.DefaultParameter;

public class EdiReaderConfigurator
extends DfdlReaderConfigurator {
    protected String segmentTerminator = "'%NL;%WSP*; '%WSP*;";
    protected String dataElementSeparator = "+";
    protected String compositeDataElementSeparator = ":";
    protected String escapeCharacter = "?";
    protected String repetitionSeparator = "*";
    protected String decimalSign = ".";
    protected String triadSeparator = ",";

    public EdiReaderConfigurator(String schemaUri) {
        super(schemaUri);
    }

    public EdiReaderConfigurator setSegmentTerminator(String segmentTerminator) {
        AssertArgument.isNotNullAndNotEmpty((String)segmentTerminator, (String)"segmentTerminator");
        this.segmentTerminator = segmentTerminator;
        return this;
    }

    public EdiReaderConfigurator setDataElementSeparator(String dataElementSeparator) {
        AssertArgument.isNotNullAndNotEmpty((String)dataElementSeparator, (String)"dataElementSeparator");
        this.dataElementSeparator = dataElementSeparator;
        return this;
    }

    public EdiReaderConfigurator setCompositeDataElementSeparator(String compositeDataElementSeparator) {
        AssertArgument.isNotNullAndNotEmpty((String)compositeDataElementSeparator, (String)"compositeDataElementSeparator");
        this.compositeDataElementSeparator = compositeDataElementSeparator;
        return this;
    }

    public EdiReaderConfigurator setEscapeCharacter(String escapeCharacter) {
        AssertArgument.isNotNullAndNotEmpty((String)escapeCharacter, (String)"escapeCharacter");
        this.escapeCharacter = escapeCharacter;
        return this;
    }

    public EdiReaderConfigurator setRepetitionSeparator(String repetitionSeparator) {
        AssertArgument.isNotNullAndNotEmpty((String)repetitionSeparator, (String)"repetitionSeparator");
        this.repetitionSeparator = repetitionSeparator;
        return this;
    }

    public EdiReaderConfigurator setDecimalSign(String decimalSign) {
        AssertArgument.isNotNullAndNotEmpty((String)decimalSign, (String)"decimalSign");
        this.decimalSign = decimalSign;
        return this;
    }

    public EdiReaderConfigurator setTriadSeparator(String triadSeparator) {
        AssertArgument.isNotNullAndNotEmpty((String)triadSeparator, (String)"triadSeparator");
        this.triadSeparator = triadSeparator;
        return this;
    }

    public List<ResourceConfig> toConfig() {
        List resourceConfigs = super.toConfig();
        ResourceConfig resourceConfig = (ResourceConfig)resourceConfigs.get(0);
        resourceConfig.setResource("org.smooks.cartridges.edi.parser.EdiParser");
        resourceConfig.setParameter((Parameter)new DefaultParameter("dataProcessorFactory", (Object)this.getDataProcessorFactory()));
        resourceConfig.setParameter((Parameter)new DefaultParameter("segmentTerminator", (Object)this.segmentTerminator));
        resourceConfig.setParameter((Parameter)new DefaultParameter("dataElementSeparator", (Object)this.dataElementSeparator));
        resourceConfig.setParameter((Parameter)new DefaultParameter("compositeDataElementSeparator", (Object)this.compositeDataElementSeparator));
        resourceConfig.setParameter((Parameter)new DefaultParameter("escapeCharacter", (Object)this.escapeCharacter));
        resourceConfig.setParameter((Parameter)new DefaultParameter("repetitionSeparator", (Object)this.repetitionSeparator));
        resourceConfig.setParameter((Parameter)new DefaultParameter("decimalSign", (Object)this.decimalSign));
        resourceConfig.setParameter((Parameter)new DefaultParameter("triadSeparator", (Object)this.triadSeparator));
        return resourceConfigs;
    }
}

