/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.ValidationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.cartridges.dfdl.DfdlSchema;
import org.smooks.cartridges.dfdl.DfdlSmooksException;

public class DataProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProcessorFactory.class);
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    protected ResourceConfig resourceConfig;
    @Inject
    @Named(value="schemaUri")
    protected String schemaUri;

    public DataProcessor createDataProcessor() {
        DfdlSchema dfdlSchema;
        try {
            dfdlSchema = new DfdlSchema(new URI(this.schemaUri), ValidationMode.valueOf((String)((String)this.resourceConfig.getParameterValue("validationMode", String.class, (Object)"Off"))), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("cacheOnDisk", String.class, (Object)"false")), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("debugging", String.class, (Object)"false")), (String)this.resourceConfig.getParameterValue("distinguishedRootNode", String.class), (String)this.resourceConfig.getParameterValue("schematronUrl", String.class), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("schematronValidation", String.class)));
        }
        catch (Throwable t) {
            throw new DfdlSmooksException(t);
        }
        return this.compileOrGet(dfdlSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected DataProcessor compileOrGet(DfdlSchema dfdlSchema) {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext.getRegistry().lookup(DataProcessorFactory.class) == null) {
            Class<DataProcessorFactory> clazz = DataProcessorFactory.class;
            // MONITORENTER : org.smooks.cartridges.dfdl.DataProcessorFactory.class
            if (applicationContext.getRegistry().lookup(DataProcessorFactory.class) == null) {
                applicationContext.getRegistry().registerObject(DataProcessorFactory.class, new ConcurrentHashMap());
            }
            // MONITOREXIT : clazz
        }
        Map dataProcessors = (Map)applicationContext.getRegistry().lookup(DataProcessorFactory.class);
        return dataProcessors.computeIfAbsent(dfdlSchema.getName(), k -> {
            LOGGER.info("Compiling and caching DFDL schema...");
            try {
                return dfdlSchema.compile();
            }
            catch (Throwable t) {
                throw new DfdlSmooksException(t);
            }
        });
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }
}

