/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import org.apache.daffodil.japi.Compiler;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.ValidationMode;
import org.apache.daffodil.japi.debugger.DebuggerRunner;
import org.apache.daffodil.japi.debugger.TraceDebuggerRunner;
import org.apache.daffodil.lib.api.Validator;
import org.apache.daffodil.validation.schematron.SchSource;
import org.apache.daffodil.validation.schematron.SchematronValidator;
import org.apache.daffodil.validation.schematron.SchematronValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.resource.URIResourceLocator;

public class DfdlSchema {
    public static final String WORKING_DIRECTORY = ".smooks/dfdl-cartridge/";
    protected static final Logger LOGGER = LoggerFactory.getLogger(DfdlSchema.class);
    protected final URI uri;
    protected final ValidationMode validationMode;
    protected final boolean cacheOnDisk;
    protected final boolean debugging;
    protected final String distinguishedRootNode;
    private final String schematronUrl;
    private final boolean schematronValidation;

    public DfdlSchema(URI uri, ValidationMode validationMode, boolean cacheOnDisk, boolean debugging, String distinguishedRootNode, String schematronUrl, boolean schematronValidation) {
        this.uri = uri;
        this.validationMode = validationMode;
        this.cacheOnDisk = cacheOnDisk;
        this.debugging = debugging;
        this.distinguishedRootNode = distinguishedRootNode;
        this.schematronUrl = schematronUrl;
        this.schematronValidation = schematronValidation;
    }

    public URI getUri() {
        return this.uri;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public boolean isCacheOnDisk() {
        return this.cacheOnDisk;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public String getName() {
        return this.uri + ":" + this.validationMode + ":" + this.cacheOnDisk + ":" + this.debugging;
    }

    public DataProcessor compile() throws Throwable {
        DataProcessor dataProcessor;
        if (this.cacheOnDisk) {
            File binSchemaFile = new File(WORKING_DIRECTORY + new File(this.uri.getPath()).getName() + ".dat");
            binSchemaFile.getParentFile().mkdirs();
            if (binSchemaFile.exists()) {
                LOGGER.info("Loading compiled DFDL schema from {}", (Object)binSchemaFile.getAbsolutePath());
                dataProcessor = Daffodil.compiler().reload(binSchemaFile);
            } else {
                dataProcessor = this.compileSource();
                LOGGER.info("Saving compiled DFDL schema to {}", (Object)binSchemaFile.getAbsolutePath());
                dataProcessor.save(Channels.newChannel(Files.newOutputStream(binSchemaFile.toPath(), new OpenOption[0])));
            }
        } else {
            dataProcessor = this.compileSource();
        }
        if (this.debugging) {
            dataProcessor = dataProcessor.withDebuggerRunner((DebuggerRunner)new TraceDebuggerRunner()).withDebugging(true);
        }
        dataProcessor = dataProcessor.withValidationMode(this.validationMode);
        if (this.schematronValidation) {
            SchematronValidator schematronValidator;
            URIResourceLocator uriResourceLocator = new URIResourceLocator();
            if (this.schematronUrl != null) {
                InputStream schematronInputStream = uriResourceLocator.getResource(this.schematronUrl);
                schematronValidator = SchematronValidatorFactory.makeValidator((InputStream)schematronInputStream, (String)this.schematronUrl, (SchSource)new SchSource.Sch$());
            } else {
                InputStream schematronInputStream = uriResourceLocator.getResource(this.uri.toString());
                schematronValidator = SchematronValidatorFactory.makeValidator((InputStream)schematronInputStream, (String)this.uri.toString(), (SchSource)new SchSource.Xsd$());
            }
            dataProcessor = dataProcessor.withValidator((Validator)schematronValidator);
        }
        return dataProcessor;
    }

    protected DataProcessor compileSource() throws Throwable {
        List diagnostics;
        Iterator iterator;
        Compiler compiler = Daffodil.compiler();
        ProcessorFactory processorFactory = this.distinguishedRootNode != null ? compiler.compileSource(this.uri, this.distinguishedRootNode.substring(this.distinguishedRootNode.indexOf("}") + 1), this.distinguishedRootNode.substring(this.distinguishedRootNode.indexOf("{") + 1, this.distinguishedRootNode.indexOf("}"))) : compiler.compileSource(this.uri);
        if (processorFactory.isError()) {
            List diagnostics2 = processorFactory.getDiagnostics();
            throw ((Diagnostic)diagnostics2.get(0)).getSomeCause();
        }
        DataProcessor dataProcessor = processorFactory.onPath("/");
        if (dataProcessor.isError() && (iterator = (diagnostics = dataProcessor.getDiagnostics()).iterator()).hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator.next();
            throw diagnostic.getSomeCause();
        }
        return dataProcessor;
    }
}

