/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.engine.memento.TextAccumulatorVisitorMemento;
import org.smooks.support.DomUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(condition="parameters.containsKey('valueAttributeName')", summary="Creating object under bean id <b>${resource.parameters.beanId}</b> with a value from the attribute <b>${resource.parameters.valueAttributeName}</b>.", detailTemplate="reporting/ValueBinderReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('valueAttributeName')", summary="Creating object <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/ValueBinderReport_After.html")
public class ValueBinder
implements BeforeVisitor,
AfterVisitor,
ChildrenVisitor,
Producer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ValueBinder.class);
    @Inject
    @Named(value="beanId")
    protected String beanIdName;
    @Inject
    protected Optional<String> valueAttributeName;
    @Inject
    @Named(value="default")
    protected Optional<String> defaultValue;
    @Inject
    @Named(value="type")
    protected String typeAlias = "String";
    protected BeanId beanId;
    @Inject
    protected ApplicationContext applicationContext;
    protected boolean isAttribute;
    protected TypeConverter<? super String, ?> typeConverter;

    public ValueBinder() {
    }

    public ValueBinder(String beanId) {
        this.beanIdName = beanId;
    }

    public String getBeanIdName() {
        return this.beanIdName;
    }

    public void setBeanIdName(String beanIdName) {
        this.beanIdName = beanIdName;
    }

    public String getValueAttributeName() {
        return this.valueAttributeName.orElse(null);
    }

    public void setValueAttributeName(String valueAttributeName) {
        this.valueAttributeName = Optional.ofNullable(valueAttributeName);
    }

    public String getDefaultValue() {
        return this.defaultValue.orElse(null);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    public String getTypeAlias() {
        return this.typeAlias;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public TypeConverter<? super String, ?> getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter<? super String, ?> typeConverter) {
        this.typeConverter = typeConverter;
    }

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        this.isAttribute = this.valueAttributeName.isPresent();
        this.beanId = this.applicationContext.getBeanIdStore().register(this.beanIdName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Value Binder created for [{}]", (Object)this.beanIdName);
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.isAttribute) {
            this.bindValue(DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName.orElse(null)), executionContext, (Fragment<?>)new NodeFragment((Node)element));
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.isAttribute) {
            NodeFragment nodeFragment = new NodeFragment((Node)element);
            TextAccumulatorVisitorMemento textAccumulatorMemento = new TextAccumulatorVisitorMemento((Fragment)nodeFragment, (Visitor)this);
            executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
            this.bindValue(textAccumulatorMemento.getText(), executionContext, (Fragment<?>)nodeFragment);
        }
    }

    protected void bindValue(String dataString, ExecutionContext executionContext, Fragment<?> source) {
        Object valueObj = this.decodeDataString(dataString, executionContext);
        BeanContext beanContext = executionContext.getBeanContext();
        if (valueObj == null) {
            beanContext.removeBean(this.beanId, source);
        } else {
            beanContext.addBean(this.beanId, valueObj, source);
        }
    }

    public Set<?> getProducts() {
        return Stream.of(this.beanIdName).collect(Collectors.toSet());
    }

    protected Object decodeDataString(String dataString, ExecutionContext executionContext) throws TypeConverterException {
        if (dataString == null || dataString.isEmpty() && this.defaultValue.isPresent()) {
            if (this.defaultValue.get().equals("null")) {
                return null;
            }
            dataString = this.defaultValue.get();
        }
        try {
            return this.getTypeConverter(executionContext).convert((Object)dataString);
        }
        catch (TypeConverterException e) {
            throw new TypeConverterException("Failed to convert the value '" + dataString + "' for the bean id '" + this.beanIdName + "'.", (Throwable)e);
        }
    }

    protected TypeConverter<? super String, ?> getTypeConverter(ExecutionContext executionContext) throws TypeConverterException {
        if (this.typeConverter == null) {
            List decoders = executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().getObjects("decoder:" + this.typeAlias);
            if (decoders == null || decoders.isEmpty()) {
                this.typeConverter = ((TypeConverterFactory)this.applicationContext.getRegistry().lookup((Function)new NameTypeConverterFactoryLookup(this.typeAlias))).createTypeConverter();
            } else {
                if (!(decoders.get(0) instanceof TypeConverterFactory)) {
                    throw new TypeConverterException("Configured type converter factory '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + TypeConverterFactory.class.getName());
                }
                this.typeConverter = ((TypeConverterFactory)decoders.get(0)).createTypeConverter();
            }
        }
        return this.typeConverter;
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
        if (!this.isAttribute) {
            TextAccumulatorVisitorMemento textAccumulatorMemento = new TextAccumulatorVisitorMemento((Fragment)new NodeFragment(characterData.getParentNode()), (Visitor)this);
            textAccumulatorMemento.accumulateText(characterData.getTextContent());
            executionContext.getMementoCaretaker().capture((Memento)textAccumulatorMemento);
        }
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) throws SmooksException {
    }
}

