/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.binding;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.smooks.Smooks;
import org.smooks.api.ExecutionContext;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.binding.model.Bean;
import org.smooks.cartridges.javabean.binding.model.DataBinding;
import org.smooks.cartridges.javabean.binding.model.WiredBinding;
import org.smooks.cartridges.javabean.binding.model.get.GetterGraph;
import org.smooks.engine.lookup.CustomResourceConfigSeqLookup;
import org.smooks.engine.report.HtmlReportGenerator;
import org.smooks.io.sink.JavaSink;
import org.xml.sax.SAXException;

public class AbstractBinding {
    protected Smooks smooks;
    protected String reportPath;
    protected boolean allConfigsAdded = false;
    protected boolean initialized = false;

    protected AbstractBinding() {
        this.smooks = new Smooks();
    }

    protected AbstractBinding(Smooks smooks) {
        this.smooks = smooks;
        this.allConfigsAdded = true;
    }

    public AbstractBinding add(String smooksConfigURI) throws IOException, SAXException {
        this.assertNotAllConfigsAdded();
        this.assertNotInitialized();
        this.smooks.addResourceConfigs(smooksConfigURI);
        return this;
    }

    public AbstractBinding add(InputStream smooksConfigStream) throws IOException, SAXException {
        this.assertNotAllConfigsAdded();
        this.assertNotInitialized();
        this.smooks.addResourceConfigs(smooksConfigStream);
        return this;
    }

    public AbstractBinding initialise() {
        this.assertNotInitialized();
        this.smooks.createExecutionContext();
        this.allConfigsAdded = true;
        this.initialized = true;
        return this;
    }

    public Smooks getSmooks() {
        return this.smooks;
    }

    public AbstractBinding setReportPath(String reportPath) {
        this.reportPath = reportPath;
        return this;
    }

    protected <T> T bind(Source inputSource, Class<T> toType) throws IOException {
        AssertArgument.isNotNull((Object)inputSource, (String)"inputSource");
        AssertArgument.isNotNull(toType, (String)"toType");
        this.assertInitialized();
        JavaSink javaSink = new JavaSink();
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        if (this.reportPath != null) {
            executionContext.getContentDeliveryRuntime().getExecutionEventListeners().add(new HtmlReportGenerator(this.reportPath, this.smooks.getApplicationContext()));
        }
        this.smooks.filterSource(executionContext, inputSource, new Sink[]{javaSink});
        return (T)javaSink.getBean(toType);
    }

    protected ResourceConfigSeq getUserDefinedResourceList() {
        return (ResourceConfigSeq)this.smooks.getApplicationContext().getRegistry().lookup((Function)new CustomResourceConfigSeqLookup(this.smooks.getApplicationContext().getRegistry()));
    }

    protected GetterGraph constructContextualGetter(DataBinding binding) {
        GetterGraph contextualGetter = new GetterGraph();
        contextualGetter.add(binding);
        this.addToContextualGetter(contextualGetter, binding.getParentBean());
        return contextualGetter;
    }

    protected GetterGraph constructContextualGetter(Bean bean) {
        return this.addToContextualGetter(new GetterGraph(), bean);
    }

    protected GetterGraph addToContextualGetter(GetterGraph contextualGetter, Bean bean) {
        Bean theBean = bean;
        while (theBean != null) {
            Bean parentBean = theBean.getWiredInto();
            if (parentBean != null) {
                if (parentBean.isCollection()) {
                    Bean wiredInto = parentBean.getWiredInto();
                    if (wiredInto == null) break;
                    contextualGetter.setContextObjectName(theBean.getBeanId());
                    break;
                }
                WiredBinding binding = parentBean.getWiredBinding(theBean);
                if (binding == null) {
                    throw new IllegalStateException("Failed to locate a wiring of theBean '" + theBean + "' on theBean '" + parentBean + "'.");
                }
                contextualGetter.add(parentBean, binding.getProperty());
            }
            theBean = parentBean;
        }
        return contextualGetter;
    }

    protected void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Illegal call to method before instance is initialized.  Must call the 'initialize' method first.");
        }
    }

    protected void assertNotAllConfigsAdded() {
        if (this.allConfigsAdded) {
            throw new IllegalStateException("Illegal call to method after all configurations have been added.");
        }
    }

    protected void assertNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Illegal call to method after instance is initialized.");
        }
    }
}

