/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.api;

import java.util.Objects;
import java.util.UUID;

public interface TypedKey<T> {
    public String getName();

    public static <T> TypedKey<T> of() {
        return new DefaultTypedKey(UUID.randomUUID().toString());
    }

    public static <T> TypedKey<T> of(String name) {
        return new DefaultTypedKey(name);
    }

    public static final class DefaultTypedKey<T>
    implements TypedKey<T> {
        private final String name;
        private int hash;

        public DefaultTypedKey(String name) {
            Objects.requireNonNull(name);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypedKey)) {
                return false;
            }
            TypedKey typedKey = (TypedKey)o;
            return this.name.equals(typedKey.getName());
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Objects.hash(this.name);
            }
            return this.hash;
        }

        public String toString() {
            return this.name;
        }
    }
}

