/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class StorageType
extends MOMutableColumn<Integer32> {
    public static final int other = 1;
    public static final int volatile_ = 2;
    public static final int nonVolatile = 3;
    public static final int permanent = 4;
    public static final int readOnly = 5;

    public StorageType(int columnID, MOAccess access, Integer32 defaultValue, boolean mutableInService) {
        super(columnID, 2, access, (Variable)defaultValue, mutableInService);
    }

    public StorageType(int columnID, MOAccess access, Integer32 defaultValue) {
        super(columnID, 2, access, (Variable)defaultValue);
    }

    public static Integer32 getStorageType(MOTableRow<?> row, MOTable<?, ?, ?> table) {
        int maxCol = table.getColumnCount();
        for (int c = maxCol - 1; c >= 0; --c) {
            Object moColumn = table.getColumn(c);
            if (!(moColumn instanceof StorageType)) continue;
            return new Integer32(row.getValue(c).toInt());
        }
        return null;
    }

    @Override
    public synchronized int validate(Variable newValue, Variable oldValue) {
        int ov;
        int v = ((Integer32)newValue).getValue();
        if (v < 1 || v > 5) {
            return 10;
        }
        if (oldValue != null && (ov = ((Integer32)oldValue).getValue()) >= 4) {
            return 10;
        }
        return super.validate(newValue, oldValue);
    }

    @Override
    public boolean isVolatile(MOTableRow<Integer32> row, int column) {
        Integer32 value = row.getValue(column);
        if (value != null) {
            int storageType = value.getValue();
            switch (storageType) {
                case 1: 
                case 2: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

