/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class JarExtractor {
    public Path extractToTemp(String filenameWithoutSuffix) {
        String filename = filenameWithoutSuffix + ".jar";
        URL url = this.getClass().getResource("/" + filename);
        try {
            Path copy = Files.createTempFile(filenameWithoutSuffix, ".jar", new FileAttribute[0]);
            copy.toFile().deleteOnExit();
            try (InputStream in = url.openStream();){
                Files.copy(in, copy, StandardCopyOption.REPLACE_EXISTING);
            }
            return copy;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to extract " + filename, e);
        }
    }
}

