/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarUtils;
import org.sonarsource.scanner.api.Utils;

public class SonarPropertyComputer {
    private static final Logger LOGGER = Logging.getLogger(SonarPropertyComputer.class);
    private static final Pattern TEST_RESULT_FILE_PATTERN = Pattern.compile("TESTS?-.*\\.xml");
    static final String SONAR_SOURCES_PROP = "sonar.sources";
    static final String SONAR_TESTS_PROP = "sonar.tests";
    static final String SONAR_JAVA_SOURCE_PROP = "sonar.java.source";
    static final String SONAR_JAVA_TARGET_PROP = "sonar.java.target";
    private final Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap;
    private final Project targetProject;

    public SonarPropertyComputer(Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap, Project targetProject) {
        this.actionBroadcastMap = actionBroadcastMap;
        this.targetProject = targetProject;
    }

    public Map<String, Object> computeSonarProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.computeSonarProperties(this.targetProject, properties, "");
        return properties;
    }

    private void computeSonarProperties(Project project, Map<String, Object> properties, String prefix) {
        ActionBroadcast<SonarQubeProperties> actionBroadcast;
        SonarQubeExtension extension = (SonarQubeExtension)project.getExtensions().getByType(SonarQubeExtension.class);
        if (extension.isSkipProject()) {
            return;
        }
        LinkedHashMap<String, Object> rawProperties = new LinkedHashMap<String, Object>();
        this.addGradleDefaults(project, rawProperties);
        if (SonarUtils.isAndroidProject(project)) {
            AndroidUtils.configureForAndroid(project, extension.getAndroidVariant(), rawProperties);
        }
        if ((actionBroadcast = this.actionBroadcastMap.get(project)) != null) {
            SonarPropertyComputer.evaluateSonarPropertiesBlocks(actionBroadcast, rawProperties);
        }
        if (project.equals(this.targetProject)) {
            SonarPropertyComputer.addEnvironmentProperties(rawProperties);
            SonarPropertyComputer.addSystemProperties(rawProperties);
        }
        rawProperties.putIfAbsent(SONAR_SOURCES_PROP, "");
        if (project.equals(this.targetProject)) {
            rawProperties.putIfAbsent("sonar.projectKey", this.computeProjectKey());
        } else {
            String projectKey = (String)properties.get("sonar.projectKey");
            rawProperties.putIfAbsent("sonar.moduleKey", projectKey + project.getPath());
        }
        SonarPropertyComputer.convertProperties(rawProperties, prefix, properties);
        List enabledChildProjects = project.getChildProjects().values().stream().filter(p -> !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).collect(Collectors.toList());
        List<Project> skippedChildProjects = project.getChildProjects().values().stream().filter(p -> ((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).collect(Collectors.toList());
        if (!skippedChildProjects.isEmpty()) {
            LOGGER.debug("Skipping collecting SonarQube properties on: " + skippedChildProjects.toArray(new Project[0]));
        }
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (Project childProject : enabledChildProjects) {
            String moduleId = childProject.getPath();
            moduleIds.add(moduleId);
            String modulePrefix = prefix.length() > 0 ? prefix + "." + moduleId : moduleId;
            this.computeSonarProperties(childProject, properties, modulePrefix);
        }
        properties.put(SonarPropertyComputer.convertKey("sonar.modules", prefix), moduleIds.stream().collect(Collectors.joining(",")));
    }

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarQubeProperties> propertiesActions, Map<String, Object> properties) {
        SonarQubeProperties sqProperties = new SonarQubeProperties(properties);
        propertiesActions.execute(sqProperties);
    }

    private static void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = SonarPropertyComputer.convertValue(entry.getValue());
            if (value == null) continue;
            properties.put(SonarPropertyComputer.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private static String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private static String convertValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            String joined = StreamSupport.stream(((Iterable)value).spliterator(), false).map(SonarPropertyComputer::convertValue).filter(Objects::nonNull).collect(Collectors.joining(","));
            return joined.isEmpty() ? null : joined;
        }
        return value.toString();
    }

    private static void configureSourceEncoding(Project project, Map<String, Object> properties) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            String encoding = compile.getOptions().getEncoding();
            if (encoding != null) {
                properties.put("sonar.sourceEncoding", encoding);
            }
        });
    }

    private static void configureJdkSourceAndTarget(Project project, Map<String, Object> properties) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        properties.put(SONAR_JAVA_SOURCE_PROP, javaPluginConvention.getSourceCompatibility());
        properties.put(SONAR_JAVA_TARGET_PROP, javaPluginConvention.getTargetCompatibility());
    }

    private static void addEnvironmentProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> e : Utils.loadEnvironmentProperties(System.getenv()).entrySet()) {
            properties.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    private static void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private static void configureForJava(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> SonarPropertyComputer.configureJdkSourceAndTarget(project, properties));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            boolean hasSourceOrTest = SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, false);
            if (hasSourceOrTest) {
                SonarPropertyComputer.configureSourceEncoding(project, properties);
                SonarPropertyComputer.extractTestProperties(project, properties, false);
            }
        });
    }

    private static void configureForGroovy(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(GroovyBasePlugin.class, groovyBasePlugin -> SonarPropertyComputer.configureJdkSourceAndTarget(project, properties));
        project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> {
            boolean hasSourceOrTest = SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, true);
            if (hasSourceOrTest) {
                SonarPropertyComputer.configureSourceEncoding(project, properties);
                SonarPropertyComputer.extractTestProperties(project, properties, true);
            }
        });
    }

    private static void extractTestProperties(Project project, Map<String, Object> properties, boolean addForGroovy) {
        Task testTask = project.getTasks().getByName("test");
        if (testTask instanceof Test) {
            SonarPropertyComputer.configureTestReports((Test)testTask, properties);
            SonarPropertyComputer.configureJaCoCoCoverageReport((Test)testTask, addForGroovy, project, properties);
        } else {
            LOGGER.warn("Non standard test task: unable to automatically find test execution and coverage reports paths");
        }
    }

    private static void configureJaCoCoCoverageReport(Test testTask, boolean addForGroovy, Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> {
            JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
            File destinationFile = jacocoTaskExtension.getDestinationFile();
            if (destinationFile.exists()) {
                properties.put("sonar.jacoco.reportPath", destinationFile);
                SonarUtils.appendProp(properties, "sonar.jacoco.reportPaths", destinationFile);
                if (addForGroovy) {
                    properties.put("sonar.groovy.jacoco.reportPath", destinationFile);
                }
            }
        });
    }

    private static void configureTestReports(Test testTask, Map<String, Object> properties) {
        File testResultsDir = testTask.getReports().getJunitXml().getDestination();
        if (testResultsDir.isDirectory() && Arrays.asList(testResultsDir.list()).stream().anyMatch(file -> TEST_RESULT_FILE_PATTERN.matcher((CharSequence)file).matches())) {
            SonarUtils.appendProp(properties, "sonar.junit.reportPaths", testResultsDir);
            SonarUtils.appendProp(properties, "sonar.junit.reportsPath", testResultsDir);
            SonarUtils.appendProp(properties, "sonar.surefire.reportsPath", testResultsDir);
        }
    }

    private static boolean configureSourceDirsAndJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt("main");
        List sourceDirectories = SonarUtils.nonEmptyOrNull(main.getAllJava().getSrcDirs().stream().filter(File::exists).collect(Collectors.toList()));
        properties.put(SONAR_SOURCES_PROP, sourceDirectories);
        SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt("test");
        List testDirectories = SonarUtils.nonEmptyOrNull(test.getAllJava().getSrcDirs().stream().filter(File::exists).collect(Collectors.toList()));
        properties.put(SONAR_TESTS_PROP, testDirectories);
        Collection<File> mainClassDirs = SonarPropertyComputer.getOutputDirs(main);
        Collection<File> mainLibraries = SonarPropertyComputer.getLibraries(main);
        SonarUtils.setMainClasspathProps(properties, addForGroovy, mainClassDirs, mainLibraries);
        Collection<File> testClassDirs = SonarPropertyComputer.getOutputDirs(test);
        Collection<File> testLibraries = SonarPropertyComputer.getLibraries(test);
        SonarUtils.setTestClasspathProps(properties, testClassDirs, testLibraries);
        return sourceDirectories != null || testDirectories != null;
    }

    private static Collection<File> getOutputDirs(SourceSet sourceSet) {
        Collection<Object> result = GradleVersion.version((String)"4.0").compareTo(GradleVersion.current()) <= 0 ? sourceSet.getOutput().getClassesDirs().getFiles() : Collections.singletonList(sourceSet.getOutput().getClassesDir());
        return SonarUtils.exists(result);
    }

    private static Collection<File> getLibraries(SourceSet main) {
        File fxRuntimeJar;
        List<File> libraries = SonarUtils.exists(main.getCompileClasspath().getFiles());
        File runtimeJar = SonarPropertyComputer.getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        if ((fxRuntimeJar = SonarPropertyComputer.getFxRuntimeJar()) != null) {
            libraries.add(fxRuntimeJar);
        }
        return libraries;
    }

    private static File getRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/rt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/rt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File getFxRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/ext/jfxrt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/ext/jfxrt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addGradleDefaults(Project project, Map<String, Object> properties) {
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        if (project.equals(this.targetProject)) {
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        }
        if (project.getPlugins().hasPlugin(GroovyBasePlugin.class)) {
            SonarPropertyComputer.configureForGroovy(project, properties);
        } else {
            SonarPropertyComputer.configureForJava(project, properties);
        }
    }

    private String computeProjectKey() {
        String rootKey;
        Project rootProject = this.targetProject.getRootProject();
        String rootProjectName = rootProject.getName();
        String rootGroup = rootProject.getGroup().toString();
        String string = rootKey = rootGroup.isEmpty() ? rootProjectName : rootGroup + ":" + rootProjectName;
        if (this.targetProject == rootProject) {
            return rootKey;
        }
        return rootKey + this.targetProject.getPath();
    }
}

